ORCA/M Asm65816 2.1.0

0001 D000              ;===============================================================================
0002 D000              ; System Call Information Tables
0003 D000              ;===============================================================================
0004 D000
0005 D000              sys_call_info proc 
0006 D000
0007 D000              ;===============================================================================
0008 D000              ; info_ptr table:  top level table for accessing system call information
0009 D000              ;
0010 D000              ; The first word of this table holds a value one greater than the highest legal
0011 D000              ; system call number.  The rest of the table has a pointer for each system call
0012 D000              ; to the descriptor table entry for the call.  A call is illegal if 1) the call 
0013 D000              ; number is zero, 2) the call number is greater than or equal to the value in
0014 D000              ; the first word of the table, 3) its table entry is zero, or 4) the high byte
0015 D000              ; of the call number is $01, indicating a call that should have been handled by
0016 D000              ; APW.
0017 D000              ;===============================================================================
0018 D000
0019 D000                       entry info_ptr
0020 D000                       entry end_info_ptr
0021 D000                       entry ctype_vector
0022 D000                       entry path_script
0023 D000
0024 D000                       import new_volume_call
0025 D000
0026 D000 3B 00        info_ptr DC W:(end_info_ptr-info_ptr)/2  ;number of vectors in table + 1
0027 D002
0028 D002 76 D0                 DC W:create                    ;$01-create
0029 D004 86 D0                 DC W:destroy                   ;$02-destroy
0030 D006 96 D0                 DC W:s_os_shutdown             ;$03-os_shutdown
0031 D008 A5 D0                 DC W:change_path               ;$04-change_path
0032 D00A B7 D0                 DC W:set_file_info             ;$05-set_file_info
0033 D00C C7 D0                 DC W:s_get_file_info           ;$06-get_file_info
0034 D00E D7 D0                 DC W:s_judge_name              ;$07-JudgeName
0035 D010 E7 D0                 DC W:volume                    ;$08-volume
0036 D012 FE D0                 DC W:s_set_prefix              ;$09-set_prefix
0037 D014 17 D1                 DC W:s_get_prefix              ;$0A-get_prefix
0038 D016 30 D1                 DC W:clear_backup              ;$0B-clear_backup_bit
0039 D018 40 D1                 DC W:s_set_sys_prefs           ;$0C-set_sys_prefs
0040 D01A 4F D1                 DC W:s_null                    ;$0D-null
0041 D01C 5D D1                 DC W:s_expand_path             ;$0E-expand_path
0042 D01E 6E D1                 DC W:s_get_sys_prefs           ;$0F-get_sys_prefs
0043 D020
0044 D020 7D D1                 DC W:s_open                    ;$10-open
0045 D022 8D D1                 DC W:s_newline                 ;$11-newline
0046 D024 A6 D1                 DC W:s_read                    ;$12-read
0047 D026 B8 D1                 DC W:write                     ;$13-write
0048 D028 CA D1                 DC W:s_close                   ;$14-close
0049 D02A D8 D1                 DC W:flush                     ;$15-flush
0050 D02C E6 D1                 DC W:set_mark                  ;$16-set_mark
0051 D02E F6 D1                 DC W:get_mark                  ;$17-get_mark
0052 D030 06 D2                 DC W:set_eof                   ;$18-set_eof
0053 D032 16 D2                 DC W:s_get_eof                 ;$19-get_eof
0054 D034 26 D2                 DC W:s_set_level               ;$1A-set_level
0055 D036 3D D2                 DC W:s_get_level               ;$1B-get_level
0056 D038 54 D2                 DC W:get_dir_entry             ;$1C-get_dir_entry
0057 D03A 64 D2                 DC W:s_begin_session           ;$1D-begin_session
0058 D03C 72 D2                 DC W:s_end_session             ;$1E-end_session
0059 D03E 80 D2                 DC W:s_session_stat            ;$1F-session_status
0060 D040
0061 D040 8F D2                 DC W:get_dev_num               ;$20-get_dev_number
0062 D042 9F D2                 DC W:get_last_dev              ;$21-get_last_dev
0063 D044 AA D2                 DC W:read_block                ;$22-read_block
0064 D046 B2 D2                 DC W:write_block               ;$23-write_block
0065 D048 BA D2                 DC W:s_format                  ;$24-format
0066 D04A CC D2                 DC W:s_erase_disk              ;$25-erase_disk
0067 D04C DE D2                 DC W:s_reset_cache             ;$26-reset_cache
0068 D04E EC D2                 DC W:s_get_name                ;$27-get_name
0069 D050 05 D3                 DC W:s_get_boot_vol            ;$28-get_boot_bol
0070 D052 1E D3                 DC W:s_quit                    ;$29-quit
0071 D054 34 D3                 DC W:s_get_version             ;$2A-get_version
0072 D056 4B D3                 DC W:s_get_fst_info            ;$2B-get_fst_info
0073 D058 5A D3                 DC W:s_d_info                  ;$2C-d_info
0074 D05A 5A D3                 DC W:s_d_status                ;$2D-d_status
0075 D05C 5A D3                 DC W:s_d_control               ;$2E-d_control
0076 D05E 5A D3                 DC W:s_d_read                  ;$2F-d_read
0077 D060
0078 D060 5A D3                 DC W:s_d_write                 ;$30-d_write
0079 D062 5A D3                 DC W:s_alloc_int               ;$31-alloc_interrupt
0080 D064 73 D3                 DC W:s_dealloc_int             ;$32-dealloc_interrupt
0081 D066 8C D3                 DC W:fst_specific              ;$33-fst_specific_call
0082 D068 9B D3                 DC W:s_add_queue               ;$34-add_to_queue
0083 D06A AA D3                 DC W:s_delete_queue            ;$35-delete_from_queue
0084 D06C 5A D3                 DC W:s_d_rename                ;$36-d_rename
0085 D06E B9 D3                 DC W:s_get_std_ref             ;$37-get_std_ref_num
0086 D070 C8 D3                 DC W:s_get_ref_num             ;$38-get_ref_num
0087 D072 D8 D3                 DC W:s_get_ref_info            ;$39-get_ref_info
0088 D074 E7 D3                 DC W:s_set_std_ref             ;$3A-set_std_ref_num
0089 D076
0090 D076              end_info_ptr  
0091 D076
0092 D076              ;===============================================================================
0093 D076              ; Call Descriptor Table
0094 D076              ;
0095 D076              ; This table describes aspects of each system call that are relevant for call
0096 D076              ; preprocessing by the System Call Manager.  Words in the info_ptr table point
0097 D076              ; to this table.  This table is formatted as follows:
0098 D076              ;
0099 D076              ; Top level locations in the table (e.g. create) are tables of pointers to
0100 D076              ; lower level structures in the table.  Each top level structure corresponds to
0101 D076              ; one system call.  The first byte is one greater than the maximum class number 
0102 D076              ; for the call.  This is followed by a word for each subclass in the range from
0103 D076              ; 0 to the maximum subclass number (one less than the value in the first word).
0104 D076              ; A value of zero in a subclass word indicates that the given subclass does not
0105 D076              ; exist.  A value other than zero is a pointer to a table of information that
0106 D076              ; completely describes the call.  The descriptor table consists of a series of
0107 D076              ; entries (a script), each element of which is defined as follows:
0108 D076              ;
0109 D076              ; 76543210  Meaning
0110 D076              ;
0111 D076              ; 00000000  End of script
0112 D076              ; 0001xxxx  Specifies the call type.  The two bytes immediately following this
0113 D076              ;           code contain the call type premultiplied by 2 to serve as an index
0114 D076              ;           into the ctype_vector table.  xxxx is undefined.
0115 D076              ; 0010vvvv  Minimum parameter count for the given call and subclass is vvvv
0116 D076              ; 0011vvvv  There is a pathname pointer at offset vvvv in the parameter block
0117 D076              ;           corresponding to a pathname input
0118 D076              ; 0100vvvv  There is a reference number input at offset vvvv in the parameter
0119 D076              ;           block
0120 D076              ; 0101vvvv  There is a pathname pointer at offset vvvv in the parameter block
0121 D076              ;           corresponding to a pathname output.
0122 D076              ; 0110vvvv  Maximum parameter count for the given call and subclass is vvvv
0123 D076              ; 1110xxxx  Execute a special processing routine whose address is contained in
0124 D076              ;           the following 3 bytes.  xxxx is undefined
0125 D076              ; 1111oooo  Escape to alternate script opcode number oooo.
0126 D076              ;
0127 D076              ;           Remaining values are reserved
0128 D076              ;===============================================================================
0129 D076
0130 D076              ;don't expand the macros.  makes the listing really messy ;-)
0131 D076                              print   push
0132 D076                              print   nogen
0133 D076
0134 D076 02           create          classes 2               ;$01
0135 D077 7B D0                        info_at create0
0136 D079 80 D0                        info_at create1
0137 D07B 10 04 00     create0         ctype   2
0138 D07E 30                           pathptr 0
0139 D07F 00                           end_script
0140 D080 10 04 00     create1         ctype   2
0141 D083 21                           pcount  1
0142 D084 32                           pathptr 2
0143 D085 00                           end_script
0144 D086
0145 D086 02           destroy         classes 2               ;$02
0146 D087 8B D0                        info_at destroy0
0147 D089 90 D0                        info_at destroy1
0148 D08B 10 04 00     destroy0        ctype   2
0149 D08E 30                           pathptr 0
0150 D08F 00                           end_script
0151 D090 10 04 00     destroy1        ctype   2
0152 D093 21                           pcount  1
0153 D094 32                           pathptr 2
0154 D095 00                           end_script
0155 D096
0156 D096 02           s_os_shutdown   classes 2               ;$03
0157 D097 00 00                        no_such_class
0158 D099 9B D0                        info_at s_os_shutdown1
0159 D09B 10 08 00     s_os_shutdown1  ctype   4
0160 D09E 21                           pcount  1
0161 D09F 61                           maxpcnt 1
0162 D0A0 E0 B1 E8 00                  exec    os_shutdown
0163 D0A4 00                           end_script
0164 D0A5
0165 D0A5 02           change_path     classes 2               ;$04
0166 D0A6 AA D0                        info_at change_path0
0167 D0A8 B0 D0                        info_at change_path1
0168 D0AA 10 04 00     change_path0    ctype   2
0169 D0AD 30                           pathptr 0
0170 D0AE 34                           pathptr 4
0171 D0AF 00                           end_script
0172 D0B0 10 04 00     change_path1    ctype   2
0173 D0B3 22                           pcount  2
0174 D0B4 32                           pathptr 2
0175 D0B5 36                           pathptr 6
0176 D0B6 00                           end_script
0177 D0B7
0178 D0B7 02           set_file_info   classes 2               ;$05
0179 D0B8 BC D0                        info_at set_file_info0
0180 D0BA C1 D0                        info_at set_file_info1
0181 D0BC 10 04 00     set_file_info0  ctype   2
0182 D0BF 30                           pathptr 0
0183 D0C0 00                           end_script
0184 D0C1 10 04 00     set_file_info1  ctype   2
0185 D0C4 22                           pcount  2
0186 D0C5 32                           pathptr 2
0187 D0C6 00                           end_script
0188 D0C7
0189 D0C7 02           s_get_file_info classes 2               ;$06
0190 D0C8 CC D0                        info_at get_file_info0
0191 D0CA D1 D0                        info_at get_file_info1
0192 D0CC 10 04 00     get_file_info0  ctype   2
0193 D0CF 30                           pathptr 0
0194 D0D0 00                           end_script
0195 D0D1 10 04 00     get_file_info1  ctype   2
0196 D0D4 22                           pcount  2
0197 D0D5 32                           pathptr 2
0198 D0D6 00                           end_script
0199 D0D7
0200 D0D7 02           s_judge_name    classes 2               ;$07
0201 D0D8 00 00                        no_such_class
0202 D0DA DC D0                        info_at s_judge_name1
0203 D0DC 10 08 00     s_judge_name1   ctype   4
0204 D0DF 23                           pcount  3
0205 D0E0 66                           maxpcnt 6
0206 D0E1 5C                           outpath 12
0207 D0E2 E0 70 E6 00                  exec    do_judgename
0208 D0E6 00                           end_script
0209 D0E7
0210 D0E7 02           volume          classes 2               ;$08
0211 D0E8 EC D0                        info_at volume0
0212 D0EA F2 D0                        info_at volume1
0213 D0EC 10 04 00     volume0         ctype   2
0214 D0EF 30                           pathptr 0
0215 D0F0 54                           outpath 4
0216 D0F1 00                           end_script
0217 D0F2 10 08 00     volume1         ctype   4
0218 D0F5 22                           pcount  2
0219 D0F6 68                           maxpcnt 8
0220 D0F7 32                           pathptr 2
0221 D0F8 56                           outpath 6
0222 D0F9 E0 14 EA 00                  exec    new_volume_call
0223 D0FD 00                           end_script
0224 D0FE
0225 D0FE 02           s_set_prefix    classes 2               ;$09
0226 D0FF 03 D1                        info_at set_prefix0
0227 D101 0C D1                        info_at set_prefix1
0228 D103 10 08 00     set_prefix0     ctype   4
0229 D106 32                           pathptr 2
0230 D107 E0 9A E2 00                  exec    set_prefix
0231 D10B 00                           end_script
0232 D10C 10 08 00     set_prefix1     ctype   4
0233 D10F 22                           pcount  2
0234 D110 62                           maxpcnt 2
0235 D111 34                           pathptr 4
0236 D112 E0 9A E2 00                  exec    set_prefix
0237 D116 00                           end_script
0238 D117
0239 D117 02           s_get_prefix    classes 2               ;$0A
0240 D118 1C D1                        info_at get_prefix0
0241 D11A 25 D1                        info_at get_prefix1
0242 D11C 10 08 00     get_prefix0     ctype   4
0243 D11F 52                           outpath 2
0244 D120 E0 FB E2 00                  exec    get_prefix
0245 D124 00                           end_script
0246 D125 10 08 00     get_prefix1     ctype   4
0247 D128 22                           pcount  2
0248 D129 62                           maxpcnt 2
0249 D12A 54                           outpath 4
0250 D12B E0 FB E2 00                  exec    get_prefix
0251 D12F 00                           end_script
0252 D130
0253 D130 02           clear_backup    classes 2               ;$0B
0254 D131 35 D1                        info_at clear_backup0
0255 D133 3A D1                        info_at clear_backup1
0256 D135 10 04 00     clear_backup0   ctype   2
0257 D138 30                           pathptr 0
0258 D139 00                           end_script
0259 D13A 10 04 00     clear_backup1   ctype   2
0260 D13D 21                           pcount  1
0261 D13E 32                           pathptr 2
0262 D13F 00                           end_script
0263 D140
0264 D140 02           s_set_sys_prefs classes 2               ;$0C
0265 D141 00 00                        no_such_class
0266 D143 45 D1                        info_at set_sys_prefs1
0267 D145 10 08 00     set_sys_prefs1  ctype   4
0268 D148 21                           pcount  1
0269 D149 61                           maxpcnt 1
0270 D14A E0 3B E8 00                  exec    set_sys_prefs
0271 D14E 00                           end_script
0272 D14F
0273 D14F 02           s_null          classes 2               ;$0D
0274 D150 00 00                        no_such_class
0275 D152 54 D1                        info_at null1
0276 D154 10 08 00     null1           ctype   4
0277 D157 60                           maxpcnt 0
0278 D158 E0 6E E6 00                  exec    null_call
0279 D15C 00                           end_script
0280 D15D
0281 D15D 02           s_expand_path   classes 2               ;$0E
0282 D15E 00 00                        no_such_class
0283 D160 62 D1                        info_at expand_path_1
0284 D162 10 08 00     expand_path_1   ctype   4
0285 D165 22                           pcount  2
0286 D166 63                           maxpcnt 3
0287 D167 32                           pathptr 2
0288 D168 56                           outpath 6
0289 D169 E0 5A E5 00                  exec    expand_path
0290 D16D 00                           end_script
0291 D16E
0292 D16E 02           s_get_sys_prefs classes 2               ;$0F
0293 D16F 00 00                        no_such_class
0294 D171 73 D1                        info_at get_sys_prefs1
0295 D173 10 08 00     get_sys_prefs1  ctype   4
0296 D176 21                           pcount  1
0297 D177 61                           maxpcnt 1
0298 D178 E0 50 E8 00                  exec    get_sys_prefs
0299 D17C 00                           end_script
0300 D17D
0301 D17D 02           s_open          classes 2               ;$10
0302 D17E 82 D1                        info_at open0
0303 D180 87 D1                        info_at open1
0304 D182 10 04 00     open0           ctype   2
0305 D185 32                           pathptr 2
0306 D186 00                           end_script
0307 D187 10 04 00     open1           ctype   2
0308 D18A 22                           pcount  2
0309 D18B 34                           pathptr 4
0310 D18C 00                           end_script
0311 D18D
0312 D18D 02           s_newline       classes 2               ;$11
0313 D18E 92 D1                        info_at newline0
0314 D190 9B D1                        info_at newline1
0315 D192 10 08 00     newline0        ctype   4
0316 D195 40                           refnum  0
0317 D196 E0 86 E6 00                  exec    newline
0318 D19A 00                           end_script
0319 D19B 10 08 00     newline1        ctype   4
0320 D19E 24                           pcount  4
0321 D19F 64                           maxpcnt 4
0322 D1A0 42                           refnum  2
0323 D1A1 E0 86 E6 00                  exec    newline
0324 D1A5 00                           end_script
0325 D1A6
0326 D1A6 02           s_read          classes 2               ;$12
0327 D1A7 AB D1                        info_at read0
0328 D1A9 B1 D1                        info_at read1
0329 D1AB 10 06 00     read0           ctype   3
0330 D1AE 40                           refnum  0
0331 D1AF 32                           pathptr 2
0332 D1B0 00                           end_script
0333 D1B1 10 06 00     read1           ctype   3
0334 D1B4 24                           pcount  4
0335 D1B5 42                           refnum  2
0336 D1B6 34                           pathptr 4
0337 D1B7 00                           end_script
0338 D1B8
0339 D1B8 02           write           classes 2               ;$13
0340 D1B9 BD D1                        info_at write0
0341 D1BB C3 D1                        info_at write1
0342 D1BD 10 06 00     write0          ctype   3
0343 D1C0 40                           refnum  0
0344 D1C1 32                           pathptr 2
0345 D1C2 00                           end_script
0346 D1C3 10 06 00     write1          ctype   3
0347 D1C6 24                           pcount  4
0348 D1C7 42                           refnum  2
0349 D1C8 34                           pathptr 4
0350 D1C9 00                           end_script
0351 D1CA
0352 D1CA 02           s_close         classes 2               ;$14
0353 D1CB CF D1                        info_at close0
0354 D1CD D3 D1                        info_at close1
0355 D1CF 10 0C 00     close0          ctype   6
0356 D1D2 00                           end_script
0357 D1D3 10 0C 00     close1          ctype   6
0358 D1D6 21                           pcount  1
0359 D1D7 00                           end_script
0360 D1D8
0361 D1D8 02           flush           classes 2               ;$15
0362 D1D9 DD D1                        info_at flush0
0363 D1DB E1 D1                        info_at flush1
0364 D1DD 10 0C 00     flush0          ctype   6
0365 D1E0 00                           end_script
0366 D1E1 10 0C 00     flush1          ctype   6
0367 D1E4 21                           pcount  1
0368 D1E5 00                           end_script
0369 D1E6
0370 D1E6 02           set_mark        classes 2               ;$16
0371 D1E7 EB D1                        info_at set_mark0
0372 D1E9 F0 D1                        info_at set_mark1
0373 D1EB 10 06 00     set_mark0       ctype   3
0374 D1EE 40                           refnum  0
0375 D1EF 00                           end_script
0376 D1F0 10 06 00     set_mark1       ctype   3
0377 D1F3 23                           pcount  3
0378 D1F4 42                           refnum  2
0379 D1F5 00                           end_script
0380 D1F6
0381 D1F6 02           get_mark        classes 2               ;$17
0382 D1F7 FB D1                        info_at get_mark0
0383 D1F9 00 D2                        info_at get_mark1
0384 D1FB 10 06 00     get_mark0       ctype   3
0385 D1FE 40                           refnum  0
0386 D1FF 00                           end_script
0387 D200 10 06 00     get_mark1       ctype   3
0388 D203 22                           pcount  2
0389 D204 42                           refnum  2
0390 D205 00                           end_script
0391 D206
0392 D206 02           set_eof         classes 2               ;$18
0393 D207 0B D2                        info_at set_eof0
0394 D209 10 D2                        info_at set_eof1
0395 D20B 10 06 00     set_eof0        ctype   3
0396 D20E 40                           refnum  0
0397 D20F 00                           end_script
0398 D210 10 06 00     set_eof1        ctype   3
0399 D213 23                           pcount  3
0400 D214 42                           refnum  2
0401 D215 00                           end_script
0402 D216
0403 D216 02           s_get_eof       classes 2               ;$19
0404 D217 1B D2                        info_at get_eof0
0405 D219 20 D2                        info_at get_eof1
0406 D21B 10 06 00     get_eof0        ctype   3
0407 D21E 40                           refnum  0
0408 D21F 00                           end_script
0409 D220 10 06 00     get_eof1        ctype   3
0410 D223 22                           pcount  2
0411 D224 42                           refnum  2
0412 D225 00                           end_script
0413 D226
0414 D226 02           s_set_level     classes 2               ;$1A
0415 D227 2B D2                        info_at set_level0
0416 D229 33 D2                        info_at set_level1
0417 D22B 10 08 00     set_level0      ctype   4
0418 D22E E0 3B E4 00                  exec    set_level
0419 D232 00                           end_script
0420 D233 10 08 00     set_level1      ctype   4
0421 D236 21                           pcount  1
0422 D237 62                           maxpcnt 2
0423 D238 E0 3B E4 00                  exec    set_level
0424 D23C 00                           end_script
0425 D23D
0426 D23D 02           s_get_level     classes 2               ;$1B
0427 D23E 42 D2                        info_at get_level0
0428 D240 4A D2                        info_at get_level1
0429 D242 10 08 00     get_level0      ctype   4
0430 D245 E0 0B E4 00                  exec    get_level
0431 D249 00                           end_script
0432 D24A 10 08 00     get_level1      ctype   4
0433 D24D 21                           pcount  1
0434 D24E 62                           maxpcnt 2
0435 D24F E0 0B E4 00                  exec    get_level
0436 D253 00                           end_script
0437 D254
0438 D254 02           get_dir_entry   classes 2               ;$1C
0439 D255 59 D2                        info_at get_dir_entry0
0440 D257 5E D2                        info_at get_dir_entry1
0441 D259 10 06 00     get_dir_entry0  ctype   3
0442 D25C 40                           refnum  0
0443 D25D 00                           end_script
0444 D25E 10 06 00     get_dir_entry1  ctype   3
0445 D261 25                           pcount  5
0446 D262 42                           refnum  2
0447 D263 00                           end_script
0448 D264
0449 D264 02           s_begin_session classes 2               ;$1D
0450 D265 00 00                        no_such_class
0451 D267 69 D2                        info_at beg_session1
0452 D269 10 08 00     beg_session1    ctype   4
0453 D26C 60                           maxpcnt 0
0454 D26D E0 5B E8 00                  exec    begin_session
0455 D271 00                           end_script
0456 D272
0457 D272 02           s_end_session   classes 2               ;$1E
0458 D273 00 00                        no_such_class
0459 D275 77 D2                        info_at end_session1
0460 D277 10 08 00     end_session1    ctype   4
0461 D27A 60                           maxpcnt 0
0462 D27B E0 63 E8 00                  exec    end_session
0463 D27F 00                           end_script
0464 D280
0465 D280 02           s_session_stat  classes 2               ;$1F
0466 D281 00 00                        no_such_class
0467 D283 85 D2                        info_at session_stat1
0468 D285 10 08 00     session_stat1   ctype   4
0469 D288 21                           pcount  1
0470 D289 61                           maxpcnt 1
0471 D28A E0 9B E8 00                  exec    session_status
0472 D28E 00                           end_script
0473 D28F
0474 D28F 02           get_dev_num     classes 2               ;$20
0475 D290 94 D2                        info_at get_dev_num0
0476 D292 99 D2                        info_at get_dev_num1
0477 D294 10 04 00     get_dev_num0    ctype   2
0478 D297 30                           pathptr 0
0479 D298 00                           end_script
0480 D299 10 04 00     get_dev_num1    ctype   2
0481 D29C 22                           pcount  2
0482 D29D 32                           pathptr 2
0483 D29E 00                           end_script
0484 D29F
0485 D29F 01           get_last_dev    classes 1               ;$21
0486 D2A0 A2 D2                        info_at get_last_dev0
0487 D2A2 10 08 00     get_last_dev0   ctype   4
0488 D2A5 E0 14 DD 00                  exec    do_get_last_dev
0489 D2A9 00                           end_script
0490 D2AA
0491 D2AA 01           read_block      classes 1               ;$22
0492 D2AB AD D2                        info_at read_block0
0493 D2AD 10 02 00     read_block0     ctype   1
0494 D2B0 40                           refnum  0
0495 D2B1 00                           end_script
0496 D2B2
0497 D2B2 01           write_block     classes 1               ;$23
0498 D2B3 B5 D2                        info_at write_block0
0499 D2B5 10 02 00     write_block0    ctype   1
0500 D2B8 40                           refnum  0
0501 D2B9 00                           end_script
0502 D2BA
0503 D2BA 02           s_format        classes 2               ;$24
0504 D2BB BF D2                        info_at format0
0505 D2BD C5 D2                        info_at format1
0506 D2BF 10 0E 00     format0         ctype   7
0507 D2C2 30                           pathptr 0
0508 D2C3 34                           pathptr 4
0509 D2C4 00                           end_script
0510 D2C5 10 0E 00     format1         ctype   7
0511 D2C8 21                           pcount  1
0512 D2C9 66                           maxpcnt 6
0513 D2CA 32                           pathptr 2
0514 D2CB              *               pathptr 6
0515 D2CB 00                           end_script
0516 D2CC
0517 D2CC 02           s_erase_disk    classes 2               ;$25
0518 D2CD D1 D2                        info_at erase_disk0
0519 D2CF D7 D2                        info_at erase_disk1
0520 D2D1 10 0E 00     erase_disk0     ctype   7
0521 D2D4 30                           pathptr 0
0522 D2D5 34                           pathptr 4
0523 D2D6 00                           end_script
0524 D2D7 10 0E 00     erase_disk1     ctype   7
0525 D2DA 21                           pcount  1
0526 D2DB 66                           maxpcnt 6
0527 D2DC 32                           pathptr 2
0528 D2DD              *               pathptr 6
0529 D2DD 00                           end_script
0530 D2DE
0531 D2DE 02           s_reset_cache   classes 2               ;$26
0532 D2DF 00 00                        no_such_class
0533 D2E1 E3 D2                        info_at reset_cache_1
0534 D2E3 10 08 00     reset_cache_1   ctype   4
0535 D2E6 60                           maxpcnt 0
0536 D2E7 E0 A5 E8 00                  exec    reset_cache
0537 D2EB 00                           end_script
0538 D2EC
0539 D2EC 02           s_get_name      classes 2               ;$27
0540 D2ED F1 D2                        info_at get_name0
0541 D2EF FA D2                        info_at get_name1
0542 D2F1 10 08 00     get_name0       ctype   4
0543 D2F4 30                           pathptr 0
0544 D2F5 E0 E5 E5 00                  exec    get_name
0545 D2F9 00                           end_script
0546 D2FA 10 08 00     get_name1       ctype   4
0547 D2FD 21                           pcount  1
0548 D2FE 62                           maxpcnt 2
0549 D2FF 32                           pathptr 2
0550 D300 E0 E5 E5 00                  exec    get_name
0551 D304 00                           end_script
0552 D305
0553 D305 02           s_get_boot_vol  classes 2               ;$28
0554 D306 0A D3                        info_at get_boot_vol0
0555 D308 13 D3                        info_at get_boot_vol1
0556 D30A 10 08 00     get_boot_vol0   ctype   4
0557 D30D 50                           outpath 0
0558 D30E E0 9A E3 00                  exec    get_boot_vol
0559 D312 00                           end_script
0560 D313 10 08 00     get_boot_vol1   ctype   4
0561 D316 21                           pcount  1
0562 D317 61                           maxpcnt 1
0563 D318 52                           outpath 2
0564 D319 E0 9A E3 00                  exec    get_boot_vol
0565 D31D 00                           end_script
0566 D31E
0567 D31E 02           s_quit          classes 2               ;$29
0568 D31F 23 D3                        info_at quit0
0569 D321 2B D3                        info_at quit1
0570 D323 10 08 00     quit0           ctype   4
0571 D326 E0 D7 E9 00                  exec    do_quit
0572 D32A 00                           end_script
0573 D32B 10 08 00     quit1           ctype   4
0574 D32E 62                           maxpcnt 2
0575 D32F E0 D7 E9 00                  exec    do_quit
0576 D333 00                           end_script
0577 D334
0578 D334 02           s_get_version   classes 2               ;$2A
0579 D335 39 D3                        info_at get_version0
0580 D337 41 D3                        info_at get_version1
0581 D339 10 08 00     get_version0    ctype   4
0582 D33C E0 5A E4 00                  exec    get_version
0583 D340 00                           end_script
0584 D341 10 08 00     get_version1    ctype   4
0585 D344 21                           pcount  1
0586 D345 61                           maxpcnt 1
0587 D346 E0 5A E4 00                  exec    get_version
0588 D34A 00                           end_script
0589 D34B
0590 D34B 02           s_get_fst_info  classes 2               ;$2B
0591 D34C 00 00                        no_such_class
0592 D34E 50 D3                        info_at get_fst_info1
0593 D350 10 08 00     get_fst_info1   ctype   4
0594 D353 22                           pcount  2
0595 D354 68                           maxpcnt 8
0596 D355 E0 60 E7 00                  exec    get_fst_info
0597 D359 00                           end_script
0598 D35A
0599 D35A              s_d_info                                ;$2C
0600 D35A              ;               classes 2
0601 D35A              ;               info_at d_info0
0602 D35A              ;               info_at d_info1
0603 D35A              ;d_info0        ctype   5
0604 D35A              ;               dnum    0
0605 D35A              ;               outpath 2
0606 D35A              ;               end_script
0607 D35A              ;d_info1        ctype   5
0608 D35A              ;               pcount  2
0609 D35A              ;               dnum    2
0610 D35A              ;               outpath 4
0611 D35A              ;               end_script
0612 D35A
0613 D35A              s_d_status                              ;$2D
0614 D35A              ;               classes 2
0615 D35A              ;               no_such_class
0616 D35A              ;               info_at d_status1
0617 D35A              ;d_status1      ctype   5
0618 D35A              ;               pcount  5
0619 D35A              ;               dnum    2
0620 D35A              ;               end_script
0621 D35A
0622 D35A              s_d_control                             ;$2E
0623 D35A              ;               classes 2
0624 D35A              ;               no_such_class
0625 D35A              ;               info_at d_control1
0626 D35A              ;d_control1     ctype   5
0627 D35A              ;               pcount  5
0628 D35A              ;               dnum    2
0629 D35A              ;               end_script
0630 D35A
0631 D35A              s_d_read                                ;$2F
0632 D35A              ;               classes 2
0633 D35A              ;               no_such_class
0634 D35A              ;               info_at d_read1
0635 D35A              ;d_read1        ctype   5
0636 D35A              ;               pcount  6
0637 D35A              ;               dnum    2
0638 D35A              ;               end_script
0639 D35A
0640 D35A              s_d_rename                              ;Dummy entry. ($36)
0641 D35A              s_d_write                               ;$30
0642 D35A              ;               classes 2
0643 D35A              ;               no_such_class
0644 D35A              ;               info_at d_write1
0645 D35A              ;d_write1       ctype   5
0646 D35A              ;               pcount  6
0647 D35A              ;               dnum    2
0648 D35A              ;               end_script
0649 D35A
0650 D35A 02           s_alloc_int     classes 2               ;$31
0651 D35B 5F D3                        info_at alloc_int0
0652 D35D 68 D3                        info_at alloc_int1
0653 D35F 10 08 00     alloc_int0      ctype   4
0654 D362 32                           pathptr 2
0655 D363 E0 C6 EA 00                  exec    alloc_int
0656 D367 00                           end_script
0657 D368 10 08 00     alloc_int1      ctype   4
0658 D36B 23                           pcount  3
0659 D36C 63                           maxpcnt 3
0660 D36D 36                           pathptr 6
0661 D36E E0 EB EA 00                  exec    bind_int
0662 D372 00                           end_script
0663 D373
0664 D373 02           s_dealloc_int   classes 2               ;$32
0665 D374 78 D3                        info_at dealloc_int0
0666 D376 81 D3                        info_at dealloc_int1
0667 D378 10 08 00     dealloc_int0    ctype   4
0668 D37B 40                           refnum  0
0669 D37C E0 2B EB 00                  exec    dealloc_int
0670 D380 00                           end_script
0671 D381 10 08 00     dealloc_int1    ctype   4
0672 D384 21                           pcount  1
0673 D385 61                           maxpcnt 1
0674 D386 42                           refnum  2
0675 D387 E0 3F EB 00                  exec    unbind_int
0676 D38B 00                           end_script
0677 D38C
0678 D38C 02           fst_specific    classes 2               ;$33
0679 D38D 00 00                        no_such_class
0680 D38F 91 D3                        info_at fst_specific1
0681 D391 10 08 00     fst_specific1   ctype   4
0682 D394 22                           pcount  2
0683 D395 42                           refnum  2
0684 D396 E0 70 E6 00                  exec    fst_spec
0685 D39A 00                           end_script
0686 D39B
0687 D39B
0688 D39B 02           s_add_queue     classes 2               ;$34
0689 D39C 00 00                        no_such_class
0690 D39E A0 D3                        info_at s_add_queue1
0691 D3A0 10 08 00     s_add_queue1    ctype   4
0692 D3A3 21                           pcount  1
0693 D3A4 61                           maxpcnt 1
0694 D3A5 E0 99 B3 00                  exec    os_add_queue
0695 D3A9 00                           end_script
0696 D3AA
0697 D3AA
0698 D3AA 02           s_delete_queue  classes 2               ;$35
0699 D3AB 00 00                        no_such_class
0700 D3AD AF D3                        info_at s_delete_queue1
0701 D3AF 10 08 00     s_delete_queue1 ctype   4
0702 D3B2 21                           pcount  1
0703 D3B3 61                           maxpcnt 1
0704 D3B4 E0 9E B3 00                  exec    os_delete_queue
0705 D3B8 00                           end_script
0706 D3B9
0707 D3B9              ;d_rename                               ;$36
0708 D3B9
0709 D3B9 02           s_get_std_ref   classes 2               ;$37
0710 D3BA 00 00                        no_such_class
0711 D3BC BE D3                        info_at get_std_ref1
0712 D3BE 10 08 00     get_std_ref1    ctype   4
0713 D3C1 22                           pcount  2
0714 D3C2 62                           maxpcnt 2
0715 D3C3 E0 1C B4 00                  exec    get_std_ref_num
0716 D3C7 00                           end_script
0717 D3C8
0718 D3C8 02           s_get_ref_num   classes 2               ;$38
0719 D3C9 00 00                        no_such_class
0720 D3CB CD D3                        info_at get_ref1
0721 D3CD 10 08 00     get_ref1        ctype   4
0722 D3D0 22                           pcount  2
0723 D3D1 66                           maxpcnt 6
0724 D3D2 32                           pathptr 2
0725 D3D3 E0 78 B5 00                  exec    get_ref_num
0726 D3D7 00                           end_script
0727 D3D8
0728 D3D8 02           s_get_ref_info  classes 2               ;$39
0729 D3D9 00 00                        no_such_class
0730 D3DB DD D3                        info_at get_ref_info1
0731 D3DD 10 08 00     get_ref_info1   ctype   4
0732 D3E0 22                           pcount  2
0733 D3E1 65                           maxpcnt 5
0734 D3E2 E0 F1 B5 00                  exec    get_ref_info
0735 D3E6 00                           end_script
0736 D3E7
0737 D3E7 02           s_set_std_ref   classes 2               ;$3A
0738 D3E8 00 00                        no_such_class
0739 D3EA EC D3                        info_at set_std_ref1
0740 D3EC 10 08 00     set_std_ref1    ctype   4
0741 D3EF 22                           pcount  2
0742 D3F0 62                           maxpcnt 2
0743 D3F1 E0 44 B4 00                  exec    set_std_ref_num
0744 D3F5 00                           end_script
0745 D3F6
0746 D3F6 32           path_script     pathptr 2
0747 D3F7 00                           end_script
0748 D3F8
0749 D3F8                              print   pop
0750 D3F8
0751 D3F8              ;===============================================================================
0752 D3F8              ; Call Type Vector Table
0753 D3F8              ;
0754 D3F8              ; Each call has a type specified by the ctype field in the Call Descriptor
0755 D3F8              ; Table.  The value in this field is an index number into the Call Type Vector
0756 D3F8              ; Table.  Each entry in this table is the two byte address of a routine that
0757 D3F8              ; performs tasks specific to the calls of the given type.
0758 D3F8              ;===============================================================================
0759 D3F8
0760 D3F8 D9 B7        ctype_vector DC W:do_type_0             ;not a legal type
0761 D3FA DD B7                 DC W:do_type_1                 ;read_block and write_block
0762 D3FC CA D7                 DC W:do_type_2                 ;FST bouncing calls w/pathname parms
0763 D3FE 78 DA                 DC W:do_type_3                 ;file access using refnums
0764 D400 1A DB                 DC W:do_type_4                 ;calls requiring unique processing
0765 D402 1D DB                 DC W:do_type_5                 ;d_info, d_status, etc.
0766 D404 22 DB                 DC W:do_type_6                 ;flush & close
0767 D406 76 DB                 DC W:do_type_7                 ;format & erase_disk
0768 D408              ;	 aif	not debug_calls,.dt
0769 D408              ;	 dc	i2'debug'	 ;The debug call
0770 D408              ;.dt	 anop
0771 D408
0772 D408                       end_proc 
0773 D408                       eject 
0774 D408              ;===============================================================================
0775 D408              ; Initialize the System Call Manager
0776 D408              ;===============================================================================
0777 D408
0778 D408              ;===============================================================================
0779 D408              ; init_scm:  Initialize the System Call Manager
0780 D408              ;
0781 D408              ; This routine initializes the state of the System Call Manager.  Therefore, it
0782 D408              ; must be executed before making any GS/OS system calls.
0783 D408              ;
0784 D408              ; Created:      4/22/87
0785 D408              ; Modified:     11/17/88
0786 D408              ; Author:       JJ
0787 D408              ;
0788 D408              ; Enter:        jsl     init_scm
0789 D408              ;
0790 D408              ; Input:        P = nvmxdizc
0791 D408              ;                   ..000...
0792 D408              ;
0793 D408              ; Output:       P = nvmxdizc
0794 D408              ;                   ..000..|
0795 D408              ;                          0=no error, 1=error
0796 D408              ;===============================================================================
0797 D408
0798 D408              init_scm proc 
0799 D408
0800 D408
0801 D408              ocjml    equ   $5C                      ;opcode of the jml instruction
0802 D408
0803 D408 8B                    phb                            ;save DBR
0804 D409 4B                    phk                            ;set DBR to value in PBR
0805 D40A AB                    plb   
0806 D40B
0807 D40B A9 0F B8              lda   #fst_count               ;Set fst_tbl_ptr for Ray's DA.
0808 D40E 8D F2 B9              sta   fst_tbl_ptr
0809 D411 A9 00 00              lda   #fst_count>>16
0810 D414 8D F4 B9              sta   fst_tbl_ptr+2
0811 D417
0812 D417 A9 00 80              lda   #set_user_level          ;Init system level.
0813 D41A 8D 58 E4              sta   |system_level
0814 D41D
0815 D41D A9 00 80              lda   #default_prefs           ;set default system behavior
0816 D420 8F F6 B9 00           sta   >sys_prefs               ;...preferences
0817 D424
0818 D424 A9 00 00              lda   #session_off             ;indicate no session in progress
0819 D427 8F FE B9 00           sta   >session_stat
0820 D42B
0821 D42B A9 FF 7F              lda   #is_inactive             ;indicate that GS/OS is inactive, i.e.
0822 D42E 2F BE 00 E1           and   >active_flag             ;... no GS/OS call in progress
0823 D432 8F BE 00 E1           sta   >active_flag
0824 D436
0825 D436 A9 5C 00              lda   #ocjml                   ;place jml opcode as first byte of each
0826 D439 8F A8 00 E1           sta   >pro16mli                ;... GS/OS entry vector
0827 D43D 8F B0 00 E1           sta   >stkpro16mli
0828 D441
0829 D441 A9 00 9E              lda   #inline_entry            ;insert inline entry address in next
0830 D444 8F A9 00 E1           sta   >pro16mli+1              ;... three bytes of the vector
0831 D448 A9 9E 00              lda   #inline_entry>>8
0832 D44B 8F AA 00 E1           sta   >pro16mli+2
0833 D44F
0834 D44F A9 12 9E              lda   #stack_entry             ;insert stack entry address in next
0835 D452 8F B1 00 E1           sta   >stkpro16mli+1           ;... three bytes of the vector
0836 D456 A9 9E 00              lda   #stack_entry>>8
0837 D459 8F B2 00 E1           sta   >stkpro16mli+2
0838 D45D              *
0839 D45D              * At this point we need to conditionally call init code based on the state of
0840 D45D              * the warm_cold_flag...
0841 D45D              *
0842 D45D AF D0 01 E1           lda   >warm_cold_flag          ;Warm startup?
0843 D461 D0 0B                 bne   do_cache                 ;Yes, skip ahead.
0844 D463
0845 D463 20 F3 B6              jsr   init_fst_tbl             ;initialize the FST Table
0846 D466 B0 14                 bcs   error_exit
0847 D468
0848 D468 22 01 F4 00           jsl   init_gim
0849 D46C B0 0E                 bcs   error_exit
0850 D46E
0851 D46E 22 0C FC 01  do_cache jsl   cache_init               ;initialize the cache
0852 D472 B0 08                 bcs   error_exit
0853 D474
0854 D474 20 62 EA              jsr   init_int                 ;initialize the interrupt manager
0855 D477 B0 03                 bcs   error_exit
0856 D479
0857 D479 20 BF EC              jsr   init_signal
0858 D47C              *	bcs	error_exit
0859 D47C              *
0860 D47C              *normal_exit			;indicate no error
0861 D47C
0862 D47C              error_exit                              ;indicate error
0863 D47C AB                    plb                            ;restore value of DBR
0864 D47D 6B                    rtl   
0865 D47E
0866 D47E                       end_proc 
0867 D47E                       eject 
0868 D47E              ;===============================================================================
0869 D47E              ; shutdown_scm:  Shutdown the System Call Manager
0870 D47E              ;
0871 D47E              ; This routine does a complete shut down of the System Call Manager.  All memory
0872 D47E              ;  used by the SCM is released, the ID is returned, all FSTs are shutdown and
0873 D47E              ;  the memory released, and the cache is shut down.  If errors occur they are
0874 D47E              ;  ignored.
0875 D47E              ;
0876 D47E              ; Created:      December 18, 1987
0877 D47E              ; Modified:
0878 D47E              ; Author:       MSA
0879 D47E              ;
0880 D47E              ; Enter:        jsl     shutdown_scm
0881 D47E              ;
0882 D47E              ;               warm_cold_flag          ;0 = cold, 1 = warm.
0883 D47E              ;
0884 D47E              ; Input:        P = nvmxdizc
0885 D47E              ;                   ..000...
0886 D47E              ;
0887 D47E              ; Output:       P = nvmxdizc
0888 D47E              ;                   ..000...
0889 D47E              ;
0890 D47E              ;===============================================================================
0891 D47E
0892 D47E              shutdown_scm proc 
0893 D47E
0894 D47E              *
0895 D47E              * Set data bank to program bank...
0896 D47E              *
0897 D47E 8B                    phb   
0898 D47F 4B                    phk   
0899 D480 AB                    plb   
0900 D481              *
0901 D481              * Shutdown the signal dispatcher heartbeat task and make sure we are out of
0902 D481              * the main interrupt vector...
0903 D481              *
0904 D481 F4 00 00              pea   signal_beat>>16          ;Shut off heartbeat.
0905 D484 F4 90 9F              pea   signal_beat
0906 D487 A2 03 13 22           _DelHeartBeat 
0907 D48E
0908 D48E 20 95 B6              jsr   remove_int_vec           ;Make sure we're out.
0909 D491              *
0910 D491              * We also need to release all VCRs...
0911 D491              *
0912 D491 A9 01 00     vcr_loop lda   #0001                    ;Set to get first VCR.
0913 D494 22 3C F9 00           jsl   getvcr                   ;Get a VP to a VCR. Done all?
0914 D498 B0 0E                 bcs   fsts                     ;Yep, so continue on.
0915 D49A 20 3C B7              jsr   deref2_vp                ;No, put pointer into dirpg vcr
0916 D49D A0 00 00              ldy   #vcr_id                  ;Now release VCR.
0917 D4A0 B7 F8                 lda   [<vcr],y
0918 D4A2 22 E7 F6 00           jsl   alt_rel_vcr
0919 D4A6 80 E9                 bra   vcr_loop                 ;Go do next one.
0920 D4A8              *
0921 D4A8              * Now let's loop thru all the fsts and do a shutdown call...
0922 D4A8              *
0923 D4A8 AD 17 B9     fsts     lda   |last_fst
0924 D4AB              fst_loop  
0925 D4AB 38                    sec                            ;Walk back to another FST
0926 D4AC ED 0D B8              sbc   |fst_entry_size
0927 D4AF AA                    tax   
0928 D4B0 DA                    phx                            ;Keep the index for later
0929 D4B1
0930 D4B1 A9 04 00              lda   #kill_fst
0931 D4B4 20 3B D5              jsr   do_fst
0932 D4B7              *
0933 D4B7              * If we're doing a warm shutdown, release the memory for the fst...
0934 D4B7              *
0935 D4B7 AF D0 01 E1           lda   >warm_cold_flag          ;Warm shutdown?
0936 D4BB D0 0D                 bne   next                     ;Yes, so don't release mem.
0937 D4BD
0938 D4BD AD 58 D5              lda   |jump_v+3                ;Push address
0939 D4C0 29 FF 00              and   #$00FF                   ;Isolate bank
0940 D4C3 A8                    tay   
0941 D4C4 AE 56 D5              ldx   |jump_v+1
0942 D4C7 20 EF D4              jsr   do_usd                   ;Release this FST
0943 D4CA
0944 D4CA 68           next     pla                            ;Get back the old index
0945 D4CB D0 DE                 bne   fst_loop                 ;Back for another FST
0946 D4CD              *
0947 D4CD              * Shut down the cache...
0948 D4CD              *
0949 D4CD 22 52 A6 00           jsl   >cash_shutdown
0950 D4D1              *
0951 D4D1              * If we're doing a cold shutdown, dispose of all GS/OS managed memory.
0952 D4D1              * We're done if not...
0953 D4D1              *
0954 D4D1 AF D0 01 E1           lda   >warm_cold_flag          ;Warm shutdown?
0955 D4D5 D0 16                 bne   exit                     ;Yes, so don't release mem.
0956 D4D7
0957 D4D7 AD E2 B9              lda   |gsos_id
0958 D4DA 48                    pha   
0959 D4DB A2 02 11 22           _DisposeAll 
0960 D4E2
0961 D4E2 AD E2 B9              lda   |gsos_id
0962 D4E5 48                    pha   
0963 D4E6 A2 03 21 22           _DeleteID 
0964 D4ED
0965 D4ED AB           exit     plb                            ;Restore data bank.
0966 D4EE 6B                    rtl   
0967 D4EF
0968 D4EF
0969 D4EF              do_usd                                  ;X,Y address of segment to unload
0970 D4EF
0971 D4EF              ; First use findHandle to ascertain the handle for this segment
0972 D4EF
0973 D4EF 48                    pha                            ;Push space for result
0974 D4F0 48                    pha                            ;Push more space for result
0975 D4F1
0976 D4F1 5A                    phy                            ;Push the address hi
0977 D4F2 DA                    phx                            ; and low
0978 D4F3 A2 02 1A 22           _FindHandle                    ;Do it
0979 D4FA 68 85 D4 68           PullLong <s_temp1              ;Shove handle into s_temp1
0980 D500
0981 D500              ; Now sneak a peak at the userID so that we can make a call to UserShutdown
0982 D500
0983 D500 A0 06 00              ldy   #$0006
0984 D503 B7 D4                 lda   [<s_temp1],y             ;Got ID
0985 D505 48                    pha                            ;Space for result
0986 D506 48                    pha                            ;Push ID
0987 D507 F4 00 00              pea   0000                     ;Push flags
0988 D50A A2 11 12 22           _UserShutdown 
0989 D511 68                    pla                            ;Pull off result and ignore
0990 D512
0991 D512 60                    rts   
0992 D513
0993 D513                       end_proc 
0994 D513                       eject 
0995 D513              *******************************************************************************
0996 D513              *
0997 D513              *        Name:  close_all_files
0998 D513              *
0999 D513              * Description:  Forces all files to be closed.
1000 D513              *
1001 D513              *      Author:  Bryan Atsatt
1002 D513              *     Created:  April 2, 1989
1003 D513              *    Modified:
1004 D513              *
1005 D513              *       Entry:  jsl
1006 D513              *
1007 D513              *       Input:  A = undefined
1008 D513              *               X = undefined
1009 D513              *               Y = undefined.
1010 D513              *               P = nvmxdizc
1011 D513              *                   ..000...
1012 D513              *
1013 D513              *      Output:  A = undefined
1014 D513              *               X = undefined
1015 D513              *               Y = undefined
1016 D513              *               P = nvmxdizc
1017 D513              *                   ..000..x
1018 D513              *
1019 D513              *        Exit:  rtl
1020 D513              *
1021 D513              *        Uses:  end_session
1022 D513              *               do_all
1023 D513              *               num
1024 D513              *
1025 D513              * Copyright Apple Computer, Inc. 1988  All rights reserved.
1026 D513              *******************************************************************************
1027 D513
1028 D513              close_all_files proc 
1029 D513
1030 D513 8B                    phb                            ;Save data bank.
1031 D514 4B                    phk                            ;Set to our code bank.
1032 D515 AB                    plb   
1033 D516              *
1034 D516              * Set preferences so will put up mount dialog (if needed) with no cancel
1035 D516              * button...
1036 D516              *
1037 D516 AF F6 B9 00           lda   >sys_prefs               ;Get prefs.
1038 D51A 48                    pha                            ;Save them.
1039 D51B A9 00 C0              lda   #%1100000000000000       ;Set b15 and 14.
1040 D51E 8F F6 B9 00           sta   >sys_prefs               ;Save it.
1041 D522              *
1042 D522              * End sessions and close all files...
1043 D522              *
1044 D522 20 63 E8              jsr   end_session              ;Make sure sessions off.
1045 D525
1046 D525 9C 58 E4              stz   |system_level            ;Set level to zero.
1047 D528
1048 D528 A9 14 00              lda   #$0014                   ;Fake a close call.
1049 D52B 85 30                 sta   <call_number
1050 D52D 0A                    asl   a
1051 D52E 8D A0 B9              sta   |num
1052 D531 20 2C DB              jsr   do_all                   ;Close all open files.
1053 D534              *
1054 D534              * Restore preferences and data bank and exit...
1055 D534              *
1056 D534 68                    pla                            ;Get preferences.
1057 D535 8F F6 B9 00           sta   >sys_prefs               ;Restore them.
1058 D539 AB                    plb                            ;Restore data bank.
1059 D53A 6B                    rtl   
1060 D53B
1061 D53B                       end_proc 
1062 D53B                       eject 
1063 D53B              ;===============================================================================
1064 D53B              ; do_fst:  Call an FSTs system entry point
1065 D53B              ;
1066 D53B              ; This routine calls the system entry point of an FST with the function code
1067 D53B              ;  passed in X.  A 4 byte parameter is shoved on the stack just prior to the
1068 D53B              ;  call and can be accessed by the FST with 3,s to 6,s.
1069 D53B              ;
1070 D53B              ; Created:      January 26, 1988
1071 D53B              ; Modified:
1072 D53B              ; Author:       MSA
1073 D53B              ;
1074 D53B              ; Input:        A = FST function code [1..n] * 2
1075 D53B              ;               X = Offset into FST table for this FST
1076 D53B              ;             vcr = Parameter to be passed on the stack
1077 D53B              ;               P = nvmxdizc
1078 D53B              ;                   ..000...
1079 D53B              ;
1080 D53B              ; Output:       s_temp1 = fst table header ptr
1081 D53B              ;               jump_v  = address of FST entry point
1082 D53B              ;               P = nvmxdizc
1083 D53B              ;                   ..000..x -> As returned from FST call
1084 D53B              ;
1085 D53B              ;===============================================================================
1086 D53B
1087 D53B              do_fst   proc 
1088 D53B                       entry jump_v
1089 D53B
1090 D53B              ; Pull the sys entry point for this FST and make up instruction that JSRs to it.
1091 D53B              ;  The FST is then called with X as the function code (function [1..n]*2).
1092 D53B
1093 D53B 48                    pha   
1094 D53C BD 13 B8              lda   fst_tbl+fst_hdr_ptr+2,x
1095 D53F 85 D6                 sta   <s_temp1+2
1096 D541 BD 11 B8              lda   fst_tbl+fst_hdr_ptr,x
1097 D544 85 D4                 sta   <s_temp1
1098 D546
1099 D546 A0 08 00              ldy   #sys_entry
1100 D549 B7 D4                 lda   [<s_temp1],y
1101 D54B 8D 56 D5              sta   |jump_v+1
1102 D54E C8                    iny   
1103 D54F B7 D4                 lda   [<s_temp1],y
1104 D551 8D 57 D5              sta   |jump_v+2
1105 D554 FA                    plx                            ;Pull back the function code
1106 D555
1107 D555              ; Call the FST
1108 D555
1109 D555              jump_v    
1110 D555 22 00 00 00           jsl   >$000000                 ;Set up by above code
1111 D559
1112 D559 4B                    phk   
1113 D55A AB                    plb                            ;Assume FST flagellated the dbr
1114 D55B
1115 D55B 60                    rts   
1116 D55C                       end_proc 
1117 D55C                       eject 
1118 D55C              ;===============================================================================
1119 D55C              ; GS/OS SYSTEM CALL MANAGER
1120 D55C              ;===============================================================================
1121 D55C              ; This module performs all general processing of GS/OS system calls from the
1122 D55C              ; point at which they are issued by an application to the point at which they
1123 D55C              ; are passed to other parts of the system, including other parts of the System
1124 D55C              ; Call Manager for further processing.
1125 D55C              ;===============================================================================
1126 D55C
1127 D55C              ;===============================================================================
1128 D55C              ; Main entry points for GS/OS system calls from application programs
1129 D55C              ;===============================================================================
1130 D55C              ;
1131 D55C              ; This module has been moved into its own file os.call.b00
1132 D55C              ;===============================================================================
1133 D55C
1134 D55C              ;===============================================================================
1135 D55C              ; Continuation of the GS/OS shell system call processor.  This portion resides
1136 D55C              ; in the language card.
1137 D55C              ;===============================================================================
1138 D55C
1139 D55C              gsos_lc_entry proc 
1140 D55C
1141 D55C
1142 D55C A9 00 00              lda   #$0000                   ;zero out ...
1143 D55F 8F 2F A0 00           sta   >temp_error              ;... temporary GS/OS error word and ...
1144 D563 8F 4A BD 00           sta   >direct_base+user_stack+2
1145 D567                                                      ;... top 2 bytes of user stack pointer
1146 D567
1147 D567 3B                    tsc                            ;capture user's stack pointer and ...
1148 D568 8F 48 BD 00           sta   >direct_base+user_stack
1149 D56C
1150 D56C E2 20                 sep   #m8                      ;enter 8-bit mode
1151 D56E EB                    xba                            ;was the stack in page $01?
1152 D56F 3A                    dec   a
1153 D570 D0 05                 bne   not_page_1               ;no, do nothing
1154 D572 EB                    xba                            ;yes, save stack offset
1155 D573 8F 00 01 01           sta   >emulstack
1156 D577 C2 20        not_page_1 rep   #m16                   ;back to 16-bit mode
1157 D579
1158 D579              *
1159 D579              * If the stack pointer is in our area, leave it alone; else set it to the top
1160 D579              * of our area...
1161 D579              *
1162 D579 3B                    tsc                            ;In our area?
1163 D57A C9 FF BF              cmp   #stack_top
1164 D57D B0 05                 bcs   set_top                  ;Nope.
1165 D57F C9 00 BE              cmp   #direct_base+$100
1166 D582 B0 04                 bcs   no_change                ;Yes, so no change.
1167 D584
1168 D584 A9 FF BF     set_top  lda   #stack_top               ;switch to GS/OS stack
1169 D587 1B                    tcs   
1170 D588
1171 D588 0B           no_change phd                           ;save user direct reg in GS/OS stack
1172 D589 A9 00 BD              lda   #direct_base             ;switch to GS/OS direct page
1173 D58C 5B                    tcd   
1174 D58D
1175 D58D              ; At this point, we begin running on the GS/OS stack and direct page
1176 D58D
1177 D58D 8B                    phb                            ;save DBR on GS/OS stack
1178 D58E
1179 D58E 4B                    phk                            ;set DBR to same value as PBR
1180 D58F AB                    plb   
1181 D590
1182 D590 AD 26 A0              lda   entry_type               ;prepare to get call_num and parm_block
1183 D593 F0 0E                 beq   lc_stack_entry           ;processing differs by inline vs. stack
1184 D595
1185 D595                       entry lc_inline_entry
1186 D595 A0 03 00     lc_inline_entry ldy   #3                ;set up pointer to 1 byte below call_num
1187 D598 B7 48                 lda   [<user_stack],y          ;user return address in user stack ...
1188 D59A 85 D4                 sta   <call_block              ;... is the proper value
1189 D59C C8                    iny   
1190 D59D B7 48                 lda   [<user_stack],y
1191 D59F 85 D5                 sta   <call_block+1
1192 D5A1 80 0A                 bra   get_parms
1193 D5A3
1194 D5A3                       entry lc_stack_entry
1195 D5A3 18           lc_stack_entry clc                      ;set up pointer to 1 byte below call_num
1196 D5A4 A5 48                 lda   <user_stack
1197 D5A6 69 05 00              adc   #5                       ;address of location 5 bytes above user
1198 D5A9 85 D4                 sta   <call_block              ;... stack pointer is the right value   
1199 D5AB 64 D6                 stz   <call_block+2
1200 D5AD
1201 D5AD A0 01 00     get_parms ldy   #1                      ;call_number to GS/OS direct page
1202 D5B0 B7 D4                 lda   [<call_block],y
1203 D5B2 85 30                 sta   <call_number
1204 D5B4 AA                    tax                            ;save in X temporarily
1205 D5B5
1206 D5B5 A0 03 00              ldy   #3                       ;param_blk_ptr to GS/OS direct page 
1207 D5B8 B7 D4                 lda   [<call_block],y
1208 D5BA 85 32                 sta   <param_blk_ptr
1209 D5BC A0 05 00              ldy   #5
1210 D5BF B7 D4                 lda   [<call_block],y
1211 D5C1 85 34                 sta   <param_blk_ptr+2
1212 D5C3
1213 D5C3              ;===============================================================================
1214 D5C3              ; At this point, the state of the system is as follows:
1215 D5C3              ;
1216 D5C3              ; All caller information has been saved.
1217 D5C3              ; The processor is in full native mode, 16-bit m and x
1218 D5C3              ; The system stack and zero page have been established at $00BFFF and $00BD00,
1219 D5C3              ;   respectively.
1220 D5C3              ; The user's D and DBR have been pushed on the system stack, so S=$BFFC.
1221 D5C3              ; The call number is in the word at direct page location $30
1222 D5C3              ; A pointer to the parameter block is in a long word at direct page $32.
1223 D5C3              ; The user stack pointer is saved at direct page location $4E.
1224 D5C3              ; System state variables entry_type, entry_mode, save_x, save_y, lc_state,
1225 D5C3              ;   and active_flag have been set properly.
1226 D5C3              ; System variable temp_error has been initialized to $0000.
1227 D5C3              ; Direct page locations temp1, temp2, temp3 and temp4 (16 bytes) are available.
1228 D5C3              ;===============================================================================
1229 D5C3
1230 D5C3              ;
1231 D5C3              ; doing a write to the console?  if so, then no need to lock down the
1232 D5C3              ; system memory or check the validity of the pblock
1233 D5C3              ;
1234 D5C3
1235 D5C3              *
1236 D5C3              * check to see if the call is a write call
1237 D5C3              *
1238 D5C3 A0 02 00              ldy   #2
1239 D5C6 E0 13 20              cpx   #$2013                   ; class 1 write?
1240 D5C9 F0 12                 beq   @chk_cons                ; yes ->
1241 D5CB E0 12 20              cpx   #$2012                   ; class 1 read?
1242 D5CE F0 0D                 beq   @chk_cons                ; yes ->
1243 D5D0 A0 00 00              ldy   #0
1244 D5D3 E0 13 00              cpx   #$0013                   ; class 0 write?
1245 D5D6 F0 05                 beq   @chk_cons
1246 D5D8 E0 12 00              cpx   #$0012                   ; class 0 read?
1247 D5DB D0 56                 bne   not_char_write           ; no, handle normally
1248 D5DD              *
1249 D5DD              * ok, it is a write call.  now check the fst_id of the file's
1250 D5DD              * fcr against the fst_id for the character fst.
1251 D5DD              *
1252 D5DD B7 32        @chk_cons lda   [<param_blk_ptr],y      ; get the ref #
1253 D5DF 22 72 F8 00           jsl   findfcr                  ; find the fcr
1254 D5E3 B0 4E                 bcs   not_char_write           ; error ->
1255 D5E5
1256 D5E5 86 3A                 stx   <fcr_ptr                 ; store vp of fcr for fst
1257 D5E7 84 3C                 sty   <fcr_ptr+2
1258 D5E9
1259 D5E9 22 09 FE 00           jsl   deref2                   ; deref it
1260 D5ED 86 D4                 stx   s_temp1
1261 D5EF 84 D6                 sty   s_temp1+2
1262 D5F1
1263 D5F1 A0 06 00              ldy   #fcr_fst_id              ; get the fst id
1264 D5F4 B7 D4                 lda   [<s_temp1],y
1265 D5F6 C9 09 00              cmp   #$0009                   ; character fst?
1266 D5F9 D0 38                 bne   not_char_write           ; no, so cannot be console driver ->
1267 D5FB              *
1268 D5FB              * the file belongs to the character fst. setup the call and class #'s for the
1269 D5FB              * fst.
1270 D5FB              *
1271 D5FB 64 3E                 stz   <vcr_ptr                 ; no vcr for char devices
1272 D5FD 64 40                 stz   <vcr_ptr+2
1273 D5FF
1274 D5FF A5 30                 lda   <call_number
1275 D601 AA                    tax   
1276 D602
1277 D602              *
1278 D602              * isolate the call class.  no need to clc before the rol, because I
1279 D602              * and it out anyways.
1280 D602              *
1281 D602 2A                    rol   a                        ; isolate the call class
1282 D603 2A                    rol   a
1283 D604 2A                    rol   a
1284 D605 2A                    rol   a
1285 D606 29 07 00              and   #$0007                   ; mask it out
1286 D609 0A           around_1 asl   a
1287 D60A 8D A2 B9              sta   class
1288 D60D
1289 D60D 8A                    txa                            ; isolate call #
1290 D60E 29 FF 1F              and   #$1FFF
1291 D611 0A                    asl   a
1292 D612 8D A0 B9              sta   num                      ; save it
1293 D615
1294 D615              *
1295 D615              * call the char fst
1296 D615              *
1297 D615 AD 13 B9              lda   char_index               ; get the char fst index
1298 D618 30 19                 bmi   not_char_write           ; no character FST!
1299 D61A
1300 D61A 20 AB B7              jsr   call_fst                 ; call the fst
1301 D61D 08                    php                            ; save error and carry
1302 D61E 48                    pha   
1303 D61F A9 00 C0              lda   #$C000                   ; init flag for no dec_busy or signal dispatch
1304 D622 A6 02                 ldx   <drvr_call_num           ; check the call #
1305 D624 E0 03 00              cpx   #drvr_write              ; was it a write call?
1306 D627 F0 03                 beq   @store                   ; yes, store io_flags as-is
1307 D629 A9 00 80              lda   #$8000                   ; else allow signal dispatch on exit
1308 D62C              @store    
1309 D62C 8D E0 B9              sta   io_flag                  ; store the flags
1310 D62F 68                    pla                            ; restore error and carry
1311 D630 28                    plp   
1312 D631 80 1F                 bra   to_skip_lock
1313 D633
1314 D633              not_char_write  
1315 D633 22 64 00 E1           jsl   inc_busy_flag            ; increment the system busy flag
1316 D637 9C E0 B9              stz   io_flag                  ; set flag to call dec_busy on exit
1317 D63A
1318 D63A A5 30                 lda   <call_number             ; get the call number again
1319 D63C 29 FF 1F              and   #$1FFF                   ; mask out call class
1320 D63F C9 2C 00              cmp   #d_calls_start           ; is it a device call?
1321 D642 90 14                 bcc   not_d_call               ; no...
1322 D644 C9 31 00              cmp   #d_calls_end
1323 D647 90 05                 bcc   @is_d_call               ; yes...
1324 D649 C9 36 00              cmp   #d_rename_num            ; is it a DRename call?
1325 D64C D0 0A                 bne   not_d_call               ; no, handle normally
1326 D64E              @is_d_call  
1327 D64E 22 CC FC 01           jsl   >dev_manager             ; call the device manager
1328 D652              to_skip_lock  
1329 D652 2A                    rol   a                        ; include carry in error code
1330 D653 8D 2F A0              sta   temp_error
1331 D656 80 1C                 bra   skip_lock
1332 D658
1333 D658              not_d_call  
1334 D658               if do_force_lock<>0 then  
1335 D658 22 D4 B6 00           jsl   force_lock               ;Lock all GS/OS managed memory.
1336 D65C               endif    
1337 D65C              ;
1338 D65C              ; Perform one-time checks that are required for all GS/OS system calls
1339 D65C              ;
1340 D65C 20 CD D6     do_check jsr   check_call
1341 D65F B0 0B                 bcs   error_finish             ;oops!  report the error condition {GAB}
1342 D661              ;
1343 D661              ; Now that the general contents of the parameter block have been validated,
1344 D661              ; branch to a call handling routine based on the value placed in the type field
1345 D661              ; by check_call.
1346 D661              ;
1347 D661 AE A4 B9              ldx   |type                    ;jump to appropriate call handler
1348 D664 FC F8 D3     do_call  jsr   (ctype_vector,x)
1349 D667 B0 03                 bcs   error_finish             ; save error and carry if there's an error
1350 D669 A9 00 00              lda   #$0000                   ; else make sure the saved error = 0 {GAB}
1351 D66C
1352 D66C 2A           error_finish rol   a                    ; rotate the carry into the error code (1)
1353 D66D 8D 2F A0              sta   temp_error               ; then save the combined error code/carry status
1354 D670
1355 D670              ;------------------------ D E B U G   C O D E ---------------------------------
1356 D670              ;
1357 D670              ;	 aif	not debug_calls,.nodebug
1358 D670              ;	 jsr	journal_add
1359 D670              ;.nodebug	 anop
1360 D670
1361 D670              ;------------------------ D E B U G   C O D E ---------------------------------
1362 D670
1363 D670               if do_force_lock<>0 then  
1364 D670 22 DC B6 00           jsl   force_unlock             ;Unlock all GS/OS managed memory.
1365 D674               endif    
1366 D674
1367 D674 AB           skip_lock plb                           ;restore caller's DBR
1368 D675 A5 48                 lda   user_stack               ;retrieve caller's stack pointer
1369 D677 2B                    pld                            ;restore caller's direct page
1370 D678 1B                    tcs                            ;restore caller's stack pointer
1371 D679
1372 D679 AF 2F A0 00           lda   >temp_error              ; restore carry bit and error code (3)
1373 D67D 4A                    lsr   a                        ; shift saved carry into P register
1374 D67E 8F 2F A0 00           sta   >temp_error              ; save the normalized error code again
1375 D682 B0 0A                 bcs   error_exit               ;handle error if carry set (1)
1376 D684
1377 D684 A3 02        no_error_exit lda   2,s                 ;retrieve saved user P register
1378 D686 29 FE FF              and   #not_c_flag              ;clear c flag
1379 D689 09 02 00              ora   #z_flag                  ;set z flag
1380 D68C 80 08                 bra   finished
1381 D68E
1382 D68E A3 02        error_exit lda   2,s                    ;retrieve saved user P register
1383 D690 29 FD FF              and   #not_z_flag              ;clear z flag
1384 D693 09 01 00              ora   #c_flag                  ;set c flag
1385 D696
1386 D696 83 02        finished sta   2,s                      ;restore the modified P register
1387 D698
1388 D698 4C 81 9E              jmp   return_from_lc           ;continue processing outside of lc
1389 D69B
1390 D69B                       end_proc 
1391 D69B                       eject 
1392 D69B              ;===============================================================================
1393 D69B              ; Perform general processing on GS/OS system calls
1394 D69B              ;===============================================================================
1395 D69B
1396 D69B              ;===============================================================================
1397 D69B              ; play_script:  Set up to play the script code pointed to by script_current, and
1398 D69B              ;               increment script_current to point to the next script code.
1399 D69B              ;
1400 D69B              ; Created:      5/11/87
1401 D69B              ; Modified:
1402 D69B              ; Author:       JJ
1403 D69B              ;
1404 D69B              ; Enter:        jsr     play_script
1405 D69B              ;
1406 D69B              ; Input:        script_current:  pointer to the current script code
1407 D69B              ;               P = nvmxdizc
1408 D69B              ;                   ..000...
1409 D69B              ;
1410 D69B              ; Output:       A = the current script code
1411 D69B              ;               X = address of the current script code
1412 D69B              ;               Y = trashed
1413 D69B              ;               P = nvmxdizc
1414 D69B              ;                   ..000.|.
1415 D69B              ;                         0=script code not 0, 1=script code is zero (end of
1416 D69B              ;                                                script)
1417 D69B              ;
1418 D69B              ; Side effects: Increments script_current by the appropriate amount to point to
1419 D69B              ;               the next script code.  Increments by zero for end of script code
1420 D69B              ;               and any undefined code.  Puts current script code information in
1421 D69B              ;               the registers.
1422 D69B              ;===============================================================================
1423 D69B              play_script proc 
1424 D69B
1425 D69B AE A8 B9              ldx   |script_current          ;address of current script code
1426 D69E BD 00 00              lda   |0,x                     ;get the code itself
1427 D6A1 4A                    lsr   a                        ;get the 4-bit code into bits 3:0
1428 D6A2 4A                    lsr   a
1429 D6A3 4A                    lsr   a
1430 D6A4 4A                    lsr   a
1431 D6A5 29 0F 00              and   #$000F                   ;... and zero out the remaining bits
1432 D6A8 A8                    tay   
1433 D6A9 B9 BD D6              lda   |sc_size,y               ;get size byte for script code
1434 D6AC 29 FF 00              and   #$00FF
1435 D6AF 18                    clc   
1436 D6B0 6D A8 B9              adc   |script_current
1437 D6B3 8D A8 B9              sta   |script_current
1438 D6B6 BD 00 00              lda   |0,x                     ;get the script code into A again
1439 D6B9 29 FF 00              and   #$00FF
1440 D6BC 60                    rts   
1441 D6BD
1442 D6BD 00 03 01 01  sc_size  DC B:0,3,1,1,1,1,1,1,0,0,0,0,0,0,4,0
1443 D6CD
1444 D6CD                       end_proc 
1445 D6CD                       eject 
1446 D6CD              ;===============================================================================
1447 D6CD              ; check_call:  Perform one-time general checks on GS/OS system calls, and set
1448 D6CD              ;              up the call processing pseudo-machine.
1449 D6CD              ;
1450 D6CD              ; Created:      5/5/87
1451 D6CD              ; Modified:
1452 D6CD              ; Author:       JJ
1453 D6CD              ;
1454 D6CD              ; Enter:        jsr     check_call
1455 D6CD              ;
1456 D6CD              ; Input:        call_number on direct page
1457 D6CD              ;                 bits 15:13 - subclass number for the call
1458 D6CD              ;                 bits 12:0  - primary call number
1459 D6CD              ;                 bit 8      - Westerfield kludge bit--if this bit is 1,
1460 D6CD              ;                              bits 15:9 must not all be zero
1461 D6CD              ;               parm_blk_ptr on direct page
1462 D6CD              ;               P = nvmxdizc
1463 D6CD              ;                   ..000...
1464 D6CD              ;
1465 D6CD              ; Output:       A = if c=0, undefined; if c=1, error code
1466 D6CD              ;                 = 0001 - bad system call
1467 D6CD              ;                 = 0004 - invalid pcount
1468 D6CD              ;                 = 0053 - parameter value out of range
1469 D6CD              ;                 = 0062 - invalid subclass for the call
1470 D6CD              ;               X = trashed
1471 D6CD              ;               Y = trashed
1472 D6CD              ;               P = nvmxdizc
1473 D6CD              ;                   ..000..|
1474 D6CD              ;                          0=no error, 1=error
1475 D6CD              ;
1476 D6CD              ; Side effects: Initializes the call processing pseudo-machine variables
1477 D6CD              ;               num, class, type, script_start, and script_current.
1478 D6CD              ;===============================================================================
1479 D6CD
1480 D6CD              check_call proc 
1481 D6CD              ;
1482 D6CD              ; Isolate call number and check its legality.  Call is illegal if 1) high byte
1483 D6CD              ; of 16-bit call number is $01 (indicating call to be handled by APW), 2)
1484 D6CD              ; primary call number is 0, 3) primary call number is > maximum legal call
1485 D6CD              ; number, or 4) call's entry in info_ptr table is 0.
1486 D6CD              ;
1487 D6CD
1488 D6CD              ;------------------------ D E B U G   C O D E ---------------------------------
1489 D6CD
1490 D6CD              ;	aif	not debug_calls,.nodebug
1491 D6CD              ;	lda	#$0006	;Number of bytes in entry (for now...)
1492 D6CD              ;	jsr	journal_add
1493 D6CD              ;	lda	<call_number
1494 D6CD              ;	jsr	journal_add
1495 D6CD              ;.nodebug	anop
1496 D6CD
1497 D6CD              ;------------------------ D E B U G   C O D E ---------------------------------
1498 D6CD
1499 D6CD A5 30                 lda   <call_number             ;get complete call number/subclass
1500 D6CF A8                    tay                            ;save in Y
1501 D6D0 29 00 FF              and   #$FF00                   ;check high byte = $01
1502 D6D3 C9 00 01              cmp   #$0100
1503 D6D6 F0 2C                 beq   relay                    ;GS/OS should never see a call number
1504 D6D8                                                      ;...with high byte = $01
1505 D6D8 98                    tya                            ;get back complete call number/subclass
1506 D6D9 29 FF 1F              and   #$1FFF                   ;isolate low 13 bits (primary call num)
1507 D6DC F0 26                 beq   relay                    ;call number cannot be 0
1508 D6DE CD 00 D0              cmp   |info_ptr                ;compare to value 1 bigger than maximum
1509 D6E1 B0 21                 bge   relay                    ;... call number
1510 D6E3              *
1511 D6E3              * If this is a d_info, d_status, d_control, d_read or d_write call, we will
1512 D6E3              * set type and exit.  Ray checks everything himself so the rest of this routine
1513 D6E3              * is redundant for these calls...
1514 D6E3              *
1515 D6E3 C9 36 00              cmp   #d_rename_num            ;Is it a d_rename call?
1516 D6E6 F0 0A                 beq   is_d_call                ;Yes.
1517 D6E8 C9 2C 00              cmp   #d_calls_start           ;Is it a d_ call?
1518 D6EB 90 0D                 bcc   not_d_call               ;Nope.
1519 D6ED C9 31 00              cmp   #d_calls_end             ;Maybe.
1520 D6F0 B0 08                 bcs   not_d_call               ;Nope.
1521 D6F2 A9 0A 00     is_d_call lda   #d_calls_type           ;Yes, get type.
1522 D6F5 8D A4 B9              sta   |type                    ;Set it.
1523 D6F8 18                    clc                            ;Indicate no error.
1524 D6F9 60                    rts                            ;Exit with carry clear.
1525 D6FA              *
1526 D6FA              * Its not a d_ call so continue...
1527 D6FA              *
1528 D6FA 0A           not_d_call asl   a                      ;double call number to form index
1529 D6FB AA                    tax   
1530 D6FC 8D A0 B9              sta   |num                     ;save for later use in calling FST
1531 D6FF BD 00 D0              lda   |info_ptr,x              ;get pointer to call processing info
1532 D702 D0 05                 bne   around                   ;if null, the call is undefined
1533 D704              relay     
1534 D704
1535 D704              ;--------------------------- D e b u g  C o d e -----------------------------
1536 D704              ;	aif	not debug_calls,.nodebug
1537 D704              ;	cpy	#$20F0	;Check to see if it's a debug call
1538 D704              ;	blt	relay1	;If less than $F0, we're outahear
1539 D704              ;	cpy	#$20F9	;If >= $F9, done, too.
1540 D704              ;	bge	relay1
1541 D704              ;	lda	#debug_type
1542 D704              ;	sta	|type
1543 D704              ;	clc
1544 D704              ;	rts
1545 D704              ;.nodebug	anop
1546 D704              ;--------------------------- D e b u g  C o d e -----------------------------
1547 D704
1548 D704              relay1    
1549 D704 A9 01 00     bad_call lda   #bad_system_call
1550 D707 38                    sec   
1551 D708 60                    rts   
1552 D709              around    
1553 D709              ;
1554 D709              ; Call number is legal, so isolate subclass and check its legality.  Subclass
1555 D709              ; is illegal if 1) its value is greater than or equal to the classes field in
1556 D709              ; the call descriptor table or 2) its script pointer in the call descriptor
1557 D709              ; table is zero.
1558 D709              ;
1559 D709 AA                    tax                            ;save address of call's descriptor tbl
1560 D70A 98                    tya                            ;isolate subclass from saved call num
1561 D70B 2A                    rol   a
1562 D70C 2A                    rol   a
1563 D70D 2A                    rol   a
1564 D70E 2A                    rol   a
1565 D70F 29 07 00              and   #$0007
1566 D712 E2 20                 sep   #m8                      ;compare to value 1 bigger than maximum
1567 D714 DD 00 00              cmp   |0,x                     ;...legal subclass.  comparison must be
1568 D717 C2 20                 rep   #m8                      ;...8 bits since classes field is a
1569 D719 B0 0F                 bge   bad_class                ;...single byte.
1570 D71B 0A                    asl   a                        ;double the class number to make index
1571 D71C 8D A2 B9              sta   |class                   ;... and save it
1572 D71F 8A                    txa                            ;recover address of descriptor table
1573 D720 38                    sec                            ;add subclass index to descriptor entry
1574 D721 6D A2 B9              adc   |class                   ;... base address plus 1
1575 D724 AA                    tax                            ;to give address of subclass entry
1576 D725 BD 00 00              lda   |0,x                     ;subclass is undefined if it's zero
1577 D728 D0 05                 bne   start_script
1578 D72A A9 62 00     bad_class lda   #invalid_class
1579 D72D 38                    sec   
1580 D72E 60                    rts   
1581 D72F
1582 D72F              ;
1583 D72F              ; call number and subclass are both legal at this point
1584 D72F              ; A contains pointer to descriptor script for the call/subclass
1585 D72F              ;
1586 D72F 8D A6 B9     start_script sta   |script_start
1587 D732 8D A8 B9              sta   |script_current
1588 D735              ;
1589 D735              ; now run through the script checking that pcount is greater than or equal to
1590 D735              ; minimum pcount and that all reference numbers and pathname pointers are non-
1591 D735              ; zero and non-null, respectively
1592 D735              ;
1593 D735 20 9B D6     do_script jsr   play_script             ;get script information in A and X
1594 D738 D0 02                 bne   continue_script          ;zero indicates end of script
1595 D73A 18           end_of_script clc   
1596 D73B 60                    rts   
1597 D73C
1598 D73C              continue_script  
1599 D73C A8                    tay                            ;save script byte in Y
1600 D73D 29 F0 00              and   #$00F0                   ;isolate 'opcode' of the script
1601 D740 C9 10 00              cmp   #$0010                   ;is it a call type specifier?
1602 D743 D0 09                 bne   not_call_type
1603 D745 E8           is_call_type inx                        ;yes, capture and save the value
1604 D746 BD 00 00              lda   |0,x
1605 D749 8D A4 B9              sta   |type
1606 D74C 80 E7                 bra   do_script
1607 D74E C9 20 00     not_call_type cmp   #$0020              ;is it a pcount check?
1608 D751 D0 0E                 bne   not_pcount
1609 D753 98           is_pcount tya                           ;yes, check pcount; get script code
1610 D754 29 0F 00              and   #$000F                   ;isolate the minimum parameter count
1611 D757 3A                    dec   a                        ;reduce it by 1 for comparison to pcount
1612 D758 C7 32                 cmp   [<param_blk_ptr]         ;... field in parameter block
1613 D75A 90 D9                 blt   do_script
1614 D75C A9 04 00     bad_pcount lda   #invalid_pcount
1615 D75F 38                    sec   
1616 D760 60                    rts   
1617 D761
1618 D761 C9 30 00     not_pcount cmp   #$0030                 ;is it a pathname pointer check?
1619 D764 D0 14                 bne   not_pathptr
1620 D766 98           is_pathptr tya                          ;yes, check pointer non-null
1621 D767 29 0F 00              and   #$000F                   ;isolate low nibble of script code
1622 D76A A8                    tay                            ;use it as index to parameter block
1623 D76B B7 32                 lda   [<param_blk_ptr],y       ;check path pointer non-zero
1624 D76D D0 C6                 bne   do_script                ;pathname pointer is non-null
1625 D76F C8                    iny   
1626 D770 C8                    iny   
1627 D771 B7 32                 lda   [<param_blk_ptr],y
1628 D773 D0 C0                 bne   do_script                ;pathname pointer is non-null
1629 D775 A9 53 00     bad_parm lda   #parm_range_err          ;error--pathname pointer is null
1630 D778 38                    sec   
1631 D779 60                    rts   
1632 D77A
1633 D77A C9 40 00     not_pathptr cmp   #$0040                ;is it a refnum non-zero check?
1634 D77D D0 10                 bne   not_refnum
1635 D77F 98           is_refnum tya                           ;yes, check refnum non-zero
1636 D780 29 0F 00              and   #$000F                   ;isolate low nibble of script code
1637 D783 A8                    tay                            ;use it as an index to the refnum field
1638 D784 B7 32                 lda   [<param_blk_ptr],y       ;check for non-zero
1639 D786 D0 AD                 bne   do_script
1640 D788 F0 00                 beq   bad_refnum               ;error--refnum field is zero
1641 D78A A9 43 00     bad_refnum lda   #invalid_ref_num
1642 D78D 38                    sec   
1643 D78E 60                    rts   
1644 D78F
1645 D78F C9 50 00     not_refnum cmp   #$0050                 ;is it an output path pointer
1646 D792 F0 A1        is_outpath beq   do_script              ;yes, no processing defined.
1647 D794
1648 D794 C9 60 00     not_outpath cmp   #$0060                ;is it the maximum parameter count?
1649 D797 D0 0A                 bne   not_maxpcnt
1650 D799 98           is_maxpcnt tya                          ;yes, check against actual pcount
1651 D79A 29 0F 00              and   #$000F                   ;isolate the maximum parameter count
1652 D79D C7 32                 cmp   [<param_blk_ptr]         ;compare to actual parameter count
1653 D79F 90 BB                 blt   bad_pcount               ;if max<actual, bad parameter count
1654 D7A1 80 92                 bra   do_script
1655 D7A3
1656 D7A3 C9 70 00     not_maxpcnt cmp   #$0070                ;is it the dnum thingy?
1657 D7A6 D0 0E                 bne   not_dnum                 ;no--try something else
1658 D7A8 98           is_dnum  tya                            ;yes, check dnum not zero
1659 D7A9 29 0F 00              and   #$000F
1660 D7AC A8                    tay   
1661 D7AD B7 32                 lda   [<param_blk_ptr],y       ;get the devnum field value
1662 D7AF D0 84                 bne   do_script
1663 D7B1 A9 11 00     bad_dnum lda   #invalid_dev_num
1664 D7B4 38                    sec   
1665 D7B5 60                    rts   
1666 D7B6
1667 D7B6 C9 E0 00     not_dnum cmp   #$00E0                   ;is it address of processing routine?
1668 D7B9 D0 0C                 bne   leapfrog                 ;will branch further to do_script
1669 D7BB BD 01 00     is_address lda   |1,x                   ;yes, get address of processing routine
1670 D7BE 8D D6 B9              sta   |handler_addr
1671 D7C1 BD 02 00              lda   |2,x
1672 D7C4 8D D7 B9              sta   |handler_addr+1
1673 D7C7              leapfrog  
1674 D7C7 4C 35 D7              jmp   do_script
1675 D7CA
1676 D7CA                       end_proc 
1677 D7CA                       eject 
1678 D7CA              ;===============================================================================
1679 D7CA              ; do_type_2
1680 D7CA              ;
1681 D7CA              ; Handle bouncing type calls with pathname parameters.
1682 D7CA              ;
1683 D7CA              ; This module handles the FST calling, bouncing, automatic volume mounting, and
1684 D7CA              ; error reporting functions for calls in which the primary parameters are
1685 D7CA              ; pathnames.
1686 D7CA              ;
1687 D7CA              ; Calling order strategy:  This module tries to call the right FST first.  To
1688 D7CA              ; do this, it translates the first pathname and, if the pathname begins with a
1689 D7CA              ; volume name, looks up the volume in the GS/OS VCR list.  If a VCR for the
1690 D7CA              ; volume exists, it calls the FST identified in this VCR first.
1691 D7CA              ;
1692 D7CA              ; Automatic mounting strategy:  This module makes a first pass through the FSTs.
1693 D7CA              ; If no FST handles the call, but the 'first FST' returns a volume not found
1694 D7CA              ; error, this module calls the mount dialog routine and then performs a second
1695 D7CA              ; pass through the FSTs.
1696 D7CA              ;
1697 D7CA              ; Error reporting strategy:  If all of this results in an error condition, this
1698 D7CA              ; module returns the error code returned by the 'first FST' picked by the
1699 D7CA              ; calling order strategy.
1700 D7CA              ;
1701 D7CA              ;===============================================================================
1702 D7CA
1703 D7CA              do_type_2 proc 
1704 D7CA
1705 D7CA              *
1706 D7CA              * Initialize some flags...
1707 D7CA              *
1708 D7CA 9C 21 B9              stz   std_prefix_num           ;Clear prefix number.
1709 D7CD 9C 23 B9              stz   last_ref_num             ;Clear last ref_num.
1710 D7D0              ;
1711 D7D0              ; Perform a preliminary pathname translation so we can see if the volume (if
1712 D7D0              ; any) is known to GS/OS.
1713 D7D0              ;
1714 D7D0 9C 19 B9              stz   |fst_flags               ;translation control flags--no uppercase
1715 D7D3 20 35 A0              jsr   xlate_script             ;perform translation
1716 D7D6 90 03                 bcc   prelim_xlate_ok
1717 D7D8 4C 56 D8              jmp   dealc_exit               ;if error, deallocate and exit
1718 D7DB              ;
1719 D7DB              ; Now, try to get the volume name and look up the VCR.
1720 D7DB              ;
1721 D7DB              prelim_xlate_ok  
1722 D7DB 20 CD D8              jsr   path_to_fst_id           ;try to find FST id corresp to pathname
1723 D7DE 8E BE B9              stx   |volname_vp              ;save vp to volume name string, or
1724 D7E1 8C C0 B9              sty   |volname_vp+2            ;...null if there was no volume name
1725 D7E4 B0 0A                 bcs   didnt_find_vcr
1726 D7E6
1727 D7E6 20 46 E2     found_vcr jsr   find_fst                ;translate FST id into FST Table offset
1728 D7E9 B0 71                 bcs   no_such_fst
1729 D7EB 8D BC B9              sta   |first_fst               ;this will be the first FST to call
1730 D7EE 80 03                 bra   go_on_1
1731 D7F0
1732 D7F0 9C BC B9     didnt_find_vcr stz   |first_fst         ;make first FST in FST table the first
1733 D7F3
1734 D7F3 20 61 B7     go_on_1  jsr   release_v_ptrs           ;release vps set by preliminary xlate
1735 D7F6              ;
1736 D7F6              ; Perform pass 1 of FST calls.  A contains offset of first FST to call.
1737 D7F6              ;
1738 D7F6 AD BC B9     pass_1   lda   |first_fst
1739 D7F9 20 5D D9              jsr   call_fsts
1740 D7FC 90 62                 bcc   release_exit1            ;if call was handled, release volname_vp
1741 D7FE                                                      ;...and exit successfully
1742 D7FE              ;
1743 D7FE              ; Determine whether or not to perform a second pass.
1744 D7FE              ;
1745 D7FE C9 45 00     pass_1_failed cmp   #vol_not_found      ;was pass 1 error 'volume not found'?
1746 D801 F0 03                 beq   check_vol                ;yes, check to see if we have a vol name
1747 D803 4C 7D D8              jmp   release_exit2            ;no, return with the error code in A
1748 D806
1749 D806 A8           check_vol tay                           ;save error code in Y
1750 D807 AD BE B9              lda   |volname_vp              ;is there a non-null vp to a vol name?
1751 D80A AA                    tax                            ;low word of vp to X in anticipation
1752 D80B 0D C0 B9              ora   |volname_vp+2
1753 D80E D0 03                 bne   pass_2                   ;yes, do pass 2
1754 D810 98                    tya                            ;no, return error
1755 D811 38                    sec                            ;no need to release vp because it's null
1756 D812 60                    rts   
1757 D813              ;
1758 D813              ; Perform pass 2 of FST calls.  First, put up MOUNT dialog.  If MOUNT succeeds,
1759 D813              ; call FSTs again.  Otherwise, return with error.
1760 D813              ;
1761 D813              pass_2    
1762 D813
1763 D813 AE BE B9              ldx   |volname_vp              ;convert vp to volume name to pointer
1764 D816 AC C0 B9              ldy   |volname_vp+2
1765 D819 22 09 FE 00           jsl   deref2
1766 D81D 86 D4                 stx   <s_temp1                 ;move pointer onto direct page
1767 D81F 84 D6                 sty   <s_temp1+2
1768 D821
1769 D821 A7 D4                 lda   [<s_temp1]               ;get length word of string
1770 D823 EB                    xba                            ;reverse bytes and restore it to fake
1771 D824 87 D4                 sta   [<s_temp1]               ;...up a class 0 string
1772 D826
1773 D826 E8                    inx                            ;increment low byte of pointer
1774 D827 D0 01                 bne   ar_3
1775 D829 C8                    iny                            ;increment high byte
1776 D82A              ar_3      
1777 D82A
1778 D82A 8E C2 B9              stx   |volname_ptr             ;save volume name pointer in permanent
1779 D82D 8C C4 B9              sty   |volname_ptr+2           ;...location
1780 D830
1781 D830              ar_1      
1782 D830 AD C4 B9              lda   |volname_ptr+2           ;set up parameters for MOUNT call
1783 D833 48                    pha                            ;first, push volume name pointer
1784 D834 AD C2 B9              lda   |volname_ptr
1785 D837 48                    pha   
1786 D838 A9 00 00              lda   #$0000                   ;tell MOUNT to respect system preference
1787 D83B                                                      ;...on whether or not to display dialog
1788 D83B 22 11 DF E1           jsl   s_mount_msg              ;perform the MOUNT
1789 D83F AA                    tax                            ;was the result 'OK'?
1790 D840 F0 05                 beq   ar_2
1791 D842
1792 D842 A9 45 00     cancel_mount lda   #vol_not_found
1793 D845 80 36                 bra   release_exit2
1794 D847
1795 D847 AD BC B9     ar_2     lda   |first_fst               ;do the next round of FST calls
1796 D84A 20 5D D9              jsr   call_fsts
1797 D84D 90 11                 bcc   release_exit1            ;if no error, return
1798 D84F C9 45 00              cmp   #vol_not_found           ;if volume not
1799 D852 F0 DC                 beq   ar_1
1800 D854 80 27                 bra   release_exit2
1801 D856
1802 D856 48           dealc_exit pha                          ;save error code
1803 D857 20 61 B7              jsr   release_v_ptrs           ;release vps to pathnames
1804 D85A 80 6C                 bra   no_deallocate
1805 D85C
1806 D85C 22 44 FC 01  no_such_fst jsl   sys_death
1807 D860
1808 D860              *
1809 D860              * Exit point if call completed successfully.  Here we will update the std_ref_num
1810 D860              * table if the call is OPEN and the pathname was just prefix 10, 11 or 12... 
1811 D860              *
1812 D860 AE 21 B9     release_exit1 ldx   std_prefix_num      ;Was it a standard prefix?
1813 D863 F0 15                 beq   success                  ;Nope, so done.
1814 D865 AD A0 B9              lda   |num                     ;Yes, get call number.
1815 D868 C9 20 00              cmp   #$0020                   ;Is open?
1816 D86B D0 0D                 bne   success                  ;Nope.
1817 D86D
1818 D86D 8A                    txa                            ;Yes, so let's update.
1819 D86E 38                    sec                            ;Zero adjust.
1820 D86F E9 0A 00              sbc   #10
1821 D872 0A                    asl   a                        ;Make a word offset.
1822 D873 A8                    tay   
1823 D874 AD 23 B9              lda   last_ref_num             ;Get ref_num.
1824 D877 99 1B B9              sta   std_ref_num,y            ;Update std_ref_num.
1825 D87A
1826 D87A A9 00 00     success  lda   #$0000                   ;Indicate success.
1827 D87D              *
1828 D87D              * Exit point if call failed...
1829 D87D              *
1830 D87D              release_exit2  
1831 D87D C9 50 00              cmp   #file_busy               ;was this the error that we saw?
1832 D880 D0 35                 bne   bye_bye                  ;no, just exit
1833 D882 AE 21 B9              ldx   std_prefix_num           ;trying to open stdout or stderr?
1834 D885 E0 0B 00              cpx   #11
1835 D888 90 2D                 bcc   bye_bye                  ;no, just exit
1836 D88A AC A2 B9              ldy   |class                   ;class 0 or class 1 call?
1837 D88D F0 07                 beq   @do_compare              ;class 0, allow duplicate refnum
1838 D88F A7 32                 lda   [<param_blk_ptr]         ;check the pCount
1839 D891 C9 04 00              cmp   #$0004                   ;can't be greater than 3
1840 D894 B0 1E                 bcs   @true_error              ;'cause we can't return all the extra info
1841 D896              @do_compare  
1842 D896 20 ED B7              jsr   cmp_11_12                ;compare prefixes 11 and 12
1843 D899 D0 19                 bne   @true_error              ;if not equal, let the error stand
1844 D89B AD 1D B9              lda   stdout_refnum            ;assume we're opening stderr
1845 D89E AE 21 B9              ldx   std_prefix_num
1846 D8A1 E0 0C 00              cpx   #12                      ;is it stderr?
1847 D8A4 F0 03                 beq   @store_it                ;yes
1848 D8A6 AD 1F B9              lda   stderr_refnum            ;else use existing stderr refnum
1849 D8A9              @store_it  
1850 D8A9 8D 23 B9              sta   last_ref_num             ;save this refnum
1851 D8AC AC A2 B9              ldy   |class                   ;get the call class (as offset)
1852 D8AF 97 32                 sta   [<param_blk_ptr],y       ;store the return refnum
1853 D8B1 AA                    tax                            ;valid refnum?
1854 D8B2 D0 AC                 bne   release_exit1            ;yes, go store it
1855 D8B4              @true_error  
1856 D8B4 A9 50 00              lda   #file_busy               ;else return a true error
1857 D8B7              bye_bye   
1858 D8B7 48                    pha                            ;do a return with the error code in A
1859 D8B8 AD BE B9              lda   |volname_vp              ;release volname_vp if its non-null
1860 D8BB AA                    tax   
1861 D8BC 0D C0 B9              ora   |volname_vp+2
1862 D8BF F0 07                 beq   no_deallocate
1863 D8C1 AC C0 B9              ldy   |volname_vp+2
1864 D8C4 22 15 FD 00           jsl   deallocate
1865 D8C8 68           no_deallocate pla   
1866 D8C9 C9 01 00              cmp   #$0001                   ;set c according to error code value
1867 D8CC 60                    rts   
1868 D8CD
1869 D8CD                       end_proc 
1870 D8CD                       eject 
1871 D8CD              ;===============================================================================
1872 D8CD              ; path_to_fst_id
1873 D8CD              ;
1874 D8CD              ; Determine the FST id value corresponding to the first pathname in a pathname
1875 D8CD              ; call.  Succeeds only if the pathname starts with a volume name and there is
1876 D8CD              ; a VCR for the volume.  Also, capture the volume name string and return a vp
1877 D8CD              ; to it.
1878 D8CD              ;
1879 D8CD              ; Created:      1/28/88
1880 D8CD              ; Modified:     1/9/89  BPA     Modified to check for character device and
1881 D8CD              ;                               return character fst id if so.
1882 D8CD              ; Author:       JJ
1883 D8CD              ;
1884 D8CD              ; Enter:        jsr     path_to_fst_id
1885 D8CD              ;
1886 D8CD              ; Input:        P = nvmxdizc
1887 D8CD              ;                   ..000...
1888 D8CD              ;
1889 D8CD              ;               char_dev_flag   non-zero if drvr_dev_num non-zero and device
1890 D8CD              ;                               is a character device
1891 D8CD              ;
1892 D8CD              ; Output:       A = if c=0, fst id corresponding to the volume name in the path
1893 D8CD              ;                   if c=1, undefined
1894 D8CD              ;               X = low word of vp to volume name string (null if no name)
1895 D8CD              ;               Y = high word of vp to volume name string (null if no name)
1896 D8CD              ;               P = nvmxdizc
1897 D8CD              ;                   ..000..|
1898 D8CD              ;                          0=no error, 1=error
1899 D8CD              ;===============================================================================
1900 D8CD
1901 D8CD              path_to_fst_id proc 
1902 D8CD
1903 D8CD
1904 D8CD              temp_sep equ   s_temp1
1905 D8CD              vol_ptr  equ   s_temp2                  ;these two symbols share the same
1906 D8CD              vcr_ptr_temp equ   s_temp2              ;...storage
1907 D8CD              *
1908 D8CD              * Does the first pathname begin with a device name?
1909 D8CD              *
1910 D8CD A5 36                 lda   <dev1_num                ;if device number = 0, then pathname
1911 D8CF F0 0F                 beq   may_be_volume            ;...may start with volume name.
1912 D8D1              *
1913 D8D1              * Yes, is it a character device?  If so, return character fst id and null vp, else
1914 D8D1              * error...
1915 D8D1              *
1916 D8D1 AF F8 B9 00           lda   >char_dev_flag           ;Character device?
1917 D8D5 F0 7C                 beq   not_volume               ;Nope, so error.
1918 D8D7 A9 09 00              lda   #character_fst           ;Yes, get character fst id.
1919 D8DA A2 00 00              ldx   #0000                    ;Set null vp.
1920 D8DD 9B                    txy   
1921 D8DE 18                    clc                            ;Indicate no error.
1922 D8DF 60                    rts                            ;Exit.
1923 D8E0              *
1924 D8E0              * Nope, does it begin with a pathname?
1925 D8E0              *
1926 D8E0 A5 42        may_be_volume lda   <path_flag          ;does path1_ptr point to something?
1927 D8E2 29 00 40              and   #$4000
1928 D8E5 F0 6C        error_hop beq   not_volume              ;no, return error state
1929 D8E7              ;
1930 D8E7              ; Pathname begins with volume name.  Isolate it and copy to its own GS/OS
1931 D8E7              ; dynamic memory segment.
1932 D8E7              ;
1933 D8E7 E2 20        is_volume sep   #m8                     ;enter 8-bit m mode
1934 D8E9                       longa off
1935 D8E9
1936 D8E9 A0 02 00              ldy   #2                       ;pick up first character in string
1937 D8EC B7 3A                 lda   [<path1_ptr],y           ;this will be the separator character
1938 D8EE 85 D4                 sta   <temp_sep                ;save it
1939 D8F0
1940 D8F0 A2 00 00              ldx   #0000                    ;set character count to zero
1941 D8F3
1942 D8F3 C8           count_size_loop iny                     ;Y = offset of first char in vol name
1943 D8F4 B7 3A                 lda   [<path1_ptr],y           ;get a character
1944 D8F6 F0 07                 beq   loop_no_more             ;bomb out if end of string
1945 D8F8 C5 D4                 cmp   <temp_sep                ;is it next occurrence of separator?
1946 D8FA F0 03                 beq   loop_no_more
1947 D8FC E8                    inx   
1948 D8FD 80 F4                 bra   count_size_loop
1949 D8FF
1950 D8FF C2 20        loop_no_more rep   #m16                 ;back to 16-bit m mode
1951 D901                       longa on
1952 D901
1953 D901 E8                    inx                            ;allocate space for volname; need
1954 D902 E8                    inx                            ;...length of volname+2
1955 D903 8A                    txa   
1956 D904 18                    clc   
1957 D905 22 1C FC 01           jsl   alloc_seg
1958 D909 B0 4E                 bcs   fatal_error
1959 D90B 5A                    phy                            ;save the vp
1960 D90C DA                    phx   
1961 D90D 22 09 FE 00           jsl   deref2                   ;dereference the vp
1962 D911 86 D8                 stx   <vol_ptr
1963 D913 84 DA                 sty   <vol_ptr+2
1964 D915
1965 D915 E2 20                 sep   #m8                      ;8 bit m mode
1966 D917                       longa off
1967 D917
1968 D917 A0 03 00              ldy   #3                       ;get ready to copy
1969 D91A B7 3A        copy_loop lda   [<path1_ptr],y          ;get a character
1970 D91C F0 0B                 beq   done_copying             ;if null at end of string, done
1971 D91E C5 D4                 cmp   <temp_sep
1972 D920 F0 07                 beq   done_copying
1973 D922 88                    dey                            ;copy it one byte lower in the
1974 D923 97 D8                 sta   [<vol_ptr],y             ;...destination string
1975 D925 C8                    iny                            ;double increment to get next char
1976 D926 C8                    iny                            ;...in source string
1977 D927 80 F1                 bra   copy_loop
1978 D929
1979 D929 C2 20        done_copying rep   #m16                 ;back to 16-bit m mode
1980 D92B                       longa on
1981 D92B
1982 D92B 88                    dey                            ;Y holds value 3 greater than volume
1983 D92C 88                    dey                            ;...name length
1984 D92D 88                    dey   
1985 D92E 98                    tya   
1986 D92F 87 D8                 sta   [<vol_ptr]               ;store length into string
1987 D931              ;
1988 D931              ; Finally ready to look up the VCR for this volume name.
1989 D931              ;
1990 D931 A6 D8                 ldx   <vol_ptr                 ;prepare to do find_vcr; get pointer
1991 D933 A4 DA                 ldy   <vol_ptr+2               ;...to volume name
1992 D935
1993 D935 A9 00 00              lda   #$0000
1994 D938 22 63 F8 00           jsl   findvcrcase
1995 D93C B0 11                 bcs   no_vcr
1996 D93E
1997 D93E 22 09 FE 00  found_vcr jsl   deref2                  ;convert vp to pointer
1998 D942 86 D8                 stx   <vcr_ptr_temp
1999 D944 84 DA                 sty   <vcr_ptr_temp+2
2000 D946
2001 D946 A0 0A 00              ldy   #vcr_fst_id              ;get fst id field from VCR
2002 D949 B7 D8                 lda   [<vcr_ptr_temp],y        ;return FST id value in A
2003 D94B FA                    plx                            ;return vp to volume name string
2004 D94C 7A                    ply                            ;...in X and Y
2005 D94D
2006 D94D 18                    clc                            ;return with no error
2007 D94E 60                    rts   
2008 D94F
2009 D94F FA           no_vcr   plx                            ;rebalance stack and return vp
2010 D950 7A                    ply                            ;...to volume name string even though
2011 D951 38                    sec                            ;...there was no vcr
2012 D952 60                    rts   
2013 D953
2014 D953 A2 00 00     not_volume ldx   #$0000                 ;return null pointer to volname string
2015 D956 9B                    txy   
2016 D957 38                    sec                            ;indicate error and return
2017 D958 60                    rts   
2018 D959
2019 D959 22 02 EF 00  fatal_error jsl   s_sys_death
2020 D95D
2021 D95D                       end_proc 
2022 D95D                       eject 
2023 D95D
2024 D95D              ;===============================================================================
2025 D95D              ; call_fsts
2026 D95D              ;
2027 D95D              ; Perform the FST call and bouncing process.
2028 D95D              ;
2029 D95D              ; Created:      1/27/88
2030 D95D              ; Modified:
2031 D95D              ; Author:       JJ
2032 D95D              ;
2033 D95D              ; Enter:        jsr     call_fsts
2034 D95D              ;
2035 D95D              ; Input:        A = offset in FST table of FST descriptor for first FST to call
2036 D95D              ;               P = nvmxdizc
2037 D95D              ;                   ..000...
2038 D95D              ;
2039 D95D              ; Output:       A = if c=0, undefined; if c=1, error code
2040 D95D              ;               X = trashed
2041 D95D              ;               Y = trashed
2042 D95D              ;               P = nvmxdizc
2043 D95D              ;                   ..000..|
2044 D95D              ;                          0=no error, 1=error
2045 D95D              ;
2046 D95D              ; Side Effects:
2047 D95D              ;
2048 D95D              ;===============================================================================
2049 D95D
2050 D95D              call_fsts proc 
2051 D95D                       Import rename_preamble
2052 D95D
2053 D95D              volume_callnum equ   $10                ;num value for VOLUME call
2054 D95D              open_callnum equ   $20                  ;num value for OPEN call
2055 D95D              ;
2056 D95D              ; Initialize variables used to index into FST table.
2057 D95D              ;
2058 D95D 8D 15 B9              sta   |curr_fst                ;offset of table entry for current FST
2059 D960 8D BC B9              sta   |first_fst               ;remember offset of first FST
2060 D963
2061 D963 AD 0F B8              lda   |fst_count               ;offset beyond last FST entry in table
2062 D966 0A                    asl   a
2063 D967 0A                    asl   a
2064 D968 0A                    asl   a
2065 D969 0A                    asl   a
2066 D96A 8D 17 B9              sta   |last_fst
2067 D96D
2068 D96D 9C BA B9              stz   |fstError                ;initialize to no error condition
2069 D970              ;
2070 D970              ; This is the beginning of the FST call/bounce loop
2071 D970              ;
2072 D970 AE 15 B9     bounce   ldx   |curr_fst                ;get current FST table offset
2073 D973 EC BC B9              cpx   |first_fst               ;is it the first FST?
2074 D976 D0 08                 bne   not_first_fst            ;no, branch
2075 D978
2076 D978 BD 1F B8     is_first_fst lda   |fst_tbl+s_flags,x   ;get flags word for FST
2077 D97B 8D 19 B9              sta   |fst_flags               ;...and store for later use
2078 D97E 80 0E                 bra   xlate
2079 D980 BD 1F B8     not_first_fst lda   |fst_tbl+s_flags,x  ;get current FST's flags
2080 D983 CD 19 B9              cmp   |fst_flags               ;same as previous flags?
2081 D986 F0 37                 beq   call_the_fst             ;yes--no need to retranslate pathnames
2082 D988 8D 19 B9              sta   |fst_flags               ;no--save new flags and do translation
2083 D98B
2084 D98B 20 61 B7              jsr   release_v_ptrs           ;release previously translated pathnames
2085 D98E
2086 D98E              xlate     
2087 D98E AD A0 B9              lda   |num                     ;is this a ChangePath call?
2088 D991 C9 08 00              cmp   #8
2089 D994 D0 24                 bne   @simple_case             ;no...
2090 D996 AD A6 B9              lda   script_start             ;save this around call
2091 D999 8D AA B9              sta   save_script_start
2092 D99C 22 91 DC E1           jsl   rename_preamble          ;else set up for eventual loader_rename
2093 D9A0 B0 1B                 bcs   @to_outta_here           ;translation error
2094 D9A2 F0 0A                 beq   @no_release              ;don't release v_ptr1
2095 D9A4 AE C6 B9              ldx   v_ptr1                   ;else release unused pathname
2096 D9A7 AC C8 B9              ldy   v_ptr1+2
2097 D9AA 22 15 FD 00           jsl   deallocate
2098 D9AE              @no_release  
2099 D9AE A9 08 00              lda   #8                       ;restore call number
2100 D9B1 8D A0 B9              sta   |num
2101 D9B4 AD AA B9              lda   save_script_start
2102 D9B7 8D A6 B9              sta   script_start
2103 D9BA
2104 D9BA              @simple_case  
2105 D9BA 20 35 A0              jsr   xlate_script
2106 D9BD              @to_outta_here  
2107 D9BD B0 68                 bcs   outta_here               ;translation errors are non-bouncing
2108 D9BF              ;
2109 D9BF              ; Pathname translation complete.  Prepare to call the FST.  There are several
2110 D9BF              ; special considerations:
2111 D9BF              ;
2112 D9BF              ; 1.  If the call is a VOLUME call, check to make sure the dev_name parameter
2113 D9BF              ;     consists of a device name and nothing more.
2114 D9BF              ; 2.  If the FST to be called is the character FST, call it only if the system
2115 D9BF              ;     call is an OPEN call and the pathname consists of a device name and
2116 D9BF              ;     nothing more.
2117 D9BF              ;
2118 D9BF AD A0 B9     call_the_fst lda   |num                 ;get 2*call number
2119 D9C2 C9 10 00              cmp   #volume_callnum          ;is it a volume call
2120 D9C5 D0 10                 bne   not_volume_call          ;no, branch ahead
2121 D9C7
2122 D9C7              is_volume_call                          ; ;yes, check dev_name validity
2123 D9C7 A5 36                 lda   <dev_num                 ;error if dev_num is 0
2124 D9C9 F0 07                 beq   volume_error
2125 D9CB A5 42                 lda   <path_flag               ;error if path_flag indicates there is
2126 D9CD 29 00 40              and   #$4000                   ;...more than just a device name
2127 D9D0 F0 05                 beq   not_volume_call          ;so far, so good
2128 D9D2
2129 D9D2 A9 40 00     volume_error lda   #bad_path_syntax
2130 D9D5 80 4A                 bra   no_bounce
2131 D9D7
2132 D9D7              not_volume_call  
2133 D9D7 AE 15 B9              ldx   |curr_fst                ;offset of FST in FST table
2134 D9DA 3C 1F B8              bit   |fst_tbl+s_flags,x       ;test the block/character attribute bit
2135 D9DD 50 18                 bvc   do_the_fst_call          ;jump ahead if block device
2136 D9DF
2137 D9DF AD A0 B9     is_character lda   |num                 ;get 2*call_number
2138 D9E2 C9 20 00              cmp   #open_callnum            ;is it an OPEN call?
2139 D9E5 F0 05                 beq   is_open                  ;yes.
2140 D9E7 A9 58 00     simulate_err lda   #not_block_dev       ;No, so simulate an error.
2141 D9EA 80 11                 bra   save_error
2142 D9EC
2143 D9EC A5 36        is_open  lda   <dev_num                 ;get the device number.  if it is 0,
2144 D9EE F0 3B                 beq   do_bounce                ;...don't call the character FST
2145 D9F0 A5 42        dev_not_zero lda   <path_flag           ;get path flag word
2146 D9F2 29 00 40              and   #$4000                   ;is rest of pathname non_null?
2147 D9F5 D0 F0                 bne   simulate_err             ;yes, so simulate error.
2148 D9F7
2149 D9F7 8A           do_the_fst_call txa                     ;put offset of FST entry into A
2150 D9F8 20 AB B7              jsr   call_fst                 ;...and call the FST
2151 D9FB 90 4D                 bcc   return                   ;return immediately if no error from FST
2152 D9FD
2153 D9FD              ;-------------------------------------------------------------------------------
2154 D9FD              ; Handle the case in which the FST returned an error.  This may require FST
2155 D9FD              ; bouncing.  Two conditions must be met for FST bouncing to occur:
2156 D9FD              ;   1) the system call contains a pathname parameter (all calls handled by
2157 D9FD              ;      do_type_2 do), and
2158 D9FD              ;   2) the called FST returns one of the following errors:
2159 D9FD              ;      - bad pathname syntax (bad_path_syntax--$40)
2160 D9FD              ;      - volume not found (vol_not_found--$45)
2161 D9FD              ;      - unknown volume (unknown_vol--$52)
2162 D9FD              ;      - invalid parameter count (invalid_pcount--$04)
2163 D9FD              ;      - bad system call (bad_system_call--$01)
2164 D9FD              ;      - not a block device (not_block_dev--$58)
2165 D9FD              ;-------------------------------------------------------------------------------
2166 D9FD              ;
2167 D9FD              ; If the FST was the first FST, save the error code in fstError.
2168 D9FD              ;
2169 D9FD              save_error  
2170 D9FD 89 00 80              bit   #%1000000000000000       ;is the priority bit set?
2171 DA00 D0 1F                 bne   no_bounce                ;yes, exit immediately
2172 DA02
2173 DA02 2C BA B9              bit   |fstError                ;is the priority bit already set?
2174 DA05 70 0D                 bvs   @check_error             ;if volNotFound bit is set in stored error,
2175 DA07                                                      ;  replace only with higher priority error
2176 DA07
2177 DA07 C9 45 00              cmp   #vol_not_found           ;did the FST find the volume?
2178 DA0A D0 03                 bne   @1                       ;no...
2179 DA0C 09 00 40              ora   #%0100000000000000       ;else set bit 14 (priority)
2180 DA0F              @1        
2181 DA0F AC BA B9              ldy   |fstError                ;has error # already been saved?
2182 DA12 F0 05                 beq   @store_it                ;no, just store as-is
2183 DA14              @check_error  
2184 DA14 89 00 C0              bit   #%1100000000000000       ;is either priority bit set?
2185 DA17 F0 03                 beq   ar1                      ;no, don't replace existing error
2186 DA19              @store_it  
2187 DA19 8D BA B9              sta   |fstError                ;store the new error code
2188 DA1C
2189 DA1C              ar1       
2190 DA1C              ;
2191 DA1C              ; Is the error one that should cause bounce to another FST?
2192 DA1C              ;
2193 DA1C 20 8C B7              jsr   is_bouncer
2194 DA1F F0 0A                 beq   do_bounce
2195 DA21              ;
2196 DA21              ; No bounce.  Release pathname strings and return error code.
2197 DA21              ;
2198 DA21 48           no_bounce pha                           ;save error code
2199 DA22 20 61 B7              jsr   release_v_ptrs           ;release space occupied by pathnames
2200 DA25 68                    pla   
2201 DA26 38                    sec                            ;indicate error
2202 DA27              outta_here  
2203 DA27 29 FF 00              and   #$00FF                   ;clear high byte of error code
2204 DA2A 60                    rts   
2205 DA2B              ;
2206 DA2B              ; If there are any more FSTs, bounce to the next one.  Otherwise, return error
2207 DA2B              ; that the first FST generated.
2208 DA2B              ;
2209 DA2B 18           do_bounce clc                           ;increment curr_fst to next FST
2210 DA2C AD 15 B9              lda   |curr_fst
2211 DA2F 69 10 00              adc   #entry_size
2212 DA32 CD 17 B9              cmp   |last_fst                ;did it increment past end of table?
2213 DA35 90 03                 blt   store_new_index          ;no, just store the index
2214 DA37 A9 00 00              lda   #$0000                   ;yes, wrap back to beginning of table
2215 DA3A 8D 15 B9     store_new_index sta   |curr_fst
2216 DA3D
2217 DA3D CD BC B9              cmp   |first_fst               ;have we gotten back to the first FST?
2218 DA40 F0 03                 beq   ar2                      ;yes, no more FSTs, so error out
2219 DA42 4C 70 D9              jmp   bounce                   ;no, bounce to another FST
2220 DA45
2221 DA45 AD BA B9     ar2      lda   |fstError                ;return the error given by the first FST
2222 DA48 80 D7                 bra   no_bounce
2223 DA4A
2224 DA4A              return                                  ;no error return
2225 DA4A              ; We now check for a ChangePath call.  If so, then check for a "special" rename
2226 DA4A              ; call, in which a volume name is being changed, but the application does not wish
2227 DA4A              ; to have a system-wide rename performed (for instance, after the finder performs a
2228 DA4A              ; block-by-block copy and then restores the original name of the destination disk).
2229 DA4A              ; If this is the case, we skip the loader rename call.
2230 DA4A
2231 DA4A AD A0 B9              lda   |num                     ;Is this a change_path call?
2232 DA4D C9 08 00              cmp   #$0008
2233 DA50 D0 21                 bne   exit                     ;Nope.
2234 DA52 AC A2 B9              ldy   |class                   ;class 1 call?
2235 DA55 F0 15                 beq   @do_the_rename           ;nope.
2236 DA57 A7 32                 lda   [<param_blk_ptr]         ;get the pCount
2237 DA59 C9 03 00              cmp   #3                       ;flags word included?
2238 DA5C 90 0E                 bcc   @do_the_rename           ;no...
2239 DA5E A0 0A 00              ldy   #10                      ;get the flags word
2240 DA61 B7 32                 lda   [<param_blk_ptr],y
2241 DA63 10 07                 bpl   @do_the_rename           ;normal changepath call
2242 DA65 A5 42                 lda   <path_flag               ;does input pathname have a length?
2243 DA67 89 00 40              bit   #$4000
2244 DA6A F0 07                 beq   exit                     ;no, skip the loader rename
2245 DA6C              @do_the_rename  
2246 DA6C 20 61 B7              jsr   release_v_ptrs           ;else release names used by FST,
2247 DA6F 22 CB DC E1           jsl   loader_rename            ;then make sure loader knows.
2248 DA73              exit      
2249 DA73 20 61 B7              jsr   release_v_ptrs           ;no error return
2250 DA76 18                    clc   
2251 DA77 60                    rts                            ;Exit to caller.
2252 DA78
2253 DA78                       end_proc 
2254 DA78                       eject 
2255 DA78              ;===============================================================================
2256 DA78              ; do_type_3
2257 DA78              ;
2258 DA78              ; Handle file access calls with reference numbers as primary input.
2259 DA78              ;===============================================================================
2260 DA78
2261 DA78              do_type_3 proc 
2262 DA78                       entry type_3_alt
2263 DA78
2264 DA78 9C DA B9              stz   |s_level                 ;precondition level
2265 DA7B
2266 DA7B AC A2 B9              ldy   |class                   ;get class of call (either 0 or 2)
2267 DA7E B7 32                 lda   [<param_blk_ptr],y       ;get refnum into A
2268 DA80              ar_1      
2269 DA80
2270 DA80 22 72 F8 00           jsl   findfcr                  ;get vp of fcr corresponding to refnum
2271 DA84 90 04                 bcc   type_3_alt               ;no error.
2272 DA86              bad_refnum  
2273 DA86 A9 43 00              lda   #invalid_ref_num
2274 DA89              outta_here  
2275 DA89 60                    rts   
2276 DA8A
2277 DA8A              type_3_alt                              ;entry location for processing close all
2278 DA8A                                                      ;...and flush all calls
2279 DA8A
2280 DA8A 86 3A                 stx   <fcr_ptr                 ;store vp of fcr for FST
2281 DA8C 84 3C                 sty   <fcr_ptr+2
2282 DA8E
2283 DA8E 22 09 FE 00           jsl   deref2                   ;dereference to get pointer to fcr
2284 DA92 86 D4                 stx   <s_temp1
2285 DA94 84 D6                 sty   <s_temp1+2
2286 DA96              ;
2287 DA96              ; Close and flush calls enter from do_type_6 via the label type_3_alt.  All
2288 DA96              ; other reference number calls enter at the main entry point, do_type_3.  At
2289 DA96              ; this point, s_level will be set to the current system level if the call is a
2290 DA96              ; close or flush, and it will be set to 0 for any other reference number call.
2291 DA96              ; Thus all calls other than close and flush should fall through the following
2292 DA96              ; conditional.  Close and flush will make it through only if the file's level
2293 DA96              ; is greater than or equal to the current system level.
2294 DA96              ;
2295 DA96 A0 0A 00              ldy   #fcr_level               ;get file level from fcr
2296 DA99 B7 D4                 lda   [<s_temp1],y
2297 DA9B CD DA B9              cmp   |s_level                 ;if file level is < s_level, do nothing
2298 DA9E 90 E9                 bcc   outta_here               ;...i.e., return with carry clear
2299 DAA0              *
2300 DAA0              * At this point, we know we need to perform an operation on the file.  Save
2301 DAA0              * off the ref_num so we can update std_ref_num later...
2302 DAA0              *
2303 DAA0 A7 D4        do_it    lda   [s_temp1]                ;Get ref_num.
2304 DAA2 8D 23 B9              sta   last_ref_num             ;Save it.
2305 DAA5 AE A0 B9              ldx   |num                     ;is this a close call?
2306 DAA8 E0 28 00              cpx   #$14*2
2307 DAAB D0 0F                 bne   @continue                ;no, don't mess around with the refnums
2308 DAAD CD 1D B9              cmp   stdout_refnum            ;trying to close stdout?
2309 DAB0 D0 0A                 bne   @continue                ;no...
2310 DAB2 CD 1F B9              cmp   stderr_refnum            ;are stdout and stderr the same file?
2311 DAB5 D0 05                 bne   @continue                ;no...
2312 DAB7 9C 1F B9              stz   stderr_refnum            ;else zero out stderr refnum
2313 DABA 80 58                 bra   success                  ;and don't really close the file
2314 DABC              @continue  
2315 DABC
2316 DABC              ; In the case that there is no VCR associated with FCR (vol_id = $FFFF), do not
2317 DABC              ;  make a call to findvcr.  Instead just signal the FST that no VCR was
2318 DABC              ;  indicated by nulling out the VCR pointer.  (This only happens in the case
2319 DABC              ;  of FCRs made by the character FST).  The dev_num parameter is also nulled
2320 DABC              ;  in this case (the char FST maintains the device number in it's own storage).
2321 DABC
2322 DABC A0 08 00     check_vol_id ldy   #fcr_vol_id          ;load fcr_vol_id field from fcr
2323 DABF B7 D4                 lda   [<s_temp1],y
2324 DAC1 C9 FF FF              cmp   #$FFFF                   ;Check if this is a valid vol_id
2325 DAC4 D0 08                 bne   noffff                   ;Normal case
2326 DAC6 64 3E                 stz   <vcr_ptr
2327 DAC8 64 40                 stz   <vcr_ptr+2               ;Null out the VP
2328 DACA 64 36                 stz   <dev_num                 ; ... and the device number parm
2329 DACC 80 19                 bra   ffff                     ;Skip past vcr stuff
2330 DACE
2331 DACE              noffff    
2332 DACE 22 6F F8 00           jsl   findvcr                  ;get vp of vcr corresponding to this fcr
2333 DAD2 B0 42                 bcs   no_vcr
2334 DAD4 86 3E                 stx   <vcr_ptr                 ;store vp of vcr for FST
2335 DAD6 84 40                 sty   <vcr_ptr+2
2336 DAD8
2337 DAD8 22 09 FE 00           jsl   deref2                   ;dereference to get pointer to vcr
2338 DADC 86 D8                 stx   <s_temp2
2339 DADE 84 DA                 sty   <s_temp2+2
2340 DAE0 A0 0C 00              ldy   #vcr_dev
2341 DAE3 B7 D8                 lda   [<s_temp2],y             ;get the device number from the vcr
2342 DAE5 85 36                 sta   <dev_num                 ;...and save it on zero page
2343 DAE7
2344 DAE7              ffff      
2345 DAE7 A0 06 00              ldy   #fcr_fst_id              ;offset of FST id in fcr
2346 DAEA B7 D4                 lda   [<s_temp1],y             ;get the FST id from the fcr
2347 DAEC
2348 DAEC 20 46 E2              jsr   find_fst                 ;get the FST's offset
2349 DAEF B0 25                 bcs   no_fst                   ;say what???
2350 DAF1              *
2351 DAF1              * Ok, we're all set up.  Call the fst and exit if error...
2352 DAF1              *
2353 DAF1 20 AB B7              jsr   call_fst                 ;Do call.  Success?
2354 DAF4 B0 1F                 bcs   return                   ;Nope.
2355 DAF6              *
2356 DAF6              * Call successful.  Is it a close call?  Exit if not...
2357 DAF6              *
2358 DAF6 AD A0 B9              lda   |num                     ;Is close call?
2359 DAF9 C9 28 00              cmp   #$0028
2360 DAFC D0 16                 bne   success                  ;Nope.
2361 DAFE              *
2362 DAFE              * Yes, so we must see if the ref_num is in our std_ref_num list and, if it is,
2363 DAFE              * clear it out...
2364 DAFE              *
2365 DAFE A0 04 00              ldy   #0004                    ;Yes, is ref_num in std_ref list?
2366 DB01 AD 23 B9              lda   last_ref_num
2367 DB04 D9 1B B9     scan_list cmp   std_ref_num,y           ;Match?
2368 DB07 D0 07                 bne   next_ref                 ;Nope.
2369 DB09 A9 00 00              lda   #0000                    ;Yes, so clear it.
2370 DB0C 99 1B B9              sta   std_ref_num,y
2371 DB0F A8                    tay                            ;Force exit from loop.
2372 DB10 88           next_ref dey                            ;Done all?
2373 DB11 88                    dey   
2374 DB12 10 F0                 bpl   scan_list                ;Nope, so loop.
2375 DB14
2376 DB14 18           success  clc                            ;Yes, so we're done with no error.
2377 DB15 60           return   rts   
2378 DB16
2379 DB16
2380 DB16              no_fst    
2381 DB16 22 02 EF 00  no_vcr   jsl   s_sys_death
2382 DB1A
2383 DB1A                       end_proc 
2384 DB1A                       eject 
2385 DB1A
2386 DB1A              ;===============================================================================
2387 DB1A              ; do_type_4
2388 DB1A              ;
2389 DB1A              ; Handle calls that have unique processing.
2390 DB1A              ;===============================================================================
2391 DB1A
2392 DB1A              do_type_4 proc 
2393 DB1A
2394 DB1A DC D6 B9              jmp   [handler_addr]
2395 DB1D
2396 DB1D                       end_proc 
2397 DB1D                       eject 
2398 DB1D              ;===============================================================================
2399 DB1D              ; do_type_5
2400 DB1D              ;
2401 DB1D              ; Handle device calls d_info, d_status, d_control, d_read, d_write, and d_rename
2402 DB1D              ;===============================================================================
2403 DB1D
2404 DB1D              do_type_5 proc 
2405 DB1D
2406 DB1D 22 CC FC 01           jsl   >dev_manager             ;call the device manager 
2407 DB21
2408 DB21 60                    rts   
2409 DB22
2410 DB22                       end_proc 
2411 DB22                       eject 
2412 DB22              ;===============================================================================
2413 DB22              ; do_type_6
2414 DB22              ;
2415 DB22              ; Handle the flush and close calls.
2416 DB22              ;===============================================================================
2417 DB22
2418 DB22              do_type_6 proc 
2419 DB22                       entry do_all
2420 DB22
2421 DB22              ; Yank the reference number from the parameter block.  If it is other than
2422 DB22              ;  a class 0 call, skip over the pcount param.  If the refnum = 0, do it to
2423 DB22              ;  all appropriate open files; ow just do it to the file corresponding to
2424 DB22              ;  the reference number passed.
2425 DB22
2426 DB22 AC A2 B9              ldy   |class                   ;either 0 or 2
2427 DB25 B7 32                 lda   [<param_blk_ptr],y       ;Get the refnum request
2428 DB27 F0 03                 beq   do_all
2429 DB29
2430 DB29              ; The app requested a file operation with a specific reference number.  Find
2431 DB29              ;  the correct FCR, find out who the owning FST is, and fire the call of to
2432 DB29              ;  that FST.  The type_3 command executor does these very things.
2433 DB29
2434 DB29 4C 78 DA              jmp   do_type_3
2435 DB2C
2436 DB2C              error    equ   found_count              ;Error storage area (reuse variable)
2437 DB2C
2438 DB2C              do_all                                  ;Used during OS_Shutdown.
2439 DB2C
2440 DB2C              ; Now get into a loop which performs the operation on every open file with
2441 DB2C              ;  a level greater than or equal to the current system level.  Tell the
2442 DB2C              ;  do_type_3 code to do the level comparison by setting the variable s_level.
2443 DB2C
2444 DB2C AD 58 E4              lda   |system_level
2445 DB2F 8D DA B9              sta   |s_level
2446 DB32 9C 9C B9              stz   |error                   ;Clear out the error storage byte
2447 DB35
2448 DB35 A9 01 00              lda   #1                       ;Start out on the right foot
2449 DB38 22 44 F9 00           jsl   getfcr
2450 DB3C B0 1C                 bcs   all_done                 ;Bail out if there ain't no FCRs
2451 DB3E
2452 DB3E              again     
2453 DB3E
2454 DB3E 86 EC                 stx   <m_temp                  ;store vp of fcr for FST
2455 DB40 84 EE                 sty   <m_temp+2
2456 DB42
2457 DB42 20 62 DB              jsr   peek_next_rec            ;See what the next record's VP is
2458 DB45 5A                    phy                            ;Keep it for later
2459 DB46 DA                    phx   
2460 DB47
2461 DB47 A6 EC                 ldx   <m_temp                  ;Get back the VP
2462 DB49 A4 EE                 ldy   <m_temp+2
2463 DB4B
2464 DB4B 20 8A DA              jsr   type_3_alt               ;Do the operation on this file.
2465 DB4E FA                    plx                            ;Get back the successor
2466 DB4F 7A                    ply   
2467 DB50 90 03                 bcc   return                   ;If there was no error, skip store
2468 DB52 8D 9C B9              sta   |error
2469 DB55
2470 DB55              return    
2471 DB55 D0 E7                 bne   again                    ;If VP high was non-zero, more to do
2472 DB57 8A                    txa   
2473 DB58 D0 E4                 bne   again                    ;If VP low was non-zero, ditto
2474 DB5A
2475 DB5A              all_done  
2476 DB5A
2477 DB5A              ; All files have been operated on.  Load up the error byte and return it
2478 DB5A              ;  after setting the carry correctly.
2479 DB5A
2480 DB5A 18                    clc   
2481 DB5B AD 9C B9              lda   |error
2482 DB5E F0 01                 beq   skip4
2483 DB60 38                    sec   
2484 DB61              skip4     
2485 DB61 60                    rts   
2486 DB62
2487 DB62              peek_next_rec  
2488 DB62
2489 DB62 22 F0 FD 00           jsl   gderef                   ;dereference to get pointer to block
2490 DB66 86 D4                 stx   <s_temp1
2491 DB68 84 D6                 sty   <s_temp1+2
2492 DB6A
2493 DB6A A0 02 00              ldy   #succ                    ;Want to get the VP of the successor
2494 DB6D B7 D4                 lda   [<s_temp1],y
2495 DB6F AA                    tax                            ;Got low part of successor
2496 DB70 C8                    iny   
2497 DB71 C8                    iny   
2498 DB72 B7 D4                 lda   [<s_temp1],y
2499 DB74 A8                    tay   
2500 DB75 60                    rts   
2501 DB76
2502 DB76                       end_proc 
2503 DB76                       eject 
2504 DB76              ;===============================================================================
2505 DB76              ; do_type_7
2506 DB76              ;
2507 DB76              ; Handle the FORMAT and ERASE_DISK calls.
2508 DB76              ;===============================================================================
2509 DB76
2510 DB76              do_type_7 proc 
2511 DB76
2512 DB76              pblk_fe_act_fst equ   10                ;offset of class 1 actual fst id field
2513 DB76              pblk_fe_req_fst equ   12                ;offset of class 1 requested fst id
2514 DB76              pblk_fe_flags equ   14                  ;offset of class 1 flags word
2515 DB76              pblk_fe_realname equ 16                 ;offset of class 1 result buffer for
2516 DB76                                                      ;...name used in actual operation
2517 DB76
2518 DB76              ; First, check to see if requested FST field is OK if this is a class 1 call
2519 DB76              ; with pcount of 4.  Also checks the flags word if pCount == 5.
2520 DB76
2521 DB76 AD A2 B9              lda   |class                   ;get class
2522 DB79 F0 29                 beq   do_check                 ;go ahead if it's class 0
2523 DB7B A7 32                 lda   [<param_blk_ptr]         ;get pcount
2524 DB7D C9 04 00              cmp   #$0004                   ;is it 4?
2525 DB80 90 22                 bcc   do_check                 ;go ahead if it's not pcount>=4
2526 DB82 A0 0C 00              ldy   #pblk_fe_req_fst         ;offset of requested FST field
2527 DB85 B7 32                 lda   [<param_blk_ptr],y       ;get requested FST
2528 DB87 F0 05                 beq   @skip_check              ;if 0, allow user to select it
2529 DB89 20 46 E2              jsr   find_fst                 ;is it a legal FST id?
2530 DB8C B0 15                 bcs   @bad_fst                 ;no, return invalid_fst
2531 DB8E              @skip_check  
2532 DB8E A7 32                 lda   [<param_blk_ptr]         ;get pCount again
2533 DB90 C9 05 00              cmp   #$0005                   ;flags word included?
2534 DB93 90 0F                 bcc   do_check                 ;no, so skip the check
2535 DB95 A0 0E 00              ldy   #pblk_fe_flags
2536 DB98 B7 32                 lda   [<param_blk_ptr],y       ;get flags out of parm block
2537 DB9A 29 FF 1F              and   #%0001111111111111       ;only bits 13, 14 & 15 are valid
2538 DB9D F0 05                 beq   do_check                 ;if any other bits are set, return error
2539 DB9F A9 53 00              lda   #parm_range_err
2540 DBA2 38                    sec   
2541 DBA3              @bad_fst  
2542 DBA3 60                    rts   
2543 DBA4              *
2544 DBA4              * Now we need to check to see if there are any files open on the volume that is
2545 DBA4              * to be formatted or erased.  To do this, we will do a volume call then look up
2546 DBA4              * the VCR and check the open_cnt.  First, we get the device name parameter into
2547 DBA4              * device_name...
2548 DBA4              *
2549 DBA4 AD A2 B9     do_check lda   |class                   ;Class 0?
2550 DBA7 D0 15                 bne   do_class1                ;Nope.
2551 DBA9
2552 DBA9 A0 02 00              ldy   #0002                    ;Yes, convert name.
2553 DBAC B7 32                 lda   [<param_blk_ptr],y
2554 DBAE 48                    pha   
2555 DBAF A7 32                 lda   [<param_blk_ptr]
2556 DBB1 48                    pha   
2557 DBB2 F4 00 00              pea   device_name>>16
2558 DBB5 F4 60 B9              pea   device_name
2559 DBB8 22 9A E4 00           jsl   cvt0to1                  ;Convert and move string.
2560 DBBC 80 1B                 bra   save_env                 ;Continue.
2561 DBBE
2562 DBBE A0 02 00     do_class1 ldy   #0002                   ;Get offset to pointer.
2563 DBC1 B7 32                 lda   [<param_blk_ptr],y       ;Get pointer.
2564 DBC3 85 EC                 sta   <m_temp                  ;Set source pointer.
2565 DBC5 A0 04 00              ldy   #0004
2566 DBC8 B7 32                 lda   [<param_blk_ptr],y
2567 DBCA 85 EE                 sta   <m_temp+2
2568 DBCC A9 60 B9              lda   #device_name             ;Set destination pointer.
2569 DBCF 85 E8                 sta   <ptr
2570 DBD1 A9 00 00              lda   #device_name>>16
2571 DBD4 85 EA                 sta   <ptr+2
2572 DBD6 20 01 B7              jsr   copy_ext_string          ;Copy string.
2573 DBD9              *
2574 DBD9              * Now we must save our current environment...
2575 DBD9              *
2576 DBD9 D4 32        save_env pei   <param_blk_ptr           ;Save parameter block pointer.
2577 DBDB D4 34                 pei   <param_blk_ptr+2
2578 DBDD D4 30                 pei   <call_number             ;Save call number.
2579 DBDF AD A0 B9              lda   |num                     ;Save num.
2580 DBE2 48                    pha   
2581 DBE3 AD A6 B9              lda   |script_start            ;Save script start.
2582 DBE6 48                    pha   
2583 DBE7              *
2584 DBE7              * Now do the call and restore saved environment.  If an error occured, branch
2585 DBE7              * ahead past check for open count...
2586 DBE7              *
2587 DBE7 20 4B B5              jsr   do_volume_call           ;Do volume call.
2588 DBEA
2589 DBEA 68                    pla                            ;Restore script_start.
2590 DBEB 8D A6 B9              sta   |script_start
2591 DBEE 68                    pla                            ;Restore num.
2592 DBEF 8D A0 B9              sta   |num
2593 DBF2 68                    pla                            ;Restore call number.
2594 DBF3 85 30                 sta   <call_number
2595 DBF5 68                    pla                            ;Restore parameter block pointer.
2596 DBF6 85 34                 sta   <param_blk_ptr+2
2597 DBF8 68                    pla   
2598 DBF9 85 32                 sta   <param_blk_ptr
2599 DBFB 08                    php                            ;Save error status.
2600 DBFC 20 61 B7              jsr   release_v_ptrs           ;Release vps.
2601 DBFF 28                    plp                            ;Did we get an error for volume?
2602 DC00 B0 2A                 bcs   go_ahead                 ;Yes, so skip open count check.
2603 DC02              *
2604 DC02              * Volume call succeeded so now let's look up the vcr and check the open count.
2605 DC02              * If the count is not zero, exit with a file_busy error...
2606 DC02              *
2607 DC02 AD 60 B9              lda   device_name              ;Get length.
2608 DC05 3A                    dec   a                        ;Strip leading separator.
2609 DC06 8D 61 B9              sta   device_name+1
2610 DC09
2611 DC09 A9 00 00              lda   #0000                    ;Select search for name.
2612 DC0C A2 61 B9              ldx   #device_name+1           ;Get pointer to name.
2613 DC0F A0 00 00              ldy   #device_name+1>>16
2614 DC12 22 63 F8 00           jsl   findvcrcase              ;Go look for it. Found?
2615 DC16 B0 14                 bcs   go_ahead                 ;Nope, so we're ok.
2616 DC18 22 09 FE 00           jsl   deref2                   ;Yes, deref vp.
2617 DC1C 86 F8                 stx   <vcr                     ;Save pointer to vcr.
2618 DC1E 84 FA                 sty   <vcr+2
2619 DC20 A0 08 00              ldy   #vcr_open_cnt            ;Get offset to open count.
2620 DC23 B7 F8                 lda   [<vcr],y                 ;Get open count.  Zero?
2621 DC25 F0 05                 beq   go_ahead                 ;Yes, so we're ok.
2622 DC27 A9 50 00              lda   #file_busy               ;Nope, so exit with error.
2623 DC2A 38                    sec   
2624 DC2B 60                    rts   
2625 DC2C
2626 DC2C              ; Perform preliminary pathname translation for the init package.
2627 DC2C              go_ahead  
2628 DC2C A9 00 00              lda   #$0000                   ;translation flags (no uppercasing)
2629 DC2F AA                    tax                            ;signify that this is first time through
2630 DC30 22 73 DA E1           jsl   fe_xlate                 ;do the translation
2631 DC34 90 05                 bcc   @continue
2632 DC36 08                    php                            ;bomb out if there's an error
2633 DC37 48                    pha                            ;set up stack for correct return
2634 DC38 4C 0E DD              jmp   outta_here               ;then leave
2635 DC3B
2636 DC3B              ; Call the init package.
2637 DC3B
2638 DC3B              @continue  
2639 DC3B 9C BE B9              stz   volname_vp               ;null out VP variable
2640 DC3E 9C C0 B9              stz   volname_vp+2
2641 DC41 9C C2 B9              stz   volname_ptr              ;and volume name pointer
2642 DC44 9C C4 B9              stz   volname_ptr+2
2643 DC47
2644 DC47 AE A0 B9              ldx   |num                     ;X = 2*call number
2645 DC4A AC A2 B9              ldy   |class                   ;Y = 2*call class
2646 DC4D
2647 DC4D 22 00 B2 00           jsl   init_pack                ;call the initialization package
2648 DC51
2649 DC51 B0 63                 bcs   relay_error              ;bomb out if there's an error
2650 DC53
2651 DC53              ; Save the returned fst id in the actual_fst_id field if a class 1 call.
2652 DC53
2653 DC53 48                    pha                            ;save returned fst_id
2654 DC54 5A                    phy                            ;save returned VP to volume name
2655 DC55 DA                    phx   
2656 DC56
2657 DC56 AE A2 B9              ldx   |class                   ;is it class 1 (i.e. class = 2)?
2658 DC59 F0 0E                 beq   ar_1                     ;no, don't save actual fst id
2659 DC5B AA                    tax                            ;save FST ID in X for a sec.
2660 DC5C A7 32                 lda   [<param_blk_ptr]         ;get the pCount
2661 DC5E C9 03 00              cmp   #$0003                   ;is there enough room in the parmblock?
2662 DC61 90 06                 bcc   ar_1                     ;no, skip it
2663 DC63 A0 0A 00              ldy   #pblk_fe_act_fst
2664 DC66 8A                    txa                            ;get FST ID back into Acc.
2665 DC67 97 32                 sta   [<param_blk_ptr],y
2666 DC69              ar_1      
2667 DC69
2668 DC69              ; Done with the translated pathnames, so release them.
2669 DC69
2670 DC69 20 61 B7              jsr   release_v_ptrs
2671 DC6C
2672 DC6C              ; Now we lock GIM memory and deref the returned VP so we can use the
2673 DC6C              ; name supplied by the user.
2674 DC6C
2675 DC6C 22 35 FE 00           jsl   lockmem                  ;lock down memory
2676 DC70 FA                    plx                            ;retrieve VP
2677 DC71 7A                    ply   
2678 DC72 8E BE B9              stx   volname_vp               ;save here for disposal later
2679 DC75 8C C0 B9              sty   volname_vp+2
2680 DC78 98                    tya                            ;now check for a null VP
2681 DC79 0D BE B9              ora   volname_vp               ;is it NULL?
2682 DC7C F0 06                 beq   @original_name           ;yes, just use the supplied name
2683 DC7E 22 09 FE 00           jsl   deref2                   ;deref the VP
2684 DC82 80 10                 bra   @store_ptr               ;go store the pointer
2685 DC84              @original_name  
2686 DC84 AD A2 B9              lda   |class                   ;class 0 or 1?
2687 DC87 18                    clc                            ;(value was 0 or 2, make
2688 DC88 69 04 00              adc   #4                       ; into 4 or 6, index to parm pointer)
2689 DC8B A8                    tay   
2690 DC8C B7 32                 lda   [<param_blk_ptr],y       ;get the pointer to the supplied name
2691 DC8E AA                    tax   
2692 DC8F C8                    iny   
2693 DC90 C8                    iny   
2694 DC91 B7 32                 lda   [<param_blk_ptr],y
2695 DC93 A8                    tay   
2696 DC94              @store_ptr  
2697 DC94 8E C2 B9              stx   volname_ptr              ;save the pointer to the volume name
2698 DC97 8C C4 B9              sty   volname_ptr+2
2699 DC9A
2700 DC9A              ; Recover the fst_id and perform pathname translation.
2701 DC9A 68                    pla   
2702 DC9B 20 46 E2              jsr   find_fst                 ;translate fst_id into fst_tbl index
2703 DC9E B0 16                 bcs   relay_error
2704 DCA0 8D 15 B9              sta   |curr_fst                ;curr_fst = index to FST table
2705 DCA3 AA                    tax                            ;X = fst_tbl index
2706 DCA4 BD 1F B8              lda   |fst_tbl+s_flags,x       ;get translation control flags
2707 DCA7 A2 01 00              ldx   #1                       ;signify that this is second time through
2708 DCAA 22 73 DA E1           jsl   fe_xlate                 ;perform the pathname translation
2709 DCAE B0 06                 bcs   relay_error
2710 DCB0
2711 DCB0              ; Call the FST
2712 DCB0 AD 15 B9              lda   |curr_fst
2713 DCB3 20 AB B7              jsr   call_fst
2714 DCB6              relay_error  
2715 DCB6 08                    php                            ;save status
2716 DCB7 48                    pha                            ;save error code
2717 DCB8
2718 DCB8 AD A2 B9              lda   |class                   ;was there a realVolName parameter?
2719 DCBB F0 37                 beq   @class0                  ;can't be with class 0 call
2720 DCBD A7 32                 lda   [<param_blk_ptr]         ;check the pCount
2721 DCBF C9 06 00              cmp   #$0006                   ;did they want the realVolName returned?
2722 DCC2 D0 30                 bne   @class0                  ;no...
2723 DCC4 AD C2 B9              lda   |volname_ptr             ;else set up m_temp pointer
2724 DCC7 85 EC                 sta   <m_temp
2725 DCC9 AD C4 B9              lda   |volname_ptr+2
2726 DCCC 85 EE                 sta   <m_temp+2
2727 DCCE 05 EC                 ora   <m_temp                  ;is there a volume name to return?
2728 DCD0 F0 22                 beq   @class0                  ;no, just skip it
2729 DCD2 A7 EC                 lda   [<m_temp]                ;get the length of the string
2730 DCD4 A0 10 00              ldy   #pblk_fe_realName        ;offset to buffer pointer in parm block
2731 DCD7 20 A9 E5              jsr   chk_app_buf              ;check the length of the app's buffer
2732 DCDA F0 18                 beq   @class0                  ;skip it if its a NULL pointer
2733 DCDC 90 13                 bcc   @long_enuff              ;yup, it's long enough
2734 DCDE A3 02                 lda   2,s                      ;retrieve the saved status
2735 DCE0 89 00 01              bit   #%0000000100000000       ;is the carry already set?
2736 DCE3 D0 0F                 bne   @class0                  ;yup, just leave it as is
2737 DCE5 09 00 01              ora   #%0000000100000000       ;else set it
2738 DCE8 83 02                 sta   2,s
2739 DCEA A9 4F 00              lda   #buff_too_small          ;and store the error code
2740 DCED 83 01                 sta   1,s
2741 DCEF 80 03                 bra   @class0                  ;then skip the copy
2742 DCF1
2743 DCF1              @long_enuff  
2744 DCF1 20 01 B7              jsr   copy_ext_string          ;copy the string to caller's buffer
2745 DCF4              @class0   
2746 DCF4 AD BE B9              lda   volname_vp               ;do we have a buffer to dispose of?
2747 DCF7 0D C0 B9              ora   volname_vp+2
2748 DCFA F0 0A                 beq   @1                       ;no...
2749 DCFC AE BE B9              ldx   volname_vp               ;else dispose of volume name
2750 DCFF AC C0 B9              ldy   volname_vp+2
2751 DD02 22 15 FD 00           jsl   deallocate
2752 DD06              @1        
2753 DD06 22 25 FE 00           jsl   unlockmem                ;let memory float around
2754 DD0A 22 0E B2 00           jsl   init_pack_end            ;Tell init_pack we're done.
2755 DD0E
2756 DD0E 20 61 B7     outta_here jsr   release_v_ptrs         ;release storage used by pathnames
2757 DD11
2758 DD11 68                    pla   
2759 DD12 28                    plp   
2760 DD13 60                    rts   
2761 DD14
2762 DD14                       end_proc 
2763 DD14
2764 DD14                       eject 
2765 DD14              ;===============================================================================
2766 DD14              ; do_get_last_dev
2767 DD14              ;
2768 DD14              ; Handle the get_last_devnum call.
2769 DD14              ;===============================================================================
2770 DD14
2771 DD14              do_get_last_dev proc 
2772 DD14
2773 DD14 A5 00                 lda   <drvr_dev_num            ;get last device number from zero page
2774 DD16 F0 04                 beq   data_error               ;error if device number is zero
2775 DD18 87 32                 sta   [<param_blk_ptr]         ;save the device number
2776 DD1A 18                    clc   
2777 DD1B 60                    rts   
2778 DD1C
2779 DD1C A9 60 00     data_error lda   #data_unavail
2780 DD1F 38                    sec   
2781 DD20 60                    rts   
2782 DD21
2783 DD21                       end_proc 
2784 DD21                       eject 
2785 DD21              ;===============================================================================
2786 DD21              ; Pathname Translation Module
2787 DD21              ;
2788 DD21              ; This module contains routines and data structures used to translate input
2789 DD21              ; pathnames into the internal format used by FSTs.
2790 DD21              ;===============================================================================
2791 DD21
2792 DD21              ;===============================================================================
2793 DD21              ; xlate_path:  Translate pathname into canonical format for FST.
2794 DD21              ; xlate_path2: Alternate entry point for set_prefix and quit.
2795 DD21              ;
2796 DD21              ; Enter:        jsr     xlate_path
2797 DD21              ;               jsr     xlate_path2
2798 DD21              ;
2799 DD21              ; Input:        A = offset of pathname pointer field in parameter block
2800 DD21              ;                   we are guaranteed that this field is not null
2801 DD21              ;               X = prefix number of prefix to append if partial pathname does
2802 DD21              ;                   not explicitly specify a prefix (this is only used by
2803 DD21              ;                   xlate_path2)
2804 DD21              ;               fst_flags = pathname translation attributes of the FST
2805 DD21              ;               xlate_count = 0--translate first pathname in parameter block
2806 DD21              ;                           = 1--translate second pathname in parameter block
2807 DD21              ;               param_blk_ptr = pointer to parameter block
2808 DD21              ;               P = nvmxdizc
2809 DD21              ;                   ..000...
2810 DD21              ;
2811 DD21              ; Output:       Translated pathnames as described in the Filenames, Device
2812 DD21              ;               Names, and Pathnames ERS
2813 DD21              ;               Explain differences between two entry points:
2814 DD21              ;                   How null prefix is interpreted.
2815 DD21              ;                   How device name at beginning is handled.
2816 DD21              ;
2817 DD21              ;
2818 DD21              ;===============================================================================
2819 DD21
2820 DD21              xlate_path proc 
2821 DD21                       entry xlate_path2,xlate_path3
2822 DD21
2823 DD21 9C B8 B9              stz   |default_prefix          ;default prefix is prefix 0
2824 DD24 9C B0 B9              stz   |xlate_type              ;indicate that call is not set_prefix
2825 DD27 80 09                 bra   xlate_it
2826 DD29
2827 DD29              xlate_path2                             ;alternate entry for set_prefix
2828 DD29 8E B8 B9              stx   |default_prefix          ;default prefix specified by caller
2829 DD2C A0 01 00              ldy   #$0001                   ;indicate that call is set_prefix
2830 DD2F 8C B0 B9              sty   |xlate_type
2831 DD32
2832 DD32              ;
2833 DD32              ; Set up working pointers to input pathname.  First get pointer to pathname out
2834 DD32              ; of parameter block.  We are guaranteed that the pathname pointer is non-null.
2835 DD32              ;
2836 DD32 A8           xlate_it tay                            ;pathname offset to Y
2837 DD33 B7 32                 lda   [<param_blk_ptr],y       ;get pathname pointer (low word)
2838 DD35 85 D4                 sta   <in_ptr
2839 DD37 C8                    iny   
2840 DD38 C8                    iny   
2841 DD39 B7 32                 lda   [<param_blk_ptr],y       ;get pathname pointer (high)
2842 DD3B 85 D6                 sta   <in_ptr+2
2843 DD3D
2844 DD3D              ; enter here to use custom pathname pointer, must be stored in in_ptr
2845 DD3D
2846 DD3D              xlate_path3  
2847 DD3D              ;
2848 DD3D              ; Initialize prefix_number to indicate no prefix.
2849 DD3D              ;
2850 DD3D A9 FF FF              lda   #$FFFF
2851 DD40 8D B6 B9              sta   |prefix_number
2852 DD43              ;
2853 DD43              ; Set in_curr to offset of first string byte and in_end to offset one past
2854 DD43              ; last string byte.
2855 DD43              ;
2856 DD43 AD A2 B9              lda   |class                   ;check call's class
2857 DD46 D0 17                 bne   not_class_0              ;branch ahead for class > 0
2858 DD48 A9 01 00     class_0  lda   #$0001                   ;set in_curr to 1
2859 DD4B 85 D8                 sta   <in_curr
2860 DD4D A7 D4                 lda   [<in_ptr]                ;get string length (one byte)
2861 DD4F 29 FF 00              and   #$00FF
2862 DD52 1A                    inc   a                        ;increment and make it the value of
2863 DD53 8D B4 B9              sta   |str_len                 ;save string length + 1
2864 DD56 85 DA                 sta   <in_end                  ;...in_end
2865 DD58 3A                    dec   a
2866 DD59 D0 16                 bne   ar_1                     ;Non-null, continue.
2867 DD5B
2868 DD5B E2 20        null_hop sep   #m8                      ;Null, we need to switch to 8 bit.
2869 DD5D 80 47                 bra   is_null                  ;we have a zero length string.
2870 DD5F
2871 DD5F A9 02 00     not_class_0 lda   #$0002                ;set in_curr to 2
2872 DD62 85 D8                 sta   <in_curr
2873 DD64 A7 D4                 lda   [<in_ptr]                ;get string length (two bytes)
2874 DD66 1A                    inc   a                        ;increment twice and store in in_end
2875 DD67 8D B4 B9              sta   |str_len                 ;save string length + 1
2876 DD6A 1A                    inc   a
2877 DD6B 85 DA                 sta   <in_end
2878 DD6D C5 D8                 cmp   <in_curr                 ;check for a length of zero from user
2879 DD6F F0 EA                 beq   null_hop                 ;get out of here
2880 DD71              ar_1      
2881 DD71              ;
2882 DD71              ; Enter 8-bit accumulator mode.
2883 DD71              ;
2884 DD71 E2 20                 sep   #m8                      ;8-bit memory mode
2885 DD73                       longa off
2886 DD73              *
2887 DD73              * Now scan string from in_cur to in_end looking for nulls. If any found, exit with
2888 DD73              * bad_path_syntax err...
2889 DD73              *
2890 DD73 A4 D8                 ldy   <in_curr                 ;Get offset to first char.
2891 DD75 B7 D4        null_loop lda   [<in_ptr],y             ;Get char. Null?
2892 DD77 F0 65                 beq   syntax_err_hop           ;Yep, so error.
2893 DD79 C8                    iny                            ;Nope, bump offset.
2894 DD7A C4 DA                 cpy   <in_end                  ;Done all?
2895 DD7C D0 F7                 bne   null_loop                ;No, so keep going.
2896 DD7E              ;
2897 DD7E              ; Set up translation control flags and character mask.
2898 DD7E              ;
2899 DD7E AD 1A B9              lda   |fst_flags+1
2900 DD81 85 E5                 sta   <control+1
2901 DD83
2902 DD83 0A                    asl   a                        ;shift bit 12 of full fst_flags word
2903 DD84 0A                    asl   a                        ;...into sign position of accumulator
2904 DD85 0A                    asl   a                        ;=1 indicates 'turn off high bits'
2905 DD86 29 80                 and   #$80                     ;make sure no other bits are on
2906 DD88 49 FF                 eor   #$FF                     ;if high bit=1 mask will be $7F else $FF
2907 DD8A 8D D5 B9              sta   |char_mask               ;save for use throughout translation
2908 DD8D              ;
2909 DD8D              ; Process first character of pathname, if any.
2910 DD8D              ;
2911 DD8D 20 D8 E0              jsr   look_at_char             ;get the first character
2912 DD90 20 8A E0              jsr   classify_char            ;classify the character
2913 DD93 7C 96 DD              jmp   (tbl1,x)                 ;case branch on the first character
2914 DD96
2915 DD96 A6 DD        tbl1     DC W:is_null                   ;no character--can't happen
2916 DD98 6E DE                 DC W:syntax_err                ;illegal character is syntax error
2917 DD9A B4 DD                 DC W:init_sep                  ;initial character is separator
2918 DD9C D4 DD                 DC W:init_period               ;...period
2919 DD9E 97 DE                 DC W:init_star                 ;...asterisk
2920 DDA0 9D DE                 DC W:init_at                   ;...'@'
2921 DDA2 AA DE                 DC W:init_digit                ;...digit
2922 DDA4 51 E0                 DC W:init_other                ;...some other legal character
2923 DDA6              ;-------------------------------------------------------------------------------
2924 DDA6              ; Case 1:  The input pathname string contains no characters.  This is
2925 DDA6              ;          a syntax error for normal calls, but is OK for set_prefix.
2926 DDA6              ;-------------------------------------------------------------------------------
2927 DDA6 AD B0 B9     is_null  lda   |xlate_type              ;determine which call is being processed
2928 DDA9 F0 33                 beq   syntax_err_hop           ;only set_prefix is allowed to have a NULL string
2929 DDAB A0 03 00     prefix_1 ldy   #$0003                   ;allocate a null string in virtual space
2930 DDAE 20 30 E1              jsr   alloc_string
2931 DDB1 4C 86 DE              jmp   return
2932 DDB4
2933 DDB4              ;-------------------------------------------------------------------------------
2934 DDB4              ; Case 2:  Full pathname beginning with volume name.  The input pathname starts
2935 DDB4              ;          with a separator.
2936 DDB4              ;
2937 DDB4              ;          Beginning at the label special_xlate, this code also handles a
2938 DDB4              ;          subcase of Case 3 corresponding to the situation where a pathname
2939 DDB4              ;          begins with a device name, but the device name is not to be
2940 DDB4              ;          translated to a device number and discarded from the pathname string.
2941 DDB4              ;          Code in Case 3 branches to this label.
2942 DDB4              ;-------------------------------------------------------------------------------
2943 DDB4 85 E4        init_sep sta   <control                 ;store separator character
2944 DDB6              ;
2945 DDB6              ; Allocate space for translated string.  Then move the string.
2946 DDB6              ;
2947 DDB6 AC B4 B9     special_xlate ldy   |str_len            ;get string length saved earlier
2948 DDB9 C8                    iny                            ;already incremented by 1; need to add
2949 DDBA C8                    iny                            ;...2 more to account for length word
2950 DDBB 20 30 E1              jsr   alloc_string             ;allocate space for the string
2951 DDBE 90 03                 bcc   ok_1
2952 DDC0 4C 67 DE              jmp   memory_err
2953 DDC3 A4 D8        ok_1     ldy   <in_curr
2954 DDC5 A6 E0                 ldx   <out_curr
2955 DDC7 20 E4 E0              jsr   copy_xlate
2956 DDCA B0 12                 bcs   syntax_err_hop
2957 DDCC 20 7E E1     ok_2     jsr   calc_span
2958 DDCF B0 0D                 bcs   syntax_err_hop
2959 DDD1 4C 86 DE     ok_3     jmp   return
2960 DDD4              ;-------------------------------------------------------------------------------
2961 DDD4              ; Case 3:  Full pathname beginning with device name.  The input pathname starts
2962 DDD4              ;          with a period.
2963 DDD4              ;-------------------------------------------------------------------------------
2964 DDD4              ;
2965 DDD4              ; Handle the initial part of the pathname containing the device name.
2966 DDD4              ;
2967 DDD4 20 E7 E1     init_period jsr   len_to_delim          ;determine length of device name substr
2968 DDD7 B0 05                 bcs   syntax_err_hop           ;syntax error if too many characters
2969 DDD9 E0 00 00     ok_4     cpx   #$0000                   ;any characters in device name?
2970 DDDC D0 03                 bne   ok_5                     ;yes, continue
2971 DDDE 4C 6E DE     syntax_err_hop jmp   syntax_err         ;otherwise it's a syntax error
2972 DDE1 E0 21 00     ok_5     cpx   #$0021                   ;device name more than 32 characters
2973 DDE4 B0 F8                 bcs   syntax_err_hop           ;yes, syntax error
2974 DDE6              ;
2975 DDE6              ; At this point, initial device name is valid.  Now we must determine whether or
2976 DDE6              ; not to translate the device name to a device number and strip it off (as
2977 DDE6              ; required by most calls) or leave the device name as is (as required by
2978 DDE6              ; SET_PREFIX and QUIT.
2979 DDE6              ;
2980 DDE6 85 E4        ok_6     sta   <control                 ;store separator character determined
2981 DDE8                                                      ;...by len_to_delim
2982 DDE8 AD B0 B9              lda   |xlate_type              ;which type of device name translation?
2983 DDEB D0 C9                 bne   special_xlate            ;if non-zero, do not xlate device name
2984 DDED
2985 DDED 8C B2 B9     normal_xlate sty   |cont_offset         ;save offset just after device name
2986 DDF0 A4 D8                 ldy   <in_curr                 ;get offset of initial '.'
2987 DDF2 8A                    txa                            ;store device name length temporarily
2988 DDF3 97 D4                 sta   [<in_ptr],y              ;...in place of the '.'
2989 DDF5
2990 DDF5 C2 30                 rep   #mx16                    ;prepare to call get_dnum--set 16-bit
2991 DDF7                       longa on                       ;...m and x
2992 DDF7
2993 DDF7 18                    clc                            ;compute a pointer to the period by
2994 DDF8 98                    tya                            ;...adding offset of period to pointer
2995 DDF9 65 D4                 adc   <in_ptr                  ;...to beginning of string
2996 DDFB AA                    tax                            ;save low order word in X
2997 DDFC A9 00 00              lda   #$0000
2998 DDFF 65 D6                 adc   <in_ptr+2
2999 DE01 A8                    tay                            ;save high order word in Y
3000 DE02 22 71 FB E0           jsl   >get_dnum                ;get device number corresponding to
3001 DE06 90 03                 bcc   ok_7                     ;handle device number error
3002 DE08 4C 75 DE              jmp   devnum_err
3003 DE0B AE AE B9     ok_7     ldx   |xlate_count             ;first or second pathname translation?
3004 DE0E D0 04                 bne   go_on_3                  ;store device number in proper place
3005 DE10 85 36                 sta   <dev1_num
3006 DE12 80 02                 bra   go_on_4
3007 DE14 85 38        go_on_3  sta   <dev2_num
3008 DE16              go_on_4   
3009 DE16
3010 DE16 E2 20                 sep   #m8                      ;return to 8-bit m mode
3011 DE18                       longa off
3012 DE18
3013 DE18 A4 D8                 ldy   <in_curr                 ;restore period in pathname
3014 DE1A A9 2E                 lda   #'.'
3015 DE1C 97 D4                 sta   [<in_ptr],y
3016 DE1E              ;
3017 DE1E              ; Handle the part of the pathname after the initial device name.  At this
3018 DE1E              ; point, we don't know if there is anything after the device name.
3019 DE1E              ;
3020 DE1E AC B2 B9              ldy   |cont_offset             ;update in_curr to contain offset of
3021 DE21 84 D8                 sty   <in_curr                 ;...byte just after device name
3022 DE23
3023 DE23 C4 DA                 cpy   <in_end                  ;are we past the end of the string?
3024 DE25 B0 31                 bge   devname_only             ;yes, go to clean up and exit
3025 DE27
3026 DE27 B7 D4                 lda   [<in_ptr],y              ;no, continue processing at separator
3027 DE29 2D D5 B9              and   |char_mask
3028 DE2C 85 E4                 sta   <control                 ;save the controlling separator
3029 DE2E
3030 DE2E C8                    iny                            ;adjust in_curr and Y to be offset
3031 DE2F 84 D8                 sty   <in_curr                 ;...following separator
3032 DE31 C4 DA                 cpy   <in_end                  ;are we past end of string?
3033 DE33 B0 23                 bge   devname_only             ;yes, go clean up and exit
3034 DE35              ;
3035 DE35              ; There is a pathname body after the device name and separator.
3036 DE35              ;
3037 DE35 C2 20        handle_body rep   #m16                  ;enter 16-bit m mode
3038 DE37 38                    sec                            ;compute size of space to allocate for
3039 DE38 A5 DA                 lda   <in_end                  ;...rest of string
3040 DE3A E5 D8                 sbc   <in_curr                 ;size = in_end - in_curr + 3 (3 accounts
3041 DE3C A8                    tay                            ;...for length word and trailing NUL)
3042 DE3D E2 20                 sep   #m8                      ;back to 8-bit m mode
3043 DE3F C8                    iny   
3044 DE40 C8                    iny   
3045 DE41 C8                    iny   
3046 DE42 20 30 E1              jsr   alloc_string             ;allocate space for the string
3047 DE45 B0 20                 bcs   memory_err
3048 DE47
3049 DE47 A4 D8                 ldy   <in_curr                 ;copy string to allocated space
3050 DE49 A6 E0                 ldx   <out_curr
3051 DE4B 20 E4 E0              jsr   copy_xlate
3052 DE4E B0 1E                 bcs   syntax_err
3053 DE50
3054 DE50 20 7E E1              jsr   calc_span                ;calculate span and do gross syntax chk
3055 DE53 B0 19                 bcs   syntax_err
3056 DE55
3057 DE55 4C 86 DE              jmp   return
3058 DE58
3059 DE58 AE AE B9     devname_only ldx   |xlate_count         ;set path flag to indicate to body
3060 DE5B D0 04                 bne   go_on_5                  ;...in pathname beyond device name
3061 DE5D 64 43                 stz   <path_flag+1
3062 DE5F 80 02                 bra   go_on_6
3063 DE61 64 42        go_on_5  stz   <path_flag
3064 DE63              go_on_6   
3065 DE63 C2 20                 rep   #m16                     ;normal exit, set 16-bit memory
3066 DE65 18                    clc   
3067 DE66 60                    rts   
3068 DE67
3069 DE67              ;===============================================================================
3070 DE67              ; Return and error handling has been inserted in the middle of this routine to
3071 DE67              ; minimize the number of long branches in pathname translation routines.
3072 DE67              ;===============================================================================
3073 DE67
3074 DE67 A9 00        memory_err lda   #$00                   ;out of memory error
3075 DE69 EB                    xba   
3076 DE6A A9 54                 lda   #out_of_mem
3077 DE6C 80 14                 bra   error_tail
3078 DE6E
3079 DE6E A9 00        syntax_err lda   #$00                   ;pathname syntax error
3080 DE70 EB                    xba   
3081 DE71 A9 40                 lda   #bad_path_syntax
3082 DE73 80 0D                 bra   error_tail
3083 DE75              ;
3084 DE75              ; Device number error.  A=error code.  16-bit mode.  Need to restore period
3085 DE75              ; in caller's input string.
3086 DE75              ;
3087 DE75 E2 20        devnum_err sep   #m8                    ;enter 8-bit m mode
3088 DE77 48                    pha                            ;push error from get_dnum onto stack
3089 DE78 A4 D8                 ldy   <in_curr                 ;restore period in input string
3090 DE7A A9 2E                 lda   #'.'
3091 DE7C 97 D4                 sta   [<in_ptr],y
3092 DE7E A9 00                 lda   #$00                     ;get back error code
3093 DE80 EB                    xba   
3094 DE81 68                    pla   
3095 DE82
3096 DE82 C2 20        error_tail rep   #m16                   ;return to 16-bit accumulator mode
3097 DE84 38                    sec                            ;indicate error
3098 DE85 60                    rts   
3099 DE86
3100 DE86 A9 40        return   lda   #$40                     ;set path_flag to indicate path has
3101 DE88 AE AE B9              ldx   |xlate_count             ;...been set up
3102 DE8B D0 04                 bne   second
3103 DE8D 85 43        first    sta   <path_flag+1
3104 DE8F 80 02                 bra   ar_2
3105 DE91 85 42        second   sta   <path_flag
3106 DE93              ar_2      
3107 DE93
3108 DE93 C2 20                 rep   #m16                     ;normal return, enter 16-bit mode
3109 DE95 18                    clc   
3110 DE96 60                    rts   
3111 DE97
3112 DE97              ;-------------------------------------------------------------------------------
3113 DE97              ; Case 4:  Partial pathname.  The input starts with an asterisk, designating the
3114 DE97              ;          system prefix.
3115 DE97              ;-------------------------------------------------------------------------------
3116 DE97 A9 20        init_star lda   #32                     ;prefix number for * prefix
3117 DE99 E6 D8                 inc   <in_curr                 ;make in_curr point just after the *
3118 DE9B 80 50                 bra   continue_pref            ;handle the rest just like a numeric
3119 DE9D                                                      ;prefix
3120 DE9D              ;-------------------------------------------------------------------------------
3121 DE9D              ; Case 5:  Partial pathname.  The input starts with an '@', designating the
3122 DE9D              ;          appleshare prefix.
3123 DE9D              ;-------------------------------------------------------------------------------
3124 DE9D A9 21        init_at  lda   #33                      ;prefix number for @ prefix
3125 DE9F E6 D8                 inc   <in_curr                 ;make in_curr point just after the @
3126 DEA1 80 4A                 bra   continue_pref            ;handle the rest just like a numeric
3127 DEA3                                                      ;prefix
3128 DEA3              ;-------------------------------------------------------------------------------
3129 DEA3              ; Overflow code for case 6 just below.
3130 DEA3              ;-------------------------------------------------------------------------------
3131 DEA3 A9 3A        no_trailing_sep lda   #sep              ;assume default separator
3132 DEA5 8D D4 B9              sta   |save_control            ;save as the controlling separator
3133 DEA8 80 62                 bra   past_sep
3134 DEAA
3135 DEAA              ;-------------------------------------------------------------------------------
3136 DEAA              ; Case 6:  Partial pathname.  The input starts with a digit, designating a
3137 DEAA              ;          specific prefix.
3138 DEAA              ;-------------------------------------------------------------------------------
3139 DEAA              init_digit  
3140 DEAA D4 D8                 pei   <in_curr                 ;save current value
3141 DEAC 20 0D E2              jsr   str_to_int               ;convert initial numeric prefix
3142 DEAF                                                      ;  designator to binary integer
3143 DEAF FA                    plx                            ;retrieve previous in_curr
3144 DEB0 B0 1E                 bcs   @num_too_big             ;number got too big
3145 DEB2 C4 DA                 cpy   <in_end                  ;did str_to_int reach the end of the string?
3146 DEB4 D0 06                 bne   @check_for_sep           ;no, must check for separator
3147 DEB6 C9 20                 cmp   #32                      ;number too big to be a prefix?
3148 DEB8 90 33                 bcc   continue_pref            ;no, must be a real prefix designator
3149 DEBA                                                      ;  with no trailing separator
3150 DEBA 80 0F                 bra   @partial_path            ;if number is too large with no trailing
3151 DEBC                                                      ;  separator, it must be a partial pathname
3152 DEBC              @check_for_sep  
3153 DEBC 48                    pha                            ;save prefix number
3154 DEBD B7 D4                 lda   [<in_ptr],y              ;get character following number
3155 DEBF 2D D5 B9              and   |char_mask
3156 DEC2 C9 3A                 cmp   #':'                     ;separator?
3157 DEC4 F0 26                 beq   @good_prefix             ;yes, real prefix designator
3158 DEC6 C9 2F                 cmp   #'/'
3159 DEC8 F0 22                 beq   @good_prefix
3160 DECA 68                    pla                            ;clean up stack
3161 DECB              @partial_path  
3162 DECB 86 D8                 stx   <in_curr                 ;restore current character pointer
3163 DECD 4C 51 E0              jmp   init_other               ;then treat as normal partial pathname
3164 DED0
3165 DED0              ; if we get here, it means that str_to_int exited because the converted number got
3166 DED0              ; bigger than 32.  In this case, we have to scan the remainder of the string until a
3167 DED0              ; non-digit character is seen.  If the character following the last digit is a separator,
3168 DED0              ; we have an honest-to-goodness pathname syntax error.  If its not a separator, or if
3169 DED0              ; we run out of string characters, we treat it as a partial pathname.
3170 DED0              @num_too_big  
3171 DED0 B7 D4                 lda   [<in_ptr],y              ;get character
3172 DED2 2D D5 B9              and   |char_mask
3173 DED5 C9 3A                 cmp   #':'                     ;separator?
3174 DED7 F0 95                 beq   syntax_err               ;yes, real error
3175 DED9 C9 2F                 cmp   #'/'
3176 DEDB F0 91                 beq   syntax_err
3177 DEDD C9 30                 cmp   #'0'                     ;digit?
3178 DEDF 90 EA                 bcc   @partial_path            ;no, treat as partial pathname
3179 DEE1 C9 3A                 cmp   #'9'+1
3180 DEE3 B0 E6                 bcs   @partial_path
3181 DEE5 C8                    iny                            ;bump to next character
3182 DEE6 C4 DA                 cpy   <in_end                  ;at end yet?
3183 DEE8 90 E6                 blt   @num_too_big             ;no, skip until non-digit found
3184 DEEA 80 DF                 bra   @partial_path
3185 DEEC
3186 DEEC 68           @good_prefix pla                        ;retrieve prefix number
3187 DEED 8D B6 B9     continue_pref sta   |prefix_number      ;save prefix number
3188 DEF0 9C B7 B9              stz   |prefix_number+1
3189 DEF3 A4 D8                 ldy   <in_curr                 ;are we now past end of string
3190 DEF5 C4 DA                 cpy   <in_end
3191 DEF7 B0 AA                 bge   no_trailing_sep          ;there was no separator after pfx desig
3192 DEF9 B7 D4                 lda   [<in_ptr],y              ;get the current character
3193 DEFB 2D D5 B9              and   |char_mask
3194 DEFE C9 3A                 cmp   #sep
3195 DF00 F0 04                 beq   at_sep
3196 DF02 C9 2F                 cmp   #'/'                     ;must be a separator
3197 DF04 D0 51                 bne   to_syntax_err
3198 DF06
3199 DF06 8D D4 B9     at_sep   sta   |save_control            ;save the separator from partial path
3200 DF09 C8                    iny                            ;make Y and in_curr point after sep
3201 DF0A 84 D8                 sty   <in_curr
3202 DF0C
3203 DF0C C2 20        past_sep rep   #m16                     ;compute length of partial pathname
3204 DF0E                       longa on
3205 DF0E 38                    sec                            ;...string remaining after the initial
3206 DF0F A5 DA                 lda   <in_end                  ;...separator
3207 DF11 E5 D8                 sbc   <in_curr
3208 DF13 8D D2 B9              sta   |partial_len
3209 DF16              *
3210 DF16              * At this point, if partial_len is zero, we have only a prefix # and if it is 10,11,
3211 DF16              * or 12, let's save it in std_prefix_num...
3212 DF16              *
3213 DF16 D0 10                 bne   contin                   ;Not zero.
3214 DF18 AD B6 B9              lda   |prefix_number           ;Get prefix.
3215 DF1B C9 0A 00              cmp   #10                      ;Is standard?
3216 DF1E 90 08                 bcc   contin                   ;Nope.
3217 DF20 C9 0D 00              cmp   #13
3218 DF23 B0 03                 bcs   contin                   ;Nope.
3219 DF25 8D 21 B9              sta   std_prefix_num           ;Yes, so save it.
3220 DF28
3221 DF28 D4 D6        contin   pei   <in_ptr+2                ;save pointer to partial pathname string
3222 DF2A D4 D4                 pei   <in_ptr
3223 DF2C D4 D8                 pei   <in_curr                 ;save offset of current and end bytes
3224 DF2E D4 DA                 pei   <in_end
3225 DF30
3226 DF30 AD B6 B9              lda   |prefix_number           ;retrieve the prefix number saved above
3227 DF33 29 FF 00              and   #$00FF                   ;we are accessing a byte value in 16-bit
3228 DF36                                                      ;mode, so zero out high byte
3229 DF36 20 DD E3              jsr   get_pfx                  ;get pointer to the prefix string
3230 DF39 84 D6                 sty   <in_ptr+2                ;save high word of pointer
3231 DF3B 10 1D                 bpl   contin_1                 ;if positive, prefix is non-null
3232 DF3D              ;
3233 DF3D              ; At this point we know that the specified prefix is the null string.  This is
3234 DF3D              ; a syntax error if the system call was anything but a set_prefix.  If the call
3235 DF3D              ; was a set_prefix and the remainder of the partial pathname is null, there is
3236 DF3D              ; no syntax error.
3237 DF3D              ;
3238 DF3D AD B0 B9              lda   |xlate_type              ;is it a set_prefix?
3239 DF40 F0 12                 beq   contin_0                 ;no, indicate a syntax error
3240 DF42
3241 DF42 A3 01                 lda   1,s                      ;is rest partial pathname null?
3242 DF44 C3 03                 cmp   3,s
3243 DF46 D0 0C                 bne   contin_0                 ;if not, syntax error
3244 DF48
3245 DF48 A0 03 00              ldy   #$0003                   ;if so, return null string to caller
3246 DF4B 20 30 E1              jsr   alloc_string
3247 DF4E 20 73 E0              jsr   pop_stack
3248 DF51 4C 86 DE              jmp   return
3249 DF54
3250 DF54 20 73 E0     contin_0 jsr   pop_stack                ;if prefix is null, pop stack and return
3251 DF57 4C 6E DE     to_syntax_err jmp   syntax_err          ;...syntax error
3252 DF5A
3253 DF5A 86 D4        contin_1 stx   <in_ptr                  ;save low word of pointer
3254 DF5C
3255 DF5C A9 02 00              lda   #$0002                   ;initialize in_curr for prefix string
3256 DF5F 85 D8                 sta   <in_curr
3257 DF61 A7 D4                 lda   [<in_ptr]                ;initialize in_end for prefix string
3258 DF63 1A                    inc   a
3259 DF64 1A                    inc   a
3260 DF65 85 DA                 sta   <in_end
3261 DF67
3262 DF67 1A                    inc   a                        ;compute size of output string =
3263 DF68 38                    sec                            ;...length(prefix) + length(partial
3264 DF69 6D D2 B9              adc   |partial_len             ;...pathname) + 4
3265 DF6C A8                    tay   
3266 DF6D
3267 DF6D E2 20                 sep   #m8                      ;return to 8-bit m mode
3268 DF6F                       longa off
3269 DF6F
3270 DF6F 20 30 E1              jsr   alloc_string             ;allocate space for the output string
3271 DF72 90 06                 bcc   contin_2
3272 DF74 20 73 E0              jsr   pop_stack
3273 DF77 4C 67 DE              jmp   memory_err
3274 DF7A
3275 DF7A A4 D8        contin_2 ldy   <in_curr                 ;set up input and output offsets for
3276 DF7C A6 E0                 ldx   <out_curr                ;...xlate_path
3277 DF7E A9 3A                 lda   #sep                     ;set up separator character for xlate
3278 DF80 85 E4                 sta   <control
3279 DF82 20 E4 E0              jsr   copy_xlate               ;copy prefix to beginning of outpur str
3280 DF85 B0 CD                 bcs   contin_0
3281 DF87
3282 DF87 A9 3A        contin_3 lda   #sep                     ;add separator just after prefix
3283 DF89 9B                    txy                            ;current offset in output string to Y
3284 DF8A 97 DC                 sta   [<out_ptr],y             ;store the separator in output string
3285 DF8C C8                    iny                            ;update out_curr to point after sep
3286 DF8D 84 E0                 sty   <out_curr
3287 DF8F
3288 DF8F C2 20                 rep   #m16                     ;16 bit mode
3289 DF91                       longa on
3290 DF91 A7 DC                 lda   [<out_ptr]               ;gotta inc the length to compensate
3291 DF93 1A                    inc   a                        ; for the slash we just added.
3292 DF94 87 DC                 sta   [<out_ptr]
3293 DF96                       longa off
3294 DF96 E2 20                 sep   #m8                      ;back to 8 bit mode
3295 DF98
3296 DF98 7A                    ply                            ;restore state of partial pathname
3297 DF99 84 DA                 sty   <in_end
3298 DF9B 7A                    ply   
3299 DF9C 84 D8                 sty   <in_curr
3300 DF9E 7A                    ply   
3301 DF9F 84 D4                 sty   <in_ptr
3302 DFA1 7A                    ply   
3303 DFA2 84 D6                 sty   <in_ptr+2
3304 DFA4
3305 DFA4 AC D2 B9              ldy   |partial_len             ;are there any characters remaining in
3306 DFA7 F0 17                 beq   end_partial              ;...the partial pathname?
3307 DFA9
3308 DFA9 AD D4 B9              lda   |save_control            ;yes, prepare to copy partial to output
3309 DFAC 85 E4                 sta   <control                 ;set up separator
3310 DFAE A4 D8                 ldy   <in_curr                 ;set up current offsets in input and
3311 DFB0 A6 E0                 ldx   <out_curr                ;...output
3312 DFB2 20 E4 E0              jsr   copy_xlate
3313 DFB5 90 09                 bcc   end_partial
3314 DFB7 4C 6E DE     relay_syn_err jmp   syntax_err
3315 DFBA
3316 DFBA 4C 49 E0     relay_calc_ret jmp   calc_and_ret
3317 DFBD 4C 58 DE     relay_dev_only jmp   devname_only
3318 DFC0              ;
3319 DFC0              ; At this point, we need to check whether or not the pathname produced thus far
3320 DFC0              ; needs additional translation.  If the pathname begins with a device name and
3321 DFC0              ; we are performing a normal call, we need to translate the device name into a
3322 DFC0              ; device number and strip it off the beginning of the pathname.  Otherwise (for
3323 DFC0              ; set_prefix and a few other calls), we just leave the pathname as is.
3324 DFC0              ;
3325 DFC0 A0 02 00     end_partial ldy   #0002                 ;is first char in pathname a period?
3326 DFC3 B7 DC                 lda   [<out_ptr],y
3327 DFC5 C9 2E                 cmp   #'.'
3328 DFC7 D0 F1                 bne   relay_calc_ret           ;no, just return pathname as is
3329 DFC9              ;
3330 DFC9              ; Here, we have a pathname that starts with a period, so check further.
3331 DFC9              ;
3332 DFC9 AD B0 B9              lda   |xlate_type              ;otherwise, check translation type
3333 DFCC F0 03                 beq   skipit
3334 DFCE 4C 49 E0              jmp   calc_and_ret             ;it's a set_prefix (or related), so
3335 DFD1              skipit                                  ; ;don't need to get rid of device name
3336 DFD1              ;
3337 DFD1              ; Here, the pathname starts with a device name, and we are doing a normal
3338 DFD1              ; translation, so we need to convert device name to number and strip off device
3339 DFD1              ; name.
3340 DFD1              ;
3341 DFD1 84 D8                 sty   <in_curr                 ;offset of first characer (2)
3342 DFD3 84 E0                 sty   <out_curr
3343 DFD5 A4 E2                 ldy   <out_end                 ;give in_end same value as out_end
3344 DFD7 84 DA                 sty   <in_end
3345 DFD9 A4 DC                 ldy   <out_ptr                 ;give in_ptr same value as out_ptr
3346 DFDB 84 D4                 sty   <in_ptr
3347 DFDD A4 DE                 ldy   <out_ptr+2
3348 DFDF 84 D6                 sty   <in_ptr+2
3349 DFE1
3350 DFE1 20 E7 E1              jsr   len_to_delim             ;determine number of chars in dev name
3351 DFE4 B0 D1                 bcs   relay_syn_err
3352 DFE6 E0 00 00     contin_4 cpx   #0000                    ;any characters in device name?
3353 DFE9 F0 CC                 beq   relay_syn_err            ;nope!
3354 DFEB E0 21 00     contin_5 cpx   #$0021                   ;more than 32 chars in device name?
3355 DFEE B0 C7        to_relay_err bge   relay_syn_err        ;yes
3356 DFF0              ;
3357 DFF0              ; At this point, there is a reasonable candidate for a device name.
3358 DFF0              ;
3359 DFF0 8C B2 B9     contin_6 sty   |cont_offset             ;store offset of character just after
3360 DFF3                                                      ;device name
3361 DFF3 A4 D8                 ldy   <in_curr                 ;temporarily replace period in device
3362 DFF5 8A                    txa                            ;...name with length of device name
3363 DFF6 97 D4                 sta   [<in_ptr],y
3364 DFF8
3365 DFF8 C2 20                 rep   #m16                     ;temporarily use 16-bit m mode
3366 DFFA                       longa on
3367 DFFA
3368 DFFA 18                    clc                            ;construct a pointer to the beginning
3369 DFFB 98                    tya                            ;...(length byte) of the device name
3370 DFFC 65 D4                 adc   <in_ptr
3371 DFFE AA                    tax   
3372 DFFF A9 00 00              lda   #$0000
3373 E002 65 D6                 adc   <in_ptr+2
3374 E004 A8                    tay   
3375 E005
3376 E005 22 71 FB E0           jsl   >get_dnum                ;get device number corresponding to name
3377 E009 90 03                 bcc   contin_7                 ;go on if no error
3378 E00B 4C 75 DE              jmp   devnum_err               ;otherwise, device number error
3379 E00E
3380 E00E AE AE B9     contin_7 ldx   |xlate_count             ;save device number in proper direct
3381 E011 D0 04                 bne   contin_8                 ;...page device number location
3382 E013 85 36                 sta   <dev1_num
3383 E015 80 02                 bra   contin_9
3384 E017 85 38        contin_8 sta   <dev2_num
3385 E019              contin_9  
3386 E019
3387 E019 E2 20                 sep   #m8                      ;go back to 8-bit m mode
3388 E01B                       longa off
3389 E01B              ;
3390 E01B              ; No need to restore the period in the device name because we are going to
3391 E01B              ; write over it.  cont_offset points one past last character in device name,
3392 E01B              ; which may be a separator or end of string.
3393 E01B              ;
3394 E01B AC B2 B9              ldy   |cont_offset             ;determine where rest of pathname starts
3395 E01E C4 DA                 cpy   <in_end                  ;any chars left in pathname?
3396 E020 B0 9B                 bge   relay_dev_only           ;no, handle device name only case
3397 E022 C8                    iny                            ;must have been a separator, incr past
3398 E023 C4 DA                 cpy   <in_end                  ;now, are there any more characters?
3399 E025 B0 96                 bge   relay_dev_only           ;no, it's just a dev name and sep
3400 E027 84 D8                 sty   <in_curr                 ;yes, save offset of first character
3401 E029              ;
3402 E029              ; At this point, there is some part of the pathname after the device name and
3403 E029              ; separator.  We need to move this substring to the beginning of the string.
3404 E029              ; We move the substring beginning at offset in_curr and ending one byte before
3405 E029              ; offset in_end to locations beginning at offset out_curr (which starts with
3406 E029              ; value 2).
3407 E029 E6 DA                 inc   <in_end                  ;make in_end point one after final NUL
3408 E02B B7 D4        begin_loop lda   [<in_ptr],y            ;get character
3409 E02D 2D D5 B9              and   |char_mask
3410 E030 C8                    iny                            ;increment source offset
3411 E031 BB                    tyx                            ;...and save it in X
3412 E032 A4 E0                 ldy   <out_curr                ;get destination offset
3413 E034 97 DC                 sta   [<out_ptr],y             ;store character
3414 E036 C8                    iny                            ;increment destination offset
3415 E037 84 E0                 sty   <out_curr                ;...and save it
3416 E039 9B                    txy                            ;get back source offset
3417 E03A C4 DA                 cpy   <in_end                  ;are we past end of string?
3418 E03C 90 ED                 blt   begin_loop               ;no, continue the loop
3419 E03E              ;
3420 E03E              ; At this point, our_curr gives offset one past end of new string.  To get
3421 E03E              ; length of new string, need to subtract 3 to account for length word and NUL
3422 E03E              ; terminator.
3423 E03E              ;
3424 E03E C2 20                 rep   #m16                     ;16-bit m mode
3425 E040                       longa on
3426 E040 A5 E0                 lda   <out_curr
3427 E042 3A                    dec   a
3428 E043 3A                    dec   a
3429 E044 3A                    dec   a
3430 E045 87 DC                 sta   [<out_ptr]               ;store the length word
3431 E047 E2 20                 sep   #m8                      ;back to 8-bit m mode
3432 E049                       longa off
3433 E049
3434 E049 20 7E E1     calc_and_ret jsr   calc_span            ;calculate span and do gross syntax chk
3435 E04C B0 A0                 bcs   to_relay_err
3436 E04E 4C 86 DE     just_return jmp   return
3437 E051
3438 E051              ;-------------------------------------------------------------------------------
3439 E051              ; Case 7:  Partial pathname.  The input starts with a legal character other than
3440 E051              ;          a separator, period, asterisk, @, or digit.  This is equivalent to
3441 E051              ;          using prefix designator specified by default_prefix.  If default
3442 E051              ;          prefix is 0 and prefix 0 is nil, use prefix 8.
3443 E051              ;-------------------------------------------------------------------------------
3444 E051 AD B8 B9     init_other lda   |default_prefix        ;default prefix number (only low byte is
3445 E054                                                      ;meaningful even though it was initially
3446 E054                                                      ;stored as a word)
3447 E054 D0 0E                 bne   set_pfx_num              ;Non-zero so use it.
3448 E056
3449 E056 C2 20                 rep   #m16                     ;16-bit m mode
3450 E058 20 DD E3              jsr   get_pfx                  ;Check if prefix is null.
3451 E05B E2 20                 sep   #m8                      ;back to 8-bit m mode
3452 E05D
3453 E05D A9 00                 lda   #00                      ;Set default to 0 in case non-null.
3454 E05F BB                    tyx                            ;Null prefix?
3455 E060 10 02                 bpl   set_pfx_num              ;Nope, so use 0 as default.
3456 E062 A9 08                 lda   #08                      ;Yes, so use 8 as default.
3457 E064
3458 E064 8D B6 B9     set_pfx_num sta   |prefix_number
3459 E067 9C B7 B9              stz   |prefix_number+1
3460 E06A 20 E7 E1              jsr   len_to_delim             ;determine the controlling separator
3461 E06D 8D D4 B9              sta   |save_control            ;...and remember it for later use
3462 E070 4C 0C DF              jmp   past_sep                 ;continue in normal prefix code
3463 E073
3464 E073                       longa on
3465 E073
3466 E073              ;===============================================================================
3467 E073              ; Helper routine to pop 8-bytes off the stack.
3468 E073              ;===============================================================================
3469 E073
3470 E073 C2 20        pop_stack rep   #m16                    ;go to 16-bit m mode
3471 E075 A3 01                 lda   1,s                      ;get return address
3472 E077 83 09                 sta   9,s                      ;move it up 8 bytes in the stack
3473 E079 3B                    tsc                            ;adjust S by adding 8
3474 E07A 18                    clc   
3475 E07B 69 08 00              adc   #$0008
3476 E07E 1B                    tcs   
3477 E07F E2 20                 sep   #m8                      ;back to 8 bit m mode
3478 E081 60                    rts   
3479 E082
3480 E082                       end_proc 
3481 E082
3482 E082              call_xlate_path proc                    ;used to access xlate_path from
3483 E082 20 21 DD              jsr   xlate_path               ;outside bank 0
3484 E085 6B                    rtl   
3485 E086                       end_proc 
3486 E086
3487 E086              call_xlate3 Proc 
3488 E086 20 3D DD              jsr   xlate_path3              ;used to access xlate_path3 from
3489 E089 6B                    rtl                            ;outside bank 0
3490 E08A                       end_proc 
3491 E08A
3492 E08A                       eject 
3493 E08A              ;===============================================================================
3494 E08A              ; classify_char
3495 E08A              ;
3496 E08A              ; Classifies the character in the accumulator.  Returns a classification number
3497 E08A              ; that can be used as an index into a jump table.
3498 E08A              ;
3499 E08A              ; Enter:        jsr     classify_char
3500 E08A              ;
3501 E08A              ; Assumes:      get_char is called first to load A and condition c
3502 E08A              ;
3503 E08A              ; Input:        A = character to be classified
3504 E08A              ;               P = nvmxdizc
3505 E08A              ;                   ..100..| (8-bit accumulator)
3506 E08A              ;                          0=character came from within a string
3507 E08A              ;                          1=character is end of string indicator
3508 E08A              ;
3509 E08A              ; Output:       A = character to be classified
3510 E08A              ;               X = classification number for the character
3511 E08A              ;                   0000 = no more characters in input
3512 E08A              ;                   0002 = illegal character
3513 E08A              ;                   0004 = separator (slash or colon)
3514 E08A              ;                   0006 = period
3515 E08A              ;                   0008 = asterisk
3516 E08A              ;                   000A = @
3517 E08A              ;                   000C = digit
3518 E08A              ;                   000E = other legal character
3519 E08A              ;               Y = trashed
3520 E08A              ;               P = nvmxdizc
3521 E08A              ;                   ..100...
3522 E08A              ;
3523 E08A              ;===============================================================================
3524 E08A
3525 E08A              classify_char proc 
3526 E08A
3527 E08A                       longa off
3528 E08A
3529 E08A 90 04                 bcc   not_end                  ;carry clear if not end of input
3530 E08C
3531 E08C A2 00 00     is_end   ldx   #$0000                   ;code for end of input
3532 E08F 60                    rts   
3533 E090
3534 E090 C9 30        not_end  cmp   #'0'                     ;do a somewhat binary search of
3535 E092 B0 18                 bge   top_half                 ;...remaining possibilities
3536 E094
3537 E094 C9 2A        bottom_half cmp   #'*'                  ;codes < $30 ('*', '.', and '/')
3538 E096 D0 04                 bne   not_star
3539 E098 A2 08 00              ldx   #$0008                   ;code for asterisk
3540 E09B 60                    rts   
3541 E09C
3542 E09C C9 2E        not_star cmp   #'.'
3543 E09E D0 04                 bne   not_period
3544 E0A0 A2 06 00              ldx   #$0006                   ;code for period
3545 E0A3 60                    rts   
3546 E0A4
3547 E0A4 C9 2F        not_period cmp   #'/'
3548 E0A6 D0 1A                 bne   other_legal
3549 E0A8 A2 04 00              ldx   #$0004                   ;code for slash
3550 E0AB 60                    rts   
3551 E0AC
3552 E0AC C9 3A        top_half cmp   #'9'+1                   ;codes >= $30 (digits and ':')
3553 E0AE B0 04                 bge   not_digit
3554 E0B0 A2 0C 00              ldx   #$000C                   ;code for digit
3555 E0B3 60                    rts   
3556 E0B4
3557 E0B4              not_digit                               ;cmp	#':'	 ':' _is_ '9'+1!
3558 E0B4 D0 04                 bne   not_colon
3559 E0B6 A2 04 00              ldx   #$0004                   ;code for separator
3560 E0B9 60                    rts   
3561 E0BA
3562 E0BA C9 40        not_colon cmp   #'@'
3563 E0BC D0 04                 bne   other_legal
3564 E0BE A2 0A 00              ldx   #$000A                   ;code for '@'
3565 E0C1 60                    rts   
3566 E0C2
3567 E0C2 A2 0E 00     other_legal ldx   #$000E                ;code for other legal character
3568 E0C5 60                    rts   
3569 E0C6
3570 E0C6                       longa on
3571 E0C6
3572 E0C6                       end_proc 
3573 E0C6                       eject 
3574 E0C6              ;===============================================================================
3575 E0C6              ; get_char
3576 E0C6              ;
3577 E0C6              ; Gets the next character in the input string specified by in_ptr, in_curr, and
3578 E0C6              ; in_end, and increments in_current.  If there are no more characters in the
3579 E0C6              ; input string, returns ASCII NUL ($00) and does not increment in_curr.
3580 E0C6              ;
3581 E0C6              ; Enter:        jsr     get_char
3582 E0C6              ;
3583 E0C6              ; Input:        P = nvmxdizc
3584 E0C6              ;                   ..100... (8-bit accumulator)
3585 E0C6              ;               in_ptr = pointer to input string
3586 E0C6              ;               in_curr = offset of current character position in input string
3587 E0C6              ;               in_end = offset one greater than last character in input string
3588 E0C6              ;
3589 E0C6              ; Output:       A = if in_curr < in_end, the character at offset in_curr;
3590 E0C6              ;                   otherwise ASCII NUL
3591 E0C6              ;               X = trashed
3592 E0C6              ;               Y = trashed
3593 E0C6              ;               P = nvmxdizc
3594 E0C6              ;                   ..100..|
3595 E0C6              ;                          0=character returned, 1=attempt to read beyond string
3596 E0C6              ;               in_curr = in_curr + 1 if not past end of string; otherwise,
3597 E0C6              ;                         in_curr is unchanged
3598 E0C6              ;===============================================================================
3599 E0C6
3600 E0C6              get_char proc 
3601 E0C6                       entry return_null
3602 E0C6
3603 E0C6                       longa off
3604 E0C6
3605 E0C6 A4 D8                 ldy   <in_curr                 ;offset of current input character
3606 E0C8 C4 DA                 cpy   <in_end                  ;are we past end of string?
3607 E0CA B0 09                 bge   return_null              ;yes, branch ahead
3608 E0CC
3609 E0CC B7 D4        return_char lda   [<in_ptr],y           ;no, get the input character
3610 E0CE 2D D5 B9              and   |char_mask
3611 E0D1 C8                    iny                            ;increment input character offset
3612 E0D2 84 D8                 sty   <in_curr
3613 E0D4
3614 E0D4 60                    rts                            ;carry is still clear from cpy
3615 E0D5
3616 E0D5 A9 00        return_null lda   #$00                  ;return ASCII NUL
3617 E0D7 60                    rts                            ;carry is still set from cpy instruction
3618 E0D8
3619 E0D8                       longa on
3620 E0D8
3621 E0D8                       eject 
3622 E0D8              ;===============================================================================
3623 E0D8              ; look_at_char
3624 E0D8              ;
3625 E0D8              ; Gets the next character in the input string specified by in_ptr, in_curr, and
3626 E0D8              ; in_end, but does not increment in_curr.  If there are no more characters in
3627 E0D8              ; the input string, returns ASCII NUL ($00) and does not increment in_curr.
3628 E0D8              ;
3629 E0D8              ; Enter:        jsr     look_at_char
3630 E0D8              ;
3631 E0D8              ; Input:        P = nvmxdizc
3632 E0D8              ;                   ..100... (8-bit accumulator)
3633 E0D8              ;               in_ptr = pointer to input string
3634 E0D8              ;               in_curr = offset of current character position in input string
3635 E0D8              ;               in_end = offset one greater than last character in input string
3636 E0D8              ;
3637 E0D8              ; Output:       A = if in_curr < in_end, the character at offset in_curr;
3638 E0D8              ;                   otherwise ASCII NUL
3639 E0D8              ;               X = trashed
3640 E0D8              ;               Y = trashed
3641 E0D8              ;               P = nvmxdizc
3642 E0D8              ;                   ..100..|
3643 E0D8              ;                          0=character returned, 1=attempt to read beyond string
3644 E0D8              ;               in_curr = unchanged
3645 E0D8              ;===============================================================================
3646 E0D8
3647 E0D8                       entry look_at_char
3648 E0D8              look_at_char  
3649 E0D8
3650 E0D8                       longa off
3651 E0D8
3652 E0D8 A4 D8                 ldy   <in_curr                 ;offset of current input character
3653 E0DA C4 DA                 cpy   <in_end                  ;are we past end of string?
3654 E0DC B0 F7                 bge   return_null              ;yes, branch out.
3655 E0DE
3656 E0DE B7 D4        @return_char lda   [<in_ptr],y          ;no, get the input character
3657 E0E0 2D D5 B9              and   |char_mask
3658 E0E3
3659 E0E3 60                    rts                            ;carry is still clear from cpy
3660 E0E4
3661 E0E4                       longa on
3662 E0E4
3663 E0E4                       end_proc 
3664 E0E4                       eject 
3665 E0E4              ;===============================================================================
3666 E0E4              ; copy_xlate
3667 E0E4              ;
3668 E0E4              ; Copy an input string onto the end of an existing output string while
3669 E0E4              ; performing character-by-character translation.
3670 E0E4              ;
3671 E0E4              ; Created:      6/3/87
3672 E0E4              ; Modified:
3673 E0E4              ; Author:       JJ
3674 E0E4              ;
3675 E0E4              ; Enter:        jsr     copy_xlate
3676 E0E4              ;
3677 E0E4              ; Input:        in_ptr  4-byte pointer to input string
3678 E0E4              ;               Y       2-byte offset to current position in input string
3679 E0E4              ;               in_end  2-byte offset of position 1 past end of input string
3680 E0E4              ;               out_ptr 4-byte pointer to output string
3681 E0E4              ;               X       2-byte offset to current position in output string
3682 E0E4              ;               out_end 2-byte offset of position 1 past end of output space
3683 E0E4              ;               control bit 15=0 do not upper case letters
3684 E0E4              ;                             =1 force letters to upper case
3685 E0E4              ;                       bits 7-0 separator character (value must be ASCII
3686 E0E4              ;                                slash or colon)
3687 E0E4              ;               P = nvmxdizc
3688 E0E4              ;                   ..100... (8-bit accumulator)
3689 E0E4              ;
3690 E0E4              ; Output:       The portion of the input string from offset Y to in_end-1
3691 E0E4              ;               is copied into the output string beginning at offset X.
3692 E0E4              ;               The routine forces the high bit of each character to 0.  If the
3693 E0E4              ;               high bit of control is 1, the routine translates all lower case
3694 E0E4              ;               characters to upper case.  The low byte of control indicates
3695 E0E4              ;               the separator character.  All occurrences of the separator are
3696 E0E4              ;               translated to $80.  The routine also
3697 E0E4              ;               updates X, Y, and the length word of the output
3698 E0E4              ;               string.  A system error exists if this routine attempts to copy
3699 E0E4              ;               a character into the location at offset out_end.  This means
3700 E0E4              ;               there is not enough space left in the output to accommodate the
3701 E0E4              ;               input.
3702 E0E4              ;               A = if c=0, undefined; if c=1, error code
3703 E0E4              ;                 = 0040 - syntax error
3704 E0E4              ;               X = updated value of out_curr
3705 E0E4              ;               Y = updated value of in_curr
3706 E0E4              ;               P = nvmxdizc
3707 E0E4              ;                   ..100..|
3708 E0E4              ;                          0=no error, 1=error
3709 E0E4              ;
3710 E0E4              ; Notes:        in_ptr  ---> XXXXXXXXXXCCCCCCCCCCCCCCCCCCCCCCCC
3711 E0E4              ;                                      |                       |
3712 E0E4              ;               Y  --------------------+                       |
3713 E0E4              ;               in_end  ---------------------------------------+
3714 E0E4              ;
3715 E0E4              ;               out_ptr ---> LLCCCCCCCCCCCXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
3716 E0E4              ;                                         |                                    |
3717 E0E4              ;               X  -----------------------+                                    |
3718 E0E4              ;               out_end  ------------------------------------------------------+
3719 E0E4              ;
3720 E0E4              ;               Copy the C's from the input string into the output string
3721 E0E4              ;               beginning at offset X.  The first two bytes of the output
3722 E0E4              ;               string (LL) are the length word.  The input string may have a
3723 E0E4              ;               length byte, word, or nothing, since Y and in_end
3724 E0E4              ;               determine the number of characters to copy.
3725 E0E4              ;
3726 E0E4              ;               The output string may initially have length zero.  This does not
3727 E0E4              ;               mean, however, out_curr=out_end.
3728 E0E4              ;               The format of the input string is relatively unconstrained, as
3729 E0E4              ;               the routine simply copies the characters between offsets Y
3730 E0E4              ;               and in_end-1, inclusive, from in_ptr.  However, the output
3731 E0E4              ;               string has a specific format.  out_ptr points to a length word,
3732 E0E4              ;               which is followed by the string content.  Thus, the minimum
3733 E0E4              ;               value of Y is 2.  In order to complete the output string,
3734 E0E4              ;               another routine must terminate it with an ASCII NUL ($00).  The
3735 E0E4              ;               NUL will not be included in the string length.
3736 E0E4              ;===============================================================================
3737 E0E4
3738 E0E4              copy_xlate proc 
3739 E0E4
3740 E0E4                       longa off
3741 E0E4              ;
3742 E0E4              ; Is there another character to copy?
3743 E0E4              ;
3744 E0E4 C4 DA        next_char cpy   <in_end                 ;if current position equals or exceeds
3745 E0E6 B0 32                 bge   done                     ;...end position, we are done
3746 E0E8              ;
3747 E0E8              ; Is there space in the output string?
3748 E0E8              ;
3749 E0E8 E4 E2                 cpx   <out_end                 ;if current position equals or exceeds
3750 E0EA B0 39                 bge   no_space                 ;...end position, we are done
3751 E0EC              ;
3752 E0EC              ; Get character from input string and adjust in_curr
3753 E0EC              ;
3754 E0EC B7 D4                 lda   [<in_ptr],y              ;get input character
3755 E0EE 2D D5 B9              and   |char_mask
3756 E0F1 C8                    iny                            ;adjust in_curr to point to next char
3757 E0F2 84 D8                 sty   <in_curr                 ;...and save it temporarily
3758 E0F4              ;
3759 E0F4              ; If the character is a colon, it is valid only if the already-determined
3760 E0F4              ; separator is the colon.  Otherwise, it is a syntax error.
3761 E0F4              ;
3762 E0F4 C9 3A                 cmp   #sep                     ;are we looking at a colon?
3763 E0F6 D0 06                 bne   character_ok             ;no, branch ahead
3764 E0F8 C5 E4        is_sep   cmp   <control                 ;yes, is colon the separator?
3765 E0FA F0 16                 beq   store_character          ;yes, store it away
3766 E0FC 80 2B                 bra   syntax_error             ;no, it's a syntax error
3767 E0FE
3768 E0FE              ;
3769 E0FE              ; If high bit of control word is 1, shift lower case alphabetics to upper case.
3770 E0FE              ;
3771 E0FE 24 E5        character_ok bit   <control+1           ;upper case flag is in high order byte
3772 E100 10 0A                 bpl   no_shift
3773 E102 C9 61                 cmp   #$61
3774 E104 90 06                 blt   no_shift
3775 E106 C9 7B                 cmp   #$7B
3776 E108 B0 02                 bge   no_shift
3777 E10A 29 DF                 and   #$DF                     ;shift to upper case
3778 E10C              no_shift  
3779 E10C              ;
3780 E10C              ; If the character is the indicated separator (slash or colon only), force it to
3781 E10C              ; be the colon.
3782 E10C              ;
3783 E10C C5 E4                 cmp   <control
3784 E10E D0 02                 bne   not_separator
3785 E110 A9 3A                 lda   #sep
3786 E112              not_separator  
3787 E112              ;
3788 E112              ; Store the character into the output string and increment out_curr
3789 E112              ;
3790 E112 9B           store_character txy                     ;out_curr was saved in X
3791 E113 97 DC                 sta   [<out_ptr],y
3792 E115 E8                    inx                            ;adjust out_curr (still in X)
3793 E116
3794 E116 A4 D8                 ldy   <in_curr                 ;restore in_curr to Y
3795 E118
3796 E118 80 CA                 bra   next_char                ;go to beginning of loop
3797 E11A              ;
3798 E11A              ; All characters have been copied.  Now set length word of output.
3799 E11A              ;
3800 E11A C2 20        done     rep   #m16                     ;restore full 16-bit mode
3801 E11C                       longa on
3802 E11C
3803 E11C 8A                    txa                            ;X still contains out_curr, but length
3804 E11D 3A                    dec   a                        ;... is actually out_curr-2
3805 E11E 3A                    dec   a                        ;store value in length word at out_ptr
3806 E11F 87 DC                 sta   [<out_ptr]
3807 E121
3808 E121 E2 20                 sep   #m8                      ;restore 8-bit memory mode
3809 E123                       longa off
3810 E123
3811 E123 18                    clc                            ;normal return
3812 E124 60                    rts   
3813 E125
3814 E125 22 02 EF 00  no_space jsl   >s_sys_death             ;no space in output string--system err
3815 E129
3816 E129 A9 00        syntax_error lda   #$00                 ;load error code into A (high byte)
3817 E12B EB                    xba   
3818 E12C A9 40                 lda   #bad_path_syntax         ;(low byte)
3819 E12E
3820 E12E 38           error_tail sec                          ;indicate error
3821 E12F 60                    rts   
3822 E130
3823 E130                       longa on
3824 E130
3825 E130                       end_proc 
3826 E130                       eject 
3827 E130              ;===============================================================================
3828 E130              ; alloc_string
3829 E130              ;
3830 E130              ; Allocate space for a translated pathname and set up translation state
3831 E130              ; variables to place translated string into the allocated space.
3832 E130              ;
3833 E130              ; Enter:        jsr     alloc_string
3834 E130              ;
3835 E130              ; Input:        Y = amount of space to allocate
3836 E130              ;               xlate_count = 0:  first pathname in parameter block
3837 E130              ;                             1:  second pathname in parameter block
3838 E130              ;               P = nvmxdizc
3839 E130              ;                   ..100...
3840 E130              ;
3841 E130              ; Output:       out_ptr = pointer to the output string
3842 E130              ;               out_curr = offset of first byte of string portion of output str
3843 E130              ;               out_end = offset of byte one past end of string portion of
3844 E130              ;                         output; this byte is set to NUL ($00)
3845 E130              ;               length word at beginning of output string set to $0000
3846 E130              ;               v_ptr1 or v_ptr2 set to virtual pointer to the string
3847 E130              ;               path1_ptr or path2_ptr set to point to the string
3848 E130              ;               P = nvmxdizc
3849 E130              ;                   ..100...
3850 E130              ;                          |
3851 E130              ;                          0=string allocation succeeded
3852 E130              ;                          1=string allocation failed
3853 E130              ;===============================================================================
3854 E130
3855 E130              alloc_string proc 
3856 E130
3857 E130                       longa on
3858 E130
3859 E130 C2 20                 rep   #m16                     ;16-bit accumulator
3860 E132 98                    tya                            ;allocation size to A
3861 E133 48                    pha                            ;also save it on stack
3862 E134 22 E8 FC 00           jsl   >alloc_zero
3863 E138 B0 3F                 bcs   error
3864 E13A
3865 E13A AD AE B9              lda   |xlate_count             ;store virtual pointer in the right
3866 E13D D0 08                 bne   second                   ;...place based on whether this is the
3867 E13F 8E C6 B9     first    stx   |v_ptr1                  ;...first or second pathname in the
3868 E142 8C C8 B9              sty   |v_ptr1+2                ;...current parameter block
3869 E145 80 06                 bra   ar_1
3870 E147 8E CA B9     second   stx   |v_ptr2
3871 E14A 8C CC B9              sty   |v_ptr2+2
3872 E14D
3873 E14D 22 09 FE 00  ar_1     jsl   >deref2                  ;dereference the virtual pointer and
3874 E151 86 DC                 stx   <out_ptr                 ;...store it in out_ptr as well as the
3875 E153 84 DE                 sty   <out_ptr+2               ;...appropriate direct page pointer
3876 E155 AD AE B9              lda   |xlate_count
3877 E158 D0 06                 bne   second2
3878 E15A 86 3A        first2   stx   <path1_ptr
3879 E15C 84 3C                 sty   <path1_ptr+2
3880 E15E 80 04                 bra   ar_2
3881 E160 86 3E        second2  stx   <path2_ptr
3882 E162 84 40                 sty   <path2_ptr+2
3883 E164
3884 E164 A9 00 00     ar_2     lda   #$0000                   ;zero to output string length word
3885 E167 87 DC                 sta   [<out_ptr]
3886 E169
3887 E169 1A                    inc   a                        ;set out_curr to 2
3888 E16A 1A                    inc   a
3889 E16B 85 E0                 sta   <out_curr
3890 E16D
3891 E16D 7A                    ply                            ;get back allocation size
3892 E16E 88                    dey                            ;set out_end to offset of last byte
3893 E16F 84 E2                 sty   <out_end
3894 E171
3895 E171 E2 20                 sep   #m8                      ;and store NUL ($00) into the last byte
3896 E173                       longa off
3897 E173 A9 00                 lda   #$00
3898 E175 97 DC                 sta   [<out_ptr],y
3899 E177
3900 E177 18                    clc                            ;indicate no error
3901 E178 60                    rts   
3902 E179
3903 E179 7A           error    ply                            ;pop off pushed value of A
3904 E17A E2 20                 sep   #m8
3905 E17C 38                    sec                            ;indicate error
3906 E17D 60                    rts   
3907 E17E
3908 E17E                       longa on
3909 E17E
3910 E17E                       end_proc 
3911 E17E                       eject 
3912 E17E              ;===============================================================================
3913 E17E              ; calc_span
3914 E17E              ;
3915 E17E              ; Calculate the maximal span between separators or between the last separator
3916 E17E              ; and the end of string.  If the string ends with a separator, cut back the
3917 E17E              ; string length by 1 to eliminate the separator.  For example,
3918 E17E              ;
3919 E17E              ;     /a/bc/def/bc/a    span=3
3920 E17E              ;     /a/b/c/defgh      span=5
3921 E17E              ;
3922 E17E              ;     /a/b/ becomes /a/b
3923 E17E              ;
3924 E17E              ; Enter:        jsr     calc_span
3925 E17E              ;
3926 E17E              ; Input:        out_ptr = pointer to string whose span is to be calculated
3927 E17E              ;                         string is a standard internal string
3928 E17E              ;               xlate_count = 0:  first pathname in parameter block
3929 E17E              ;                             1:  second pathname in parameter block
3930 E17E              ;               fst_flags bit 12 = 0:  do not turn off high bits
3931 E17E              ;                                = 1:  turn off high bit of all characters
3932 E17E              ;               P = nvmxdizc
3933 E17E              ;                   ..100...
3934 E17E              ;
3935 E17E              ; Output:       A = if c=0, undefined; otherwise, error code
3936 E17E              ;                 = $0040 - bad path syntax
3937 E17E              ;               span1 = calculated span if this is the first pathname parm
3938 E17E              ;               span2 = calculated span if this is the second pathname parm
3939 E17E              ;               P = nvmxdizc
3940 E17E              ;                   ..100..|
3941 E17E              ;                          0=no error in pathname string
3942 E17E              ;                          1=syntax error in pathname
3943 E17E              ;===============================================================================
3944 E17E
3945 E17E              calc_span proc 
3946 E17E
3947 E17E                       longa off
3948 E17E              ;
3949 E17E              ; Initialize state machine.
3950 E17E              ;
3951 E17E A0 02 00              ldy   #$0002                   ;offset of first character in pathname
3952 E181 64 E6                 stz   <max_span                ;maximal span found so far is zero
3953 E183 64 E7                 stz   <max_span+1
3954 E185
3955 E185 B7 DC        start    lda   [<out_ptr],y             ;start state--get a chracter
3956 E187 C8                    iny   
3957 E188 C9 00                 cmp   #nul                     ;if nul, string length is 0, which is
3958 E18A F0 54                 beq   error_state              ;...an error
3959 E18C A2 01 00              ldx   #$0001                   ;assume non-separator character
3960 E18F C9 3A                 cmp   #sep                     ;if not a separator, leave span count
3961 E191 D0 0D                 bne   within_span              ;...at 1 and continue count
3962 E193 CA                    dex                            ;...else set it to 0
3963 E194 B7 DC        just_saw_sep lda   [<out_ptr],y         ;just saw separator state--get char
3964 E196 C8                    iny   
3965 E197 C9 3A                 cmp   #sep                     ;if character is a separator, error
3966 E199 F0 45                 beq   error_state
3967 E19B C9 00                 cmp   #nul                     ;if character is end of string, remove
3968 E19D F0 25                 beq   cut_back                 ;...separator just before end of string
3969 E19F E8                    inx                            ;otherwise, must increment current span
3970 E1A0
3971 E1A0 B7 DC        within_span lda   [<out_ptr],y          ;within a span--get character
3972 E1A2 C8                    iny   
3973 E1A3 C9 3A                 cmp   #sep                     ;is it a separator?
3974 E1A5 D0 0B                 bne   not_sep
3975 E1A7 E4 E6        is_sep   cpx   <max_span                ;current span > max span?
3976 E1A9 90 02                 blt   zero_curr_span1          ;no, back to just saw sep state
3977 E1AB 86 E6                 stx   <max_span                ;yes, save as new maximum
3978 E1AD A2 00 00     zero_curr_span1 ldx   #$0000
3979 E1B0 80 E2                 bra   just_saw_sep
3980 E1B2
3981 E1B2 C9 00        not_sep  cmp   #nul                     ;is it the end of string?
3982 E1B4 D0 0B                 bne   not_nul
3983 E1B6 E4 E6        is_nul   cpx   <max_span
3984 E1B8 90 02                 blt   zero_curr_span2
3985 E1BA 86 E6                 stx   <max_span
3986 E1BC A2 00 00     zero_curr_span2 ldx   #$0000
3987 E1BF 80 10                 bra   end_state
3988 E1C1
3989 E1C1 E8           not_nul  inx                            ;no, character contributes to span
3990 E1C2 80 DC                 bra   within_span              ;continue in same state
3991 E1C4
3992 E1C4 88           cut_back dey                            ;make Y point to separator just before
3993 E1C5 88                    dey                            ;...end of string
3994 E1C6 97 DC                 sta   [<out_ptr],y             ;store NUL at new end of string
3995 E1C8
3996 E1C8 C2 20                 rep   #m16                     ;16 bit m mode
3997 E1CA A7 DC                 lda   [<out_ptr]               ;decrement string length by 1
3998 E1CC 3A                    dec   a
3999 E1CD 87 DC                 sta   [<out_ptr]
4000 E1CF E2 20                 sep   #m8                      ;back to 8-bit m mode
4001 E1D1
4002 E1D1 A6 E6        end_state ldx   <max_span
4003 E1D3 AD AE B9              lda   |xlate_count             ;8-bit load is OK
4004 E1D6 D0 04                 bne   second_path
4005 E1D8 86 44        first_path stx   <span1
4006 E1DA 80 02                 bra   ar_1
4007 E1DC 86 46        second_path stx   <span2
4008 E1DE              ar_1      
4009 E1DE
4010 E1DE 18                    clc   
4011 E1DF 60                    rts   
4012 E1E0
4013 E1E0 A9 00        error_state lda   #$00
4014 E1E2 EB                    xba   
4015 E1E3 A9 40                 lda   #bad_path_syntax
4016 E1E5 38                    sec   
4017 E1E6 60                    rts   
4018 E1E7
4019 E1E7                       longa on
4020 E1E7
4021 E1E7                       end_proc 
4022 E1E7                       eject 
4023 E1E7              ;===============================================================================
4024 E1E7              ; len_to_delim
4025 E1E7              ;
4026 E1E7              ; Count the number of characters between the current character and the next
4027 E1E7              ; separator character or end of string.  The current character and the separator
4028 E1E7              ; or end of string are not included in the count.  Also return the separator
4029 E1E7              ; character.
4030 E1E7              ;
4031 E1E7              ; Enter:        jsr     len_to_delim
4032 E1E7              ;
4033 E1E7              ; Input:        in_ptr = pointer to the input string
4034 E1E7              ;               in_curr = offset of the current character in the input string
4035 E1E7              ;               in_end = offset of byte just past end of input string
4036 E1E7              ;               P = nvmxdizc
4037 E1E7              ;                   ..100...
4038 E1E7              ;
4039 E1E7              ; Output:       A = if c=0, the separator character ('/', or ':') or $00
4040 E1E7              ;                   if there is no separator
4041 E1E7              ;               X = if c=0, the number of characters between current character
4042 E1E7              ;                   and the separator or end of string; else, undefined
4043 E1E7              ;               Y = if c=0, the offset of the separator or just past the end of
4044 E1E7              ;                   string; else, undefined
4045 E1E7              ;               P = nvmxdizc
4046 E1E7              ;                   ..100..|
4047 E1E7              ;                          0=A, X, and Y contain valid values
4048 E1E7              ;                          1=count overflowed past 255
4049 E1E7              ;===============================================================================
4050 E1E7
4051 E1E7              len_to_delim proc 
4052 E1E7
4053 E1E7                       longa off
4054 E1E7
4055 E1E7 A2 00 00              ldx   #$0000                   ;initialize character count to 0
4056 E1EA A4 D8                 ldy   <in_curr                 ;offset of current character to Y
4057 E1EC C8                    iny                            ;offset of first character to look at
4058 E1ED
4059 E1ED A9 00        get_looped lda   #$00                   ;precondition A = 0
4060 E1EF C4 DA                 cpy   <in_end                  ;did we reach end of string?
4061 E1F1 B0 16                 bge   done                     ;yes, branch ahead
4062 E1F3
4063 E1F3 B7 D4                 lda   [<in_ptr],y              ;no, check for delimiters
4064 E1F5 2D D5 B9              and   |char_mask
4065 E1F8 C9 3A                 cmp   #sep
4066 E1FA F0 0D                 beq   done
4067 E1FC C9 2F                 cmp   #'/'
4068 E1FE F0 09                 beq   done
4069 E200
4070 E200 E8           not_delim inx                           ;increment count
4071 E201 E0 00 01              cpx   #256                     ;if count exceeded 255, overflow
4072 E204 F0 05                 beq   overflow
4073 E206 C8                    iny                            ;increment string offset
4074 E207 80 E4                 bra   get_looped
4075 E209
4076 E209 18           done     clc   
4077 E20A 60                    rts   
4078 E20B
4079 E20B 38           overflow sec   
4080 E20C 60                    rts   
4081 E20D
4082 E20D                       longa on
4083 E20D
4084 E20D                       end_proc 
4085 E20D                       eject 
4086 E20D              ;===============================================================================
4087 E20D              ; str_to_int
4088 E20D              ;
4089 E20D              ; Convert a numeric prefix designator string into a 2-byte integer.  Move the
4090 E20D              ; current character pointer to the byte following the last digit in the prefix
4091 E20D              ; designator.
4092 E20D              ;
4093 E20D              ; Enter:        jsr     str_to_int
4094 E20D              ;
4095 E20D              ; Input:        in_ptr = pointer to the input string
4096 E20D              ;               in_curr = offset of the current character in the input string
4097 E20D              ;               in_end = offset of byte just past end of input string
4098 E20D              ;               P = nvmxdizc
4099 E20D              ;                   ..100...
4100 E20D              ;
4101 E20D              ; Output:       A = if c=0, binary prefix number specified by the prefix
4102 E20D              ;                   designator; if c=1, error code
4103 E20D              ;               X = trashed
4104 E20D              ;               Y = trashed
4105 E20D              ;               in_curr = offset of character one past the last digit
4106 E20D              ;               P = nvmxdizc
4107 E20D              ;                   ..100..|
4108 E20D              ;                          0=no error, prefix number is in A
4109 E20D              ;                          1=error occurred during prefix designator translation
4110 E20D              ;===============================================================================
4111 E20D
4112 E20D              str_to_int proc 
4113 E20D
4114 E20D                       longa off
4115 E20D
4116 E20D A2 00 00              ldx   #$0000                   ;initialize prefix number accumulator
4117 E210 A4 D8                 ldy   <in_curr                 ;initialize Y to point to current char
4118 E212
4119 E212 B7 D4        loop     lda   [<in_ptr],y              ;get the current character
4120 E214 2D D5 B9              and   |char_mask
4121 E217 C9 30                 cmp   #'0'                     ;is it less than ASCII '0'?
4122 E219 90 1E                 blt   reached_end
4123 E21B C9 3A                 cmp   #'9'+1                   ;is it greater than ASCII '9'?
4124 E21D B0 1A                 bge   reached_end
4125 E21F
4126 E21F 38           is_digit sec   
4127 E220 E9 30                 sbc   #'0'                     ;convert ASCII digit to binary number
4128 E222 48                    pha                            ;save value on stack
4129 E223
4130 E223 E0 14 00              cpx   #20                      ;is accumulated value greater than 20?
4131 E226 B0 16                 bge   pfx_num_err              ;yes, prefix number way to big
4132 E228
4133 E228 8A                    txa                            ;A = accumulator
4134 E229 0A                    asl   a                        ;A = 2*accumulator
4135 E22A 48                    pha                            ;push 2*accumulator
4136 E22B 0A                    asl   a                        ;A = 4*accumulator
4137 E22C 0A                    asl   a                        ;A = 8*accumulator
4138 E22D 18                    clc   
4139 E22E 63 01                 adc   1,s                      ;A = 2*accumulator + 8*accumulator
4140 E230 63 02                 adc   2,s                      ;A = 10*accumulator + digit
4141 E232 FA                    plx                            ;pull two bytes from stack and discard
4142 E233 AA                    tax                            ;save accumulated value back in X
4143 E234
4144 E234 C8                    iny                            ;increment offset to get next character
4145 E235 C4 DA                 cpy   <in_end
4146 E237 90 D9                 blt   loop
4147 E239
4148 E239 84 D8        reached_end sty   <in_curr              ;update in_curr to point past pfx desig
4149 E23B 8A                    txa                            ;get 8-bit prefix number into A
4150 E23C 18                    clc   
4151 E23D 60                    rts   
4152 E23E
4153 E23E 68           pfx_num_err pla                         ;balance the stack
4154 E23F A9 00                 lda   #$00                     ;set up error code for bad pathname
4155 E241 EB                    xba   
4156 E242 A9 40                 lda   #bad_path_syntax
4157 E244 38                    sec   
4158 E245 60                    rts   
4159 E246
4160 E246                       longa on
4161 E246
4162 E246                       end_proc 
4163 E246                       eject 
4164 E246              ;===============================================================================
4165 E246              ; FST Table Management Routines
4166 E246              ;===============================================================================
4167 E246
4168 E246              ;init_fst_tbl has been relocated to Miscellaneous segment.
4169 E246              ;add_fst has been relocated to bank $E1 segment.
4170 E246
4171 E246              ;===============================================================================
4172 E246              ; find_fst:  converts an FST id number into an offset in the FST Table.
4173 E246              ;
4174 E246              ; Created:      12/4/87
4175 E246              ; Modified:
4176 E246              ; Author:       JJ
4177 E246              ;
4178 E246              ; Enter:        jsr     find_fst
4179 E246              ;
4180 E246              ; Input:        A = fst id number
4181 E246              ;               P = nvmxdizc
4182 E246              ;                   ..000...
4183 E246              ;
4184 E246              ; Output:       A = if c=0, offset of fst table entry for the fst
4185 E246              ;                   if c=1, error code for invalid fst id
4186 E246              ;               P = nvmxdizc
4187 E246              ;                   ..000..|
4188 E246              ;                          0=no error, 1=no fst with the given fst id
4189 E246              ;===============================================================================
4190 E246
4191 E246              find_fst proc 
4192 E246
4193 E246 48                    pha                            ;save input FST id on stack
4194 E247
4195 E247 AD 0F B8              lda   |fst_count               ;compute offset of base of last entry
4196 E24A 3A                    dec   a                        ;...in FST table
4197 E24B 0A                    asl   a
4198 E24C 0A                    asl   a
4199 E24D 0A                    asl   a
4200 E24E 0A                    asl   a
4201 E24F
4202 E24F AA           loop     tax                            ;X gives offset of base of FST record
4203 E250 BD 1D B8              lda   |fst_tbl+id,x            ;look at the FST id field
4204 E253 C3 01                 cmp   1,s                      ;is it the FST we're looking for
4205 E255 F0 0D                 beq   found                    ;yes, jump ahead
4206 E257 8A           not_found txa                           ;no, try another earlier in the table
4207 E258 38                    sec   
4208 E259 E9 10 00              sbc   #entry_size
4209 E25C B0 F1                 bcs   loop
4210 E25E
4211 E25E 68                    pla                            ;fst with given id not found in table
4212 E25F A9 64 00              lda   #invalid_fst_id
4213 E262 38                    sec   
4214 E263 60                    rts   
4215 E264
4216 E264 68           found    pla                            ;balance the stack
4217 E265 8A                    txa                            ;put fst table offset into A
4218 E266 18                    clc   
4219 E267 60                    rts   
4220 E268
4221 E268              ; find_fst2 - used to call find_fst from outside bank 0
4222 E268                       entry find_fst2
4223 E268 20 46 E2     find_fst2 jsr   find_fst
4224 E26B 6B                    rtl   
4225 E26C
4226 E26C                       end_proc 
4227 E26C                       eject 
4228 E26C              ;===============================================================================
4229 E26C              ; System Call Manager code for handling debug system calls.
4230 E26C              ;===============================================================================
4231 E26C
4232 E26C              dbg_module proc 
4233 E26C                       longa on
4234 E26C                       longi on
4235 E26C
4236 E26C              dbg_vcb_info  
4237 E26C
4238 E26C              dbg_fcb_info  
4239 E26C
4240 E26C              dbg_shell_info  
4241 E26C
4242 E26C              dbg_journal_on  
4243 E26C
4244 E26C              dbg_journal_off  
4245 E26C
4246 E26C              dbg_journal_data  
4247 E26C
4248 E26C                       end_proc 
4249 E26C                       eject 
4250 E26C              ;===============================================================================
4251 E26C              ; System Service Entry Points
4252 E26C              ;
4253 E26C              ; These are the actual code entry points for system services called through the
4254 E26C              ; System Service Dispatch Table at $01FC00.
4255 E26C              ;===============================================================================
4256 E26C
4257 E26C              sys_svc  proc 
4258 E26C                       entry s_get_sys_gbuf
4259 E26C
4260 E26C              s_get_sys_gbuf                          ;return address of generic FST buffer
4261 E26C A2 00 9A              ldx   #gbuf                    ;...to a more reasonable global equates
4262 E26F A0 00 00              ldy   #gbuf>>16                ;...file
4263 E272 18                    clc   
4264 E273 6B                    rtl   
4265 E274
4266 E274                       end_proc 
4267 E274                       eject 
4268 E274              *******************************************************************************
4269 E274              *
4270 E274              *        Name:  init_path_vars
4271 E274              *
4272 E274              * Description:  Clears variables used in pathname translation.
4273 E274              *
4274 E274              *      Author:  Bryan Atsatt
4275 E274              *     Created:  Jan 12, 1989
4276 E274              *    Modified:  Apr 19, 1989    Steven Glass and Lee Collings
4277 E274              *
4278 E274              *       Entry:  jsr
4279 E274              *
4280 E274              *       Input:  A = undefined
4281 E274              *               X = undefined
4282 E274              *               Y = undefined
4283 E274              *               P = nvmxdizc
4284 E274              *                   ..000...
4285 E274              *
4286 E274              *      Output:  A = unchanged
4287 E274              *               X = unchanged
4288 E274              *               Y = unchanged
4289 E274              *               P = nvmxdizc
4290 E274              *                   ..000..x 
4291 E274              *
4292 E274              *               dev1_num                ;zero
4293 E274              *               dev2_num                ;zero
4294 E274              *               path1_ptr               ;zero
4295 E274              *               path2_ptr               ;zero
4296 E274              *               span1                   ;zero
4297 E274              *               span2                   ;zero
4298 E274              *               path_flag               ;zero
4299 E274              *               v_ptr1                  ;zero
4300 E274              *               v_ptr2                  ;zero
4301 E274              *               xlate_count             ;zero
4302 E274              *
4303 E274              *        Exit:  rts
4304 E274              *
4305 E274              *        Uses:  nothing
4306 E274              *
4307 E274              * Copyright Apple Computer, Inc. 1988  All rights reserved.
4308 E274              *******************************************************************************
4309 E274
4310 E274              init_path_vars proc 
4311 E274
4312 E274              *
4313 E274              * Initialize direct page variables used to communicate pathname information to
4314 E274              * the FSTs...
4315 E274              *
4316 E274 64 36                 stz   <dev1_num                ;device numbers indicate no device
4317 E276 64 38                 stz   <dev2_num
4318 E278 64 3A                 stz   <path1_ptr               ;path pointers indicate no pathnames
4319 E27A 64 3C                 stz   <path1_ptr+2
4320 E27C 64 3E                 stz   <path2_ptr
4321 E27E 64 40                 stz   <path2_ptr+2
4322 E280 64 44                 stz   <span1                   ;spans initialized to 0
4323 E282 64 46                 stz   <span2
4324 E284 64 42                 stz   <path_flag               ;indicate no pathnames set up initially
4325 E286              *
4326 E286              * Initialize other variables involved in pathname translation...
4327 E286              *
4328 E286 9C C6 B9              stz   |v_ptr1                  ;set vps corresponding to pathn_ptr's
4329 E289 9C C8 B9              stz   |v_ptr1+2                ;...to null
4330 E28C 9C CA B9              stz   |v_ptr2
4331 E28F 9C CC B9              stz   |v_ptr2+2
4332 E292
4333 E292 9C AE B9              stz   |xlate_count             ;indicate no pathnames translated so far
4334 E295
4335 E295 60                    rts                            ;exit.
4336 E296
4337 E296                       end_proc 
4338 E296
4339 E296              init_path_vars2 proc                    ;used to access init_path_vars from
4340 E296 20 74 E2              jsr   init_path_vars           ;outside bank 0
4341 E299 6B                    rtl   
4342 E29A                       end_proc 
4343 E29A
4344 E29A                       eject 
4345 E29A              ;======================================================================
4346 E29A              ; set_prefix : Copy the string from the app's buffer to a prefix buffer
4347 E29A              ;
4348 E29A              ;Created:       August 4, 1987
4349 E29A              ;Modified:      August 10, 1987
4350 E29A              ;Author:        Mike Askins
4351 E29A              ;
4352 E29A              ;Copyright Apple Computer Inc. 1987  All rights reserved
4353 E29A              ;
4354 E29A              ;Input:         A = <undefined>
4355 E29A              ;               X = <undefined>
4356 E29A              ;               Y = <undefined>
4357 E29A              ;               P = nvmxdizc
4358 E29A              ;                   ..000...
4359 E29A              ;               b = k
4360 E29A              ;
4361 E29A              ;Output:        A = trashed
4362 E29A              ;               X = trashed
4363 E29A              ;               Y = trashed
4364 E29A              ;               P = nvmxdizc
4365 E29A              ;                   ..000...
4366 E29A              ;               b = k
4367 E29A              ;
4368 E29A              ;======================================================================
4369 E29A
4370 E29A              set_prefix proc 
4371 E29A
4372 E29A              ; Set up the parameter block pointer for this type call
4373 E29A
4374 E29A 20 AC E3              jsr   set_ptr                  ;Set pb_ptr
4375 E29D
4376 E29D              ; Prepare for a call to the path translator routine
4377 E29D
4378 E29D A0 00 00              ldy   #pblk_09_pfxnum
4379 E2A0 B7 FC                 lda   [<pb_ptr],y              ;Get the prefix number
4380 E2A2 C9 20 00              cmp   #32                      ;Prefix > 31?
4381 E2A5 90 06                 bcc   @good_number             ;no, within range
4382 E2A7 1A                    inc   a                        ;setting the @ prefix (number = $FFFF)?
4383 E2A8 D0 4D                 bne   range_error              ;no (carry still set)
4384 E2AA A9 21 00              lda   #33                      ;else translate to prefix #33
4385 E2AD              @good_number  
4386 E2AD 48                    pha                            ;Nope.
4387 E2AE AA                    tax   
4388 E2AF 9C 19 B9              stz   |fst_flags               ;Tell xlate NOT to uppercase...
4389 E2B2 9C AE B9              stz   |xlate_count             ;Tell xlate which path to process
4390 E2B5
4391 E2B5 A9 02 00              lda   #pblk_09_pname
4392 E2B8 18                    clc   
4393 E2B9 6D A2 B9              adc   |class                   ;Offset for the class
4394 E2BC 20 29 DD              jsr   xlate_path2              ;Leaves room for an extra char for sep
4395 E2BF
4396 E2BF FA                    plx                            ;Pull back prefix # request
4397 E2C0
4398 E2C0 B0 31                 bcs   syn_error                ;If xlate had problem, don't continue
4399 E2C2
4400 E2C2              ; Class 0 calls can only access preficeseses 0-7 and class 1 calls can only
4401 E2C2              ;  access 8-31.  This limits the cases where existing ProDOS/16 apps get errors
4402 E2C2              ;  that they are not prepared for.
4403 E2C2
4404 E2C2 E0 08 00              cpx   #8                       ;Set carry if 8-31, clear ow
4405 E2C5 AD A2 B9              lda   |class
4406 E2C8 D0 0B                 bne   c1                       ;Class one call...
4407 E2CA
4408 E2CA B0 2B                 bge   range_error              ;Get an error if pfx number is 8-31
4409 E2CC
4410 E2CC              c2        
4411 E2CC A7 3A                 lda   [<path1_ptr]             ;Grab the length for this class 0 call
4412 E2CE C9 41 00              cmp   #65                      ;Only allow length to 64 like P8
4413 E2D1 B0 20                 bge   syn_error                ;Too long
4414 E2D3 80 02                 bra   def_okay                 ;Go ahead and install it
4415 E2D5
4416 E2D5              c1        
4417 E2D5 90 F5                 blt   c2                       ; prefix < 8.. check for error!
4418 E2D7
4419 E2D7              def_okay  
4420 E2D7
4421 E2D7              ; Now install the string in the prefix table.  If there already was a string
4422 E2D7              ;  there, we will deallocate the space it used.
4423 E2D7
4424 E2D7 AF C8 B9 00           lda   >v_ptr1+2
4425 E2DB A8                    tay                            ;VP high
4426 E2DC AF C6 B9 00           lda   >v_ptr1
4427 E2E0 DA                    phx                            ;Swap A and X (X is STILL set to pfx #!)
4428 E2E1 AA                    tax                            ;X has VP low
4429 E2E2 68                    pla                            ;A has prefix #
4430 E2E3
4431 E2E3 20 BC E3              jsr   set_pfx                  ;Leaves current string in pfx# in temp
4432 E2E6 B0 0F                 bcs   range_error              ;If prefix number was out of range...
4433 E2E8
4434 E2E8 A4 EE                 ldy   <m_temp+2                ;msb=1 if there was no string originally
4435 E2EA 30 06                 bmi   cherry                   ;There is no string to free up.
4436 E2EC A6 EC                 ldx   <m_temp
4437 E2EE 22 15 FD 00           jsl   deallocate               ;Dump it
4438 E2F2              cherry    
4439 E2F2 18                    clc                            ;Avoid error condition
4440 E2F3
4441 E2F3              syn_error  
4442 E2F3 A9 40 00              lda   #bad_path_syntax
4443 E2F6 60                    rts                            ;Class 4s are all rts
4444 E2F7
4445 E2F7              range_error  
4446 E2F7 A9 53 00              lda   #parm_range_err
4447 E2FA 60                    rts   
4448 E2FB
4449 E2FB                       end_proc 
4450 E2FB                       eject 
4451 E2FB              ;======================================================================
4452 E2FB              ; get_prefix : Move a prefix into the app's buffer
4453 E2FB              ;
4454 E2FB              ;Created:       August 4, 1987
4455 E2FB              ;Modified:      August 10, 1987
4456 E2FB              ;Author:        Mike Askins
4457 E2FB              ;
4458 E2FB              ;Copyright Apple Computer Inc. 1987  All rights reserved
4459 E2FB              ;
4460 E2FB              ;Input:         A = <undefined>
4461 E2FB              ;               X = <undefined>
4462 E2FB              ;               Y = <undefined>
4463 E2FB              ;               P = nvmxdizc
4464 E2FB              ;                   ..000...
4465 E2FB              ;               b = k
4466 E2FB              ;
4467 E2FB              ;Output:        A = trashed
4468 E2FB              ;               X = trashed
4469 E2FB              ;               Y = trashed
4470 E2FB              ;               P = nvmxdizc
4471 E2FB              ;                   ..000...
4472 E2FB              ;               b = k
4473 E2FB              ;
4474 E2FB              ;======================================================================
4475 E2FB
4476 E2FB              get_prefix proc 
4477 E2FB                       entry null_flag
4478 E2FB                       entry gprex_alt_ent
4479 E2FB
4480 E2FB              ; Set up our access to the parameter block
4481 E2FB
4482 E2FB 20 AC E3              jsr   set_ptr                  ;Set pb_ptr
4483 E2FE
4484 E2FE              ; Get a pointer to the prefix string requested
4485 E2FE
4486 E2FE A0 00 00              ldy   #pblk_09_pfxnum
4487 E301 B7 FC                 lda   [<pb_ptr],y              ;Get the prefix number
4488 E303 C9 20 00              cmp   #32                      ;Prefix > 31?
4489 E306 90 06                 bcc   @good_number             ;no, within range
4490 E308 1A                    inc   a                        ;getting the @ prefix (number = $FFFF)?
4491 E309 D0 06                 bne   range_hop                ;no (carry still set)
4492 E30B A9 21 00              lda   #33                      ;else translate to prefix #33
4493 E30E              @good_number  
4494 E30E 20 DD E3              jsr   get_pfx                  ;m_temp points at the prefix string
4495 E311 B0 74        range_hop bcs   range_error
4496 E313 8C 98 E3              sty   |null_flag               ;Top bit indicates if string was null
4497 E316
4498 E316              ; Get a pointer to the caller's return buffer
4499 E316
4500 E316 A0 02 00              ldy   #pblk_09_pname
4501 E319              gprex_alt_ent  
4502 E319 B7 FC                 lda   [<pb_ptr],y              ;Get low part of pointer to user buffer
4503 E31B 85 E8                 sta   <ptr
4504 E31D C8                    iny   
4505 E31E C8                    iny   
4506 E31F B7 FC                 lda   [<pb_ptr],y
4507 E321 85 EA                 sta   <ptr+2
4508 E323
4509 E323 AD A2 B9              lda   |class
4510 E326 D0 2B                 bne   class1
4511 E328
4512 E328              ; Handle the class 0 case.  We may return strings up to 64 characters in
4513 E328              ;  length.  We convert all seperators (:) to slashes.  We return an error
4514 E328              ;  if we encounter a slash in the prefix, and we append a slash to the end
4515 E328              ;  just because it's traditional.
4516 E328
4517 E328              class0    
4518 E328 A7 EC                 lda   [<m_temp]
4519 E32A 2C 98 E3              bit   |null_flag               ;Maybe a 'virgin' pfx - never been set
4520 E32D 10 03                 bpl   its_null                 ;No, gotta real live path here
4521 E32F A9 FF FF              lda   #$FFFF                   ;We're gonna increment this below...
4522 E332              its_null  
4523 E332
4524 E332                       longa off
4525 E332 E2 20                 sep   #$20
4526 E334 1A                    inc   a                        ;Make up for the slash we're adding on
4527 E335 87 E8                 sta   [<ptr]
4528 E337 F0 4A                 beq   its_over                 ;In the case of the null string, done.
4529 E339 A8                    tay   
4530 E33A C8                    iny                            ;It just works out that way
4531 E33B 80 0A                 bra   slash_time               ;Store the trailing slash
4532 E33D
4533 E33D              nutr_char  
4534 E33D B7 EC                 lda   [<m_temp],y              ;Get a source character
4535 E33F C9 2F                 cmp   #'/'
4536 E341 F0 48                 beq   slash_error              ;A slash here ambiguates the string
4537 E343 C9 3A                 cmp   #sep                     ;Check if this is the seperator (:)
4538 E345 D0 02                 bne   skip_slam                ;If not, use character unchanged
4539 E347              slash_time  
4540 E347 A9 2F                 lda   #'/'                     ;Change the sep to a slash
4541 E349              skip_slam  
4542 E349 88                    dey   
4543 E34A
4544 E34A              store     
4545 E34A
4546 E34A 97 E8                 sta   [<ptr],y                 ;Store the character
4547 E34C
4548 E34C C0 02 00              cpy   #2
4549 E34F B0 EC                 bge   nutr_char                ;Continue until we've stored up to Y=1
4550 E351 80 30                 bra   its_over
4551 E353
4552 E353                       longa on
4553 E353
4554 E353              ; The class 1 case involves first checking the app buffer to see if it is large
4555 E353              ;  enough to hold the output.  Then do the copy, incrementing the length and
4556 E353              ;  storing the trailing $80.
4557 E353
4558 E353              class1    
4559 E353 A7 EC                 lda   [<m_temp]                ;Get the length
4560 E355 F0 01                 beq   skipinc                  ;If null string, no trailing seperator
4561 E357 1A                    inc   a                        ;Need an additional byte for trail sep
4562 E358              skipinc   
4563 E358 20 B9 E5              jsr   cab_2                    ;Check the caller's buffer
4564 E35B B0 3A                 bcs   buf_size                 ;Branch if too small to return prefix
4565 E35D
4566 E35D A7 EC                 lda   [<m_temp]                ;Pull the length again
4567 E35F 87 E8                 sta   [<ptr]                   ;The null string case
4568 E361 F0 1E                 beq   itsnull                  ;We're through... no more to copy
4569 E363 1A                    inc   a                        ;Need an additional byte for trail sep
4570 E364 87 E8                 sta   [<ptr]                   ;Keep the length in caller's buffer
4571 E366
4572 E366 A0 02 00              ldy   #2                       ;Now copy to the end of the string
4573 E369              more      
4574 E369 B7 EC                 lda   [<m_temp],y              ;Get the source character
4575 E36B 97 E8                 sta   [<ptr],y                 ;Put the character away
4576 E36D C8                    iny                            ;Move to the next position
4577 E36E C8                    iny                            ;Moving two bytes at a time
4578 E36F 98                    tya   
4579 E370 C7 E8                 cmp   [<ptr]                   ;Check if we're over the edge
4580 E372 90 F5                 blt   more                     ;Go back for more char pairs
4581 E374
4582 E374 A7 E8                 lda   [<ptr]                   ;Pull the length
4583 E376 A8                    tay   
4584 E377 B7 EC                 lda   [<m_temp],y              ;Put the last character in the low part
4585 E379 29 FF 00              and   #$00FF                   ;$00xx
4586 E37C 49 00 3A              eor   #sep<<8                  ;Put seperator into high part
4587 E37F 97 E8                 sta   [<ptr],y                 ;Finished copy with trailing seperator
4588 E381
4589 E381              itsnull   
4590 E381 18                    clc   
4591 E382 60                    rts   
4592 E383
4593 E383              its_over  
4594 E383 C2 20                 rep   #$20                     ;Back to 16 bit accumulator
4595 E385                       longa on
4596 E385 18                    clc   
4597 E386 60                    rts   
4598 E387
4599 E387              range_error  
4600 E387 A9 53 00              lda   #parm_range_err
4601 E38A 60                    rts   
4602 E38B
4603 E38B              slash_error  
4604 E38B
4605 E38B              * A slash error is not returned to the app, since P16 pgms don't know how to
4606 E38B              *  handle an error on GetPrefix.  So just null out the returned string, and
4607 E38B              *  pretend all is wonderful.
4608 E38B
4609 E38B                       longa off
4610 E38B A9 00                 lda   #$00                     ;Null out the prefix string so that
4611 E38D 87 E8                 sta   [<ptr]                   ; P16 apps will fail more gracefully
4612 E38F                       longa on
4613 E38F C2 20                 rep   #$20
4614 E391 80 EE                 bra   itsnull
4615 E393              buffer_error  
4616 E393 A9 40 00              lda   #bad_path_syntax
4617 E396 38                    sec   
4618 E397              buf_size  
4619 E397 60                    rts   
4620 E398
4621 E398              null_flag  
4622 E398 4F 00                 DC W:0
4623 E39A
4624 E39A                       end_proc 
4625 E39A                       eject 
4626 E39A
4627 E39A              ;======================================================================
4628 E39A              ; get_boot_vol : Get the name of the boot volume (really '*' prefix #32)
4629 E39A              ;
4630 E39A              ;Created:       August 12, 1987
4631 E39A              ;Modified:      August 10, 1987
4632 E39A              ;Author:        Mike Askins
4633 E39A              ;
4634 E39A              ;Copyright Apple Computer Inc. 1987  All rights reserved
4635 E39A              ;
4636 E39A              ;Input:         A = <undefined>
4637 E39A              ;               X = <undefined>
4638 E39A              ;               Y = <undefined>
4639 E39A              ;               P = nvmxdizc
4640 E39A              ;                   ..000...
4641 E39A              ;               b = k
4642 E39A              ;
4643 E39A              ;Output:        A = trashed
4644 E39A              ;               X = trashed
4645 E39A              ;               Y = trashed
4646 E39A              ;               P = nvmxdizc
4647 E39A              ;                   ..000...
4648 E39A              ;               b = k
4649 E39A              ;
4650 E39A              ;======================================================================
4651 E39A
4652 E39A              get_boot_vol proc 
4653 E39A
4654 E39A              ; Currently no provision is made to make sure that the boot volume name is under
4655 E39A              ;  16 bytes.  We will want to do this in the near future...
4656 E39A
4657 E39A 20 AC E3              jsr   set_ptr
4658 E39D A9 20 00              lda   #star_pfx_num            ;Get star prefix
4659 E3A0 20 DD E3              jsr   get_pfx                  ;Prefix number known to be in range
4660 E3A3 8C 98 E3              sty   |null_flag
4661 E3A6 A0 00 00              ldy   #pblk_28_pname           ;Get access to the user's buffer
4662 E3A9 4C 19 E3              jmp   gprex_alt_ent
4663 E3AC
4664 E3AC                       end_proc 
4665 E3AC
4666 E3AC              set_ptr  proc 
4667 E3AC
4668 E3AC A5 32                 lda   <param_blk_ptr
4669 E3AE A4 34                 ldy   <param_blk_ptr+2
4670 E3B0 18                    clc                            ;For class 1, move pointer ahead by two
4671 E3B1 6D A2 B9              adc   |class
4672 E3B4 90 01                 bcc   class0
4673 E3B6 C8                    iny   
4674 E3B7              class0    
4675 E3B7 85 FC                 sta   <pb_ptr
4676 E3B9 84 FE                 sty   <pb_ptr+2
4677 E3BB 60                    rts   
4678 E3BC
4679 E3BC                       end_proc 
4680 E3BC
4681 E3BC              set_pfx  proc 
4682 E3BC
4683 E3BC
4684 E3BC              ; Check for an in-range prefix number and install the VP passed into the prefix
4685 E3BC              ;  table, return carry set if prefix number is not in range.
4686 E3BC              ;  The VP previously stored in the table is returned in m_temp.
4687 E3BC
4688 E3BC C9 22 00              cmp   #number_prefix
4689 E3BF B0 1B                 bge   out
4690 E3C1
4691 E3C1 0A                    asl   a
4692 E3C2 0A                    asl   a                        ;Four bytes per element in pfx table
4693 E3C3 DA                    phx                            ;Exchange X and A (start it)
4694 E3C4 AA                    tax                            ;X now has prefix# * 4
4695 E3C5
4696 E3C5 BF D7 F4 00           lda   >prefices,x              ;Squirrel away current contents
4697 E3C9 85 EC                 sta   <m_temp
4698 E3CB BF D9 F4 00           lda   >prefices+2,x
4699 E3CF 85 EE                 sta   <m_temp+2
4700 E3D1
4701 E3D1 68                    pla                            ;Finish exchange (A has low VP)
4702 E3D2 9F D7 F4 00           sta   >prefices,x              ;Store it all away
4703 E3D6 98                    tya   
4704 E3D7 9F D9 F4 00           sta   >prefices+2,x
4705 E3DB 18                    clc                            ;No error
4706 E3DC              out       
4707 E3DC 60                    rts   
4708 E3DD
4709 E3DD                       end_proc 
4710 E3DD
4711 E3DD              get_pfx  proc 
4712 E3DD              ; Check for an in-range prefix number and return a pointer to the prefix
4713 E3DD              ;  requested.  Return carry set if prefix number is not in range.  If the
4714 E3DD              ;  msb of Y is set upon return, the string was null.  The pointer in m_temp and
4715 E3DD              ;  X & Y is valid for both null and non-null strings.
4716 E3DD
4717 E3DD C9 22 00              cmp   #number_prefix
4718 E3E0 B0 26                 bge   out
4719 E3E2
4720 E3E2 0A                    asl   a
4721 E3E3 0A                    asl   a                        ;Four bytes per element in pfx table
4722 E3E4 AA                    tax                            ;X now has prefix# * 4
4723 E3E5 BF D9 F4 00           lda   >prefices+2,x            ;Get the high part of the VP
4724 E3E9 A8                    tay   
4725 E3EA 10 08                 bpl   outok2                   ;String is an explicitly null string
4726 E3EC A2 09 E4              ldx   #null_string             ;Set up to a null string
4727 E3EF A0 00 00              ldy   #^null_string            ; for an implicitly null string
4728 E3F2 80 09                 bra   outok1
4729 E3F4
4730 E3F4              outok2    
4731 E3F4 BF D7 F4 00           lda   >prefices,x
4732 E3F8 AA                    tax                            ;Got the low part
4733 E3F9
4734 E3F9 22 09 FE 00           jsl   deref2                   ;Make a pointer out of the beastie
4735 E3FD
4736 E3FD              outok1    
4737 E3FD 86 EC                 stx   <m_temp                  ;Need to check for explicit null string
4738 E3FF 84 EE                 sty   <m_temp+2
4739 E401 A7 EC                 lda   [<m_temp]                ;Get length
4740 E403 D0 02                 bne   outok
4741 E405 3A                    dec   a
4742 E406 A8                    tay                            ;Set msb of Y to indicate a null pfx
4743 E407
4744 E407              outok     
4745 E407 18                    clc   
4746 E408              out       
4747 E408 60                    rts   
4748 E409
4749 E409 00 00        null_string DC W:0
4750 E40B
4751 E40B                       end_proc 
4752 E40B                       eject 
4753 E40B              *******************************************************************************
4754 E40B              *
4755 E40B              *        Name:  get_level
4756 E40B              *
4757 E40B              * Description:  Returns current system level.
4758 E40B              *
4759 E40B              *      Author:  Mike Askins/Bryan Atsatt
4760 E40B              *     Created:  Nov 16, 1988
4761 E40B              *    Modified:  Nov 16, 1988
4762 E40B              *
4763 E40B              *       Entry:  jsr
4764 E40B              *
4765 E40B              *       Input:  A = undefined
4766 E40B              *               X = undefined
4767 E40B              *               Y = undefined
4768 E40B              *               P = nvmxdizc
4769 E40B              *                   ..000...
4770 E40B              *
4771 E40B              *      Output:  A = system/user level OR mask.
4772 E40B              *               X = undefined
4773 E40B              *               Y = undefined
4774 E40B              *               P = nvmxdizc
4775 E40B              *                   ..000...
4776 E40B              *
4777 E40B              *        Exit:  rts
4778 E40B              *
4779 E40B              *        Uses:  set_ptr
4780 E40B              *               get_level_flag
4781 E40B              *
4782 E40B              * Copyright Apple Computer, Inc. 1988  All rights reserved.
4783 E40B              *******************************************************************************
4784 E40B
4785 E40B              get_level proc 
4786 E40B
4787 E40B              *
4788 E40B              * Get the system/userlevel flag, make an AND mask from it, and push it on
4789 E40B              * the stack...
4790 E40B              *
4791 E40B 20 1F E4              jsr   get_level_flag           ;Get system/user level.
4792 E40E 49 FF FF              eor   #$ffff                   ;Make an AND mask from it.
4793 E411 48                    pha                            ;Put in on the stack.
4794 E412              *
4795 E412              * Get the level, mask it with system/user level and exit...
4796 E412              *
4797 E412 A0 00 00              ldy   #pblk_1a_level           ;Get offset into parameter block.
4798 E415 AD 58 E4              lda   |system_level            ;Get current level.
4799 E418 23 01                 and   1,s                      ;Mask with system/user flag.
4800 E41A 97 FC                 sta   [<pb_ptr],y              ;Put in parm block.
4801 E41C 68                    pla                            ;Clean up stack.
4802 E41D 18                    clc                            ;No error.
4803 E41E 60                    rts                            ;Exit.
4804 E41F
4805 E41F                       end_proc 
4806 E41F                       eject 
4807 E41F              *******************************************************************************
4808 E41F              *
4809 E41F              *        Name:  get_level_flag
4810 E41F              *
4811 E41F              * Description:  Gets system/user level OR mask for get_level and set_level
4812 E41F              *
4813 E41F              *      Author:  Bryan Atsatt
4814 E41F              *     Created:  Nov 16, 1988
4815 E41F              *    Modified:  Nov 16, 1988
4816 E41F              *
4817 E41F              *       Entry:  jsr
4818 E41F              *
4819 E41F              *       Input:  A = undefined
4820 E41F              *               X = undefined
4821 E41F              *               Y = undefined
4822 E41F              *               P = nvmxdizc
4823 E41F              *                   ..000...
4824 E41F              *
4825 E41F              *      Output:  A = system/user level OR mask.
4826 E41F              *               X = undefined
4827 E41F              *               Y = undefined
4828 E41F              *               P = nvmxdizc
4829 E41F              *                   ..000...
4830 E41F              *
4831 E41F              *        Exit:  rts
4832 E41F              *
4833 E41F              *        Uses:  set_ptr
4834 E41F              *
4835 E41F              * Copyright Apple Computer, Inc. 1988  All rights reserved.
4836 E41F              *******************************************************************************
4837 E41F
4838 E41F              get_level_flag proc 
4839 E41F
4840 E41F              *
4841 E41F              * Set the system/user level flag and exit...
4842 E41F              *
4843 E41F 20 AC E3              jsr   set_ptr                  ;Bump pointer by two if class 1.
4844 E422 AD A2 B9              lda   |class                   ;Class 0 call?
4845 E425 F0 10                 beq   user_exit                ;Yep, so exit with user level.
4846 E427 A7 32                 lda   [<param_blk_ptr]         ;Nope, do we have system/user parm?
4847 E429 C9 02 00              cmp   #2
4848 E42C 90 09                 bcc   user_exit                ;Nope, so exit with user level.
4849 E42E A0 02 00              ldy   #pblk_1a_flags           ;Yes, get offset to parm.
4850 E431 B7 FC                 lda   [<pb_ptr],y              ;Get level_flags.
4851 E433 29 00 80              and   #set_user_level          ;Isolate system/user flag bit.
4852 E436 60                    rts                            ;Exit with level in A.
4853 E437
4854 E437 A9 00 80     user_exit lda   #set_user_level         ;Get user level.
4855 E43A 60                    rts                            ;Exit.
4856 E43B
4857 E43B                       end_proc 
4858 E43B                       eject 
4859 E43B              ;======================================================================
4860 E43B              ; set_level : Set the system level
4861 E43B              ;
4862 E43B              ;Created:       August 14, 1987
4863 E43B              ;Modified:      August 14, 1987
4864 E43B              ;               June 22, 1988 JJ Changed error from 'parameter out of range'
4865 E43B              ;                                to 'invalid level'
4866 E43B              ;Author:        Mike Askins
4867 E43B              ;
4868 E43B              ;Copyright Apple Computer Inc. 1987  All rights reserved
4869 E43B              ;
4870 E43B              ;Input:         A = <undefined>
4871 E43B              ;               X = <undefined>
4872 E43B              ;               Y = <undefined>
4873 E43B              ;               P = nvmxdizc
4874 E43B              ;                   ..000...
4875 E43B              ;               b = k
4876 E43B              ;
4877 E43B              ;Output:        A = trashed
4878 E43B              ;               X = trashed
4879 E43B              ;               Y = trashed
4880 E43B              ;               P = nvmxdizc
4881 E43B              ;                   ..000...
4882 E43B              ;               b = k
4883 E43B              ;
4884 E43B              ;======================================================================
4885 E43B
4886 E43B              set_level proc 
4887 E43B                       entry system_level
4888 E43B
4889 E43B              *
4890 E43B              * Get the system/userlevel flag and push it on the stack...
4891 E43B              *
4892 E43B 20 1F E4              jsr   get_level_flag           ;Get system/user level.
4893 E43E 48                    pha                            ;Put in on the stack.
4894 E43F AA                    tax                            ;Save it for a second.
4895 E440              *
4896 E440              * Get the level, check it if , OR with system/user level, save it and exit...
4897 E440              *
4898 E440 A0 00 00              ldy   #pblk_1a_level           ;Get level.
4899 E443 B7 FC                 lda   [<pb_ptr],y
4900 E445 18                    clc                            ;(In case system level)
4901 E446 9B                    txy                            ;Are we at system level?
4902 E447 F0 07                 beq   set_it                   ;Yep, so skip range check.
4903 E449 C9 00 01              cmp   #256                     ;Nope, level in range?
4904 E44C B0 05                 bge   r_err                    ;Nope, so error.
4905 E44E 03 01                 ora   1,s                      ;Yep, add in system/user level.
4906 E450 8D 58 E4     set_it   sta   |system_level            ;Set new system level.
4907 E453
4908 E453 68           r_err    pla                            ;Clean up stack.
4909 E454 A9 59 00              lda   #invalid_level           ;OK if carry clear.
4910 E457 60                    rts                            ;Exit.
4911 E458
4912 E458              system_level  
4913 E458 00 80                 DC W:0
4914 E45A
4915 E45A                       end_proc 
4916 E45A
4917 E45A
4918 E45A                       eject 
4919 E45A              ;======================================================================
4920 E45A              ; get_version : Get the system version number
4921 E45A              ;
4922 E45A              ;Created:       ???
4923 E45A              ;Modified:      ???
4924 E45A              ;Author:        ???
4925 E45A              ;
4926 E45A              ;Copyright Apple Computer Inc. 1987  All rights reserved
4927 E45A              ;
4928 E45A              ;Input:         A = <undefined>
4929 E45A              ;               X = <undefined>
4930 E45A              ;               Y = <undefined>
4931 E45A              ;               P = nvmxdizc
4932 E45A              ;                   ..000...
4933 E45A              ;               b = k
4934 E45A              ;
4935 E45A              ;Output:        A = trashed
4936 E45A              ;               X = trashed
4937 E45A              ;               Y = trashed
4938 E45A              ;               P = nvmxdizc
4939 E45A              ;                   ..000...
4940 E45A              ;               b = k
4941 E45A              ;
4942 E45A              ;======================================================================
4943 E45A
4944 E45A              get_version proc 
4945 E45A
4946 E45A
4947 E45A 20 AC E3              jsr   set_ptr
4948 E45D A0 00 00              ldy   #pblk_2a_version
4949 E460 A9 02 04              lda   #sys_version
4950 E463 97 FC                 sta   [<pb_ptr],y
4951 E465 60                    rts   
4952 E466
4953 E466                       end_proc 
4954 E466
4955 E466                       eject 
4956 E466              s_get_boot_pfx proc 
4957 E466 8B                    phb   
4958 E467 4B                    phk   
4959 E468 AB                    plb   
4960 E469
4961 E469 A9 20 00              lda   #0032
4962 E46C 20 DD E3              jsr   get_pfx
4963 E46F
4964 E46F AB                    plb   
4965 E470 6B                    rtl   
4966 E471
4967 E471                       end_proc 
4968 E471
4969 E471
4970 E471              s_set_boot_pfx proc 
4971 E471
4972 E471              ; Sets the boot prefix (#32) to the string whose pointer is passed in X and Y.
4973 E471              ;  Assume that there was a boot prefix already assigned.
4974 E471
4975 E471 8B                    phb   
4976 E472 4B                    phk   
4977 E473 AB                    plb   
4978 E474
4979 E474 5A                    phy                            ;Save off the pointer to the new *pfx
4980 E475 DA                    phx   
4981 E476
4982 E476 A2 80 00              ldx   #32*4                    ;Get index into prefix table
4983 E479 BF D9 F4 00           lda   >prefices+2,x
4984 E47D A8                    tay   
4985 E47E BF D7 F4 00           lda   >prefices,x
4986 E482 AA                    tax   
4987 E483 22 15 FD 00           jsl   deallocate
4988 E487
4989 E487 A3 01                 lda   1,s
4990 E489 85 FC                 sta   <pb_ptr                  ;Set up to make a new * pfx
4991 E48B A3 03                 lda   3,s
4992 E48D 85 FE                 sta   <pb_ptr+2
4993 E48F
4994 E48F 20 69 F5              jsr   set_pfx_32_alt
4995 E492
4996 E492 FA                    plx   
4997 E493 7A                    ply   
4998 E494 22 8B D2 E1           jsl   rename_bootvol
4999 E498
5000 E498 AB                    plb   
5001 E499 6B                    rtl   
5002 E49A
5003 E49A                       end_proc 
5004 E49A                       eject 
5005 E49A              ;===============================================================================
5006 E49A              ; String conversion routines for converting class 0 strings to class 1 and
5007 E49A              ; vice versa.
5008 E49A              ;===============================================================================
5009 E49A
5010 E49A              ;===============================================================================
5011 E49A              ; cvt0to1:  convert a class 0 string into a class 1 string.
5012 E49A              ;
5013 E49A              ; Enter:        pea     source_addr>>16
5014 E49A              ;               pea     source_addr
5015 E49A              ;               pea     dest_addr>>16
5016 E49A              ;               pea     dest_addr
5017 E49A              ;               jsl     cvt0to1
5018 E49A              ;
5019 E49A              ; Input:        push pointer to source string onto stack
5020 E49A              ;               push pointer to destination string onto stack
5021 E49A              ;               source and destination pointers may be identical
5022 E49A              ;               P = nvmxdizc
5023 E49A              ;                   ..000...
5024 E49A              ;
5025 E49A              ; Output:       A = trashed
5026 E49A              ;               X = trashed
5027 E49A              ;               Y = trashed
5028 E49A              ;               Class 0 source string converted to class 1 destination string.
5029 E49A              ;               P = nvmxdizc
5030 E49A              ;                   ..000...
5031 E49A              ;===============================================================================
5032 E49A
5033 E49A              cvt0to1  proc 
5034 E49A                       entry cvt_normal_exit
5035 E49A
5036 E49A              src_ptr  equ   10
5037 E49A              dst_ptr  equ   6
5038 E49A
5039 E49A 0B                    phd                            ;save D register
5040 E49B 3B                    tsc                            ;set D to overlay stack
5041 E49C 5B                    tcd   
5042 E49D              ;
5043 E49D              ; Copy length from source to destination.
5044 E49D              ;
5045 E49D A7 0A                 lda   [<src_ptr]               ;get length byte and first character
5046 E49F 87 06                 sta   [<dst_ptr]               ;and store as length word
5047 E4A1 29 FF 00              and   #$00FF                   ;zero out high byte
5048 E4A4 A8                    tay                            ;save length in Y
5049 E4A5 D0 04                 bne   bump_ptr                 ;Not zero.
5050 E4A7
5051 E4A7 87 06                 sta   [<dst_ptr]               ;Zero, so clear length word.
5052 E4A9 80 15                 bra   cvt_normal_exit          ;branch to handle zero-length string
5053 E4AB              ;
5054 E4AB              ; Prepare to copy source to destination by incrementing destination pointer.
5055 E4AB              ;
5056 E4AB E6 06        bump_ptr inc   <dst_ptr
5057 E4AD D0 02                 bne   ar_1
5058 E4AF E6 08                 inc   <dst_ptr+2
5059 E4B1              ar_1      
5060 E4B1              ;
5061 E4B1              ; Loop to copy source string to destination string.
5062 E4B1              ;
5063 E4B1 E2 20                 sep   #m8                      ;force 8-bit m mode
5064 E4B3                       longa off
5065 E4B3
5066 E4B3 B7 0A        copy_loop lda   [<src_ptr],y            ;do the copy
5067 E4B5 97 06                 sta   [<dst_ptr],y             ;note: this copy trashes high byte of
5068 E4B7 88                    dey                            ; destination length word
5069 E4B8 10 F9                 bpl   copy_loop
5070 E4BA
5071 E4BA A9 00                 lda   #00                      ;set high byte of length word back to 0
5072 E4BC 87 06                 sta   [<dst_ptr]
5073 E4BE
5074 E4BE C2 20                 rep   #m16                     ;go back to 16-bit m mode
5075 E4C0                       longa on
5076 E4C0
5077 E4C0              cvt_normal_exit  
5078 E4C0
5079 E4C0 2B                    pld                            ;restore D register
5080 E4C1 A3 02                 lda   2,s                      ;squeeze input parameters out of stack
5081 E4C3 83 0A                 sta   10,s                     ;...by moving return address upward
5082 E4C5 A3 01                 lda   1,s
5083 E4C7 83 09                 sta   9,s
5084 E4C9
5085 E4C9 3B                    tsc                            ;set S to proper value
5086 E4CA 18                    clc   
5087 E4CB 69 08 00              adc   #0008
5088 E4CE 1B                    tcs   
5089 E4CF
5090 E4CF 6B                    rtl                            ;note:  c must be clear here
5091 E4D0
5092 E4D0                       end_proc 
5093 E4D0                       eject 
5094 E4D0              ;===============================================================================
5095 E4D0              ; cvt1to0:  convert a class 1 string into a class 0 string.
5096 E4D0              ;
5097 E4D0              ; Enter:        pea     source_addr>>16
5098 E4D0              ;               pea     source_addr
5099 E4D0              ;               pea     dest_addr>>16
5100 E4D0              ;               pea     dest_addr
5101 E4D0              ;               jsl     cvt1to0
5102 E4D0              ;
5103 E4D0              ; Input:        push pointer to source string onto stack
5104 E4D0              ;               push pointer to destination string onto stack
5105 E4D0              ;               source and destination pointers may be identical
5106 E4D0              ;               P = nvmxdizc
5107 E4D0              ;                   ..000...
5108 E4D0              ;
5109 E4D0              ; Output:       A = trashed
5110 E4D0              ;               X = trashed
5111 E4D0              ;               Y = trashed
5112 E4D0              ;               Class 1 source string converted to class 0 destination string.
5113 E4D0              ;               P = nvmxdizc
5114 E4D0              ;                   ..000..|
5115 E4D0              ;                          0 = successful call
5116 E4D0              ;                          1 = error, source string length > 255
5117 E4D0              ;
5118 E4D0              ;===============================================================================
5119 E4D0
5120 E4D0              cvt1to0  proc 
5121 E4D0
5122 E4D0              src_ptr  equ   10
5123 E4D0              dst_ptr  equ   6
5124 E4D0
5125 E4D0 0B                    phd                            ;save D register
5126 E4D1 3B                    tsc                            ;set D to overlay stack
5127 E4D2 5B                    tcd   
5128 E4D3
5129 E4D3 A7 0A                 lda   [<src_ptr]               ;get length word from source string
5130 E4D5 E2 20                 sep   #m8                      ;enter 8-bit m mode
5131 E4D7                       longa off
5132 E4D7 87 06                 sta   [<dst_ptr]               ;save low byte as length byte
5133 E4D9 C2 20                 rep   #m16                     ;go back to 16-bit mode
5134 E4DB                       longa on
5135 E4DB AA                    tax                            ;save length word in X
5136 E4DC F0 E2                 beq   cvt_normal_exit          ;branch to handle zero-length string
5137 E4DE
5138 E4DE EB                    xba                            ;check whether high byte of length is 0
5139 E4DF D0 19                 bne   error                    ;error if not
5140 E4E1              ;
5141 E4E1              ; Prepare to copy source to destination by incrementing source pointer.
5142 E4E1              ;
5143 E4E1 E6 0A                 inc   <src_ptr
5144 E4E3 D0 02                 bne   ar_1
5145 E4E5 E6 0C                 inc   <src_ptr+2
5146 E4E7              ar_1      
5147 E4E7              ;
5148 E4E7              ; Loop to copy source to destination string.  Must copy from low address to
5149 E4E7              ; high address to avoid destroying source when source and destination overlap.
5150 E4E7              ;
5151 E4E7 A0 01 00              ldy   #0001                    ;offset of first character to copy
5152 E4EA CA                    dex                            ;adjust X to give proper loop count
5153 E4EB
5154 E4EB E2 20                 sep   #m8                      ;enter 8-bit m mode
5155 E4ED                       longa off
5156 E4ED
5157 E4ED B7 0A        copy_loop lda   [<src_ptr],y
5158 E4EF 97 06                 sta   [<dst_ptr],y
5159 E4F1 C8                    iny   
5160 E4F2 CA                    dex   
5161 E4F3 10 F8                 bpl   copy_loop
5162 E4F5
5163 E4F5 C2 20                 rep   #m16                     ;enter 16-bit m mode
5164 E4F7                       longa on
5165 E4F7
5166 E4F7 4C C0 E4              jmp   cvt_normal_exit          ;branch to exit code in cvt0to1
5167 E4FA
5168 E4FA              error                                   ; ;error exit
5169 E4FA
5170 E4FA 2B                    pld                            ;restore D register
5171 E4FB A3 02                 lda   2,s                      ;squeeze input parameters out of stack
5172 E4FD 83 0A                 sta   10,s                     ;...by moving return address upward
5173 E4FF A3 01                 lda   1,s
5174 E501 83 09                 sta   9,s
5175 E503
5176 E503 3B                    tsc                            ;set S to proper value
5177 E504 18                    clc   
5178 E505 69 08 00              adc   #0008
5179 E508 1B                    tcs   
5180 E509
5181 E509 38                    sec                            ;set carry to indicate error
5182 E50A
5183 E50A 6B                    rtl   
5184 E50B
5185 E50B                       end_proc 
5186 E50B                       eject 
5187 E50B              ;===============================================================================
5188 E50B              ; replace80:  replace all occurrences of sep by a specified character
5189 E50B              ;
5190 E50B              ; This routine replaces each occurrence of sep in the input string with
5191 E50B              ; a character (repl_char) specified by the caller.  However, if there are any
5192 E50B              ; occurrences of repl_char in the input string, this routine leaves the input
5193 E50B              ; string unchanged and returns an error.
5194 E50B              ;
5195 E50B              ; Enter:        pea     string_addr>>16
5196 E50B              ;               pea     string_addr
5197 E50B              ;               pea     repl_char
5198 E50B              ;               jsl     replace80
5199 E50B              ;
5200 E50B              ; Input:        push pointer to a class 1 string onto stack
5201 E50B              ;               push word containing replacement character in low byte
5202 E50B              ;               P = nvmxdizc
5203 E50B              ;                   ..000...
5204 E50B              ;
5205 E50B              ; Output:       A = trashed
5206 E50B              ;               X = trashed
5207 E50B              ;               Y = trashed
5208 E50B              ;               Input string with seps converted to repl_char (or unchanged if
5209 E50B              ;               input string already contained occurrences of repl_char.
5210 E50B              ;               P = nvmxdizc
5211 E50B              ;                   ..000..|
5212 E50B              ;                          0=successful call
5213 E50B              ;                          1=error, replacement character already appeared in
5214 E50B              ;                            input string
5215 E50B              ;===============================================================================
5216 E50B
5217 E50B              replace80 proc 
5218 E50B
5219 E50B              string_addr equ   8                     ;direct page address of string pointer
5220 E50B              repl_char equ   6                       ;direct page address of replacement char
5221 E50B
5222 E50B 0B                    phd                            ;save D register
5223 E50C 3B                    tsc                            ;set D to overlay stack
5224 E50D 5B                    tcd   
5225 E50E              ;
5226 E50E              ; Check to see if input is a null string.
5227 E50E              ;
5228 E50E A7 08                 lda   [<string_addr]           ;get string length
5229 E510 F0 24                 beq   return                   ;if length is , return
5230 E512 AA                    tax                            ;save string length in X and Y
5231 E513 A8                    tay   
5232 E514              ;
5233 E514              ; Increment pointer by 1 to simplify indexing.
5234 E514              ;
5235 E514 E6 08                 inc   <string_addr
5236 E516 D0 02                 bne   ar_1
5237 E518 E6 0A                 inc   <string_addr+2
5238 E51A              ar_1      
5239 E51A              ;
5240 E51A              ; Go into 8-bit memory mode and search string for replacement character.
5241 E51A              ;
5242 E51A E2 20                 sep   #m8
5243 E51C                       longa off
5244 E51C
5245 E51C A5 06                 lda   <repl_char
5246 E51E
5247 E51E D7 08        loop1    cmp   [<string_addr],y         ;get character from string
5248 E520 F0 25                 beq   found_repl_char          ;is it the replacement character?
5249 E522 88                    dey                            ;no, look at next character
5250 E523 D0 F9                 bne   loop1
5251 E525              ;
5252 E525              ; Replacement character did not appear in the string, so loop through string
5253 E525              ; again, replacing each $80 by the replacement character.
5254 E525              ;
5255 E525 9B                    txy                            ;get string length back from X
5256 E526 A6 06                 ldx   <repl_char               ;get replacement character into X
5257 E528                                                      ;...high byte is garbage
5258 E528 B7 08        loop2    lda   [<string_addr],y         ;get character from string
5259 E52A C9 3A                 cmp   #sep                     ;is it ASCII $80?
5260 E52C D0 03                 bne   not_sep
5261 E52E 8A           is_sep   txa                            ;yes, replace it with repl_char
5262 E52F 97 08                 sta   [<string_addr],y
5263 E531 88           not_sep  dey   
5264 E532 D0 F4                 bne   loop2
5265 E534              ;
5266 E534              ; Successful return to caller.
5267 E534              ;
5268 E534 C2 20                 rep   #m16                     ;restore 16-bit m mode
5269 E536                       longa on
5270 E536
5271 E536 2B           return   pld                            ;restore D
5272 E537
5273 E537 A3 02                 lda   2,s                      ;squeeze input parameters out of stack
5274 E539 83 08                 sta   8,s                      ;...by moving return address upward
5275 E53B A3 01                 lda   1,s
5276 E53D 83 07                 sta   7,s
5277 E53F
5278 E53F 3B                    tsc                            ;set S to proper value
5279 E540 18                    clc   
5280 E541 69 06 00              adc   #6
5281 E544 1B                    tcs   
5282 E545
5283 E545 18                    clc   
5284 E546 6B                    rtl   
5285 E547              ;
5286 E547              ; Unsuccessful return to caller.
5287 E547              ;
5288 E547 C2 20        found_repl_char rep   #m16              ;restore 16-bit m mode
5289 E549                       longa on
5290 E549
5291 E549 2B                    pld                            ;restore D
5292 E54A
5293 E54A A3 02                 lda   2,s                      ;squeeze input parameters out of stack
5294 E54C 83 08                 sta   8,s                      ;...by moving return address upward
5295 E54E A3 01                 lda   1,s
5296 E550 83 07                 sta   7,s
5297 E552
5298 E552 3B                    tsc                            ;set S to proper value
5299 E553 18                    clc   
5300 E554 69 06 00              adc   #6
5301 E557 1B                    tcs   
5302 E558
5303 E558 38                    sec   
5304 E559 6B                    rtl   
5305 E55A
5306 E55A                       end_proc 
5307 E55A                       eject 
5308 E55A              ;======================================================================
5309 E55A              ; expand_path : Expands a class 1 partial path into a full pathname
5310 E55A              ;
5311 E55A              ;Created:       October 5, 1987
5312 E55A              ;Modified:      November 20, 1987
5313 E55A              ;Author:        Mike Askins
5314 E55A              ;
5315 E55A              ;Copyright Apple Computer Inc. 1987  All rights reserved
5316 E55A              ;
5317 E55A              ;Input:         A = <undefined>
5318 E55A              ;               X = <undefined>
5319 E55A              ;               Y = <undefined>
5320 E55A              ;               P = nvmxdizc
5321 E55A              ;                   ..000...
5322 E55A              ;               b = k
5323 E55A              ;
5324 E55A              ;Output:        A = trashed
5325 E55A              ;               X = trashed
5326 E55A              ;               Y = trashed
5327 E55A              ;               P = nvmxdizc
5328 E55A              ;                   ..000...
5329 E55A              ;               b = k
5330 E55A              ;
5331 E55A              ;======================================================================
5332 E55A
5333 E55A              expand_path proc 
5334 E55A
5335 E55A
5336 E55A              pblk_0E_flags equ   8                   ;BELONGS IN COMMON.EQU... PUT IT THERE!
5337 E55A
5338 E55A              *
5339 E55A              * Initialize pathname variables...
5340 E55A              *
5341 E55A 20 74 E2              jsr   init_path_vars
5342 E55D
5343 E55D              ; They're allowed to pass whether they want uppercasing in a 'flags' word.  If
5344 E55D              ;  the pcount=3 then pick up this value (which can only be $8000 or $0000) and
5345 E55D              ;  use it instead of the $8000 default.
5346 E55D
5347 E55D A7 32                 lda   [<param_blk_ptr]         ;Get pcount
5348 E55F 4A                    lsr   a                        ;PCount=3 -> C
5349 E560 A9 00 80              lda   #$8000                   ;This is the default
5350 E563 90 09                 bcc   skip1                    ;Use the default for PCount=2
5351 E565 A0 0A 00              ldy   #pblk_0E_flags+2         ;For the PCount=3 case
5352 E568              *	and	[<param_blk_ptr],y	;Get top bit from them
5353 E568
5354 E568              ; Check the parm passed to see if bits[14..0] are clear.  Bounce out with an
5355 E568              ;  error in that case.
5356 E568
5357 E568 B7 32                 lda   [<param_blk_ptr],y       ;7/26/88MSA Re-get user parm
5358 E56A 0A                    asl   a                        ;7/26/88MSA Remove top bit
5359 E56B D0 32                 bne   bad_parm                 ;7/26/88MSA If non zero, bad input
5360 E56D 6A                    ror   a                        ;7/26/88MSA Restore top bit
5361 E56E
5362 E56E              skip1     
5363 E56E
5364 E56E              ; Do the conversion
5365 E56E
5366 E56E A2 00 00              ldx   #0                       ;Want to use prefix #0 if any
5367 E571 8D 19 B9              sta   |fst_flags
5368 E574 9C AE B9              stz   |xlate_count
5369 E577 A9 02 00              lda   #pblk_0E_pname1+2        ;Indicate the path pointer for input
5370 E57A 20 29 DD              jsr   xlate_path2              ;Do the name munging
5371 E57D B0 25                 bcs   syn_error
5372 E57F              *
5373 E57F              * If the pathname contains a device name/number, build up a path by doing a
5374 E57F              * volume call...
5375 E57F              *
5376 E57F 22 7D B4 00           jsl   insert_vol_name          ;Insert name if available & needed.
5377 E583              *
5378 E583              * Now make sure that the user has supplied a buffer which is large enough...
5379 E583              *
5380 E583 A7 3A                 lda   [<path1_ptr]             ;Got the required length
5381 E585 A0 06 00              ldy   #pblk_0E_pname2+2        ;Indicate ptr of buffer to check
5382 E588 20 A9 E5              jsr   chk_app_buf              ;Do the checkin'
5383 E58B F0 12                 beq   bad_parm                 ;if NULL pointer, bad parm!
5384 E58D B0 19                 bcs   buf_size                 ;Acc has buffer size error code
5385 E58F              *
5386 E58F              * The buffer is large enough, so copy string...
5387 E58F              *
5388 E58F A5 3A                 lda   <path1_ptr               ;Set up the source pointer for copy
5389 E591 85 EC                 sta   <m_temp                  ; (ptr is set by chk_app_buf)
5390 E593 A5 3C                 lda   <path1_ptr+2
5391 E595 85 EE                 sta   <m_temp+2
5392 E597 20 01 B7              jsr   copy_ext_string          ;Do the copy into user's buffer
5393 E59A              *
5394 E59A              * Now get rid of the buffer that expanding the path generated and exit...
5395 E59A              *
5396 E59A              skip_it   
5397 E59A 20 61 B7              jsr   release_v_ptrs           ;Release vptrs.
5398 E59D
5399 E59D 18                    clc   
5400 E59E 60                    rts   
5401 E59F
5402 E59F              bad_parm  
5403 E59F A9 53 00              lda   #parm_range_err
5404 E5A2 80 03                 bra   skip
5405 E5A4
5406 E5A4              syn_error  
5407 E5A4 A9 40 00              lda   #bad_path_syntax
5408 E5A7              skip      
5409 E5A7 38                    sec   
5410 E5A8              buf_size  
5411 E5A8 60                    rts   
5412 E5A9                       end_proc 
5413 E5A9
5414 E5A9                       eject 
5415 E5A9              ;======================================================================
5416 E5A9              ; chk_app_buf : Check the caller's buffer to make sure it is big enough
5417 E5A9              ;
5418 E5A9              ;Created:       October 6, 1987
5419 E5A9              ;Modified:      October 16, 1987
5420 E5A9              ;Author:        Mike Askins
5421 E5A9              ;
5422 E5A9              ;Copyright Apple Computer Inc. 1987  All rights reserved
5423 E5A9              ;
5424 E5A9              ;Input:         A = Required Length
5425 E5A9              ;               X = <undefined>
5426 E5A9              ;               Y = Offset into pblock indicating location of buffer
5427 E5A9              ;               P = nvmxdizc
5428 E5A9              ;                   ..000...
5429 E5A9              ;               b = k
5430 E5A9              ;
5431 E5A9              ;Output:        A = Buffer Size error (if C set)
5432 E5A9              ;               X = trashed
5433 E5A9              ;               Y = trashed
5434 E5A9              ;               P = nvmxdizc
5435 E5A9              ;                   ..000.0. -> buffer pointer good
5436 E5A9              ;                         1  -> NULL buffer pointer (ignore it)
5437 E5A9              ;                   ..000..1 -> 'Insufficient Buffer Size'
5438 E5A9              ;                          0 -> buffer good
5439 E5A9              ;             ptr = Pointer to user buffer+2 (if C clear)
5440 E5A9              ;              vp = trashed
5441 E5A9              ;               b = k
5442 E5A9              ;
5443 E5A9              ;======================================================================
5444 E5A9
5445 E5A9              chk_app_buf proc 
5446 E5A9                       entry cab_2
5447 E5A9
5448 E5A9              ; The user buffer is checked to see if it is at least the size passed in
5449 E5A9              ;  the accumulator.  If it is not large enough (and it is at least 4 bytes)
5450 E5A9              ;  the required length is stored in the buffer as the second and third bytes
5451 E5A9              ;  of the buffer.
5452 E5A9
5453 E5A9 48                    pha                            ;save required length
5454 E5AA B7 32                 lda   [<param_blk_ptr],y       ;Fetch the pointer to the buffer
5455 E5AC 85 E8                 sta   <ptr
5456 E5AE C8                    iny   
5457 E5AF C8                    iny   
5458 E5B0 B7 32                 lda   [<param_blk_ptr],y
5459 E5B2 85 EA                 sta   <ptr+2
5460 E5B4 05 E8                 ora   <ptr                     ;null pointer?
5461 E5B6 F0 16                 beq   cab                      ;yes, exit
5462 E5B8 68                    pla   
5463 E5B9
5464 E5B9              cab_2     
5465 E5B9 18                    clc   
5466 E5BA 69 03 00              adc   #3                       ;Include the two size words plus
5467 E5BD C7 E8                 cmp   [<ptr]                   ; one as we have no 'bgt' instruction
5468 E5BF B0 0E                 bge   blewit
5469 E5C1
5470 E5C1 A9 02 00              lda   #2                       ;Carry already clear
5471 E5C4 65 E8                 adc   <ptr                     ;Skip the buff length by adding 2
5472 E5C6 85 E8                 sta   <ptr
5473 E5C8 90 04                 bcc   cab                      ;Out with no error
5474 E5CA E6 EA                 inc   <ptr+2
5475 E5CC C2 03                 rep   #%00000011               ;Return with no error and valid pointer
5476 E5CE              cab       
5477 E5CE 60                    rts   
5478 E5CF
5479 E5CF              blewit    
5480 E5CF
5481 E5CF              ; Here we know it isn't big enough to do the copy.  Check if it is big enough
5482 E5CF              ;  to allow us to store the required buffer size in the buffer itself.  If it
5483 E5CF              ;  is, do it.
5484 E5CF
5485 E5CF E9 03 00              sbc   #3                       ;reverse the addition of 3 above
5486 E5D2                                                      ;(carry already set)
5487 E5D2 48                    pha                            ;Keep the required length
5488 E5D3 A7 E8                 lda   [<ptr]                   ;Get the actual length of the buffer
5489 E5D5 C9 04 00              cmp   #4                       ;Must be at least four bytes
5490 E5D8 68                    pla   
5491 E5D9 90 05                 blt   cab2
5492 E5DB
5493 E5DB A0 02 00              ldy   #2
5494 E5DE 97 E8                 sta   [<ptr],y
5495 E5E0
5496 E5E0              cab2      
5497 E5E0 A9 4F 00              lda   #buff_too_small
5498 E5E3 38                    sec   
5499 E5E4 60                    rts   
5500 E5E5
5501 E5E5                       end_proc 
5502 E5E5                       eject 
5503 E5E5              ;===============================================================================
5504 E5E5              ; get_name:  Gets the filename of the currently executing program.
5505 E5E5              ;
5506 E5E5              ; Created:      December 4, 1987
5507 E5E5              ; Modified:
5508 E5E5              ; Author:       JJ
5509 E5E5              ;
5510 E5E5              ; Input:        A = <undefined>
5511 E5E5              ;               X = <undefined>
5512 E5E5              ;               Y = <undefined>
5513 E5E5              ;               P = nvmxdizc
5514 E5E5              ;                   ..000...
5515 E5E5              ;               b = k
5516 E5E5              ;
5517 E5E5              ;               A = trashed
5518 E5E5              ;               X = trashed
5519 E5E5              ;               Y = trashed
5520 E5E5              ;               P = nvmxdizc
5521 E5E5              ;                   ..000...
5522 E5E5              ;               b = k
5523 E5E5              ;
5524 E5E5              ;===============================================================================
5525 E5E5              ;===============================================================================
5526 E5E5              ; null_call:  Handle the null system call.
5527 E5E5              ;
5528 E5E5              ; The purpose of this call is simply to flush the event queue.
5529 E5E5              ;
5530 E5E5              ; Created:      December 6, 1987
5531 E5E5              ; Modified:
5532 E5E5              ; Author:       JJ
5533 E5E5              ;
5534 E5E5              ; Input:        A = <undefined>
5535 E5E5              ;               X = <undefined>
5536 E5E5              ;               Y = <undefined>
5537 E5E5              ;               P = nvmxdizc
5538 E5E5              ;                   ..000...
5539 E5E5              ;               b = k
5540 E5E5              ;
5541 E5E5              ;               A = unchanged
5542 E5E5              ;               X = unchanged
5543 E5E5              ;               Y = unchanged
5544 E5E5              ;               P = nvmxdizc
5545 E5E5              ;                   ..000..0
5546 E5E5              ;               b = k
5547 E5E5              ;
5548 E5E5              ;===============================================================================
5549 E5E5
5550 E5E5                       DATACHK OFF 
5551 E5E5              get_name proc 
5552 E5E5
5553 E5E5                       entry null_call
5554 E5E5
5555 E5E5              ; Make pb_ptr point to the data buffer pointer field in the parameter block.
5556 E5E5
5557 E5E5 20 AC E3              jsr   set_ptr
5558 E5E8
5559 E5E8              ; Branch depending on class of call.
5560 E5E8
5561 E5E8 AD A2 B9              lda   |class
5562 E5EB D0 40                 bne   class_1
5563 E5ED
5564 E5ED              ; Here, handle the class 0 version of the call.  First, make ptr point to the
5565 E5ED              ; caller's output buffer.
5566 E5ED
5567 E5ED              class_0   
5568 E5ED A0 00 00              ldy   #$0000
5569 E5F0 B7 FC                 lda   [<pb_ptr],y              ;low word
5570 E5F2 85 E8                 sta   <ptr
5571 E5F4 C8                    iny   
5572 E5F5 C8                    iny   
5573 E5F6 B7 FC                 lda   [<pb_ptr],y              ;high word
5574 E5F8 85 EA                 sta   <ptr+2
5575 E5FA
5576 E5FA              ; Make m_temp point to the class 0 string containing the filename of the
5577 E5FA              ; currently executing program.
5578 E5FA
5579 E5FA A9 1A D7              lda   #e1_app_filename         ;low word of address
5580 E5FD 85 EC                 sta   <m_temp
5581 E5FF A9 E1 00              lda   #e1_app_filename>>16     ;high word of address
5582 E602 85 EE                 sta   <m_temp+2
5583 E604
5584 E604              ; Get the length byte of the source and check boundary conditions.
5585 E604
5586 E604 A7 EC                 lda   [<m_temp]
5587 E606 29 FF 00              and   #$00FF                   ;mask off high byte of garbage
5588 E609 D0 08                 bne   not_0_len
5589 E60B E2 20                 sep   #$20                     ;shift to 8-bit mode
5590 E60D 87 E8                 sta   [<ptr]                   ;set the string length to 0
5591 E60F C2 20                 rep   #$20
5592 E611 80 13                 bra   done                     ;and exit
5593 E613
5594 E613              ; Here, handle the case where string length is non-zero.  Do a string copy.
5595 E613
5596 E613              not_0_len  
5597 E613 C9 10 00              cmp   #16                      ;for class 0, string length limited to 16 bytes
5598 E616 B0 10                 bge   buff_error
5599 E618
5600 E618 A8                    tay                            ;set up index
5601 E619
5602 E619 88           more     dey   
5603 E61A B7 EC        more2    lda   [<m_temp],y              ;get word from source string
5604 E61C 97 E8                 sta   [<ptr],y                 ;store it in destination string
5605 E61E 98                    tya                            ;set condition codes
5606 E61F F0 05                 beq   no_more                  ;if index is 0, no more to copy
5607 E621 88                    dey                            ;decrement once more
5608 E622 D0 F5                 bne   more                     ;if non-zero, decrement yet again
5609 E624 80 F4                 bra   more2                    ;if zero, just copy lowest word
5610 E626              no_more   
5611 E626
5612 E626 18           done     clc   
5613 E627 60                    rts   
5614 E628
5615 E628 A9 4F 00     buff_error lda   #buff_too_small
5616 E62B 38                    sec   
5617 E62C 60                    rts   
5618 E62D
5619 E62D              ; Here, we handle the class 1 version of the call.  First, get the string
5620 E62D              ; length, make ptr point to the output string area, and check that the output
5621 E62D              ; buffer is of acceptable size.
5622 E62D
5623 E62D                       Import e1_current_id
5624 E62D              class_1   
5625 E62D A7 32                 lda   [<param_blk_ptr]         ;get the pCount
5626 E62F C9 02 00              cmp   #$0002                   ;are they asking for the userID?
5627 E632 90 09                 bcc   @no_id                   ;no, skip to name copying
5628 E634 AF 79 D6 E1           lda   >e1_current_id           ;get the ID from GQuit's variables
5629 E638 A0 06 00              ldy   #$0006                   ;point to location in parmblock
5630 E63B 97 32                 sta   [<param_blk_ptr],y       ;store it
5631 E63D              @no_id    
5632 E63D AF 1A D7 E1           lda   >e1_app_filename         ;get length of the filename
5633 E641 29 FF 00              and   #$00FF                   ;mask off garbage byte
5634 E644 A0 02 00              ldy   #$0002                   ;parm list offset of pointer to output
5635 E647 20 A9 E5              jsr   chk_app_buf              ;check output area length and set up ptr
5636 E64A F0 22                 beq   skip_name                ;skip if caller supplied a NULL pointer
5637 E64C B0 21                 bcs   outta_here               ;cab_2 sets A='buff too small' if so
5638 E64E
5639 E64E              ; Here, output buffer size is sufficient, and ptr has been incremented to point
5640 E64E              ; to the actual class 1 string area in the output buffer.  Now, copy the
5641 E64E              ; filename into the output string.
5642 E64E
5643 E64E              continue_1  
5644 E64E AF 1A D7 E1           lda   >e1_app_filename         ;get length of the filename
5645 E652 29 FF 00              and   #$00FF                   ;mask off garbage byte
5646 E655 48                    pha                            ;save length on stack
5647 E656 AA                    tax                            ;put length into X and Y
5648 E657 A8                    tay   
5649 E658 80 02                 bra   more4
5650 E65A
5651 E65A CA           more3    dex                            ;copy the filename to the caller's
5652 E65B 88                    dey                            ;...destination string
5653 E65C BF 19 D7 E1  more4    lda   >e1_app_filename-1,x
5654 E660 97 E8                 sta   [<ptr],y
5655 E662 98                    tya   
5656 E663 F0 06                 beq   no_more_1
5657 E665 CA                    dex   
5658 E666 88                    dey   
5659 E667 D0 F1                 bne   more3
5660 E669 80 F1                 bra   more4
5661 E66B              no_more_1  
5662 E66B
5663 E66B              ; Set length of output string properly.
5664 E66B
5665 E66B 68                    pla   
5666 E66C 87 E8                 sta   [<ptr]
5667 E66E
5668 E66E              skip_name  
5669 E66E              null_call                               ;entry point for null call
5670 E66E 18                    clc   
5671 E66F              outta_here  
5672 E66F 60                    rts   
5673 E670
5674 E670                       end_proc 
5675 E670
5676 E670                       DATACHK ON 
5677 E670
5678 E670                       eject 
5679 E670              ;===============================================================================
5680 E670              ; fst_spec:  Handle the fst_specific system call.
5681 E670              ;
5682 E670              ; Created:      December 4, 1987
5683 E670              ; Modified:
5684 E670              ; Author:       JJ
5685 E670              ;
5686 E670              ; Input:        A = <undefined>
5687 E670              ;               X = <undefined>
5688 E670              ;               Y = <undefined>
5689 E670              ;               P = nvmxdizc
5690 E670              ;                   ..000...
5691 E670              ;               b = k
5692 E670              ;
5693 E670              ;               A = trashed
5694 E670              ;               X = trashed
5695 E670              ;               Y = trashed
5696 E670              ;               P = nvmxdizc
5697 E670              ;                   ..000...
5698 E670              ;               b = k
5699 E670              ;
5700 E670              ;===============================================================================
5701 E670
5702 E670              fst_spec proc 
5703 E670                       Export do_judgename            ;very cheap way of implementation!
5704 E670              do_judgename  
5705 E670 A0 02 00              ldy   #$0002                   ;offset of fst id field in parm blk
5706 E673 B7 32                 lda   [<param_blk_ptr],y       ;get fst id from parm blk
5707 E675
5708 E675 C9 0C 00              cmp   #iso9660FSID             ;trying to go to phantom FST?
5709 E678 D0 03                 bne   @1                       ;nope, just pass it along
5710 E67A A9 0B 00              lda   #highSierraFSID          ;else translate into High Sierra ID
5711 E67D              @1        
5712 E67D 20 46 E2              jsr   find_fst                 ;get fst table offset of fst record
5713 E680 B0 03                 bcs   no_fst
5714 E682
5715 E682 20 AB B7              jsr   call_fst                 ;call the fst
5716 E685
5717 E685 60           no_fst   rts   
5718 E686
5719 E686                       end_proc 
5720 E686
5721 E686                       eject 
5722 E686              ;======================================================================
5723 E686              ; newline:  Process the NEWLINE system call.
5724 E686              ;
5725 E686              ;Created:       December 10, 1987
5726 E686              ;Modified:
5727 E686              ;Author:        JJ
5728 E686              ;
5729 E686              ;Copyright Apple Computer Inc. 1987  All rights reserved
5730 E686              ;
5731 E686              ;Input:         A = <undefined>
5732 E686              ;               X = Call Number * 2
5733 E686              ;               Y = Class Number * 2
5734 E686              ;               P = nvmxdizc
5735 E686              ;                   ..000...
5736 E686              ;               b = k
5737 E686              ;
5738 E686              ;Output:        A = trashed
5739 E686              ;               X = trashed
5740 E686              ;               Y = trashed
5741 E686              ;               P = nvmxdizc
5742 E686              ;                   ..000...
5743 E686              ;               b = k
5744 E686              ;
5745 E686              ;======================================================================
5746 E686
5747 E686              newline  proc 
5748 E686
5749 E686              newl_tbl_ptr equ   s_temp1              ;pointer to table of newline chars
5750 E686              ref_num  equ   s_temp2                  ;reference number from the call
5751 E686              enable_mask equ   s_temp2+2             ;newline mask from the call
5752 E686              num_chars equ   s_temp3                 ;number of newline characters
5753 E686              fcr_ptr_temp equ   s_temp4              ;pointer to FCR corresponding to ref_num
5754 E686              fcr_vp   equ   s_temp5                  ;vp to the FCR corresponding to ref_num
5755 E686              tbl_ptr  equ   path1_ptr                ;pointer to the new newline table
5756 E686              tbl_vp   equ   path2_ptr                ;vp to the new newline table
5757 E686
5758 E686              ; Copy parameters from parameter block into local storage.
5759 E686
5760 E686 AC A2 B9              ldy   |class                   ;y=0 for class 0; y=2 for class 1
5761 E689 B7 32                 lda   [<param_blk_ptr],y       ;get ref_num
5762 E68B 85 D8                 sta   <ref_num
5763 E68D C8                    iny   
5764 E68E C8                    iny   
5765 E68F B7 32                 lda   [<param_blk_ptr],y       ;get enable_mask
5766 E691 29 FF 00              and   #$00FF                   ;force high byte to $00
5767 E694 85 DA                 sta   <enable_mask
5768 E696
5769 E696              ; Perform slightly different processing for class 0 vs. class 1
5770 E696
5771 E696 AD A2 B9              lda   |class
5772 E699 D0 18                 bne   is_class_1
5773 E69B
5774 E69B              ; Synthesize a newline character table for the class 0 call.
5775 E69B
5776 E69B A9 01 00     is_class_0 lda   #1                     ;pretend there is one newline character
5777 E69E 85 DC                 sta   <num_chars
5778 E6A0
5779 E6A0 C8                    iny                            ;get newline character + garbage byte
5780 E6A1 C8                    iny   
5781 E6A2 B7 32                 lda   [<param_blk_ptr],y
5782 E6A4 8D 5E E7              sta   |fake_newl_tbl           ;...and store into fake newline table
5783 E6A7
5784 E6A7 A9 5E E7              lda   #fake_newl_tbl           ;set up pointer to synthesized table
5785 E6AA 85 D4                 sta   <newl_tbl_ptr
5786 E6AC A9 00 00              lda   #fake_newl_tbl>>16
5787 E6AF 85 D6                 sta   <newl_tbl_ptr+2
5788 E6B1
5789 E6B1 80 12                 bra   common
5790 E6B3
5791 E6B3 C8           is_class_1 iny                          ;get newline character count
5792 E6B4 C8                    iny   
5793 E6B5 B7 32                 lda   [<param_blk_ptr],y
5794 E6B7 85 DC                 sta   <num_chars
5795 E6B9
5796 E6B9 C8                    iny                            ;get pointer to newline table
5797 E6BA C8                    iny   
5798 E6BB B7 32                 lda   [<param_blk_ptr],y
5799 E6BD 85 D4                 sta   <newl_tbl_ptr
5800 E6BF C8                    iny   
5801 E6C0 C8                    iny   
5802 E6C1 B7 32                 lda   [<param_blk_ptr],y
5803 E6C3 85 D6                 sta   <newl_tbl_ptr+2
5804 E6C5
5805 E6C5              ; After this point, the remainder of the processing is identical for class 0 and
5806 E6C5              ; class 1.  The local variables ref_num, enable_mask, num_chars, newl_tbl_ptr,
5807 E6C5              ; and the newline table itself are all set up.
5808 E6C5
5809 E6C5              common    
5810 E6C5
5811 E6C5              ; Get pointer to the FCR corresponding to ref_num.
5812 E6C5
5813 E6C5 A5 D8                 lda   <ref_num
5814 E6C7 22 72 F8 00           jsl   findfcr                  ;get vp to the FCR
5815 E6CB 90 03                 bcc   ok1
5816 E6CD 4C 4F E7              jmp   no_fcr
5817 E6D0 86 E4        ok1      stx   <fcr_vp
5818 E6D2 84 E6                 sty   <fcr_vp+2
5819 E6D4 22 09 FE 00           jsl   deref2                   ;transform it into pointer to the FCR
5820 E6D8 86 E0                 stx   <fcr_ptr_temp
5821 E6DA 84 E2                 sty   <fcr_ptr_temp+2
5822 E6DC
5823 E6DC              ; If there was already newline data in the FCR, get rid of it.
5824 E6DC
5825 E6DC A0 12 00              ldy   #fcr_mask                ;if mask=0, there is no newline data
5826 E6DF B7 E0                 lda   [<fcr_ptr_temp],y
5827 E6E1 F0 14                 beq   skip1
5828 E6E3
5829 E6E3 A9 00 00              lda   #0                       ;set the mask to zero
5830 E6E6 97 E0                 sta   [<fcr_ptr_temp],y
5831 E6E8
5832 E6E8 A0 0C 00              ldy   #fcr_newline             ;prepare to release the storage
5833 E6EB B7 E0                 lda   [<fcr_ptr_temp],y        ;low word of vp to newline table
5834 E6ED AA                    tax   
5835 E6EE C8                    iny   
5836 E6EF C8                    iny   
5837 E6F0 B7 E0                 lda   [<fcr_ptr_temp],y        ;high word of vp to newline table
5838 E6F2 A8                    tay   
5839 E6F3 22 15 FD 00           jsl   deallocate               ;get rid of the table
5840 E6F7
5841 E6F7              skip1     
5842 E6F7
5843 E6F7              ; Next, determine if we are disabling or enabling newline mode.
5844 E6F7
5845 E6F7 A5 DA                 lda   <enable_mask
5846 E6F9 D0 02                 bne   enable
5847 E6FB
5848 E6FB              ; Disable newline mode.  Everything has been done.
5849 E6FB
5850 E6FB              disable   
5851 E6FB 18                    clc                            ;normal return
5852 E6FC 60                    rts   
5853 E6FD
5854 E6FD              ; Enable newline mode.  First, make sure num_chars has a reasonable value.
5855 E6FD
5856 E6FD A5 DC        enable   lda   <num_chars
5857 E6FF F0 58                 beq   parm_error               ;error if enabling, but num_chars=0
5858 E701 C9 01 01              cmp   #257                     ;error if enabling, but num_chars>256
5859 E704 B0 53                 bge   parm_error
5860 E706
5861 E706              ; Now, do it.  First, get a GIM segment of the appropriate size to use as the
5862 E706              ; FCR's newline character table.
5863 E706
5864 E706 22 4C FB 00           jsl   allocate                 ;allocate the segment (length in A)
5865 E70A B0 48                 bcs   memory_error
5866 E70C 86 3E                 stx   <tbl_vp
5867 E70E 84 40                 sty   <tbl_vp+2
5868 E710 22 09 FE 00           jsl   deref2                   ;convert vp to a pointer
5869 E714 86 3A                 stx   <tbl_ptr
5870 E716 84 3C                 sty   <tbl_ptr+2
5871 E718
5872 E718              ; Re-dereference the vp to the FCR since allocate may have caused compaction.
5873 E718
5874 E718 A6 E4                 ldx   <fcr_vp
5875 E71A A4 E6                 ldy   <fcr_vp+2
5876 E71C 22 09 FE 00           jsl   deref2
5877 E720 86 E0                 stx   <fcr_ptr_temp
5878 E722 84 E2                 sty   <fcr_ptr_temp+2
5879 E724
5880 E724              ; Install vp of new newline table into FCR
5881 E724
5882 E724 A0 0C 00              ldy   #fcr_newline
5883 E727 A5 3E                 lda   <tbl_vp
5884 E729 97 E0                 sta   [<fcr_ptr_temp],y
5885 E72B C8                    iny   
5886 E72C C8                    iny   
5887 E72D A5 40                 lda   <tbl_vp+2
5888 E72F 97 E0                 sta   [<fcr_ptr_temp],y
5889 E731
5890 E731              ; Record enable mask and newline character count in FCR.
5891 E731
5892 E731 A0 12 00              ldy   #fcr_mask
5893 E734 A5 DA                 lda   <enable_mask
5894 E736 97 E0                 sta   [<fcr_ptr_temp],y
5895 E738 A0 10 00              ldy   #fcr_newline_len
5896 E73B A5 DC                 lda   <num_chars
5897 E73D 97 E0                 sta   [<fcr_ptr_temp],y
5898 E73F
5899 E73F              ; Copy the newline character table from the parameter block to the FCR's
5900 E73F              ; newline table.
5901 E73F
5902 E73F                       longa off
5903 E73F E2 20                 sep   #m8
5904 E741
5905 E741 A4 DC                 ldy   <num_chars               ;offset of last character in table
5906 E743 88                    dey   
5907 E744
5908 E744 B7 D4        copy_loop lda   [<newl_tbl_ptr],y
5909 E746 97 3A                 sta   [<tbl_ptr],y
5910 E748 88                    dey   
5911 E749 10 F9                 bpl   copy_loop
5912 E74B
5913 E74B                       longa on
5914 E74B C2 20                 rep   #m16
5915 E74D
5916 E74D 18                    clc                            ;normal return to SCM
5917 E74E 60                    rts   
5918 E74F
5919 E74F A9 43 00     no_fcr   lda   #invalid_ref_num
5920 E752 38                    sec   
5921 E753 60                    rts   
5922 E754
5923 E754 A9 54 00     memory_error lda   #out_of_mem          ;fcr already has enable mask = 0
5924 E757 38                    sec   
5925 E758 60                    rts   
5926 E759
5927 E759 A9 53 00     parm_error lda   #parm_range_err
5928 E75C 38                    sec   
5929 E75D 60                    rts   
5930 E75E
5931 E75E 00 00        fake_newl_tbl DS B:2                    ;low byte is used, high byte is garbage
5932 E760
5933 E760                       end_proc 
5934 E760                       eject 
5935 E760              ;===============================================================================
5936 E760              ; get_fst_info:  Handle the get_fst_info call.
5937 E760              ;
5938 E760              ; The purpose of this call is to get information about an FST.
5939 E760              ;
5940 E760              ; Created:      1/22/88
5941 E760              ; Modified:
5942 E760              ; Author:       JJ
5943 E760              ;
5944 E760              ; Input:        A = <undefined>
5945 E760              ;               X = <undefined>
5946 E760              ;               Y = <undefined>
5947 E760              ;               P = nvmxdizc
5948 E760              ;                   ..000...
5949 E760              ;               b = k
5950 E760              ;
5951 E760              ;               A = unchanged
5952 E760              ;               X = unchanged
5953 E760              ;               Y = unchanged
5954 E760              ;               P = nvmxdizc
5955 E760              ;                   ..000..0
5956 E760              ;               b = k
5957 E760              ;
5958 E760              ;===============================================================================
5959 E760
5960 E760              get_fst_info proc 
5961 E760
5962 E760              pcount   equ   s_temp1                  ;parameter count from param block
5963 E760              fst_num  equ   s_temp1+2                ;fst number from param block
5964 E760              fst_hdr  equ   s_temp2                  ;pointer to FST header
5965 E760              name_ptr equ   s_temp3                  ;pointer to FST name string in FST hdr
5966 E760
5967 E760              o_fst_num equ   2                       ;offsets of fields in param block
5968 E760              o_file_sys_id equ   4
5969 E760              o_name_ptr equ   6
5970 E760              o_version equ   10
5971 E760              o_attributes equ   12
5972 E760              o_block_size equ   14
5973 E760              o_max_vol equ   16
5974 E760              o_max_file equ   20
5975 E760
5976 E760              h_file_sys_id equ   12                  ;offsets of fields in FST header
5977 E760              h_name   equ   36
5978 E760              h_version equ   16
5979 E760              h_attributes equ   14
5980 E760              h_block_size equ   18
5981 E760              h_max_vol equ   20
5982 E760              h_max_file equ   28
5983 E760              ;
5984 E760              ; Get pcount from parameter block and save it (it's already been screened for
5985 E760              ; minimum and maximum value.
5986 E760              ;
5987 E760 A7 32                 lda   [<param_blk_ptr]
5988 E762 85 D4                 sta   <pcount
5989 E764              ;
5990 E764              ; Check legality of fst_num input field
5991 E764              ;
5992 E764 A0 02 00              ldy   #o_fst_num               ;offset of fst_num field
5993 E767 B7 32                 lda   [<param_blk_ptr],y       ;get fst_num input
5994 E769 F0 19                 beq   param_range_err          ;illegal if 0
5995 E76B 3A                    dec   a                        ;A = fst_num - 1
5996 E76C CD 0F B8              cmp   |fst_count
5997 E76F 90 18                 bcc   go_on                    ;legal.
5998 E771 D0 11                 bne   param_range_err          ;illegal.
5999 E773              *
6000 E773              * If the fst_num is 1 greater than the actual number of FSTs loaded and the
6001 E773              * hs_fst_flag is set (indicating that the High Sierra/ISO 9660 FST is loaded),
6002 E773              * lets set up the pointer to our fake ISO 9660 fst header...
6003 E773              *
6004 E773 AD 25 B9              lda   hs_fst_flag              ;High Sierra FST present?
6005 E776 F0 0C                 beq   param_range_err          ;Nope, so error.
6006 E778
6007 E778 A9 27 B9              lda   #iso_fst_header          ;Yes, get pointer to header.
6008 E77B A2 00 00              ldx   #iso_fst_header>>16
6009 E77E 85 D8                 sta   <fst_hdr                 ;Save it.
6010 E780 86 DA                 stx   <fst_hdr+2
6011 E782 80 14                 bra   continue                 ;Continue.
6012 E784
6013 E784 A9 53 00     param_range_err lda   #parm_range_err
6014 E787 38                    sec   
6015 E788 60           outta_here rts   
6016 E789              ;
6017 E789              ; Set up pointer to FST header.
6018 E789              ;
6019 E789              go_on     
6020 E789 0A                    asl   a                        ;X =16*(fst_num - 1)
6021 E78A 0A                    asl   a                        ;...16 is entry size in FST table
6022 E78B 0A                    asl   a
6023 E78C 0A                    asl   a
6024 E78D AA                    tax   
6025 E78E
6026 E78E BD 11 B8              lda   |fst_tbl+fst_hdr_ptr,x   ;get pointer to fst header from
6027 E791 85 D8                 sta   <fst_hdr                 ;...FST table
6028 E793 BD 13 B8              lda   |fst_tbl+fst_hdr_ptr+2,x
6029 E796 85 DA                 sta   <fst_hdr+2
6030 E798              ;
6031 E798              ; Get the file system identification value.
6032 E798              ;
6033 E798 A0 0C 00     continue ldy   #h_file_sys_id
6034 E79B B7 D8                 lda   [<fst_hdr],y
6035 E79D A0 04 00              ldy   #o_file_sys_id
6036 E7A0 97 32                 sta   [<param_blk_ptr],y
6037 E7A2
6038 E7A2 C6 D4                 dec   <pcount                  ;see if there are any more outputs
6039 E7A4 C6 D4                 dec   <pcount                  ;...to process.  min pcount is 2
6040 E7A6 F0 3E                 beq   bounce_to_done
6041 E7A8              keep_going  
6042 E7A8              ;
6043 E7A8              ; Copy the FST name into the class 1 output string pointed to by name_ptr field
6044 E7A8              ; if the output buffer is big enough.  Otherwise, buffer too small error.
6045 E7A8              ;
6046 E7A8 A0 24 00              ldy   #h_name                  ;make A = length of FST name string in
6047 E7AB B7 D8                 lda   [<fst_hdr],y             ;...FST header
6048 E7AD 29 FF 00              and   #$00FF
6049 E7B0
6050 E7B0 A0 06 00              ldy   #o_name_ptr              ;Y = offset of output pointer parameter
6051 E7B3
6052 E7B3 20 A9 E5              jsr   chk_app_buf              ;make sure output buffer is big enough
6053 E7B6 F0 2C                 beq   skip_name                ;if it's null, just skip it
6054 E7B8 B0 CE                 bcs   outta_here               ;if not, buffer error, return carry set
6055 E7BA
6056 E7BA              buffer_ok                               ;buffer big enough, so copy string
6057 E7BA A5 D8                 lda   <fst_hdr                 ;make a pointer to the name string in
6058 E7BC 18                    clc                            ;...the FST header
6059 E7BD 69 24 00              adc   #h_name
6060 E7C0 85 DC                 sta   <name_ptr
6061 E7C2 A5 DA                 lda   <fst_hdr+2
6062 E7C4 69 00 00              adc   #$0000
6063 E7C7 85 DE                 sta   <name_ptr+2
6064 E7C9              ;
6065 E7C9              ; Now, copy the string.  name_ptr points to a class 0 string in the FST header,
6066 E7C9              ; and ptr (set by chk_app_buf) points to a class 1 string.
6067 E7C9              ;
6068 E7C9 E2 20                 sep   #m8                      ;8-bit m mode
6069 E7CB                       longa off
6070 E7CB
6071 E7CB A7 DC                 lda   [<name_ptr]              ;get string length
6072 E7CD 87 E8                 sta   [<ptr]                   ;store in low byte of output string len
6073 E7CF F0 0A                 beq   copy_done                ;copy done if string length is zero
6074 E7D1
6075 E7D1 A8                    tay                            ;otherwise, do the copy
6076 E7D2 B7 DC        copy_loop lda   [<name_ptr],y           ;get character from source
6077 E7D4 C8                    iny   
6078 E7D5 97 E8                 sta   [<ptr],y                 ;store in destination
6079 E7D7 88                    dey                            ;backing up one character in source
6080 E7D8 88                    dey                            ;...requires Y = Y-2
6081 E7D9 10 F7                 bpl   copy_loop
6082 E7DB
6083 E7DB              copy_done                               ;fix high byte of destination string len
6084 E7DB A0 01 00              ldy   #$0001
6085 E7DE A9 00                 lda   #$00
6086 E7E0 97 E8                 sta   [<ptr],y
6087 E7E2
6088 E7E2 C2 20                 rep   #m16                     ;back to 16-bit m mode
6089 E7E4                       longa on
6090 E7E4
6091 E7E4              skip_name  
6092 E7E4 C6 D4                 dec   <pcount
6093 E7E6              bounce_to_done  
6094 E7E6 F0 40                 beq   done
6095 E7E8              ;
6096 E7E8              ; Get version value.
6097 E7E8              ;
6098 E7E8 A0 10 00              ldy   #h_version
6099 E7EB B7 D8                 lda   [<fst_hdr],y
6100 E7ED A0 0A 00              ldy   #o_version
6101 E7F0 97 32                 sta   [<param_blk_ptr],y
6102 E7F2
6103 E7F2 C6 D4                 dec   <pcount
6104 E7F4 F0 32                 beq   done
6105 E7F6              ;
6106 E7F6              ; Get attributes value.
6107 E7F6              ;
6108 E7F6 A0 0E 00              ldy   #h_attributes
6109 E7F9 B7 D8                 lda   [<fst_hdr],y
6110 E7FB A0 0C 00              ldy   #o_attributes
6111 E7FE 97 32                 sta   [<param_blk_ptr],y
6112 E800
6113 E800 C6 D4                 dec   <pcount
6114 E802 F0 24                 beq   done
6115 E804              ;
6116 E804              ; Get block size.
6117 E804              ;
6118 E804 A0 12 00              ldy   #h_block_size
6119 E807 B7 D8                 lda   [<fst_hdr],y
6120 E809 A0 0E 00              ldy   #o_block_size
6121 E80C 97 32                 sta   [<param_blk_ptr],y
6122 E80E
6123 E80E C6 D4                 dec   <pcount
6124 E810 F0 16                 beq   done
6125 E812              ;
6126 E812              ; Get maximum volume size.
6127 E812              ;
6128 E812 A0 14 00              ldy   #h_max_vol
6129 E815 A2 12 00              ldx   #o_max_vol+2
6130 E818 20 2A E8              jsr   copy_longword
6131 E81B
6132 E81B C6 D4                 dec   <pcount
6133 E81D F0 09                 beq   done
6134 E81F              ;
6135 E81F              ; Get maximum file size.
6136 E81F              ;
6137 E81F A0 1C 00              ldy   #h_max_file
6138 E822 A2 16 00              ldx   #o_max_file+2
6139 E825 20 2A E8              jsr   copy_longword
6140 E828              done      
6141 E828 18                    clc                            ;indicate no error and return
6142 E829              buffer_error  
6143 E829 60                    rts   
6144 E82A
6145 E82A              ; This subroutine is used to copy a longword from the FST header to the
6146 E82A              ; parameter block.  Offset within FST header is passed in Y, offset in
6147 E82A              ; parameter block +2 is passed in X.
6148 E82A
6149 E82A              copy_longword  
6150 E82A DA                    phx                            ;save parm block offset
6151 E82B B7 D8                 lda   [<fst_hdr],y             ;get low word
6152 E82D AA                    tax                            ;save in X
6153 E82E C8                    iny   
6154 E82F C8                    iny   
6155 E830 B7 D8                 lda   [<fst_hdr],y             ;get high word
6156 E832
6157 E832 7A                    ply                            ;retrieve parmblock offset
6158 E833 97 32                 sta   [<param_blk_ptr],y       ;store high word
6159 E835 88                    dey   
6160 E836 88                    dey   
6161 E837 8A                    txa   
6162 E838 97 32                 sta   [<param_blk_ptr],y       ;store low word
6163 E83A 60                    rts   
6164 E83B
6165 E83B                       end_proc 
6166 E83B                       eject 
6167 E83B              ;===============================================================================
6168 E83B              ; set_sys_prefs:  Set the system preferences global variable
6169 E83B              ;
6170 E83B              ; Created:      1/22/88
6171 E83B              ; Modified:     7/20/88 Added error check for non-zero bits 14:0
6172 E83B              ; Author:       JJ
6173 E83B              ;
6174 E83B              ; Input:        A = <undefined>
6175 E83B              ;               X = <undefined>
6176 E83B              ;               Y = <undefined>
6177 E83B              ;               P = nvmxdizc
6178 E83B              ;                   ..000...
6179 E83B              ;               b = k
6180 E83B              ;
6181 E83B              ;               A = unchanged
6182 E83B              ;               X = unchanged
6183 E83B              ;               Y = unchanged
6184 E83B              ;               P = nvmxdizc
6185 E83B              ;                   ..000..0
6186 E83B              ;               b = k
6187 E83B              ;
6188 E83B              ;===============================================================================
6189 E83B
6190 E83B              set_sys_prefs proc 
6191 E83B
6192 E83B A0 02 00              ldy   #$0002                   ;offset of preferences field
6193 E83E B7 32                 lda   [<param_blk_ptr],y
6194 E840 89 FF 1F              bit   #%0001111111111111       ;are any reserved bits non-zero?
6195 E843 D0 06                 bne   prefs_error              ;yes, error
6196 E845
6197 E845 8F F6 B9 00           sta   >sys_prefs
6198 E849
6199 E849 18                    clc                            ;indicate no error and return
6200 E84A 60                    rts   
6201 E84B
6202 E84B A9 53 00     prefs_error lda   #parm_range_err       ;indicate error
6203 E84E 38                    sec   
6204 E84F 60                    rts   
6205 E850
6206 E850
6207 E850
6208 E850
6209 E850                       end_proc 
6210 E850                       eject 
6211 E850              ;===============================================================================
6212 E850              ; get_sys_prefs:  Get the system preferences global variable value.
6213 E850              ;
6214 E850              ; Created:      1/22/88
6215 E850              ; Modified:
6216 E850              ; Author:       JJ
6217 E850              ;
6218 E850              ; Input:        A = <undefined>
6219 E850              ;               X = <undefined>
6220 E850              ;               Y = <undefined>
6221 E850              ;               P = nvmxdizc
6222 E850              ;                   ..000...
6223 E850              ;               b = k
6224 E850              ;
6225 E850              ;               A = unchanged
6226 E850              ;               X = unchanged
6227 E850              ;               Y = unchanged
6228 E850              ;               P = nvmxdizc
6229 E850              ;                   ..000..0
6230 E850              ;               b = k
6231 E850              ;
6232 E850              ;===============================================================================
6233 E850
6234 E850              get_sys_prefs proc 
6235 E850
6236 E850 AF F6 B9 00           lda   >sys_prefs
6237 E854 A0 02 00              ldy   #$0002
6238 E857 97 32                 sta   [<param_blk_ptr],y
6239 E859
6240 E859 18                    clc                            ;indicate no error and return
6241 E85A 60                    rts   
6242 E85B
6243 E85B                       end_proc 
6244 E85B                       eject 
6245 E85B
6246 E85B              ;===============================================================================
6247 E85B              ; begin_session:  Begin a cache deferred writing session.
6248 E85B              ;
6249 E85B              ; Created:      1/22/88
6250 E85B              ; Modified:
6251 E85B              ; Author:       JJ
6252 E85B              ;
6253 E85B              ; Input:        A = <undefined>
6254 E85B              ;               X = <undefined>
6255 E85B              ;               Y = <undefined>
6256 E85B              ;               P = nvmxdizc
6257 E85B              ;                   ..000...
6258 E85B              ;               b = k
6259 E85B              ;
6260 E85B              ;               A = unchanged
6261 E85B              ;               X = unchanged
6262 E85B              ;               Y = unchanged
6263 E85B              ;               P = nvmxdizc
6264 E85B              ;                   ..000..0
6265 E85B              ;               b = k
6266 E85B              ;
6267 E85B              ;===============================================================================
6268 E85B
6269 E85B              begin_session proc 
6270 E85B
6271 E85B A9 01 00              lda   #$0001                   ;set session status to session
6272 E85E 8D FE B9              sta   session_stat
6273 E861
6274 E861 18                    clc                            ;indicate no error and return
6275 E862 60                    rts   
6276 E863
6277 E863                       end_proc 
6278 E863                       eject 
6279 E863              ;===============================================================================
6280 E863              ; end_session:  End a cache deferred writing session.
6281 E863              ;
6282 E863              ; Created:      1/22/88
6283 E863              ; Modified:     1/28/88 (Mikie)
6284 E863              ; Author:       JJ
6285 E863              ;
6286 E863              ; Input:        A = <undefined>
6287 E863              ;               X = <undefined>
6288 E863              ;               Y = <undefined>
6289 E863              ;               P = nvmxdizc
6290 E863              ;                   ..000...
6291 E863              ;               b = k
6292 E863              ;
6293 E863              ;               A = unchanged
6294 E863              ;               X = unchanged
6295 E863              ;               Y = unchanged
6296 E863              ;               P = nvmxdizc
6297 E863              ;                   ..000..0
6298 E863              ;               b = k
6299 E863              ;
6300 E863              ;===============================================================================
6301 E863
6302 E863              end_session proc 
6303 E863
6304 E863              ; Loop through all of the VCRs calling the owner through the FST system entry
6305 E863              ;  asking the FST to flush any deferred blocks on the volume.
6306 E863
6307 E863 9C FE B9              stz   session_stat             ;set session status to no session
6308 E866
6309 E866 A9 01 00              lda   #$0001                   ;Start with the first FST
6310 E869              more      
6311 E869 22 3C F9 00           jsl   getvcr                   ;Ask for the VCR
6312 E86D B0 2A                 bcs   done                     ;Past the last VCR
6313 E86F
6314 E86F 22 09 FE 00           jsl   deref2                   ;Deref VP into vcr_ptr
6315 E873 86 3E                 stx   <vcr_ptr
6316 E875 84 40                 sty   <vcr_ptr+2
6317 E877
6318 E877 A0 00 00              ldy   #vcr_id                  ;Get the volume id
6319 E87A B7 3E                 lda   [<vcr_ptr],y
6320 E87C 85 18                 sta   <drvr_vol_id
6321 E87E 38                    sec   
6322 E87F 22 04 FC 01           jsl   cache_find_blk
6323 E883 B0 0F                 bcs   next_vcr
6324 E885
6325 E885 A0 0A 00              ldy   #vcr_fst_id
6326 E888 B7 3E                 lda   [<vcr_ptr],y
6327 E88A 20 46 E2              jsr   find_fst
6328 E88D AA                    tax   
6329 E88E A9 08 00              lda   #flush_def
6330 E891 20 3B D5              jsr   do_fst
6331 E894
6332 E894              next_vcr  
6333 E894 A9 00 00              lda   #$0000                   ;Value for get next vcr
6334 E897 80 D0                 bra   more
6335 E899
6336 E899              done      
6337 E899
6338 E899 18                    clc                            ;indicate no error and return
6339 E89A 60                    rts   
6340 E89B
6341 E89B                       end_proc 
6342 E89B                       eject 
6343 E89B              ;===============================================================================
6344 E89B              ; session_status:  Determine whether or not a cache deferred writing session
6345 E89B              ;                  is in progress.
6346 E89B              ;
6347 E89B              ; Created:      1/22/88
6348 E89B              ; Modified:
6349 E89B              ; Author:       JJ
6350 E89B              ;
6351 E89B              ; Input:        A = <undefined>
6352 E89B              ;               X = <undefined>
6353 E89B              ;               Y = <undefined>
6354 E89B              ;               P = nvmxdizc
6355 E89B              ;                   ..000...
6356 E89B              ;               b = k
6357 E89B              ;
6358 E89B              ;               A = unchanged
6359 E89B              ;               X = unchanged
6360 E89B              ;               Y = unchanged
6361 E89B              ;               P = nvmxdizc
6362 E89B              ;                   ..000..0
6363 E89B              ;               b = k
6364 E89B              ;
6365 E89B              ;===============================================================================
6366 E89B
6367 E89B              session_status proc 
6368 E89B
6369 E89B AD FE B9              lda   session_stat
6370 E89E A0 02 00              ldy   #$0002
6371 E8A1 97 32                 sta   [<param_blk_ptr],y
6372 E8A3
6373 E8A3 18                    clc                            ;indicate no error and return
6374 E8A4 60                    rts   
6375 E8A5
6376 E8A5                       end_proc 
6377 E8A5                       eject 
6378 E8A5              ;===============================================================================
6379 E8A5              ; reset_cache:  Shutdown the cache and restart it
6380 E8A5              ;
6381 E8A5              ; Created:      April 6, 1988
6382 E8A5              ; Modified:     April 6, 1988
6383 E8A5              ; Author:       MSA
6384 E8A5              ;
6385 E8A5              ; Input:        A = <undefined>
6386 E8A5              ;               X = <undefined>
6387 E8A5              ;               Y = <undefined>
6388 E8A5              ;               P = nvmxdizc
6389 E8A5              ;                   ..000...
6390 E8A5              ;               b = k
6391 E8A5              ;
6392 E8A5              ;               A = unchanged
6393 E8A5              ;               X = unchanged
6394 E8A5              ;               Y = unchanged
6395 E8A5              ;               P = nvmxdizc
6396 E8A5              ;                   ..000..0
6397 E8A5              ;               b = k
6398 E8A5              ;
6399 E8A5              ;===============================================================================
6400 E8A5
6401 E8A5              reset_cache proc 
6402 E8A5
6403 E8A5 20 63 E8              jsr   end_session              ;Close out an active session!
6404 E8A8 22 52 A6 00           jsl   cash_shutdown
6405 E8AC 22 D6 A2 00           jsl   cash_init
6406 E8B0
6407 E8B0 60                    rts   
6408 E8B1
6409 E8B1                       end_proc 
6410 E8B1                       eject 
6411 E8B1              ;===============================================================================
6412 E8B1              ; os_shutdown:  Shutdown the cache and restart it
6413 E8B1              ;
6414 E8B1              ; Created:      June 14, 1988
6415 E8B1              ; Modified:     Sept 26, 1989  CAF
6416 E8B1              ; Author:       JJ
6417 E8B1              ;
6418 E8B1              ; Input:        A = <undefined>
6419 E8B1              ;               X = <undefined>
6420 E8B1              ;               Y = <undefined>
6421 E8B1              ;               P = nvmxdizc
6422 E8B1              ;                   ..000...
6423 E8B1              ;               b = k
6424 E8B1              ;
6425 E8B1              ;               A = unchanged
6426 E8B1              ;               X = unchanged
6427 E8B1              ;               Y = unchanged
6428 E8B1              ;               P = nvmxdizc
6429 E8B1              ;                   ..000..0
6430 E8B1              ;               b = k
6431 E8B1              ;
6432 E8B1              ;===============================================================================
6433 E8B1
6434 E8B1              os_shutdown proc 
6435 E8B1                       entry shutdown_reboot
6436 E8B1              ;
6437 E8B1              ; Equates
6438 E8B1              ;
6439 E8B1              Temp1    equ   s_temp1
6440 E8B1              TempRgn  equ   s_temp2
6441 E8B1              temp_flag equ   s_temp3
6442 E8B1              MMPowerFlag equ   $e115fe               ;Memory Manager power flag
6443 E8B1              ToolLocator equ   $e10000               ;Tool Locator entry point
6444 E8B1
6445 E8B1              window_frame equ   $ce                  ;Offset to wFrame.
6446 E8B1              clear_vis equ   $ffdf                   ;Clear vis bit in wFrame.
6447 E8B1
6448 E8B1              SetDeskPat equ   $5
6449 E8B1
6450 E8B1              *
6451 E8B1              * Normal entry just branches to check for valid shutdown flag...
6452 E8B1              *
6453 E8B1 80 05                 bra   check_flag               ;Do check.
6454 E8B3              *
6455 E8B3              * Alternate entry forces re-boot...
6456 E8B3              *
6457 E8B3                       Export shutdown_reboot
6458 E8B3 A9 01 00     shutdown_reboot lda   #0001             ;Force reboot.
6459 E8B6 80 11                 bra   set_flag
6460 E8B8              *
6461 E8B8              * Check for valid shutdown flag...
6462 E8B8              *
6463 E8B8 A0 02 00     check_flag ldy   #2                     ;Get offset to parameter.
6464 E8BB B7 32                 lda   [<param_blk_ptr],y       ;Get flag.
6465 E8BD 29 F8 FF              and   #%1111111111111000       ;Any bits other than 0, 1 & 2 set?
6466 E8C0 F0 05                 beq   get_flag                 ;Nope.
6467 E8C2 38                    sec                            ;Yes, indicate error.
6468 E8C3 A9 53 00              lda   #parm_range_err          ;Get error code.
6469 E8C6 60                    rts                            ;Exit.
6470 E8C7
6471 E8C7 B7 32        get_flag lda   [<param_blk_ptr],y       ;Get flag.
6472 E8C9 85 DC        set_flag sta   <temp_flag               ;Save it.
6473 E8CB              *
6474 E8CB              * Set shutdown flag to indicate that application has made a shutdown call and
6475 E8CB              * set warm_cold_flag to cold 'cuz we are doing a real shutdown...
6476 E8CB              *
6477 E8CB              ;	lda	#do_shutdown
6478 E8CB              ;	sta	>shutdown_flag
6479 E8CB A9 00 00              lda   #0000                    ;Set to cold shutdown.
6480 E8CE 8F D0 01 E1           sta   >warm_cold_flag
6481 E8D2              *
6482 E8D2              * Trash the Memory Manager power up byte if the caller requested it...
6483 E8D2              *
6484 E8D2 A5 DC                 lda   <temp_flag               ;Get flag.
6485 E8D4 29 02 00              and   #$0002                   ;Isolate the Memory Mgr trash bit
6486 E8D7              ;;;	beq	post_event	;Don't trash if the bit is 0
6487 E8D7 F0 0B                 beq   @noTrashMM               ;fixed 2-Sep-92 DAL (it was skipping DeskShutDown!)
6488 E8D9
6489 E8D9 AF FE 15 E1           lda   >MMPowerFlag             ;Zero out high byte of the word
6490 E8DD 29 FF 00              and   #$00ff
6491 E8E0 8F FE 15 E1           sta   >MMPowerFlag
6492 E8E4              @noTrashMM  
6493 E8E4
6494 E8E4              *
6495 E8E4              * Take care of NDAs (7/26/88 fix)
6496 E8E4              *
6497 E8E4              * 09/26/89 CAF  Moved _DeskShutDown to before the dispatch of the
6498 E8E4              *               gsos_shutdown event to the notification queue.  This
6499 E8E4              *               fixed a bug where sometimes the system would hang after
6500 E8E4              *               an OS_Shutdown call, due to the Desk Manager making a
6501 E8E4              *               call to the Resource Manager, which had been shut down
6502 E8E4              *               through the notification_queue already.
6503 E8E4              *
6504 E8E4 A2 05 03 22           _DeskShutDown                  ;Shut down the desk manager.
6505 E8EB
6506 E8EB              *
6507 E8EB              * Notify anyone in the os_event_queue who wants to know that we are shutting
6508 E8EB              * down...
6509 E8EB              *
6510 E8EB              post_event  
6511 E8EB              *** added 2-Sep-92 DAL, mainly for EtherTalk card
6512 E8EB              ; Call OS_P8_Switch vector with A = $0001 for leaving-GS/OS, for
6513 E8EB              ; things like the ETalk driver, which have no convenient way to
6514 E8EB              ; instally a notify proc on ROM 1.
6515 E8EB A9 01 00              lda   #$0001
6516 E8EE 22 B4 00 E1           jsl   >os_p8_switch
6517 E8F2              *** end 4-Jun-92
6518 E8F2 48                    pha                            ;Don't care about parms.
6519 E8F3 48                    pha   
6520 E8F4 48                    pha   
6521 E8F5 A9 20 00              lda   #gsos_shutdown           ;Get event code.
6522 E8F8 A2 00 00              ldx   #>gsos_shutdown
6523 E8FB 22 00 B3 00           jsl   >os_event                ;Let everyone know.
6524 E8FF              *
6525 E8FF              * Close all open files just in case someone was sloppy and left any open. 
6526 E8FF              * Ignore any errors...
6527 E8FF              *
6528 E8FF 22 13 D5 00           jsl   close_all_files          ;Make sure all files closed.
6529 E903              *
6530 E903              * Shut down the device dispatcher.  Ignore any errors.
6531 E903              *
6532 E903 64 00                 stz   <drvr_dev_num
6533 E905 A2 03 00              ldx   #3                       ;assume full shutdown
6534 E908 A5 DC                 lda   <temp_flag               ;get the flags for the call
6535 E90A 89 01 00              bit   #%00000001               ;restart call?
6536 E90D F0 06                 beq   @store_code              ;no...
6537 E90F 89 04 00              bit   #%00000100               ;force eject on restart?
6538 E912 D0 01                 bne   @store_code              ;yes...
6539 E914 CA                    dex                            ;else change into normal shutdown code
6540 E915              @store_code  
6541 E915 86 02                 stx   <drvr_call_num           ;store the proper shutdown code
6542 E917 22 00 FC 01           jsl   >dev_dispatcher
6543 E91B              *
6544 E91B              * Shut down SCM.  Ignore any errors.
6545 E91B              *
6546 E91B 22 7E D4 00           jsl   >shutdown_scm
6547 E91F
6548 E91F              *** added 9-Mar-93 DAL -- shut down DoRight thoroughly
6549 E91F A9 00 80              lda   #$8000
6550 E922 22 B4 00 E1           jsl   >os_p8_switch            ;A = $8000 for Shut Down
6551 E926              *** end 9-Mar-93
6552 E926
6553 E926              *
6554 E926              * Decide whether we are performing a restart or a power down.
6555 E926              *
6556 E926 A5 DC                 lda   <temp_flag               ;Get flag.
6557 E928              *** optimized 20-Jul-92 DAL
6558 E928              ;;;	and	#$0001	;isolate restart/powerdown bit.
6559 E928              ;;;	beq	PowerDown	;Do powerdown.
6560 E928 4A                    lsr   a
6561 E929 90 03                 bcc   PowerDown
6562 E92B              *** end 20-Jul-92 DAL
6563 E92B 4C D4 E9              jmp   restart                  ;Do restart.
6564 E92E              *
6565 E92E              * Power down...
6566 E92E              * Is the window manager active?
6567 E92E              *
6568 E92E              PowerDown  
6569 E92E A9 00 00              lda   #0                       ;init SysPrefs to ensure that the
6570 E931 8F F6 B9 00           sta   >sys_prefs               ; shutdown dialog is displayed
6571 E935
6572 E935 48                    pha                            ;Space for result.
6573 E936 A2 0E 06 22           _WindStatus                    ;Do call.
6574 E93D 68                    pla                            ;Get status. Active?
6575 E93E D0 03                 bne   active                   ;Yes.
6576 E940 4C C6 E9              jmp   do_dialog                ;Nope.
6577 E943              ;
6578 E943              ; Yes, so go through the window list and make the Window
6579 E943              ; Manager think that all the windows are invisible.
6580 E943              ;
6581 E943 48           active   pha                            ;Get pointer to first window.
6582 E944 48                    pha   
6583 E945 A2 0E 52 22           _GetFirstWindow 
6584 E94C 68 85 D4 68  pull_and_loop PullLong <Temp1 
6585 E952
6586 E952 05 D4        Loop     ora   <Temp1                   ;Nil pointer?
6587 E954 F0 19                 beq   done_windows             ;Yep, so we're done w/windows.
6588 E956
6589 E956 A0 CE 00              ldy   #window_frame            ;Get offset to wFrame.
6590 E959 B7 D4                 lda   [<temp1],y               ;Get frame value.
6591 E95B 29 DF FF              and   #clear_vis               ;Clear visible bit.
6592 E95E 97 D4                 sta   [<temp1],y               ;Save frame value.
6593 E960
6594 E960 48                    pha                            ;Get pointer to next window.
6595 E961 48                    pha   
6596 E962 D4 D6                 pei   <temp1+2
6597 E964 D4 D4                 pei   <temp1
6598 E966 A2 0E 2A 22           _GetNextWindow 
6599 E96D              *** opt 2-Sep-92 DAL
6600 E96D              ;;;	PullLong <Temp1
6601 E96D              ;;;	bra	loop	;Next.
6602 E96D 80 DD                 bra   pull_and_loop
6603 E96F              *** end 2-Sep-92
6604 E96F
6605 E96F              done_windows  
6606 E96F              ;
6607 E96F              ; Now, we add the menu bar area to the desk top
6608 E96F              ; region.  This way when we re-draw the desktop,
6609 E96F              ; the menu bar will be erased too.
6610 E96F              ;
6611 E96F 48                    pha                            ; get a temp rgn
6612 E970 48                    pha   
6613 E971 A2 04 67 22           _NewRgn 
6614 E978 A3 01                 lda   1,s                      ;save region
6615 E97A 85 D8                 sta   <TempRgn                 ;but leave on stack for RectRgn call
6616 E97C A3 03                 lda   3,s
6617 E97E 85 DA                 sta   <TempRgn+2
6618 E980
6619 E980 F4 00 00 F4           PushLong #SizeRect             ; set the rgn to size of screen
6620 E986 A2 04 6C 22           _RectRgn 
6621 E98D
6622 E98D 48                    pha                            ; add this to desktop rgn
6623 E98E 48                    pha   
6624 E98F F4 01 00              PushWord #1 
6625 E992 D4 DA                 pei   <TempRgn+2
6626 E994 D4 D8                 pei   <TempRgn
6627 E996 A2 0E 0C 22           _DeskTop 
6628 E99D 68                    pla                            ; remove unused output of desktop
6629 E99E 68                    pla                            ; call
6630 E99F
6631 E99F D4 DA                 pei   <TempRgn+2               ;Get rid of temp rgn.
6632 E9A1 D4 D8                 pei   <TempRgn
6633 E9A3 A2 04 68 22           _DisposeRgn 
6634 E9AA              ;
6635 E9AA              ; Finally, set the desktop pattern to black
6636 E9AA              ;
6637 E9AA
6638 E9AA              *** opt 2-Sep-92 DAL -- Saved 4 bytes, because Desktop(SetDeskPat) does not use return value!
6639 E9AA              ;;;	pha
6640 E9AA              ;;;	pha
6641 E9AA F4 05 00              PushWord #SetDeskPat 
6642 E9AD F4 00 40 F4           PushLong #$40000000 
6643 E9B3 A2 0E 0C 22           _DeskTop 
6644 E9BA              ;;;	pla
6645 E9BA              ;;;	pla
6646 E9BA
6647 E9BA              ;
6648 E9BA              ; Refresh the desk top.
6649 E9BA              ;
6650 E9BA              *** opt 20-Jul-92 DAL
6651 E9BA              ;;;	PushLong #SizeRect
6652 E9BA A9 00 00              lda   #0
6653 E9BD 48                    pha   
6654 E9BE 48                    pha   
6655 E9BF              *** end 20-Jul-92 DAL
6656 E9BF A2 0E 39 22           _RefreshDeskTop 
6657 E9C6              ;
6658 E9C6              ; Put up the power down dialog.
6659 E9C6              ;
6660 E9C6 F4 21 00     do_dialog pea   33                      ;error message number for shutdown
6661 E9C9 A9 00 00              lda   #$0
6662 E9CC 48                    pha                            ;push two null pointers
6663 E9CD 48                    pha   
6664 E9CE 48                    pha   
6665 E9CF 48                    pha   
6666 E9D0 22 58 EF 00           jsl   s_report_error           ;call the error message handler
6667 E9D4              ;
6668 E9D4              ; Do a restart.
6669 E9D4              ;
6670 E9D4 4C F6 EF     restart  jmp   restart_system
6671 E9D7
6672 E9D7
6673 E9D7                       end_proc 
6674 E9D7                       eject 
6675 E9D7              ;===============================================================================
6676 E9D7              ; quit
6677 E9D7              ;
6678 E9D7              ; Handle the QUIT call
6679 E9D7              ;
6680 E9D7              ; Created:      10/13/87
6681 E9D7              ; Modified:
6682 E9D7              ; Author:       JJ
6683 E9D7              ;
6684 E9D7              ; Input:        A = <undefined>
6685 E9D7              ;               X = <undefined>
6686 E9D7              ;               Y = <undefined>
6687 E9D7              ;               P = nvmxdizc
6688 E9D7              ;                   ..000...
6689 E9D7              ;               b = k
6690 E9D7              ;
6691 E9D7              ; Output:       This routine never returns.
6692 E9D7              ;
6693 E9D7              ; This routine sets up the environment for GQUIT as follows:
6694 E9D7              ;
6695 E9D7              ;               A = <undefined>
6696 E9D7              ;               X = If there is a pathname, and it is a partial pathname, X
6697 E9D7              ;                   gives the prefix number expressed by the prefix designator
6698 E9D7              ;                   In all other cases, X = $FFFF
6699 E9D7              ;               Y = $0000 if this was a class 0 QUIT call
6700 E9D7              ;                   $0002 if this was a class 1 QUIT call
6701 E9D7              ;               D = the GS/OS direct page $BD00
6702 E9D7              ;               S = the GS/OS stack
6703 E9D7              ;               P = nvmxdizc
6704 E9D7              ;                   ..000...
6705 E9D7              ;===============================================================================
6706 E9D7
6707 E9D7              do_quit  proc 
6708 E9D7              *
6709 E9D7              * If it's a class 1 call, check to see if pathname is present...
6710 E9D7              *
6711 E9D7 AC A2 B9              ldy   |class
6712 E9DA F0 04                 beq   check_path_ptr           ;branch if class 0
6713 E9DC A7 32                 lda   [<param_blk_ptr]         ;Get pcount.
6714 E9DE F0 25                 beq   no_pathname              ;branch ahead if there is no pathname
6715 E9E0              ;
6716 E9E0              ; Here, we know there is a pathname field.  Check to see if it is null pointer.
6717 E9E0              ;
6718 E9E0 B7 32        check_path_ptr lda   [<param_blk_ptr],y ;check low word of pathname pointer
6719 E9E2 D0 06                 bne   translate_path
6720 E9E4 C8                    iny   
6721 E9E5 C8                    iny   
6722 E9E6 B7 32                 lda   [<param_blk_ptr],y       ;check high word of pathname pointer
6723 E9E8 F0 1B                 beq   no_pathname
6724 E9EA              ;
6725 E9EA              ; Perform translation on the pathname.
6726 E9EA              ;
6727 E9EA A2 00 00     translate_path ldx   #0                 ;set default prefix to prefix 0
6728 E9ED 9C 19 B9              stz   |fst_flags               ;do not upper case letters
6729 E9F0 9C AE B9              stz   |xlate_count             ;indicate that this is the first path
6730 E9F3 AD A2 B9              lda   |class                   ;offset of pathname pointer
6731 E9F6 20 29 DD              jsr   xlate_path2              ;perform pathname translation
6732 E9F9 B0 14                 bcs   syntax_error
6733 E9FB              ;
6734 E9FB              ; Get value indicating prefix number into X.  This was set by xlate_path.
6735 E9FB              ; And, put class value in Y.
6736 E9FB              ;
6737 E9FB AE B6 B9              ldx   |prefix_number
6738 E9FE AC A2 B9              ldy   |class
6739 EA01              ;
6740 EA01              ; Set shutdown flag to indicate that a GQUIT is in progress
6741 EA01              ;
6742 EA01              call_gquit  
6743 EA01              ;	lda	#do_gquit
6744 EA01              ;	sta	>shutdown_flag
6745 EA01
6746 EA01              ;
6747 EA01              ; Transfer control to GQUIT.
6748 EA01              ;
6749 EA01 5C 4B D1 E0           jmp   >p16quit
6750 EA05              ;
6751 EA05              ; We can never get back here.
6752 EA05              ;
6753 EA05 64 42        no_pathname stz   <path_flag            ;set path flags to indicate no file name
6754 EA07 A2 FF FF              ldx   #$FFFF                   ;indicate there was no partial pathname
6755 EA0A AC A2 B9              ldy   |class                   ;set the class
6756 EA0D 80 F2                 bra   call_gquit
6757 EA0F
6758 EA0F A9 40 00     syntax_error lda   #bad_path_syntax
6759 EA12
6760 EA12 38           error_tail sec   
6761 EA13 60                    rts   
6762 EA14
6763 EA14                       end_proc 
6764 EA14
6765 EA14                       eject 
6766 EA14              ;===============================================================================
6767 EA14              ; new_volume_call
6768 EA14              ;
6769 EA14              ; Handle new style of Volume call, with additional parameters
6770 EA14              ;
6771 EA14              ; Created:      02/21/91
6772 EA14              ; Modified:
6773 EA14              ; Author:       Greg Branche
6774 EA14              ;
6775 EA14              ; Input:        A = <undefined>
6776 EA14              ;               X = <undefined>
6777 EA14              ;               Y = <undefined>
6778 EA14              ;               P = nvmxdizc
6779 EA14              ;                   ..000...
6780 EA14              ;               b = k
6781 EA14              ;
6782 EA14              ;===============================================================================
6783 EA14
6784 EA14              new_volume_call Proc 
6785 EA14
6786 EA14                       Import e1_volume_call
6787 EA14
6788 EA14 A7 32                 lda   [<param_blk_ptr]         ;get the pCount
6789 EA16 C9 07 00              cmp   #$0007                   ;old-style call?
6790 EA19 90 09                 bcc   old_call                 ;yes, just handle like before
6791 EA1B 48                    pha                            ;save pCount
6792 EA1C A9 06 00              lda   #$0006                   ;reset to old maximum to keep
6793 EA1F 87 32                 sta   [<param_blk_ptr]         ;...the FSTs happy
6794 EA21 F4 26 EA              pea   new_call-1               ;push a return address
6795 EA24
6796 EA24 4C CA D7     old_call jmp   do_type_2                ;go handle the old way
6797 EA27
6798 EA27              new_call                                ;returns to here for new-style call
6799 EA27 A8                    tay                            ;save any error code returned from FST
6800 EA28 68                    pla                            ;retrieve original pCount
6801 EA29 87 32                 sta   [<param_blk_ptr]         ;put back into parm block
6802 EA2B 08                    php                            ;save carry
6803 EA2C 5A                    phy                            ;save possible error code
6804 EA2D 22 43 DB E1           jsl   e1_volume_call           ;call the handler in bank $E1
6805 EA31 68                    pla                            ;restore error code
6806 EA32 28                    plp                            ;and carry
6807 EA33 60                    rts   
6808 EA34
6809 EA34                       end_proc 
6810 EA34
6811 EA34                       eject 
6812 EA34              ;===============================================================================
6813 EA34              ; Interrupt and Event Subsystems
6814 EA34              ;===============================================================================
6815 EA34
6816 EA34              ;===============================================================================
6817 EA34              ; Interrupt Subsystem Code
6818 EA34              ;===============================================================================
6819 EA34              ;
6820 EA34              ; The interrupt subsystem consists of modules in the language card and modules
6821 EA34              ; in bank $00 below the language card.  The language card modules are as
6822 EA34              ; follows:
6823 EA34              ;
6824 EA34              ; interrupt_data        Global data for the interrupt subsystem
6825 EA34              ; init_int              Interrupt subsystem initialization
6826 EA34              ; alloc_int             ALLOC_INTERRUPT system call
6827 EA34              ; dealloc_int           DEALLOC_INTERRUPT system call
6828 EA34              ; bind_int              BIND_INT system service call
6829 EA34              ; unbind_int            UNBIND_INT system service call
6830 EA34              ; dispatch_int          interrupt dispatcher
6831 EA34              ; shutdown_int          shut down the interrupt system
6832 EA34              ;
6833 EA34              ; The module below the language card is as follows:
6834 EA34              ;
6835 EA34              ; below_lc_int          interrupt handler vectoring and dispatching stub
6836 EA34              ;
6837 EA34              ;===============================================================================
6838 EA34
6839 EA34              ;===============================================================================
6840 EA34              ; interrupt_data
6841 EA34              ;===============================================================================
6842 EA34
6843 EA34              interrupt_data proc 
6844 EA34
6845 EA34                       entry vrn_to_index
6846 EA34                       entry loc_1
6847 EA34                       entry loc_2
6848 EA34                       entry next_avail_vrn
6849 EA34                       entry past_avail_vrn
6850 EA34                       entry vect_disp_base
6851 EA34                       entry vect_disp_hand
6852 EA34                       entry vect_ref_num
6853 EA34                       entry int_hand_addr
6854 EA34                       entry handled
6855 EA34              ;
6856 EA34              ; Interrupt Identification Table.  This data structure is a dynalist in which
6857 EA34              ; each entry contains a virtual pointer to an interrupt control record.  The
6858 EA34              ; entry's index is the interrupt id number corresponding to a specific binding
6859 EA34              ; between an interrupt source and its interrupt handler.
6860 EA34              ;
6861 EA34              ;
6862 EA34              ; Interrupt Control Record.  These records contain all the information needed to
6863 EA34              ; execute an interrupt handler.  There are two ways to get to interrupt control
6864 EA34              ; records:  1) each interrupt identification table entry points directly to a
6865 EA34              ; single ICR and 2) each ICR is on a linked list of ICRs corresponding to the
6866 EA34              ; same firmware interrupt vector.  The format of an ICR is as follows:
6867 EA34              ;
6868 EA34              ;  ________________________________________________________________
6869 EA34              ; | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | |
6870 EA34              ; |        VP to next ICR corresponding to specific VRN           |
6871 EA34              ; |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
6872 EA34              ;
6873 EA34              ;  ________________________________________________________________
6874 EA34              ; | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | |
6875 EA34              ; |        VP to previous ICR corresponding to specific VRN       |
6876 EA34              ; |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
6877 EA34              ;
6878 EA34              ;  ________________________________________________________________
6879 EA34              ; | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | |
6880 EA34              ; |              Interrupt Handler Memory Address                 |
6881 EA34              ; |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
6882 EA34              ;
6883 EA34              ;                                  ________________________________
6884 EA34              ;                                 | | | | | | | | | | | | | | | | |
6885 EA34              ;                                 |              VRN              |
6886 EA34              ;                                 |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
6887 EA34              ;
6888 EA34              ; Normally, only offsets to handler and vrn fields are needed.
6889 EA34              ;
6890 EA34              ;
6891 EA34              ; VRN to VI Translation Table.  This table holds the information needed to
6892 EA34              ; translate a vector reference number (VRN) into an index (not byte offset) to
6893 EA34              ; the Vector Table entry corresponding to the VRN.  The table consists of
6894 EA34              ; 3-word entries.  The first two words of each entry represent a range of legal
6895 EA34              ; VRN values.  If the input VRN falls between the two values, the output index
6896 EA34              ; is the input VRN value minus the value of the third word.  Value of $00
6897 EA34              ; in the first word of an entry indicates the current end of table.
6898 EA34              ;
6899 EA34 08 00 17 00  vrn_to_index DC W:$08,$17,$07           ;map VRNs $8-$17 into indexes $01-$10
6900 EA3A 00 00 00 00  loc_1    DC W:$00,$00,$00               ;reserved for future expansion
6901 EA40 00 00 00 00           DC W:$00,$00,$00               ;reserved for future expansion
6902 EA46 00 00 00 00           DC W:$00,$00,$00               ;reserved for future expansion
6903 EA4C 00 00        loc_2    DC W:$00
6904 EA4E
6905 EA4E 3A EA        next_avail_vrn DC W:loc_1               ;address of next available entry
6906 EA50 4C EA        past_avail_vrn DC W:loc_2               ;address just past available entries
6907 EA52              ;
6908 EA52              ; Vector Table.  This is a table of headers to linked lists of ICRs.  The table
6909 EA52              ; is indexed by Vector Index (VI), which is an arbitrary index assigned to each
6910 EA52              ; firmware interrupt vector.  The Vector to Index Translation Table provides
6911 EA52              ; the translation from VRNs to VIs.  Each linked list consists of the ICRs for
6912 EA52              ; interrupt handlers bound to the particular firmware interrupt vector.  This
6913 EA52              ; table is actually allocated in the memory controlled by the GIM.
6914 EA52              ;
6915 EA52              ;  VI  Offset in        Corresponding vector
6916 EA52              ;      GIM Tables
6917 EA52              ;
6918 EA52              ; $00  icr_list         P16 interrupt handlers
6919 EA52              ; $01  icr_list+4       irq.aptalk
6920 EA52              ; $02          +8       irq.serial
6921 EA52              ; $03          +12      irq.scan
6922 EA52              ; $04          +16      irq.sound
6923 EA52              ; $05          +20      irq.vbl
6924 EA52              ; $06          +24      irq.mouse
6925 EA52              ; $07          +28      irq.qtr
6926 EA52              ; $08          +32      irq.kbd
6927 EA52              ; $09          +36      irq.response
6928 EA52              ; $0A          +40      irq.srq
6929 EA52              ; $0B          +44      irq.dskacc
6930 EA52              ; $0C          +48      irq.flush
6931 EA52              ; $0D          +52      irq.micro
6932 EA52              ; $0E          +56      irq.1sec
6933 EA52              ; $0F          +60      irq.ext
6934 EA52              ; $10          +64      irq.other
6935 EA52              ; $11          +68      reserved for expansion
6936 EA52              ; $12          +72      reserved for expansion
6937 EA52              ; $13          +76      reserved for expansion
6938 EA52              ; $14          +80      reserved for expansion
6939 EA52              ; $15          +84      reserved for expansion
6940 EA52              ; $16          +88      reserved for expansion
6941 EA52              ; $17          +92      reserved for expansion
6942 EA52              ; $18          +96      reserved for expansion
6943 EA52              ;
6944 EA52              ; Vector Dispatch Table.  This is a table that must be located in memory
6945 EA52              ; below the language card.  GS/OS patches the firmware interrupt vectors
6946 EA52              ; to point to entries in this table.  Each entry is an instruction sequence
6947 EA52              ; of the form:  ldx #vi   bra common.  vi is the vector index corresponding
6948 EA52              ; to the interrupt vector and common is the label on common processing code
6949 EA52              ; that appears after the other table entries.
6950 EA52              ;
6951 EA52              ; The interrupt system initializer (int_init) constructs the table in managed
6952 EA52              ; memory.  It puts the address of the table into vect_disp_base and the handle
6953 EA52              ; to the table in vect_disp_hand.
6954 EA52              ;
6955 EA52 77 77 02 00  vect_disp_base DC L:00000000            ;base address of Vector Dispatch Table
6956 EA56 BC 19 E1 00  vect_disp_hand DC L:00000000            ;handle of the Vector Dispatch Table
6957 EA5A              ;
6958 EA5A              ; Data used by alloc_interrupt and bind_int
6959 EA5A              ;
6960 EA5A 00 00        vect_ref_num DC W:0000                  ;vector reference number from bind_int
6961 EA5C                                                      ;...call ($0000 for alloc_interrupt)
6962 EA5C 00 00 00 00  int_hand_addr DC L:00000000             ;handler address from alloc_interrupt
6963 EA60                                                      ;...or bind_int
6964 EA60 00 00        handled  DC W:0000                      ;when polling interrupt handlers tied
6965 EA62                                                      ;...to a specific VRN, tells whether or
6966 EA62                                                      ;...not the interrupt has been handled
6967 EA62                                                      ;$0000 = not yet handled
6968 EA62                                                      ;$8000 = already handled
6969 EA62                       end_proc 
6970 EA62                       eject 
6971 EA62              ;===============================================================================
6972 EA62              ; init_int
6973 EA62              ;
6974 EA62              ; Initialize the interrupt manager data structures.
6975 EA62              ;===============================================================================
6976 EA62
6977 EA62              ; init_int assumes that DBR is set to 0 (our program bank)
6978 EA62              init_int proc 
6979 EA62
6980 EA62 08                    php                            ;save interrupt state
6981 EA63 78                    sei                            ;disable interrupts
6982 EA64              ;
6983 EA64              ; Set the user interrupt vector at $00/03FF-$00/3FFE to point to the GS/OS
6984 EA64              ; interrupt system entry point below the language card in bank $00.
6985 EA64              ;
6986 EA64 A9 FD 9E              lda   #user_int_entry
6987 EA67 8D FE 03              sta   user_int_vector
6988 EA6A              *
6989 EA6A              * If we're doing a warm startup, we're done...
6990 EA6A              *
6991 EA6A AF D0 01 E1           lda   >warm_cold_flag          ;Warm startup?
6992 EA6E D0 50                 bne   out                      ;Yes, so done.
6993 EA70              ;
6994 EA70              ; The Interrupt Identification Table dynalist is set up by init_gim.
6995 EA70              ;
6996 EA70              ; init_gim also sets every vp in the Vector Table to null.
6997 EA70              ;
6998 EA70              ; Allocate and initialize the Vector Dispatch Table.  Each 4-byte entry in this
6999 EA70              ; table consists of the instruction sequence ldx #vi bra common.  At the label
7000 EA70              ; common is the instruction jml common_disp_ent.  This instruction is at the end
7001 EA70              ; of this table.
7002 EA70              ;
7003 EA70              ; First, allocate a fixed memory segment of sufficient size.
7004 EA70              ;
7005 EA70 A9 68 00              lda   #vect_disp_len+4         ;length of MM segment
7006 EA73 20 9E FF              jsr   grab_fixed_seg           ;allocate the segment
7007 EA76 B0 4B                 bcs   mm_error                 ;handle memory manager error
7008 EA78 8E 56 EA              stx   |vect_disp_hand          ;save handle for later deallocation
7009 EA7B 8C 58 EA              sty   |vect_disp_hand+2
7010 EA7E 20 D9 FF              jsr   lock_hand                ;lock the segment into position
7011 EA81 20 79 FC              jsr   mm_deref                 ;dereference the handle
7012 EA84 8E 52 EA              stx   |vect_disp_base          ;save pointer to the segment
7013 EA87 8C 54 EA              sty   |vect_disp_base+2
7014 EA8A 86 E8                 stx   <ptr                     ;also save it on direct page
7015 EA8C 84 EA                 sty   <ptr+2
7016 EA8E              ;
7017 EA8E              ; Next, copy the jml common_disp_ent assembled at the label qb7 into the last
7018 EA8E              ; 4 bytes of the table.
7019 EA8E              ;
7020 EA8E A0 66 00              ldy   #vect_disp_len+2         ;offset of last word in table
7021 EA91              ;	lda	|qb7+2	;get two high bytes of address operand
7022 EA91 A9 9F 00              lda   #common_int_ent>>8       ;get two high bytes of address operand
7023 EA94 97 E8                 sta   [<ptr],y                 ;...and store them in table
7024 EA96 88                    dey   
7025 EA97 88                    dey   
7026 EA98              ;	lda	|qb7	;get opcode and low byte of operand
7027 EA98                       datachk off
7028 EA98 A9 5C 25              lda   #((common_int_ent<<8)+$5c) ;get opcode (JML) and low byte of operand
7029 EA9B                       datachk on
7030 EA9B 97 E8                 sta   [<ptr],y                 ;...and store them in table
7031 EA9D              ;
7032 EA9D              ; Now, set up to put the ldx #vi bra common instruction sequences into the
7033 EA9D              ; table.  Start at the last entry in the table and move toward the beginning.
7034 EA9D              ;
7035 EA9D A9 18 00              lda   #num_vects-1             ;highest vector number to low byte of A
7036 EAA0 09 00 A2              ora   #$A200                   ;LDX# opcode to high byte of A
7037 EAA3 EB                    xba                            ;swap to get right opcode/operand order
7038 EAA4 AA                    tax                            ;save in X
7039 EAA5 A9 80 00              lda   #$0080                   ;BRA $00 instruction to A
7040 EAA8              ;
7041 EAA8              ; Begin storing instructions into the table.
7042 EAA8              ;
7043 EAA8 88           loop_2   dey                            ;set offset for branch instruction
7044 EAA9 88                    dey   
7045 EAAA 30 14                 bmi   out
7046 EAAC 97 E8                 sta   [<ptr],y                 store branch
7047 EAAE 48                    pha                            ;save branch
7048 EAAF 8A                    txa                            ;get the LDX #
7049 EAB0 88                    dey                            ;set offset for load A instruction
7050 EAB1 88                    dey   
7051 EAB2 97 E8                 sta   [<ptr],y                 ;store the LDX #
7052 EAB4 38                    sec                            ;decrement the immediate value in LDX#
7053 EAB5 E9 00 01              sbc   #$0100
7054 EAB8 AA                    tax                            ;...and save result in X
7055 EAB9 68                    pla                            ;recover branch instruction
7056 EABA 18                    clc                            ;add 4 to the branch offset
7057 EABB 69 00 04              adc   #$0400
7058 EABE 80 E8                 bra   loop_2                   ;do it some more
7059 EAC0
7060 EAC0              ;qb7	jml	common_int_ent	;convenient place to put instruction
7061 EAC0                                                      ;... to be copied into Vector Disp Tbl
7062 EAC0
7063 EAC0 28           out      plp                            ;restore interrupt state
7064 EAC1 18                    clc                            ;indicate no error
7065 EAC2 60                    rts   
7066 EAC3
7067 EAC3 28           mm_error plp                            ;restore interrupt state
7068 EAC4 38                    sec                            ;indicate error
7069 EAC5 60                    rts   
7070 EAC6
7071 EAC6                       end_proc 
7072 EAC6                       eject 
7073 EAC6              ;===============================================================================
7074 EAC6              ; alloc_int
7075 EAC6              ;===============================================================================
7076 EAC6
7077 EAC6              alloc_int proc 
7078 EAC6
7079 EAC6
7080 EAC6              o_int_num equ   0                       ;offset of int_num field in parm blk
7081 EAC6              o_int_code equ   2                      ;offset of int_code field in parm blk
7082 EAC6              ;
7083 EAC6              ; Set up parameters for call to build_icr.
7084 EAC6              ;
7085 EAC6 A0 02 00              ldy   #o_int_code              ;offset of int_code field in parm blk
7086 EAC9 B7 32                 lda   [<param_blk_ptr],y       ;get low word of handler address
7087 EACB AA                    tax                            ;move low word handler address to X
7088 EACC C8                    iny   
7089 EACD C8                    iny   
7090 EACE B7 32                 lda   [<param_blk_ptr],y       ;get high word of handler address
7091 EAD0 A8                    tay                            ;move high word handler address to Y
7092 EAD1
7093 EAD1 A9 00 00              lda   #$0000                   ;vrn=$0000 for P16-style int handlers
7094 EAD4
7095 EAD4 20 04 FA              jsr   build_icr                ;set up the interrupt data structures
7096 EAD7 B0 03                 bcs   build_icr_err            ;branch ahead if there was an error
7097 EAD9
7098 EAD9 87 32                 sta   [<param_blk_ptr]         ;return int_num (interrupt id)
7099 EADB
7100 EADB 60                    rts                            ;carry must be clear
7101 EADC
7102 EADC C9 01 00     build_icr_err cmp   #$0001              ;is it an invalid vrn?
7103 EADF D0 05                 bne   not1
7104 EAE1 A9 53 00     empty_vect_err lda   #parm_range_err    ;translate to parameter range error
7105 EAE4 38                    sec   
7106 EAE5 60                    rts   
7107 EAE6
7108 EAE6 A9 25 00     not1     lda   #irq_table_full          ;otherwise, must be memory unavailable
7109 EAE9 38                    sec   
7110 EAEA 60                    rts   
7111 EAEB
7112 EAEB                       end_proc 
7113 EAEB                       eject 
7114 EAEB              ;===============================================================================
7115 EAEB              ; bind_int
7116 EAEB              ;
7117 EAEB              ; Bind an interrupt source (represented by its firmware vector reference number)
7118 EAEB              ;===============================================================================
7119 EAEB
7120 EAEB              bind_int proc 
7121 EAEB
7122 EAEB              o_pcount equ   0                        ;offset of parameter count field
7123 EAEB              o_int_num equ   2                       ;offset of int_num field in parm blk
7124 EAEB              o_vrn_parm equ   4                      ;offset of vrn field in parm block
7125 EAEB              o_int_code equ   6                      ;offset of int_code field in parm blk
7126 EAEB              ;
7127 EAEB              ; First, determine if firmware vector needs to be patched and do the patch if
7128 EAEB              ; necessary.
7129 EAEB              ;
7130 EAEB A0 04 00              ldy   #o_vrn_parm              ;offset of vrn in parameter block
7131 EAEE B7 32                 lda   [<param_blk_ptr],y       ;get the vrn value
7132 EAF0 F0 2B                 beq   parm_error               ;vrn=$0000 is illegal (special case)
7133 EAF2 48                    pha                            ;save it
7134 EAF3 20 B9 FA              jsr   empty_vect               ;has the vector been patched yet?
7135 EAF6 B0 30                 bcs   empty_vect_err           ;c=1 means invalid vrn
7136 EAF8 D0 07                 bne   after_patch              ;no, jump ahead
7137 EAFA
7138 EAFA 68           patch    pla                            ;get the vrn value back
7139 EAFB 48                    pha                            ;re-save it, too
7140 EAFC 20 75 FA              jsr   patch_vector             ;patch the firmware vector
7141 EAFF B0 21                 bcs   patch_vect_err
7142 EB01              ;
7143 EB01              ; Make a new ICR for the interrupt handler and insert it in the interrupt
7144 EB01              ; manager data structures.
7145 EB01              ;
7146 EB01 A0 06 00     after_patch ldy   #o_int_code           ;offset of interrupt handler address
7147 EB04 B7 32                 lda   [<param_blk_ptr],y       ;get low word of handler address
7148 EB06 AA                    tax   
7149 EB07 C8                    iny   
7150 EB08 C8                    iny   
7151 EB09 B7 32                 lda   [<param_blk_ptr],y       ;get high word of handler address
7152 EB0B A8                    tay   
7153 EB0C 68                    pla                            ;recover vrn value
7154 EB0D
7155 EB0D 20 04 FA              jsr   build_icr                ;build an ICR for this handler
7156 EB10 B0 06                 bcs   build_icr_err
7157 EB12
7158 EB12 A0 02 00              ldy   #o_int_num               ;offset of interrupt ident field
7159 EB15 97 32                 sta   [<param_blk_ptr],y       ;return int ident to user
7160 EB17
7161 EB17 60                    rts                            ;carry must be clear
7162 EB18
7163 EB18 C9 01 00     build_icr_err cmp   #$0001              ;is it an invalid vrn?
7164 EB1B D0 06                 bne   not1
7165 EB1D A9 53 00     parm_error lda   #parm_range_err        ;translate to parameter range error
7166 EB20 38                    sec   
7167 EB21 60                    rts   
7168 EB22
7169 EB22 68           patch_vect_err pla   
7170 EB23
7171 EB23 A9 25 00     not1     lda   #irq_table_full          ;otherwise, must be memory unavailable
7172 EB26 38                    sec   
7173 EB27 60                    rts   
7174 EB28
7175 EB28 68           empty_vect_err pla   
7176 EB29 80 F2                 bra   parm_error
7177 EB2B
7178 EB2B                       end_proc 
7179 EB2B                       eject 
7180 EB2B              ;===============================================================================
7181 EB2B              ; dealloc_int
7182 EB2B              ;===============================================================================
7183 EB2B
7184 EB2B              dealloc_int proc 
7185 EB2B
7186 EB2B              o_int_num equ   0                       ;offset of int_num field in parm blk
7187 EB2B
7188 EB2B A0 00 00              ldy   #o_int_num               ;get int_num from parameter block
7189 EB2E B7 32                 lda   [<param_blk_ptr],y
7190 EB30
7191 EB30 20 C4 FA              jsr   wreck_icr                ;get rid of the ICR
7192 EB33 A9 53 00              lda   #parm_range_err          ;Set code in case error.
7193 EB36 60                    rts                            ;normal return, carry clear
7194 EB37
7195 EB37                       end_proc 
7196 EB37                       eject 
7197 EB37              ;===============================================================================
7198 EB37              ; unbind_int
7199 EB37              ;
7200 EB37              ; Unbind a previously formed binding between a firmware vector and a GS/OS
7201 EB37              ; interrupt handler.
7202 EB37              ;===============================================================================
7203 EB37              unbind_int_vec PROC 
7204 EB37 8B                    phb                            ;save calling data bank register
7205 EB38 4B                    phk                            ;switch to our data bank
7206 EB39 AB                    plb   
7207 EB3A
7208 EB3A 20 44 EB              jsr   unbind_int2
7209 EB3D
7210 EB3D AB                    plb                            ;restore user's data bank register
7211 EB3E 6B                    rtl   
7212 EB3F                       end_proc 
7213 EB3F
7214 EB3F              unbind_int proc 
7215 EB3F
7216 EB3F              o_pcount equ   0                        ;offset of pcount field in parm blk
7217 EB3F              o_int_num equ   2                       ;offset of int_num field
7218 EB3F
7219 EB3F              o_fwd_vp equ   0                        ;offset of forward vp
7220 EB3F              o_bkwd_vp equ   4
7221 EB3F
7222 EB3F              ;
7223 EB3F              ; First, delete the ICR for the specified interrupt handler.
7224 EB3F              ;
7225 EB3F A0 02 00              ldy   #o_int_num               ;get the int_num from the parm blk
7226 EB42 B7 32                 lda   [<param_blk_ptr],y
7227 EB44
7228 EB44                       EXPORT unbind_int2 
7229 EB44 20 C4 FA     unbind_int2 jsr   wreck_icr             ;get rid of the ICR
7230 EB47 B0 40                 bcs   wreck_icr_err
7231 EB49              ;
7232 EB49              ; Now, we need to determine if we need to restore the original value in the
7233 EB49              ; firmware interrupt vector.  This is the case if there is only 1 ICR left in
7234 EB49              ; the list of ICRs corresponding to the given VRN.  Note: wreck_icr has left the
7235 EB49              ; VRN in A.
7236 EB49              ;
7237 EB49 48                    pha                            ;save the vrn
7238 EB4A
7239 EB4A 20 42 FA              jsr   map_vrn                  ;turn vrn into Object List Tbl offset
7240 EB4D AA                    tax   
7241 EB4E
7242 EB4E BD 6B F4              lda   |obj_list_tab+2,x        ;see if list header vp is null
7243 EB51 A8                    tay   
7244 EB52 1D 69 F4              ora   |obj_list_tab,x
7245 EB55 F0 2A                 beq   vp_is_null
7246 EB57
7247 EB57 BD 69 F4              lda   |obj_list_tab,x          ;get the low word of vp again
7248 EB5A AA                    tax   
7249 EB5B
7250 EB5B 22 F0 FD 00           jsl   gderef                   ;get pointer to forward link field
7251 EB5F
7252 EB5F 86 D4                 stx   <s_temp1                 ;set up pointer on direct page
7253 EB61 84 D6                 sty   <s_temp1+2
7254 EB63
7255 EB63 A0 02 00              ldy   #o_fwd_vp+succ           ;check that both forward and backward
7256 EB66 B7 D4                 lda   [<s_temp1],y             ;vps are 0
7257 EB68 C8                    iny   
7258 EB69 C8                    iny   
7259 EB6A 17 D4                 ora   [<s_temp1],y
7260 EB6C C8                    iny   
7261 EB6D C8                    iny   
7262 EB6E 17 D4                 ora   [<s_temp1],y
7263 EB70 C8                    iny   
7264 EB71 C8                    iny   
7265 EB72 17 D4                 ora   [<s_temp1],y
7266 EB74 D0 08                 bne   links_not_null
7267 EB76              ;
7268 EB76              ; There is only this one element in the linked list, so it must be the saved
7269 EB76              ; value of the firmware vector.  Therefore, do the restore operation.
7270 EB76              ;
7271 EB76 68           links_null pla                          ;get back the saved VRN
7272 EB77 20 12 FB              jsr   restore_vector           restore the value of the firmware vect
7273 EB7A B0 06                 bcs   restore_err
7274 EB7C
7275 EB7C 18                    clc                            ;normal return
7276 EB7D 60                    rts   
7277 EB7E              ;
7278 EB7E              ; There was more than one element in the linked list, so it wasn't time to
7279 EB7E              ; restore the firmware vector yet.
7280 EB7E              ;
7281 EB7E 68           links_not_null pla                      ;pop the saved VRN
7282 EB7F 18                    clc   
7283 EB80 60                    rts   
7284 EB81
7285 EB81 68           vp_is_null pla                          ;if we expected to restore a patched
7286 EB82 A9 0E 00     restore_err lda   #$000E                ;...firmware vector and there is an
7287 EB85 22 02 EF 00           jsl   >s_sys_death             ;...error, this is very bad
7288 EB89
7289 EB89 A9 53 00     wreck_icr_err lda   #parm_range_err
7290 EB8C 38                    sec   
7291 EB8D 60                    rts   
7292 EB8E
7293 EB8E                       end_proc 
7294 EB8E                       eject 
7295 EB8E              ;===============================================================================
7296 EB8E              ; disp_user_int
7297 EB8E              ;
7298 EB8E              ; On entry to this routine, the machine state is as follows:
7299 EB8E              ;
7300 EB8E              ;               e = emulation
7301 EB8E              ;               D = $0000
7302 EB8E              ;               DBR = $00
7303 EB8E              ;               speed = 1 MHz
7304 EB8E              ;               i = disabled
7305 EB8E              ;===============================================================================
7306 EB8E
7307 EB8E              disp_user_int proc 
7308 EB8E                       entry return_1
7309 EB8E
7310 EB8E              o_fwd_vp equ   0                        ;offset of forward vp after deref_int
7311 EB8E              o_handler_addr equ   8                  ;offset of handler address
7312 EB8E
7313 EB8E                       longa off
7314 EB8E                       longi off
7315 EB8E
7316 EB8E A9 80                 lda   #$80                     ;switch to high speed
7317 EB90 0C 36 C0              tsb   cyareg
7318 EB93
7319 EB93 18                    clc                            ;switch to native mode
7320 EB94 FB                    xce   
7321 EB95
7322 EB95                       longa on
7323 EB95                       longi on
7324 EB95
7325 EB95 C2 30                 rep   #mx16                    ;16-bit m and x
7326 EB97
7327 EB97 D4 FE                 pei   <i_temp+6                ;save current val of a direct page temp
7328 EB99 D4 FC                 pei   <i_temp+4
7329 EB9B D4 FA                 pei   <i_temp+2
7330 EB9D D4 F8                 pei   <i_temp
7331 EB9F              ;
7332 EB9F              ; Get vp to first ICR on the list of P16 interrupt handlers.
7333 EB9F              ;
7334 EB9F AE 71 F4              ldx   |obj_list_tab+icr_list
7335 EBA2 AC 73 F4              ldy   |obj_list_tab+icr_list+2
7336 EBA5              ;
7337 EBA5              ; Loop through the ICRs until one handles the interrupt or we get to the end of
7338 EBA5              ; the list.
7339 EBA5              ;
7340 EBA5 8A           loop     txa                            ;check if current vp is null
7341 EBA6 D0 03                 bne   not_null
7342 EBA8 98                    tya   
7343 EBA9 F0 2A                 beq   int_exit                 ;if null, we polled everybody unsuccess
7344 EBAB
7345 EBAB 20 79 EC     not_null jsr   deref_int                ;dereference the vp
7346 EBAE 86 F8                 stx   <i_temp
7347 EBB0 84 FA                 sty   <i_temp+2
7348 EBB2              ;
7349 EBB2              ; Get interrupt handler address out of the ICR and patch it into a long jump
7350 EBB2              ; instruction we have cleverly placed below the language card.
7351 EBB2              ;
7352 EBB2 A0 08 00              ldy   #o_handler_addr          ;offset of low word handler address
7353 EBB5 B7 F8                 lda   [<i_temp],y              ;low word of handler address
7354 EBB7 8D 18 9F              sta   |int_disp_jump+1         ;store into jump instruction
7355 EBBA C8                    iny                            ;offset of middle word handler address
7356 EBBB B7 F8                 lda   [<i_temp],y              ;note that middle byte of 3-byte
7357 EBBD 8D 19 9F              sta   |int_disp_jump+2         ;...address is stored twice
7358 EBC0              ;
7359 EBC0              ; Now jump to the handler calling stub below the language card.
7360 EBC0              ;
7361 EBC0 8B                    phb                            ;save DBR value
7362 EBC1
7363 EBC1 38                    sec                            ;required by defined calling standard
7364 EBC2
7365 EBC2 4C 17 9F              jmp   disp_stub_1
7366 EBC5
7367 EBC5              return_1                                ;               ;stub will jump to return here
7368 EBC5
7369 EBC5 AB                    plb                            ;restore DBR value
7370 EBC6
7371 EBC6 90 0D                 bcc   int_was_handled          ;branch ahead if interrupt handled
7372 EBC8              ;
7373 EBC8              ; Here, the interrupt was not handled, so follow the ICR forward link to the
7374 EBC8              ; next ICR.
7375 EBC8              ;
7376 EBC8 A0 00 00              ldy   #o_fwd_vp                ;offset of forward vp
7377 EBCB B7 F8                 lda   [<i_temp],y              ;low word of forward vp
7378 EBCD AA                    tax   
7379 EBCE C8                    iny   
7380 EBCF C8                    iny   
7381 EBD0 B7 F8                 lda   [<i_temp],y              ;high word of forward vp
7382 EBD2 A8                    tay   
7383 EBD3
7384 EBD3 80 D0                 bra   loop                     ;try the next ICR
7385 EBD5              ;
7386 EBD5              ; Here, the interrupt was handled.
7387 EBD5              ;
7388 EBD5              int_was_handled  
7389 EBD5
7390 EBD5 68           int_exit pla                            ;restored saved value of temp
7391 EBD6 85 F8                 sta   <i_temp
7392 EBD8 68                    pla   
7393 EBD9 85 FA                 sta   <i_temp+2
7394 EBDB 68                    pla   
7395 EBDC 85 FC                 sta   <i_temp+4
7396 EBDE 68                    pla   
7397 EBDF 85 FE                 sta   <i_temp+6
7398 EBE1
7399 EBE1 38                    sec                            ;return to emulation mode
7400 EBE2 FB                    xce   
7401 EBE3
7402 EBE3                       longa off
7403 EBE3                       longi off
7404 EBE3
7405 EBE3 A9 80                 lda   #$80                     ;return to low speed
7406 EBE5 1C 36 C0              trb   cyareg
7407 EBE8
7408 EBE8 60                    rts                            ;return to int code below lang card
7409 EBE9
7410 EBE9                       end_proc 
7411 EBE9                       eject 
7412 EBE9              ;===============================================================================
7413 EBE9              ; disp_common_int
7414 EBE9              ;
7415 EBE9              ; On entry to this routine, the machine state is as follows:
7416 EBE9              ;
7417 EBE9              ;               e = native
7418 EBE9              ;               m = 8-bit
7419 EBE9              ;               x = 8-bit
7420 EBE9              ;               D = undefined
7421 EBE9              ;               DBR = $00
7422 EBE9              ;               speed = high
7423 EBE9              ;               i = disabled
7424 EBE9              ;===============================================================================
7425 EBE9
7426 EBE9              disp_common_int proc 
7427 EBE9                       entry return_2
7428 EBE9
7429 EBE9              o_fwd_vp equ   0                        ;offset of forward vp after deref_int
7430 EBE9              o_handler_addr equ   8                  ;offset of handler address
7431 EBE9              o_the_vrn equ   12                      ;offset to vector reference number (15-Dec-92 DAL)
7432 EBE9
7433 EBE9 C2 30                 rep   #mx16                    ;switch temporarily to full 16-bit mode
7434 EBEB                       longa on
7435 EBEB                       longi on
7436 EBEB
7437 EBEB A9 00 00              lda   #$0000                   ;force D=$0000
7438 EBEE 5B                    tcd   
7439 EBEF
7440 EBEF D4 FE                 pei   <i_temp+6                ;save current val of direct page temp
7441 EBF1 D4 FC                 pei   <i_temp+4
7442 EBF3 D4 FA                 pei   <i_temp+2
7443 EBF5 D4 F8                 pei   <i_temp
7444 EBF7
7445 EBF7 8A                    txa                            ;turn Vector Index (VI) into tbl offset
7446 EBF8 20 66 FA              jsr   map_vi
7447 EBFB AA                    tax   
7448 EBFC              ;
7449 EBFC              ; Set handled to indicate that no one has handled the interrupt yet.
7450 EBFC              ;
7451 EBFC 9C 60 EA              stz   |handled
7452 EBFF              ;
7453 EBFF              ; Get vp to first ICR on the list of interrupt handlers having this VI.
7454 EBFF              ;
7455 EBFF BD 69 F4              lda   |obj_list_tab,x          ;low word
7456 EC02 BC 6B F4              ldy   |obj_list_tab+2,x        ;high word
7457 EC05 AA                    tax                            ;final destination for low word
7458 EC06              ;
7459 EC06              ; Loop through the ICRs until one handles the interrupt or we get to the end of
7460 EC06              ; the list.
7461 EC06              ;
7462 EC06 8A           loop     txa                            ;check if current vp is null
7463 EC07 D0 03                 bne   not_null
7464 EC09 98                    tya   
7465 EC0A F0 57                 beq   int_exit                 ;if null, we polled everyone unsuccess
7466 EC0C
7467 EC0C 20 79 EC     not_null jsr   deref_int                ;dereference the vp
7468 EC0F 86 F8                 stx   <i_temp
7469 EC11 84 FA                 sty   <i_temp+2
7470 EC13              ;
7471 EC13              ; Get interrupt handler address out of the ICR and patch it into a long jump
7472 EC13              ; instruction we have cleverly placed below the language card.
7473 EC13              ;
7474 EC13 A0 08 00              ldy   #o_handler_addr          ;offset of handler address
7475 EC16 B7 F8                 lda   [<i_temp],y              ;low word of handler address
7476 EC18 8D 3B 9F              sta   |common_disp_jmp+1       ;store into jump instruction
7477 EC1B C8                    iny                            ;offset of middle word handler address
7478 EC1C B7 F8                 lda   [<i_temp],y              ;note that middle byte of 3-byte
7479 EC1E 8D 3C 9F              sta   |common_disp_jmp+2       ;address is stored twice
7480 EC21              ;
7481 EC21              ; Clear carry if interrupt has not yet been handled.  Set carry if it has been
7482 EC21              ; handled.
7483 EC21              ;
7484 EC21 A9 00 80              lda   #$8000                   ;propagate high bit of handled into c
7485 EC24 6D 60 EA              adc   |handled                 ;do not change c before calling handler
7486 EC27              ;
7487 EC27              ; Now, jump to the handler calling stub below the language card.
7488 EC27              ;
7489 EC27 8B                    phb                            ;save value of DBR
7490 EC28 E2 30                 sep   #mx8                     ;switch to 8-bit native mode
7491 EC2A                       longa off
7492 EC2A                       longi off
7493 EC2A 4C 3A 9F              jmp   disp_stub_2              ;do the jump
7494 EC2D
7495 EC2D              return_2                                ;stub will jump to return here
7496 EC2D
7497 EC2D C2 30                 rep   #mx16                    ;back to full 16-bit mode
7498 EC2F                       longa on
7499 EC2F                       longi on
7500 EC2F AB                    plb                            ;restore value of DBR
7501 EC30
7502 EC30              *** added 15-Dec-92 DAL -- If we are doing IRQ.OTHER (vrn=$0017) then restore MSLOT
7503 EC30              ; DBR = $00
7504 EC30 08                    php   
7505 EC31 A0 0C 00              ldy   #o_the_vrn
7506 EC34 B7 F8                 lda   [<i_temp],y
7507 EC36 C9 17 00              cmp   #$0017                   ;IRQ.OTHER?
7508 EC39 D0 12                 bne   @never_mind
7509 EC3B
7510 EC3B E2 30                 sep   #$30
7511 EC3D                       longa off
7512 EC3D                       longi off
7513 EC3D AF 1B 01 E1           lda   >$e1011b                 ;irq_MSLOT
7514 EC41 8D F8 07              sta   $07f8                    ;MSLOT
7515 EC44 8D 4C EC              sta   @Cn00_cheat+2            ;We're in bank zero!
7516 EC47 2C FF CF              bit   $cfff
7517 EC4A 2C 00 C0     @Cn00_cheat bit   $C000                 ;*** modified to $Cn00 ***
7518 EC4D
7519 EC4D                       longa on
7520 EC4D                       longi on                       ;don't bother with REP, we're PLPing anyway
7521 EC4D
7522 EC4D 28           @never_mind plp   
7523 EC4E              *** end 15-Dec-92
7524 EC4E
7525 EC4E
7526 EC4E              ;;;	bcc	int_was_handled	;branch ahead if interrupt was handled
7527 EC4E B0 06                 bcs   int_not_handled
7528 EC50
7529 EC50              int_was_handled  
7530 EC50 A9 00 80              lda   #$8000                   ;set handled to indicate interrupt was
7531 EC53 8D 60 EA              sta   |handled                 ;...handled
7532 EC56
7533 EC56              int_not_handled  
7534 EC56              ;
7535 EC56              ; Here, the interrupt was not handled, so follow the ICR forward link to the
7536 EC56              ; next ICR.
7537 EC56              ;
7538 EC56 A0 00 00     do_next  ldy   #o_fwd_vp                ;offset of forward vp
7539 EC59 B7 F8                 lda   [<i_temp],y              ;low word of forward vp
7540 EC5B AA                    tax   
7541 EC5C C8                    iny   
7542 EC5D C8                    iny   
7543 EC5E B7 F8                 lda   [<i_temp],y              ;high word of forward vp
7544 EC60 A8                    tay   
7545 EC61
7546 EC61 80 A3                 bra   loop                     ;try the next ICR
7547 EC63
7548 EC63              ;;;int_was_handled
7549 EC63              ;;;
7550 EC63              ;;;	lda	#$8000	;set handled to indicate interrupt was
7551 EC63              ;;;	sta	|handled	;...handled
7552 EC63              ;;;	bra	do_next
7553 EC63
7554 EC63 68           int_exit pla                            ;restore saved value of temp
7555 EC64 85 F8                 sta   <i_temp
7556 EC66 68                    pla   
7557 EC67 85 FA                 sta   <i_temp+2
7558 EC69 68                    pla   
7559 EC6A 85 FC                 sta   <i_temp+4
7560 EC6C 68                    pla   
7561 EC6D 85 FE                 sta   <i_temp+6
7562 EC6F
7563 EC6F              *** added 15-Dec-92 DAL -- Before returning to firmware, condition CLC if handled=$8000, SEC if handled=0
7564 EC6F AD 60 EA              lda   |handled
7565 EC72 49 00 80              eor   #$8000
7566 EC75 0A                    asl   a
7567 EC76              *** end 15-Dec-92
7568 EC76
7569 EC76 E2 30                 sep   #mx8                     ;go back to 8-bit m and x
7570 EC78                       longa off
7571 EC78                       longi off
7572 EC78 60                    rts                            ;return to the firmware
7573 EC79
7574 EC79                       end_proc 
7575 EC79                       eject 
7576 EC79              ;======================================================================
7577 EC79              ; deref_int : Returns a physical 24 bit address corresponding to a
7578 EC79              ;              32 bit virtual pointer.  Does not require direct page to
7579 EC79              ;              be GS/OS direct page (for use at interrupt time).
7580 EC79              ;
7581 EC79              ; Created:       APR  1, 1987 (no, really)
7582 EC79              ; Modified:      November 23, 1987
7583 EC79              ; Author:        Mike Askins
7584 EC79              ;
7585 EC79              ; Copyright Apple Computer Inc. 1987  All rights reserved
7586 EC79              ;
7587 EC79              ; Input:         A = <undefined>
7588 EC79              ;                X = Virtual Pointer (low)
7589 EC79              ;                Y = Virtual Pointer (high)
7590 EC79              ;                P = nvmxdizc
7591 EC79              ;                    ..000...
7592 EC79              ;          seg_tab = Pointer to segment table  (accessed long)
7593 EC79              ;
7594 EC79              ; Output:        A = <undefined>
7595 EC79              ;                X = Physical Address (low)
7596 EC79              ;                Y = Physical Address (high)
7597 EC79              ;                P = nvmxdizc
7598 EC79              ;                    ..000...
7599 EC79              ;                b = preserved
7600 EC79              ;
7601 EC79              ;======================================================================
7602 EC79
7603 EC79              deref_int proc 
7604 EC79
7605 EC79                       longa on
7606 EC79                       longi on
7607 EC79
7608 EC79              ; This routine is to be used at interrupt time to walk a list of ICRs.
7609 EC79              ;  It does not require GS/OS direct page to be active.  The value
7610 EC79              ;  returned points to the position in the block overhead corresponding
7611 EC79              ;  to the forward link, which is what the ICR walking code really wants
7612 EC79              ;  it to access.
7613 EC79
7614 EC79
7615 EC79              ; Zero page storage
7616 EC79
7617 EC79              st       equ   i_temp
7618 EC79
7619 EC79              *
7620 EC79              * Save the direct page we will use because we can be in a situation
7621 EC79              * where the stack has crawled down into direct page (by calling
7622 EC79              * AlertWindow)...
7623 EC79              *
7624 EC79 A5 F8                 lda   <st                      ;Save st.
7625 EC7B 8F BB EC 00           sta   >st_save
7626 EC7F A5 FA                 lda   <st+2
7627 EC81 8F BD EC 00           sta   >st_save+2
7628 EC85
7629 EC85              ; Set up temporary zero page storage
7630 EC85
7631 EC85 AF 31 A0 00           lda   >seg_tab_copy
7632 EC89 85 F8                 sta   <st
7633 EC8B AF 33 A0 00           lda   >seg_tab_copy+2
7634 EC8F 85 FA                 sta   <st+2
7635 EC91
7636 EC91              ; Set up a pointer to the handle for this segment
7637 EC91
7638 EC91 B7 F8                 lda   [<st],y
7639 EC93 48                    pha   
7640 EC94 C8                    iny   
7641 EC95 C8                    iny   
7642 EC96 B7 F8                 lda   [<st],y
7643 EC98 85 FA                 sta   <st+2
7644 EC9A 68                    pla   
7645 EC9B 85 F8                 sta   <st
7646 EC9D
7647 EC9D              ; Add the offset into the address referenced by the handle and return
7648 EC9D
7649 EC9D 8A                    txa   
7650 EC9E 18                    clc   
7651 EC9F 69 02 00              adc   #succ                    ;Relative offset of the forward link
7652 ECA2 67 F8                 adc   [<st]
7653 ECA4
7654 ECA4 AA                    tax   
7655 ECA5 A0 02 00              ldy   #$0002
7656 ECA8 B7 F8                 lda   [<st],y
7657 ECAA 90 01                 bcc   skip
7658 ECAC 1A                    inc   a
7659 ECAD
7660 ECAD              skip      
7661 ECAD A8                    tay   
7662 ECAE              *
7663 ECAE              * Restore direct page usage and exit...
7664 ECAE              *
7665 ECAE AF BB EC 00           lda   >st_save                 ;Restore st.
7666 ECB2 85 F8                 sta   <st
7667 ECB4 AF BD EC 00           lda   >st_save+2
7668 ECB8 85 FA                 sta   <st+2
7669 ECBA 60                    rts   
7670 ECBB
7671 ECBB 00 00 00 00  st_save  DC L:00000000                  ;Temp storage.
7672 ECBF
7673 ECBF                       end_proc 
7674 ECBF                       eject 
7675 ECBF              ;===============================================================================
7676 ECBF              ; Signal Subsystem Code
7677 ECBF              ;===============================================================================
7678 ECBF              ; signal_data    this module is in the file os.call
7679 ECBF              ; init_signal    initialize the signal subsystem
7680 ECBF              ; signal_signal  add an signal to the GS/OS signal queue
7681 ECBF              ;===============================================================================
7682 ECBF
7683 ECBF              ;===============================================================================
7684 ECBF              ; init_signal
7685 ECBF              ;
7686 ECBF              ; Initialize the signal management subsystem.
7687 ECBF              ;===============================================================================
7688 ECBF
7689 ECBF              init_signal proc 
7690 ECBF              *
7691 ECBF              * If we're doing a warm startup, skip ahead to start_heart...
7692 ECBF              *
7693 ECBF AF D0 01 E1           lda   >warm_cold_flag          ;Warm startup?
7694 ECC3 D0 21                 bne   start_heart              ;Yes, so skip ahead.
7695 ECC5
7696 ECC5              ; Init signal queue...
7697 ECC5
7698 ECC5 A9 00 80              lda   #sig_null_ptr            ;set the signal queue to the empty state
7699 ECC8 8D 48 9F              sta   |signal_head
7700 ECCB              ;
7701 ECCB              ; Initialize free list of signal records.
7702 ECCB              ;
7703 ECCB 9C 4A 9F              stz   |signal_free             ;free list header points to first record
7704 ECCE                                                      ;...in signal table
7705 ECCE A9 00 80              lda   #sig_null_ptr            ;null pointer to last record in table
7706 ECD1 8D 84 9F              sta   |signal_table+sig_rec_size*(num_signals-1)
7707 ECD4
7708 ECD4 A9 38 00              lda   #sig_rec_size*(num_signals-1)  ;offset of last record
7709 ECD7 80 07                 bra   ar_1
7710 ECD9
7711 ECD9 9D 44 9F     fwd_ptr_init sta   |signal_table-sig_rec_size,x
7712 ECDC 38                    sec   
7713 ECDD E9 08 00              sbc   #sig_rec_size
7714 ECE0 AA           ar_1     tax   
7715 ECE1 D0 F6                 bne   fwd_ptr_init
7716 ECE3
7717 ECE3 9C 8C 9F              stz   |dispatch_busy           ;indicate dispatch_signal not running
7718 ECE6
7719 ECE6 F4 00 00     start_heart pea   signal_beat>>16       ;push pointer to signal dispatcher
7720 ECE9 F4 90 9F              pea   signal_beat              ;...heartbeat routine
7721 ECEC A2 03 12 22           _SetHeartBeat 
7722 ECF3              ;;;	bcs	return	;save two bytes, 15-Dec-92 DAL
7723 ECF3
7724 ECF3 F4 02 00              pea   $0002                    ;enable VBL interrupts
7725 ECF6 A2 03 23 22           _IntSource 
7726 ECFD
7727 ECFD 60           return   rts   
7728 ECFE
7729 ECFE
7730 ECFE                       end_proc 
7731 ECFE                       eject 
7732 ECFE              ;===============================================================================
7733 ECFE              ; s_signal
7734 ECFE              ;
7735 ECFE              ; Announce to GS/OS that a signal has occurred.  GS/OS places a signal record in
7736 ECFE              ; its signal queue.
7737 ECFE              ;
7738 ECFE              ; Created:      December 23, 1987
7739 ECFE              ; Modified:     February 9, 1988
7740 ECFE              ;               February 29, 1988  Routine no longer calls the dispatcher.
7741 ECFE              ; Author:       Jim Jatczynski
7742 ECFE              ;
7743 ECFE              ; Input:        A = signal priority
7744 ECFE              ;               X = low word of signal handler address
7745 ECFE              ;               Y = high word of signal handler address
7746 ECFE              ;               P = nvmxdizc
7747 ECFE              ;                   ..000...
7748 ECFE              ;
7749 ECFE              ; Output:       A = trashed
7750 ECFE              ;               X = trashed
7751 ECFE              ;               Y = trashed
7752 ECFE              ;               P = nvmxdizc
7753 ECFE              ;                   ..000...
7754 ECFE              ;               DBR = unchanged
7755 ECFE              ;               D = unchanged
7756 ECFE              ;===============================================================================
7757 ECFE
7758 ECFE              s_signal proc 
7759 ECFE
7760 ECFE              handler_addr equ   1
7761 ECFE
7762 ECFE 08                    php                            ;save interrupt state
7763 ECFF 78                    sei                            ;disable interrupts
7764 ED00
7765 ED00 8B                    phb                            ;save DBR
7766 ED01 4B                    phk                            ;set DBR to PBR
7767 ED02 AB                    plb   
7768 ED03 0B                    phd                            ;Save direct page register.
7769 ED04
7770 ED04 48                    pha                            ;save signal priority
7771 ED05 5A                    phy                            ;save signal handler address
7772 ED06 DA                    phx   
7773 ED07
7774 ED07 A2 00 BD              ldx   #direct_base             ;Switch in our direct page.
7775 ED0A DA                    phx                            ;(must preserve A).
7776 ED0B 2B                    pld   
7777 ED0C              ;
7778 ED0C              ; Allocate signal record and put it into signal queue according to priority.
7779 ED0C              ; Priority is in A.
7780 ED0C              ;
7781 ED0C 20 82 ED              jsr   queue_signal             ;returns signal_table offset in X
7782 ED0F B0 15                 bcs   queue_error
7783 ED11              ;
7784 ED11              ; Copy input information into new signal record.  queue_signal has already set
7785 ED11              ; priority field.
7786 ED11              ;
7787 ED11 A3 01                 lda   handler_addr,s
7788 ED13 9D 50 9F              sta   |signal_table+sig_hand_addr,x
7789 ED16 A3 03                 lda   handler_addr+2,s
7790 ED18 9D 52 9F              sta   |signal_table+sig_hand_addr+2,x
7791 ED1B              *
7792 ED1B              * Install our patch into main interrupt vector in case we aren't in the middle
7793 ED1B              * of an OS call (in which case dispatch_signal will not be called)...
7794 ED1B              *
7795 ED1B 20 61 B6              jsr   install_int_vec          ;Install patch.
7796 ED1E              ;
7797 ED1E              ; Clear the stack and return to caller.
7798 ED1E              ;
7799 ED1E
7800 ED1E              *** optimized 15-Dec-92 DAL (saved 3 bytes)
7801 ED1E              ;;;	tsc		;squeeze 6 bytes out of stack
7802 ED1E              ;;;	clc
7803 ED1E              ;;;	adc	#6
7804 ED1E              ;;;	tcs
7805 ED1E 2B                    pld   
7806 ED1F 2B                    pld   
7807 ED20 2B                    pld   
7808 ED21              *** end 15-Dec-92
7809 ED21
7810 ED21 2B                    pld                            ;Restore direct page.
7811 ED22 AB                    plb                            ;restore DBR
7812 ED23 28                    plp                            ;restore P (includes interrupt state)
7813 ED24
7814 ED24 18                    clc   
7815 ED25 6B                    rtl   
7816 ED26              ;
7817 ED26              ; Error exit if queue_signal returned error.
7818 ED26              ;
7819 ED26              queue_error  
7820 ED26              *** optimized 20-Jul-92 DAL
7821 ED26              ;;;	tsc		;clear garbage off stack
7822 ED26              ;;;	clc
7823 ED26              ;;;	adc	#6
7824 ED26              ;;;	tcs
7825 ED26 68                    pla   
7826 ED27 68                    pla   
7827 ED28 68                    pla   
7828 ED29              *** end 20-Jul-92 DAL
7829 ED29 2B                    pld                            ;Restore direct page.
7830 ED2A AB                    plb                            ;restore DBR and P
7831 ED2B 28                    plp   
7832 ED2C
7833 ED2C 38                    sec                            ;indicate error
7834 ED2D 6B                    rtl   
7835 ED2E
7836 ED2E                       end_proc 
7837 ED2E                       eject 
7838 ED2E              ;===============================================================================
7839 ED2E              ; dispatch_signal
7840 ED2E              ;
7841 ED2E              ; Call one or more signal handlers.
7842 ED2E              ;
7843 ED2E              ; Created:      February 8, 1988
7844 ED2E              ; Modified:
7845 ED2E              ; Author:       Jim Jatczynski
7846 ED2E              ;
7847 ED2E              ; Input:        P = nvmxdizc    | c is set to the value that i had on entry to
7848 ED2E              ;                   ..000..|____| the routine that ultimately called dispatch_
7849 ED2E              ;                               | signal.  dispatch_signal is called either from
7850 ED2E              ;                               | s_signal or from SCM exit code.
7851 ED2E              ; Output:       A = preserved
7852 ED2E              ;               X = preserved
7853 ED2E              ;               Y = preserved
7854 ED2E              ;               D = preserved
7855 ED2E              ;               S = restored to pre-call value on exit
7856 ED2E              ;               DBR = preserved
7857 ED2E              ;               P = nvmxdizc
7858 ED2E              ;                   **000***    * = preserved
7859 ED2E              ;===============================================================================
7860 ED2E
7861 ED2E              dispatch_signal proc 
7862 ED2E              ;
7863 ED2E              ; Save all of the registers, and disable interrupts.
7864 ED2E              ;
7865 ED2E 08           @doit    php                            ;Save P
7866 ED2F 78                    sei                            ;Disable interrupts.
7867 ED30 8B                    phb                            ;Save DBR
7868 ED31 4B                    phk                            ;Set DBR to PBR
7869 ED32 AB                    plb   
7870 ED33 0B                    phd                            ;Save D, A, X, Y
7871 ED34 48                    pha   
7872 ED35 DA                    phx   
7873 ED36 5A                    phy   
7874 ED37              ;
7875 ED37              ; If GS/OS is busy or dispatch_signal has been re-entered, return immediately.
7876 ED37              ;
7877 ED37 AF BE 00 E1           lda   >active_flag
7878 ED3B 30 3E                 bmi   return
7879 ED3D
7880 ED3D AD 8C 9F              lda   |dispatch_busy
7881 ED40 30 39                 bmi   return
7882 ED42              ;
7883 ED42              ; Neither GS/OS nor dispatch_signal is busy.  Set dispatch_signal busy flag.
7884 ED42              ;
7885 ED42 A9 00 80              lda   #disp_busy
7886 ED45 8D 8C 9F              sta   |dispatch_busy
7887 ED48              ;
7888 ED48              ; Save incoming state of c flag, which gives old state of i bit.  Note:
7889 ED48              ; code before this point must preserve c.
7890 ED48              ;
7891 ED48 A9 00 00              lda   #$0000                   ;default state is 'enabled'
7892 ED4B              ;;;	bcc	save_it	;optimized 15-Dec-92 DAL (saved 2 bytes; if CLC, we still get $0000)
7893 ED4B 6A                    ror   a                        ;set A = $8000 ('disabled')
7894 ED4C 8D 8E 9F     save_it  sta   |interrupt_state
7895 ED4F              ;
7896 ED4F              ; Beginning of the signal handler dispatch loop.  First, check to see if there
7897 ED4F              ; are any queued signals.
7898 ED4F              ;
7899 ED4F AE 48 9F     check_queue ldx   |signal_head          ;head pointer of signal queue null?
7900 ED52 10 05                 bpl   do_signal                ;Nope.
7901 ED54 20 95 B6              jsr   remove_int_vec           ;Yes, make sure our patch is out.
7902 ED57 80 1F                 bra   return2                  ;Return
7903 ED59              ;
7904 ED59              ; Get the first signal in the queue and prepare to call the signal handler.
7905 ED59              ; Simulate a JSL instruction to avoid self-modifying code.
7906 ED59              ;
7907 ED59 4B           do_signal phk                           ;push bank byte of return address
7908 ED5A F4 72 ED              pea   return_here-1            ;push return address - 1 (RTL adds 1)
7909 ED5D
7910 ED5D BD 52 9F              lda   |signal_table+sig_hand_addr+2,x ;high word handler addr
7911 ED60 EB                    xba   
7912 ED61 48                    pha                            ;push bank and dummy byte
7913 ED62 4B                    phk                            ;push another dummy byte
7914 ED63 BD 50 9F              lda   |signal_table+sig_hand_addr,x  ;low word of handler addr
7915 ED66 3A                    dec   a                        ;subtract 1 because RTL will add 1
7916 ED67 83 01                 sta   1,s
7917 ED69
7918 ED69 20 C9 ED              jsr   dequeue_signal           ;get rid of record in signal queue
7919 ED6C              ;
7920 ED6C              ; Restore interrupt state that existed when the subsystem that called
7921 ED6C              ; dispatch_signal was called.
7922 ED6C              ;
7923 ED6C 2C 8E 9F              bit   |interrupt_state
7924 ED6F 30 01                 bmi   ar_1
7925 ED71 58                    cli   
7926 ED72              ar_1      
7927 ED72              ;
7928 ED72              ; Call the signal handler.
7929 ED72              ;
7930 ED72 6B                    rtl                            ;simulate a JSL
7931 ED73
7932 ED73              return_here                             ; ;get back here when handler RTLs
7933 ED73              ;
7934 ED73              ; Restore DBR = PBR and loop back to check_queue...
7935 ED73              ;
7936 ED73 78                    sei                            ;disable interrupts
7937 ED74 4B                    phk                            ;restore DBR=PBR
7938 ED75 AB                    plb   
7939 ED76 80 D7                 bra   check_queue              ;go see if there are any in queue
7940 ED78              ;
7941 ED78              ; Set dispatcher state to not-busy and return.
7942 ED78              ;
7943 ED78 9C 8C 9F     return2  stz   |dispatch_busy           ;indicate dispatcher not busy
7944 ED7B              ;
7945 ED7B              ; Restore all of the registers.
7946 ED7B              ;
7947 ED7B              return    
7948 ED7B
7949 ED7B 7A                    ply                            ;Restore Y, X, A, D, DBR, P
7950 ED7C FA                    plx   
7951 ED7D 68                    pla   
7952 ED7E 2B                    pld   
7953 ED7F AB                    plb   
7954 ED80 28                    plp   
7955 ED81
7956 ED81 60                    rts   
7957 ED82
7958 ED82                       end_proc 
7959 ED82                       eject 
7960 ED82              ;=====================================================================
7961 ED82              ; queue_signal : Place a signal into the signal priority queue
7962 ED82              ;
7963 ED82              ; Created:      February 10, 1988
7964 ED82              ; Modified:     February 10, 1988
7965 ED82              ; Author:       Mike Askins
7966 ED82              ;
7967 ED82              ; Copyright Apple Computer Inc. 1987  All rights reserved
7968 ED82              ;
7969 ED82              ; Input:        A = Priority of new signal
7970 ED82              ;               X = undefined
7971 ED82              ;               Y = undefined
7972 ED82              ;               P = nvmxdizc
7973 ED82              ;                   ..000...
7974 ED82              ;
7975 ED82              ; Output:       A = trashed
7976 ED82              ;               X = trashed
7977 ED82              ;               Y = trashed
7978 ED82              ;               P = nvmxdizc
7979 ED82              ;                   ..000..E -> 'No mo room fuh new sign'l'
7980 ED82              ;               b = preserved
7981 ED82              ;
7982 ED82              ;======================================================================
7983 ED82
7984 ED82              ; The signal queue is maintained in a priority number, 'first come first served'
7985 ED82              ;  manner.  Items are sorted by priority number, and a new signal with the same
7986 ED82              ;  priority as others in the queue is placed following the others.
7987 ED82
7988 ED82              queue_signal proc 
7989 ED82
7990 ED82 38                    sec                            ;Anticipate exception condition
7991 ED83 3A                    dec   a                        ;Reduce priority by one for comparing
7992 ED84 AE 4A 9F              ldx   |signal_free             ;Pick up the 'next free' pointer
7993 ED87 30 3F                 bmi   sorry_full               ;If null there is no room; ret w/ error
7994 ED89 A0 00 80              ldy   #$8000                   ;Null out predecessor by setting hi bit
7995 ED8C AE 48 9F              ldx   |signal_head             ;Get the first signal in the list
7996 ED8F 30 10                 bmi   found_spot               ;If empty list we have walked far enough
7997 ED91
7998 ED91              keepwalkin  
7999 ED91 DD 4E 9F              cmp   |signal_table+sig_priority,x
8000 ED94 B0 0B                 bge   found_spot               ;If newpriority < that of x
8001 ED96 9B                    txy                            ;At least we know that we go beyond him
8002 ED97 48                    pha                            ;Save newpriority
8003 ED98 BD 4C 9F              lda   |signal_table+sig_link,x ;Move to next guy
8004 ED9B AA                    tax   
8005 ED9C 68                    pla   
8006 ED9D DA                    phx   
8007 ED9E FA                    plx                            ;Lost N bit from above lda
8008 ED9F 10 F0                 bpl   keepwalkin               ;If more signals to check, do it
8009 EDA1
8010 EDA1              found_spot  
8011 EDA1 AE 4A 9F              ldx   |signal_free             ;Pick up the next item free index
8012 EDA4 1A                    inc   a                        ;Restore the actual priority number
8013 EDA5 9D 4E 9F              sta   |signal_table+sig_priority,x ;Store priority in new sig
8014 EDA8
8015 EDA8 BD 4C 9F              lda   |signal_table+sig_link,x ;Maintain free list
8016 EDAB 8D 4A 9F              sta   |signal_free             ;New sig now out of free list
8017 EDAE
8018 EDAE AD 48 9F              lda   |signal_head             ;Anticipate the 'no predecessor' case
8019 EDB1 5A                    phy   
8020 EDB2 7A                    ply                            ;N <- 'we are first in list'
8021 EDB3 30 0C                 bmi   no_pred                  ;We're first in list
8022 EDB5 B9 4C 9F              lda   |signal_table+sig_link,y ;Get predecessor's link
8023 EDB8 9D 4C 9F              sta   |signal_table+sig_link,x ;Make it our link
8024 EDBB 8A                    txa                            ;Move our index into A
8025 EDBC 99 4C 9F              sta   |signal_table+sig_link,y ;Make predecessor point at us
8026 EDBF 80 06                 bra   rejoin
8027 EDC1
8028 EDC1              no_pred   
8029 EDC1 9D 4C 9F              sta   |signal_table+sig_link,x ;List head becomes our index
8030 EDC4 8E 48 9F              stx   |signal_head             ; and we are at the head of the list
8031 EDC7              rejoin    
8032 EDC7 18                    clc   
8033 EDC8              sorry_full  
8034 EDC8 60                    rts   
8035 EDC9
8036 EDC9                       end_proc 
8037 EDC9                       eject 
8038 EDC9              ;=====================================================================
8039 EDC9              ; dequeue_signal : Remove first signal from signal queue
8040 EDC9              ;
8041 EDC9              ; Created:      February 10, 1988
8042 EDC9              ; Modified:     February 10, 1988
8043 EDC9              ; Author:       Mike Askins
8044 EDC9              ;
8045 EDC9              ; Copyright Apple Computer Inc. 1987  All rights reserved
8046 EDC9              ;
8047 EDC9              ; Input:        A = Priority of new signal
8048 EDC9              ;               X = undefined
8049 EDC9              ;               Y = undefined
8050 EDC9              ;               P = nvmxdizc
8051 EDC9              ;                   ..000...
8052 EDC9              ;
8053 EDC9              ; Output:       A = trashed
8054 EDC9              ;               X = trashed
8055 EDC9              ;               Y = trashed
8056 EDC9              ;               P = nvmxdizc
8057 EDC9              ;                   ..000..E -> 'No sign'l ta remove'
8058 EDC9              ;               b = preserved
8059 EDC9              ;
8060 EDC9              ;======================================================================
8061 EDC9
8062 EDC9              dequeue_signal proc 
8063 EDC9
8064 EDC9 38                    sec   
8065 EDCA AE 48 9F              ldx   |signal_head
8066 EDCD 30 10                 bmi   sorry_mt
8067 EDCF
8068 EDCF BD 4C 9F              lda   |signal_table+sig_link,x
8069 EDD2 8D 48 9F              sta   |signal_head
8070 EDD5
8071 EDD5 AD 4A 9F              lda   |signal_free
8072 EDD8 9D 4C 9F              sta   |signal_table+sig_link,x
8073 EDDB 8E 4A 9F              stx   |signal_free
8074 EDDE
8075 EDDE 18                    clc   
8076 EDDF              sorry_mt  
8077 EDDF 60                    rts   
8078 EDE0
8079 EDE0                       end_proc 
8080 EDE0                       eject 
8081 EDE0              ;===============================================================================
8082 EDE0              ; Alert Data Segment
8083 EDE0              ;
8084 EDE0              ; All the alert processing data are on zero page.
8085 EDE0              ;===============================================================================
8086 EDE0
8087 EDE0              alert_data proc 
8088 EDE0
8089 EDE0                       entry default_b_data
8090 EDE0                       entry sub_ptr_1
8091 EDE0                       entry sub_ptr_2
8092 EDE0                       entry fatal_err_num
8093 EDE0                       entry fatal_err_str
8094 EDE0                       entry death_sub_tbl
8095 EDE0                       entry sub_str_1
8096 EDE0                       entry sub_str_2
8097 EDE0                       entry sub_str_3
8098 EDE0              ;
8099 EDE0              ; Message constants.
8100 EDE0              ;
8101 EDE0              ;
8102 EDE0              ; Cursor move and response accept characters.
8103 EDE0              ;
8104 EDE0
8105 EDE0              ;
8106 EDE0              ; Window size specifications.
8107 EDE0              ;
8108 EDE0              ;
8109 EDE0              ; Button data.  There are up to three buttons, numbered 0, 1, and 2.  Buttons 0 
8110 EDE0              ;               and 1 are on the first button line, and button 2 is on the
8111 EDE0              ;               second button line.
8112 EDE0              ;
8113 EDE0              ;
8114 EDE0              ; Button characteristics record offsets.  Each record contains the (x,y)
8115 EDE0              ; coordinates of the first character in the button label, the length of the
8116 EDE0              ; button label, and the response to be generated if the button is pressed.
8117 EDE0              ;
8118 EDE0              ;
8119 EDE0              ; Default button data.                     x  y  length  response
8120 EDE0              ;                                         -- --  ------  --------
8121 EDE0              default_b_data  
8122 EDE0 08 05 02 00           DC B:8,5,2,0                   ;  8  5     2      0
8123 EDE4 1C 05 02 01           DC B:28,5,2,1                  ; 28  5     2      1
8124 EDE8 12 07 02 02           DC B:18,7,2,2                  ; 18  7     2      2
8125 EDEC              ;
8126 EDEC              ; Substitution string pointer table for report_error.
8127 EDEC              ;
8128 EDEC 00 00 00 00  sub_ptr_1 DC L:00000000
8129 EDF0 00 00 00 00  sub_ptr_2 DC L:00000000
8130 EDF4              ;
8131 EDF4              ; Temporaries for s_report_fatal
8132 EDF4              ;
8133 EDF4 00 00        fatal_err_num DC W:0000
8134 EDF6 05           fatal_err_str DC B:5
8135 EDF7 24 2E 2E 2E           DC B:'$....'
8136 EDFC              ;
8137 EDFC              ; Data structures for s_sys_death2
8138 EDFC              ;
8139 EDFC 08 EE 00 00  death_sub_tbl DC L:sub_str_1
8140 EE00 0F EE 00 00           DC L:sub_str_2
8141 EE04 11 EE 00 00           DC L:sub_str_3
8142 EE08 06           sub_str_1 DC B:6                        ;address substitution string
8143 EE09 2E 2E 2E 2E           DC B:'......'
8144 EE0F 01           sub_str_2 DC B:1                        ;LC bank substitution string
8145 EE10 2E                    DC B:'.'
8146 EE11 04           sub_str_3 DC B:4                        ;error number substitution string
8147 EE12 2E 2E 2E 2E           DC B:'....'
8148 EE16              ;
8149 EE16              ; Direct page data.
8150 EE16              ;
8151 EE16                                                      ;after all buttons are processed, it
8152 EE16                                                      ;gives the number of buttons
8153 EE16
8154 EE16
8155 EE16
8156 EE16
8157 EE16                                                      ;page below it for calling alertWindow
8158 EE16                       end_proc 
8159 EE16                       eject 
8160 EE16              ;===============================================================================
8161 EE16              ; scan_alert
8162 EE16              ;
8163 EE16              ; Scan the alert string and perform the processing needed to display it.
8164 EE16              ;
8165 EE16              ; Created:      1/9/88
8166 EE16              ; Modified:
8167 EE16              ; Author:       JJ
8168 EE16              ;
8169 EE16              ; Input:        alert_ptr and subst_ptr have been preset
8170 EE16              ;               P = nvmxdizc
8171 EE16              ;                   ..000...
8172 EE16              ;
8173 EE16              ; Output:       X = trashed
8174 EE16              ;               Y = trashed
8175 EE16              ;               P = nvmxdizc
8176 EE16              ;                   ..000...
8177 EE16              ;===============================================================================
8178 EE16
8179 EE16              scan_alert proc 
8180 EE16
8181 EE16 64 01                 stz   <num_buttons             ;make button 0 the current and default
8182 EE18 64 03                 stz   <default_button          ;...button
8183 EE1A
8184 EE1A A2 0A 00              ldx   #record_len*buttons-2    ;copy default button data to tbl
8185 EE1D BD E0 ED     def_copy_loop lda   |default_b_data,x
8186 EE20 95 05                 sta   <button_table,x
8187 EE22 CA                    dex   
8188 EE23 CA                    dex   
8189 EE24 10 F7                 bpl   def_copy_loop
8190 EE26              ;
8191 EE26              ; Go into 8-bit m mode.
8192 EE26              ;
8193 EE26 E2 30                 sep   #mx8
8194 EE28                       longa off
8195 EE28                       longi off
8196 EE28
8197 EE28 A2 00                 ldx   #$00                     ;gotoxy(0,0)
8198 EE2A 9B                    txy   
8199 EE2B 20 2D F2              jsr   gotoxy
8200 EE2E              ;
8201 EE2E              ; Scan past the window size descriptor (wsd).
8202 EE2E              ;
8203 EE2E A0 01                 ldy   #$01                     ;initialize Y to 1
8204 EE30
8205 EE30 A7 13                 lda   [<alert_ptr]             ;get window size specification byte
8206 EE32 29 0F                 and   #$0F
8207 EE34 D0 02                 bne   dont_change_y            ;if it's not a custom window size,
8208 EE36 A0 09                 ldy   #$09                     ;...leave Y with value 1; otherwise 9
8209 EE38              dont_change_y  
8210 EE38              ;
8211 EE38              ; Scan past the icon descriptor (id).
8212 EE38              ;
8213 EE38 B7 13                 lda   [<alert_ptr],y           ;get icon specification
8214 EE3A 29 0F                 and   #$0F
8215 EE3C D0 05                 bne   inc_by_1                 ;if it's not a custom icon,
8216 EE3E 98                    tya                            ;...increment Y by 1; otherwise,
8217 EE3F 18                    clc                            ;...increment Y by a total of 9
8218 EE40 69 08                 adc   #$08
8219 EE42 A8                    tay   
8220 EE43 C8           inc_by_1 iny   
8221 EE44              ;
8222 EE44              ; We are now sitting at the first occurrence of the delimiter character, so set
8223 EE44              ; up to process the text string.
8224 EE44              ;
8225 EE44 B7 13                 lda   [<alert_ptr],y           ;get the delimiter character
8226 EE46 85 11                 sta   <delim_char              ;...and save it
8227 EE48
8228 EE48 C8                    iny                            ;point Y at character after delimiter
8229 EE49              ;
8230 EE49              ; Perform character-by-character processing on the text part of the alert
8231 EE49              ; string.
8232 EE49              ;
8233 EE49 B7 13        copy_loop lda   [<alert_ptr],y          ;get the next character
8234 EE4B C9 2A                 cmp   #'*'                     ;is it the text substitution indicator?
8235 EE4D F0 0C                 beq   do_subst                 ;yes, perform substitution
8236 EE4F C5 11                 cmp   <delim_char              ;is it the delimiter character?
8237 EE51 F0 38                 beq   text_done                ;yes, we are done with text portion
8238 EE53
8239 EE53 5A                    phy                            ;no, save Y,
8240 EE54 20 4A F2              jsr   out80                    ;...write out the character,
8241 EE57 7A                    ply                            ;...and restore Y
8242 EE58
8243 EE58 C8                    iny                            ;increment offset
8244 EE59 80 EE                 bra   copy_loop                ;...and continue processing
8245 EE5B
8246 EE5B C8           do_subst iny                            ;increment Y to offset just after '*'
8247 EE5C B7 13                 lda   [<alert_ptr],y           ;get substitution string number
8248 EE5E 29 0F                 and   #$0F                     ;need to turn off high nibble
8249 EE60
8250 EE60 5A                    phy                            ;save Y offset in main string
8251 EE61
8252 EE61 0A                    asl   a                        ;A = substitution string # * 4
8253 EE62 0A                    asl   a
8254 EE63 A8                    tay   
8255 EE64
8256 EE64 C2 20                 rep   #m16
8257 EE66                       longa on
8258 EE66
8259 EE66 B7 17                 lda   [<subst_ptr],y           ;get pointer to substitution string
8260 EE68 85 1D                 sta   <subst_str_ptr
8261 EE6A C8                    iny   
8262 EE6B C8                    iny   
8263 EE6C B7 17                 lda   [<subst_ptr],y
8264 EE6E 85 1F                 sta   <subst_str_ptr+2
8265 EE70
8266 EE70 E2 20                 sep   #m8
8267 EE72                       longa off
8268 EE72              ;
8269 EE72              ; Copy substitution string to output.
8270 EE72              ;
8271 EE72 A7 1D                 lda   [<subst_str_ptr]         ;get string length
8272 EE74 F0 11                 beq   done_subst               ;nothing to do for length zero string
8273 EE76
8274 EE76 A0 01                 ldy   #$01                     ;make Y offset of first character
8275 EE78
8276 EE78 AA                    tax                            ;X = character count - 1
8277 EE79 CA                    dex   
8278 EE7A
8279 EE7A B7 1D        copy_subst lda   [<subst_str_ptr],y     ;get next character
8280 EE7C 5A                    phy                            ;save Y
8281 EE7D DA                    phx   
8282 EE7E 20 4A F2              jsr   out80                    ;write out character
8283 EE81 FA                    plx   
8284 EE82 7A                    ply                            ;restore Y
8285 EE83 C8                    iny   
8286 EE84 CA                    dex   
8287 EE85 10 F3                 bpl   copy_subst
8288 EE87
8289 EE87              done_subst  
8290 EE87 7A                    ply                            ;restore offset in main string
8291 EE88 C8                    iny                            ;point to next character
8292 EE89 80 BE                 bra   copy_loop                ;go process next character in main str
8293 EE8B
8294 EE8B              text_done  
8295 EE8B              ;
8296 EE8B              ; Now we are done processing the text part of the message.  It's time to process
8297 EE8B              ; the button data.  Y is now pointing at the terminator character.
8298 EE8B              ;
8299 EE8B B7 13        button_loop lda   [<alert_ptr],y        ;get the character
8300 EE8D              ;;;	cmp	#null0	;if it's nul or cr, we're done (no need to CMP #$00, 15-Dec-92 DAL)
8301 EE8D F0 0D                 beq   no_more_buttons
8302 EE8F C9 0D                 cmp   #return_key
8303 EE91 F0 09                 beq   no_more_buttons
8304 EE93
8305 EE93 A6 01                 ldx   <num_buttons             ;get button number of current button
8306 EE95 20 AE EE              jsr   do_button                ;process the button specifier
8307 EE98 E6 01                 inc   <num_buttons
8308 EE9A 80 EF                 bra   button_loop
8309 EE9C
8310 EE9C              no_more_buttons  
8311 EE9C              ;
8312 EE9C              ; Now we're done processing the buttons.  Time to handle the response
8313 EE9C              ; specifiers.  Y points to the NUL or CR at the end of the alert string.
8314 EE9C              ;
8315 EE9C C8                    iny                            ;Y = offset of first response char
8316 EE9D B7 13                 lda   [<alert_ptr],y           ;get response value for button 0
8317 EE9F 85 08                 sta   <button_table+button_resp ;and save in button tbl
8318 EEA1 C8                    iny   
8319 EEA2 B7 13                 lda   [<alert_ptr],y
8320 EEA4 85 0C                 sta   <button_table+button_resp+record_len
8321 EEA6 C8                    iny   
8322 EEA7 B7 13                 lda   [<alert_ptr],y
8323 EEA9 85 10                 sta   <button_table+button_resp+2*record_len
8324 EEAB              ;
8325 EEAB              ; That's all, folks
8326 EEAB              ;
8327 EEAB C2 30                 rep   #mx16
8328 EEAD                       longi on
8329 EEAD                       longa on
8330 EEAD
8331 EEAD 60                    rts   
8332 EEAE
8333 EEAE                       end_proc 
8334 EEAE                       eject 
8335 EEAE              ;===============================================================================
8336 EEAE              ; do_button
8337 EEAE              ;
8338 EEAE              ; Process a button specification in an alert string.  Prints out the button
8339 EEAE              ; label and corrects the button's (x,y) coordinates, label length, and response
8340 EEAE              ; code, all of which have been preset to default values.  Also sets
8341 EEAE              ; default_button to this button number if the button specifier contains a '!'.
8342 EEAE              ;
8343 EEAE              ; Created:      1/11/88
8344 EEAE              ; Modified:     3/31/88 JJ Changed default button indicator from '!' to '^'
8345 EEAE              ; Author:       JJ
8346 EEAE              ;
8347 EEAE              ; Input:        X = button number (0, 1, or 2)
8348 EEAE              ;               Y = offset in alert string just before button specifier
8349 EEAE              ;               P = nvmxdizc
8350 EEAE              ;                   ..110...
8351 EEAE              ;
8352 EEAE              ; Output:       A = trashed
8353 EEAE              ;               X = trashed
8354 EEAE              ;               Y = offset of the terminator just after the button specifier
8355 EEAE              ;               P = nvmxdizc
8356 EEAE              ;                   ..110...
8357 EEAE              ;===============================================================================
8358 EEAE
8359 EEAE              do_button proc 
8360 EEAE                       longa off
8361 EEAE                       longi off
8362 EEAE              ;
8363 EEAE              ; Check to see if the first character is an '^', indicating the default button.
8364 EEAE              ;
8365 EEAE C8                    iny                            ;Y = offset of first char of button spec
8366 EEAF B7 13                 lda   [<alert_ptr],y
8367 EEB1 C9 5E                 cmp   #'^'
8368 EEB3 D0 03                 bne   past_default
8369 EEB5 86 03        is_default stx   <default_button        ;save default button number
8370 EEB7 C8                    iny                            ;increment Y past default indicator
8371 EEB8              past_default  
8372 EEB8              ;
8373 EEB8              ; Now march through the button label, adjusting both the button length and
8374 EEB8              ; label x value to center the label.  Loop processes two characters, backspaces
8375 EEB8              ; on every other one.
8376 EEB8              ;
8377 EEB8 5A                    phy                            	;save Y
8378 EEB9
8379 EEB9 8A                    txa                            ;X = 4*button number
8380 EEBA 0A                    asl   a
8381 EEBB 0A                    asl   a
8382 EEBC AA                    tax   
8383 EEBD
8384 EEBD B7 13        but_label_loop lda   [<alert_ptr],y     ;get a character
8385 EEBF F0 1E                 beq   end_of_label1            ;moved here to avoid CMP #$00 (15-Dec-92 DAL)
8386 EEC1 C5 11                 cmp   <delim_char
8387 EEC3 F0 1A                 beq   end_of_label1
8388 EEC5 C9 0D                 cmp   #return_key
8389 EEC7 F0 16                 beq   end_of_label1
8390 EEC9              ;;;	cmp	#null0	;moved above, 15-Dec-92 DAL
8391 EEC9              ;;;	beq	end_of_label1
8392 EEC9 F6 07                 inc   <button_table+button_len,x ;increment label length
8393 EECB C8                    iny                            	;look at the next character
8394 EECC B7 13                 lda   [<alert_ptr],y           ;get the next character
8395 EECE F0 0F                 beq   end_of_label1            ;moved here to avoid CMP #$00 (15-Dec-92 DAL)
8396 EED0 C5 11                 cmp   <delim_char
8397 EED2 F0 0B                 beq   end_of_label1
8398 EED4 C9 0D                 cmp   #return_key
8399 EED6 F0 07                 beq   end_of_label1
8400 EED8              ;;;	cmp	#null0	;moved above, 15-Dec-92 DAL
8401 EED8              ;;;	beq	end_of_label1
8402 EED8 F6 07                 inc   <button_table+button_len,x ;increment label length
8403 EEDA D6 05                 dec   <button_table+button_x,x ;decrement starting pos
8404 EEDC C8                    iny   
8405 EEDD 80 DE                 bra   but_label_loop
8406 EEDF
8407 EEDF              end_of_label1  
8408 EEDF              ;
8409 EEDF              ; Set the cursor at the proper place to print out the button label.
8410 EEDF              ;
8411 EEDF
8412 EEDF A9 00                 lda   #$00                     ;put $00 into high byte of A
8413 EEE1 EB                    xba   
8414 EEE2
8415 EEE2 B5 06                 lda   <button_table+button_y,x ;get Y value
8416 EEE4 A8                    tay   
8417 EEE5
8418 EEE5 B5 05                 lda   <button_table+button_x,x ;get X value
8419 EEE7 1A                    inc   a                        ;increment to account for blanks
8420 EEE8 AA                    tax   
8421 EEE9
8422 EEE9 20 2D F2              jsr   gotoxy
8423 EEEC
8424 EEEC 7A                    ply                            ;restore Y (offset of first label char)
8425 EEED              ;
8426 EEED              ; Now copy label from alert string onto the screen.
8427 EEED              ;
8428 EEED              copy_label_loop  
8429 EEED B7 13                 lda   [<alert_ptr],y
8430 EEEF F0 10                 beq   done_copying             ;moved here to avoid CMP #$00 (15-Dec-92 DAL)
8431 EEF1 C5 11                 cmp   <delim_char
8432 EEF3 F0 0C                 beq   done_copying
8433 EEF5 C9 0D                 cmp   #return_key
8434 EEF7 F0 08                 beq   done_copying
8435 EEF9              ;;;	cmp	#null0	;moved above, 15-Dec-92 DAL
8436 EEF9              ;;;	beq	done_copying
8437 EEF9 5A                    phy                            ;save Y
8438 EEFA 20 4A F2              jsr   out80                    ;write out the character
8439 EEFD 7A                    ply                            ;restore Y
8440 EEFE C8                    iny                            ;look at next character
8441 EEFF 80 EC                 bra   copy_label_loop
8442 EF01
8443 EF01              done_copying  
8444 EF01
8445 EF01 60                    rts   
8446 EF02
8447 EF02                       longi on
8448 EF02                       longa on
8449 EF02
8450 EF02                       end_proc 
8451 EF02                       eject 
8452 EF02              ;===============================================================================
8453 EF02              ; s_sys_death
8454 EF02              ;
8455 EF02              ; Write out a system death message.
8456 EF02              ;
8457 EF02              ; Created:      2/4/88
8458 EF02              ; Modified:
8459 EF02              ; Author:       JJ
8460 EF02              ;
8461 EF02              ; Input:        A = error code in low byte
8462 EF02              ;               P = nvmxdizc
8463 EF02              ;                   ..000...
8464 EF02              ;
8465 EF02              ; Output:       None.  Does not return to the caller.
8466 EF02              ;===============================================================================
8467 EF02
8468 EF02              s_sys_death proc 
8469 EF02
8470 EF02              ;
8471 EF02              ; Translate error number into substitution string 3.
8472 EF02              ;
8473 EF02              ;	and	#$00FF	;make sure high byte is $00
8474 EF02 48                    pha                            ;set up parameters for Int2Hex
8475 EF03 F4 00 00              pea   0+(sub_str_3+1)>>16
8476 EF06 F4 12 EE              pea   sub_str_3+1
8477 EF09 F4 04 00              pea   4
8478 EF0C A2 0B 22 22           _Int2Hex 
8479 EF13              ;
8480 EF13              ; Turn 3-byte return address into 4-byte integer for input to Long2Hex.
8481 EF13              ;
8482 EF13 4B                    phk                            ;push dummy byte onto stack
8483 EF14 A3 02                 lda   2,s                      ;move ruturn address down
8484 EF16 83 01                 sta   1,s                      ;this new long word is the first
8485 EF18 A3 04                 lda   4,s                      ;...parameter to Long2Hex
8486 EF1A 29 FF 00              and   #$00FF
8487 EF1D 83 03                 sta   3,s
8488 EF1F              ;
8489 EF1F              ; Push remaining parameters for Long2Hex and call it to build substitution
8490 EF1F              ; string 1.
8491 EF1F              ;
8492 EF1F F4 00 00              pea   0+(sub_str_1+1)>>16
8493 EF22 F4 09 EE              pea   sub_str_1+1
8494 EF25 F4 06 00              pea   6
8495 EF28 A2 0B 23 22           _Long2Hex 
8496 EF2F              ;
8497 EF2F              ; Translate language card bank into substitution string 2.
8498 EF2F              ;
8499 EF2F E2 20                 sep   #m8
8500 EF31                       longa off
8501 EF31 AF 68 C0 00           lda   >$00c068                 ;get state register
8502 EF35 29 04                 and   #$04                     ;mask off LC bank bit
8503 EF37 4A                    lsr   a                        ;turn it into the character '0' or '1'
8504 EF38 4A                    lsr   a
8505 EF39 09 30                 ora   #'0'
8506 EF3B 8F 10 EE 00           sta   >sub_str_2+1
8507 EF3F C2 20                 rep   #m16
8508 EF41                       longa on
8509 EF41              *
8510 EF41              * Clear the system busy flag so we can get at CDA's during message...
8511 EF41              *
8512 EF41 A9 00 00              lda   #0000                    ;Clear busy flag.
8513 EF44 8F FF 00 E1           sta   >sys_busy_flag
8514 EF48              ;
8515 EF48              ; Display the error message.
8516 EF48              ;
8517 EF48 F4 13 00              pea   19                       ;push error number for system death
8518 EF4B F4 00 00              pea   death_sub_tbl>>16        ;push address of substitution
8519 EF4E F4 FC ED              pea   death_sub_tbl            ;...string table
8520 EF51 22 4C F0 00           jsl   s_full_error
8521 EF55              ;
8522 EF55              ; Restart the system.
8523 EF55              ;
8524 EF55 4C F6 EF              jmp   restart_system
8525 EF58
8526 EF58                       end_proc 
8527 EF58                       eject 
8528 EF58              ;===============================================================================
8529 EF58              ; s_report_error
8530 EF58              ;
8531 EF58              ; Write out an internationalized error message with 2 substitution strings.
8532 EF58              ;
8533 EF58              ; Created:      1/12/88
8534 EF58              ; Modified:
8535 EF58              ; Author:       JJ
8536 EF58              ;
8537 EF58              ; Input:        word    error number
8538 EF58              ;               pointer pointer to first substitution string
8539 EF58              ;               pointer pointer to second substitution string
8540 EF58              ;        S --->
8541 EF58              ;
8542 EF58              ;               P = nvmxdizc
8543 EF58              ;                   ..000...
8544 EF58              ;
8545 EF58              ; Output:       A = response indicating which button was pressed
8546 EF58              ;               X = trashed
8547 EF58              ;               Y = trashed
8548 EF58              ;               P = nvmxdizc
8549 EF58              ;                   ..000...
8550 EF58              ;===============================================================================
8551 EF58
8552 EF58              s_report_error proc 
8553 EF58              ;
8554 EF58              ; Move substitution string pointers from stack into fixed table.
8555 EF58              ;
8556 EF58 A3 08                 lda   8,s                      ;low word of first pointer
8557 EF5A 8F EC ED 00           sta   >sub_ptr_1
8558 EF5E A3 0A                 lda   10,s                     ;high word of first pointer
8559 EF60 8F EE ED 00           sta   >sub_ptr_1+2
8560 EF64
8561 EF64 A3 04                 lda   4,s                      ;low word of second pointer
8562 EF66 8F F0 ED 00           sta   >sub_ptr_2
8563 EF6A A3 06                 lda   6,s                      ;high word of second pointer
8564 EF6C 8F F2 ED 00           sta   >sub_ptr_2+2
8565 EF70              ;
8566 EF70              ; Set pointer to this table into correct stack location.
8567 EF70              ;
8568 EF70 A9 EC ED              lda   #sub_ptr_1               ;low word of pointer value
8569 EF73 83 05                 sta   5,s
8570 EF75 A9 00 00              lda   #sub_ptr_1>>16           ;high word of pointer value
8571 EF78 83 07                 sta   7,s
8572 EF7A              ;
8573 EF7A              ; Move error number down 3 bytes to make room for return address.
8574 EF7A              ;
8575 EF7A A3 0C                 lda   12,s
8576 EF7C 83 09                 sta   9,s
8577 EF7E              ;
8578 EF7E              ; Move return address up into the 3-byte void.
8579 EF7E              ;
8580 EF7E A3 01                 lda   1,s                      ;lower 2 bytes
8581 EF80 83 0B                 sta   11,s
8582 EF82 A3 02                 lda   2,s                      ;middle two bytes
8583 EF84 83 0C                 sta   12,s
8584 EF86              ;
8585 EF86              ; New stack is 4-bytes smaller, so do pulls.
8586 EF86              ;
8587 EF86 68                    pla   
8588 EF87 68                    pla   
8589 EF88              ;
8590 EF88              ; Finally able to call full_error
8591 EF88              ;
8592 EF88 22 4C F0 00           jsl   s_full_error
8593 EF8C
8594 EF8C 18                    clc   
8595 EF8D 6B                    rtl   
8596 EF8E
8597 EF8E                       end_proc 
8598 EF8E                       eject 
8599 EF8E              ;===============================================================================
8600 EF8E              ; s_report_fatal
8601 EF8E              ;
8602 EF8E              ; Write out the internationalized fatal error message.
8603 EF8E              ;
8604 EF8E              ; Created:      1/21/88
8605 EF8E              ; Modified:
8606 EF8E              ; Author:       JJ
8607 EF8E              ;
8608 EF8E              ; Input:        word    fatal error number to be printed in message as
8609 EF8E              ;                       substitution string 2
8610 EF8E              ;               word    error message number in error message file
8611 EF8E              ;               pointer pointer to substitution string 1 (may be null)
8612 EF8E              ;        S --->
8613 EF8E              ;
8614 EF8E              ;               P = nvmxdizc
8615 EF8E              ;                   ..000...
8616 EF8E              ;
8617 EF8E              ; Output:       A = response indicating which button was pressed
8618 EF8E              ;               X = trashed
8619 EF8E              ;               Y = trashed
8620 EF8E              ;               P = nvmxdizc
8621 EF8E              ;                   ..000...
8622 EF8E              ;===============================================================================
8623 EF8E
8624 EF8E              s_report_fatal proc 
8625 EF8E                       entry restart_system
8626 EF8E              *
8627 EF8E              * Make sure our direct page is in...
8628 EF8E              *
8629 EF8E A9 00 BD              lda   #direct_base             ;Set our direct page.
8630 EF91 5B                    tcd   
8631 EF92              *
8632 EF92              * Force preferences to not suppress error messages...
8633 EF92              *
8634 EF92 AF F6 B9 00           lda   >sys_prefs               ;Get prefs.
8635 EF96 29 FF DF              and   #%1101111111111111       ;Clear bit 13.
8636 EF99 8F F6 B9 00           sta   >sys_prefs               ;Save it.
8637 EF9D              ;
8638 EF9D              ; Move fatal error number into temporary.
8639 EF9D              ;
8640 EF9D A3 0A                 lda   10,s
8641 EF9F 8F F4 ED 00           sta   >fatal_err_num
8642 EFA3              ;
8643 EFA3              ; Move substitution string pointer into substitution string pointer table.
8644 EFA3              ;
8645 EFA3 A3 04                 lda   4,s
8646 EFA5 8F EC ED 00           sta   >sub_ptr_1
8647 EFA9 A3 06                 lda   6,s
8648 EFAB 8F EE ED 00           sta   >sub_ptr_1+2
8649 EFAF              ;
8650 EFAF              ; Move alert error number one byte lower in the stack.
8651 EFAF              ;
8652 EFAF A3 08                 lda   8,s
8653 EFB1 83 07                 sta   7,s
8654 EFB3              ;
8655 EFB3              ; Move return address above the other parameters.
8656 EFB3              ;
8657 EFB3 A3 01                 lda   1,s
8658 EFB5 83 09                 sta   9,s
8659 EFB7 A3 02                 lda   2,s
8660 EFB9 83 0A                 sta   10,s
8661 EFBB              ;
8662 EFBB              ; Put pointer to substitution string table into stack.
8663 EFBB              ;
8664 EFBB A9 EC ED              lda   #sub_ptr_1
8665 EFBE 83 03                 sta   3,s
8666 EFC0 A9 00 00              lda   #sub_ptr_1>>16
8667 EFC3 83 05                 sta   5,s
8668 EFC5              ;
8669 EFC5              ; Reduce size of the stack by 2 bytes.
8670 EFC5              ;
8671 EFC5 68                    pla   
8672 EFC6              ;
8673 EFC6              ; Make second substitution string pointer point at location where ASCII
8674 EFC6              ; translation of fatal error number will be.
8675 EFC6              ;
8676 EFC6 A9 F6 ED              lda   #fatal_err_str
8677 EFC9 8F F0 ED 00           sta   >sub_ptr_2
8678 EFCD A9 00 00              lda   #fatal_err_str>>16
8679 EFD0 8F F2 ED 00           sta   >sub_ptr_2+2
8680 EFD4              ;
8681 EFD4              ; Translate fatal error number into ASCII.
8682 EFD4              ;
8683 EFD4 AF F4 ED 00           lda   >fatal_err_num           ;push the integer to translate
8684 EFD8 48                    pha   
8685 EFD9 F4 00 00              pea   0+(fatal_err_str+2)>>16  ;push address of translation
8686 EFDC F4 F8 ED              pea   fatal_err_str+2          ;...buffer
8687 EFDF F4 04 00              pea   4                        ;push field size
8688 EFE2 A2 0B 22 22           _Int2Hex 
8689 EFE9              ;
8690 EFE9              ; Finally call full_error.
8691 EFE9              ;
8692 EFE9 22 4C F0 00           jsl   s_full_error
8693 EFED              *
8694 EFED              * Now we jump to shutdown_reboot which will shutdown the system then jump
8695 EFED              * to restart_system below.  However, first we must check a flag set by
8696 EFED              * Gquit which tells us whether or not we're fully up and running;  if we're
8697 EFED              * not, we cannot do any of the shutdown procedures, can only reboot...
8698 EFED              *
8699 EFED AF E9 D6 E1           lda   >e1_gsos_ok              ;Ok to do shutdown?
8700 EFF1 F0 03                 beq   restart_system           ;Nope, so just reboot.
8701 EFF3
8702 EFF3 4C B3 E8              jmp   shutdown_reboot          ;Yes, force shutdown then restart.
8703 EFF6              ;
8704 EFF6              ; Nothing to do but reboot the system.
8705 EFF6              ;
8706 EFF6              restart_system  
8707 EFF6
8708 EFF6 78                    sei                            ;disable interrupts
8709 EFF7              ;
8710 EFF7              ; Turn off the mouse.  Ignore any errors.
8711 EFF7              ;
8712 EFF7 F4 00 00              pea   $0000                    ;mouse off status code
8713 EFFA A2 03 19              ldx   #$1903                   ;setMouse Miscellaneous Toolkit call
8714 EFFD 22 00 00 E1           jsl   $e10000                  ;call Tool Locator
8715 F001              ;
8716 F001              ; Turn on the 40-column text screen.
8717 F001              ;
8718 F001 20 A9 F2              jsr   save_screen
8719 F004
8720 F004 A9 00 00              lda   #$0000                   ;set D to $0000
8721 F007 5B                    tcd   
8722 F008
8723 F008              ;
8724 F008              ; Set up instructions to set the state register and jmp $fa62
8725 F008              ;
8726 F008 48                    pha                            ;set DBR to zero
8727 F009 AB                    plb   
8728 F00A AB                    plb   
8729 F00B A9 8D 68              lda   #$688d                   ;sets up 0300: sta $c068
8730 F00E              *** 17-Jul-92 DAL -- Changed to use $F0..F5 instead of $300..305
8731 F00E              ;;;	sta	$0300	;        0303: jmp $fa62
8732 F00E 85 F0                 sta   <$F0
8733 F010 A9 C0 4C              lda   #$4cc0
8734 F013              ;;;	sta	$0302
8735 F013 85 F2                 sta   <$F2
8736 F015 A9 62 FA              lda   #$fa62
8737 F018              ;;;	sta	$0304
8738 F018 85 F4                 sta   <$F4
8739 F01A              ;
8740 F01A              ; Enter emulation mode and disable various system components.
8741 F01A              ;
8742 F01A                       longa off
8743 F01A                       longi off
8744 F01A 38                    sec                            ;go into emulation mode
8745 F01B FB                    xce   
8746 F01C
8747 F01C 9C 35 C0              stz   $c035                    ;set full emulation shadowing
8748 F01F
8749 F01F 9C 47 C0              stz   $c047                    ;disable AppleTalk interrupts
8750 F022 9C 41 C0              stz   $c041
8751 F025
8752 F025 9C 23 C0              stz   $c023                    ;disable VGC interrupts
8753 F028
8754 F028 A9 09                 lda   #$09                     ;disable SCC
8755 F02A 8D 39 C0              sta   $c039
8756 F02D A9 C0                 lda   #$c0
8757 F02F 8D 39 C0              sta   $c039
8758 F032
8759 F032 EE F4 03              inc   $03f4                    ;trash the power up byte
8760 F035
8761 F035 A9 0C                 lda   #$0c
8762 F037              ;;;	jmp	>$000300	;go reboot the system
8763 F037 5C F0 00 00           jmp   >$0000F0                 ;17-Jul-92 DAL
8764 F03B
8765 F03B                       longa on
8766 F03B                       longi on
8767 F03B
8768 F03B                       end_proc 
8769 F03B                       eject 
8770 F03B              ;===============================================================================
8771 F03B              ; s_toolbox_msg -- 20-Aug-92 DAL
8772 F03B              ;
8773 F03B              ; Used by AlertMessage in the Misc tools.  Just like s_full_error, but it is not
8774 F03B              ; based on e1_msg_address.
8775 F03B              ;
8776 F03B              ; Input:        word    error message number
8777 F03B              ;               pointer pointer to table of pointers to substitution strings
8778 F03B              ;
8779 F03B              ;               YX      pointer to table of error messages (like Error.Msg)
8780 F03B              ;
8781 F03B              ; Output:       A = result code indicating which button was pressed
8782 F03B              ;
8783 F03B              ;===============================================================================
8784 F03B              s_toolbox_msg proc 
8785 F03B                       import toolbox_entry 
8786 F03B
8787 F03B 8B                    phb                            ;save DBR
8788 F03C 4B                    phk                            ;set DBR to PBR
8789 F03D AB                    plb   
8790 F03E 0B                    phd                            ;save D
8791 F03F
8792 F03F 3B                    tsc                            ;open up dp_size workspace on stack
8793 F040 38                    sec                            ;...and set both S and D to point
8794 F041 E9 28 00              sbc   #dp_size                 ;...one byte below workspace
8795 F044 1B                    tcs   
8796 F045 5B                    tcd   
8797 F046
8798 F046 84 27                 sty   <aptr+2
8799 F048 86 25                 stx   <aptr
8800 F04A
8801 F04A 80 30                 bra   toolbox_entry
8802 F04C
8803 F04C                       EndP 
8804 F04C
8805 F04C              ;===============================================================================
8806 F04C              ; s_full_error
8807 F04C              ;
8808 F04C              ; Write out one of the internationalized error message.
8809 F04C              ;
8810 F04C              ; Created:      1/12/88
8811 F04C              ; Modified:     3/31/88 JJ Changed calling sequence for AlertWindow tool call
8812 F04C              ;               6/25/88 JJ Save GS/OS direct page and one page below it before
8813 F04C              ;                          calling alertWindow in order to assure alertWindow
8814 F04C              ;                          enough space on the GS/OS stack.  Restore data after
8815 F04C              ;                          alertWindow returns.
8816 F04C              ; Author:       JJ
8817 F04C              ;
8818 F04C              ; Input:        word    error message number
8819 F04C              ;               pointer pointer to table of pointers to substitution strings
8820 F04C              ;        S --->
8821 F04C              ;
8822 F04C              ;               P = nvmxdizc
8823 F04C              ;                   ..000...
8824 F04C              ;
8825 F04C              ; Output:       removes everything from the stack
8826 F04C              ;               A = result code indicating which button was pressed
8827 F04C              ;               X = trashed
8828 F04C              ;               Y = trashed
8829 F04C              ;               P = nvmxdizc
8830 F04C              ;                   ..000...
8831 F04C              ;===============================================================================
8832 F04C
8833 F04C              s_full_error proc 
8834 F04C
8835 F04C 8B                    phb                            ;save DBR
8836 F04D 4B                    phk                            ;set DBR to PBR
8837 F04E AB                    plb   
8838 F04F 0B                    phd                            ;save D
8839 F050
8840 F050 3B                    tsc                            ;open up dp_size workspace on stack
8841 F051 38                    sec                            ;...and set both S and D to point
8842 F052 E9 28 00              sbc   #dp_size                 ;...one byte below workspace
8843 F055 1B                    tcs   
8844 F056 5B                    tcd   
8845 F057              ;
8846 F057              ; Set up pointer to error data.  First bang in the LC BANK 0 to access the
8847 F057              ;  GLOADER variable e1_msg_address.
8848 F057              ;
8849 F057 E2 20                 sep   #$20
8850 F059                       longa off
8851 F059 AD 68 C0              lda   |statereg
8852 F05C 48                    pha   
8853 F05D 29 FB                 and   #%11111011
8854 F05F 8D 68 C0              sta   |statereg
8855 F062 C2 20                 rep   #$20
8856 F064                       longa on
8857 F064
8858 F064 AF F3 D6 E1           lda   >e1_msg_address          ;get error message handle set up at
8859 F068 18                    clc   
8860 F069 69 04 00              adc   #$0004
8861 F06C 85 25                 sta   <aptr
8862 F06E AF F5 D6 E1           lda   >e1_msg_address+2
8863 F072              ;;;	adc	#$0000	;segment has no-bank-cross set! (15-Dec-92 DAL, saved 3 bytes)
8864 F072 85 27                 sta   <aptr+2
8865 F074
8866 F074 E2 20                 sep   #$20
8867 F076 68                    pla   
8868 F077 8D 68 C0              sta   |statereg
8869 F07A C2 20                 rep   #$20
8870 F07C
8871 F07C                       export toolbox_entry 
8872 F07C 20 78 F3     toolbox_entry jsr   which_one           ;should we run in graphics or text?
8873 F07F 08                    php                            ;save indication (c)
8874 F080
8875 F080 20 75 F1              jsr   oh_my_god                ;Set pointer.
8876 F083
8877 F083 A5 2F                 lda   <s_subst_ptr             ;move substring table pointer to DP
8878 F085 85 17                 sta   <subst_ptr
8879 F087 A5 31                 lda   <s_subst_ptr+2
8880 F089 85 19                 sta   <subst_ptr+2
8881 F08B              *
8882 F08B              * Do the preferences say to suppress error messages?
8883 F08B              *
8884 F08B AF F6 B9 00           lda   >sys_prefs               ;Get prefs.
8885 F08F 29 00 20              and   #%0010000000000000       ;Suppress errors?
8886 F092 F0 24                 beq   mode_select              ;Nope.
8887 F094              *
8888 F094              * Yes, so we must determine if this message has more than one button.  If so,
8889 F094              * we will go ahead anyway...
8890 F094              *
8891 F094                       longa off                      ;Enter 8-bit m mode
8892 F094 E2 20                 sep   #m8
8893 F096
8894 F096 A0 00 00              ldy   #0000                    ;Find end of alert string.
8895 F099 B7 13        find_end_loop lda   [<alert_ptr],y
8896 F09B F0 03                 beq   found_end
8897 F09D C8                    iny   
8898 F09E 80 F9                 bra   find_end_loop
8899 F0A0
8900 F0A0 A2 03 00     found_end ldx   #0003                   ;Set up to loop thru 3 buttons.
8901 F0A3
8902 F0A3 C8           button_loop iny                         ;Point to button response.
8903 F0A4 B7 13                 lda   [<alert_ptr],y           ;Get response.
8904 F0A6 29 0F                 and   #$0f                     ;Is non-zero?
8905 F0A8 D0 0C                 bne   more_than_one            ;Yep, so more than one.
8906 F0AA CA                    dex                            ;Nope, done all 3 buttons?
8907 F0AB D0 F6                 bne   button_loop              ;Nope, so loop.
8908 F0AD              *
8909 F0AD              * Only one button so cleanup and exit with default response...
8910 F0AD              *
8911 F0AD                       longa on                       ;back to 16-bit m mode
8912 F0AD C2 20                 rep   #m16
8913 F0AF
8914 F0AF 68                    pla                            ;Clean off mode selection.
8915 F0B0 A2 00 00              ldx   #0000                    ;Set default response.
8916 F0B3 4C 60 F1              jmp   suppressed_exit          ;Exit.
8917 F0B6              *
8918 F0B6              * Yes, so select either graphics or text and go do it...
8919 F0B6              *
8920 F0B6                       longa on                       ;Enter 16-bit m mode.
8921 F0B6 C2 20        more_than_one rep   #m8
8922 F0B8
8923 F0B8 28           mode_select plp                         ;recover p (c bit)
8924 F0B9 B0 03                 bcs   call_graphics
8925 F0BB 4C 54 F1              jmp   call_text                ;if c=0 do text display- no aptr adjust
8926 F0BE              call_graphics  
8927 F0BE
8928 F0BE                       longa off                      ;enter 8-bit m and x mode
8929 F0BE                       longi off
8930 F0BE E2 30                 sep   #mx8
8931 F0C0              ;
8932 F0C0              ; Set up proper button response map.
8933 F0C0              ;
8934 F0C0 A0 01                 ldy   #$01                     ;preload Y with 1
8935 F0C2 A7 13                 lda   [<alert_ptr]             ;get window size descriptor
8936 F0C4 29 0F                 and   #$0f
8937 F0C6 D0 02                 bne   dont_change_y            ;make Y skip past descriptor by setting
8938 F0C8 A0 09                 ldy   #$09                     ;...it to either 1 or 9
8939 F0CA              dont_change_y  
8940 F0CA
8941 F0CA B7 13                 lda   [<alert_ptr],y           ;get icon descriptor
8942 F0CC 29 0F                 and   #$0f
8943 F0CE D0 05                 bne   inc_by_1                 ;increment Y by either 1 or 9 to skip
8944 F0D0 98                    tya                            ;...over icon descriptor
8945 F0D1 18                    clc   
8946 F0D2 69 08                 adc   #$08
8947 F0D4 A8                    tay   
8948 F0D5 C8           inc_by_1 iny   
8949 F0D6
8950 F0D6 B7 13        loop_to_end lda   [<alert_ptr],y        ;loop until we see $00 or $13
8951 F0D8              ;;;	cmp	#null0	;saved 2 bytes (15-Dec-92 DAL)
8952 F0D8 F0 03                 beq   at_end
8953 F0DA C8                    iny   
8954 F0DB 80 F9                 bra   loop_to_end
8955 F0DD              at_end    
8956 F0DD
8957 F0DD C8                    iny                            ;offset to first byte of button resp map
8958 F0DE B7 13                 lda   [<alert_ptr],y
8959 F0E0 85 08                 sta   <button_table+button_resp
8960 F0E2 C8                    iny   
8961 F0E3 B7 13                 lda   [<alert_ptr],y
8962 F0E5 85 0C                 sta   <button_table+button_resp+record_len
8963 F0E7 C8                    iny   
8964 F0E8 B7 13                 lda   [<alert_ptr],y
8965 F0EA 85 10                 sta   <button_table+button_resp+2*record_len
8966 F0EC              ;
8967 F0EC              ; Prepare to call the AlertWindow tool.  First, save the GS/OS direct page
8968 F0EC              ; and the page below it to make sure alertWindow has plenty of space on the
8969 F0EC              ; GS/OS stack.
8970 F0EC              ;
8971 F0EC AD 68 C0              lda   |statereg                ;save contents of state register
8972 F0EF 48                    pha   
8973 F0F0 AD 83 C0              lda   |lcbank2                 ;switch in second $D000 space
8974 F0F3 AD 83 C0              lda   |lcbank2
8975 F0F6
8976 F0F6                       longa on                       ;back to 16-bit m and x mode
8977 F0F6                       longi on
8978 F0F6 C2 30                 rep   #mx16
8979 F0F8
8980 F0F8 A2 FE 01              ldx   #510                     ;offset of first word to copy
8981 F0FB BF 00 BC 00  save_dp  lda   >direct_base-256,x
8982 F0FF 9F 00 D0 E0           sta   >dp_save_area,x
8983 F103 CA                    dex   
8984 F104 CA                    dex   
8985 F105 10 F4                 bpl   save_dp
8986 F107              ;
8987 F107              ; Save the current cursor, and set the current cursor to be the arrow cursor.
8988 F107              ;
8989 F107 48                    pha                            ;open up space for result
8990 F108 48                    pha   
8991 F109 A2 04 8F 22           _GetCursorAdr                  ;after call stack contains long pointer
8992 F110 A2 04 CA 22           _InitCursor                    ;set to arrow cursor no parameters
8993 F117
8994 F117              ;
8995 F117              ; Do the alert and restore saved parms...
8996 F117              ;
8997 F117
8998 F117 AD 8B C0              lda   |lcbank1                 ;switch in primary $D000 space
8999 F11A AD 8B C0              lda   |lcbank1
9000 F11D 22 C6 DE E1           jsl   do_alert_window
9001 F121 AD 83 C0              lda   |lcbank2                 ;switch in second $D000 space
9002 F124 AD 83 C0              lda   |lcbank2
9003 F127
9004 F127 68                    pla                            ;pull long address of original cursor
9005 F128 FA                    plx   
9006 F129
9007 F129 08                    php                            ;save error code from tool
9008 F12A 5A                    phy                            ;save response from alert window
9009 F12B
9010 F12B DA                    phx                            ;push long address of original cursor
9011 F12C 48                    pha   
9012 F12D A2 04 8E 22           _SetCursor                     ;restore the cursor please
9013 F134 7A                    ply                            ;restore result from alert window
9014 F135 28                    plp                            ;restore error flag
9015 F136
9016 F136              ;
9017 F136              ; Copy back data that were saved before call.  Note, nothing changes c bit.
9018 F136              ;
9019 F136 A2 FE 01              ldx   #510
9020 F139 BF 00 D0 E0  restore_dp lda   >dp_save_area,x
9021 F13D 9F 00 BC 00           sta   >direct_base-256,x
9022 F141 CA                    dex   
9023 F142 CA                    dex   
9024 F143 10 F4                 bpl   restore_dp
9025 F145              ;
9026 F145              ; Restore language card state.  Note, nothing changes c bit
9027 F145              ;
9028 F145                       longa off                      ;8-bit m mode
9029 F145 E2 20                 sep   #m8
9030 F147 68                    pla                            ;get saved state information
9031 F148 8D 68 C0              sta   |statereg
9032 F14B                       longa on                       ;back to 16-bit m mode
9033 F14B C2 20                 rep   #m16
9034 F14D              ;
9035 F14D              ; Put saved return value from alertWindow into A.  Note c value from
9036 F14D              ; alertWindow is still preserved.
9037 F14D              ;
9038 F14D 98                    tya   
9039 F14E
9040 F14E 90 07                 bcc   all_done                 ;if no error, we're done; else, fall
9041 F150                                                      ;...through to text alert procedure
9042 F150
9043 F150 18                    clc   
9044 F151 20 75 F1              jsr   oh_my_god                ;Must set aptr again
9045 F154
9046 F154              ; Call the text alert procedure
9047 F154
9048 F154 20 8D F1     call_text jsr   text_alert
9049 F157
9050 F157              all_done  
9051 F157              ;
9052 F157              ; Map the response button number to the proper response value.
9053 F157              ;
9054 F157 0A                    asl   a                        ;response code in A
9055 F158 0A                    asl   a
9056 F159 AA                    tax   
9057 F15A B5 08                 lda   <button_table+button_resp,x
9058 F15C 29 03 00              and   #$0003                   ;Convert from ASCII and strip misc
9059 F15F AA                    tax                            ;save response code in X
9060 F160
9061 F160 7B           suppressed_exit tdc                     ;restore old value of stack pointer
9062 F161              *** optimized 20-Aug-92 DAL -- carry is clear from asl a above
9063 F161              ;;;	clc		;D contains the value
9064 F161 69 28 00              adc   #dp_size
9065 F164 1B                    tcs   
9066 F165
9067 F165 2B                    pld                            ;restore old value of D
9068 F166 AB                    plb                            ;restore old value of DBR
9069 F167
9070 F167 A3 01                 lda   1,s                      ;move the 3-byte return address 6 bytes
9071 F169 83 07                 sta   7,s                      ;...higher in the stack (squeezing out
9072 F16B A3 02                 lda   2,s                      ;...the input parameters)
9073 F16D 83 08                 sta   8,s
9074 F16F
9075 F16F              ;	tsc		;S <-- S+6
9076 F16F              ;	clc
9077 F16F              ;	adc	#6
9078 F16F              ;	tcs
9079 F16F              *** optimized 20-Aug-92 DAL
9080 F16F 68                    pla   
9081 F170 68                    pla   
9082 F171 68                    pla   
9083 F172              *** end 20-Aug-92
9084 F172
9085 F172 8A                    txa                            ;move saved response code to A
9086 F173
9087 F173 18                    clc   
9088 F174 6B                    rtl   
9089 F175
9090 F175
9091 F175              ; Sets alert_ptr based on <aptr, <s_error, and the carry.
9092 F175
9093 F175 A5 33        oh_my_god lda   <s_error                ;get error # passed by caller
9094 F177 2A                    rol   a                        ;make offset into error data struct
9095 F178 0A                    asl   a
9096 F179 A8                    tay                            ;Offset of offset word to string
9097 F17A
9098 F17A A6 27                 ldx   <aptr+2                  ;Load up hi ord result for inc'ing
9099 F17C              *	tya		;Move the offset into A
9100 F17C 18                    clc   
9101 F17D 77 25                 adc   [<aptr],y                ;Total offset into table (low)
9102 F17F 90 02                 bcc   m1                       ;Take if no carry
9103 F181 E8                    inx                            ;Increment if carry
9104 F182 18                    clc   
9105 F183 65 25        m1       adc   <aptr                    ;String Address (low)
9106 F185 90 01                 bcc   j1
9107 F187 E8                    inx                            ;X has the string address (high)
9108 F188 85 13        j1       sta   <alert_ptr
9109 F18A 86 15                 stx   <alert_ptr+2
9110 F18C 60                    rts   
9111 F18D
9112 F18D
9113 F18D                       end_proc 
9114 F18D                       eject 
9115 F18D              ;======================================================================
9116 F18D              ; text_alert : Display the alert box on the text screen
9117 F18D              ;
9118 F18D              ;Created:       January 13, 1988
9119 F18D              ;Modified:      January 13, 1988
9120 F18D              ;Author:        Mike Askins
9121 F18D              ;
9122 F18D              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9123 F18D              ;
9124 F18D              ;Input:         A = <undefined>
9125 F18D              ;               X = <undefined>
9126 F18D              ;               Y = <undefined>
9127 F18D              ;               P = nvmxdizc
9128 F18D              ;                   ..000...
9129 F18D              ;       subst_ptr = pointer to substitution string pointer table
9130 F18D              ;       alert_ptr = pointer to alert string
9131 F18D              ;
9132 F18D              ;Output:        A = Selected Option Number  <0..number_buttons-1>
9133 F18D              ;               X = <trashed>
9134 F18D              ;               Y = <trashed>
9135 F18D              ;               P = nvmxdizc
9136 F18D              ;                   ..000...
9137 F18D              ;               b = preserved
9138 F18D              ;
9139 F18D              ;======================================================================
9140 F18D
9141 F18D              text_alert proc 
9142 F18D                       longa on
9143 F18D
9144 F18D 20 A9 F2              jsr   save_screen              ;Save text screen and set text mode
9145 F190
9146 F190 E2 30                 sep   #$30                     ;8 bit mode
9147 F192 20 68 F2              jsr   draw_box                 ;Draw the dialog box frame
9148 F195
9149 F195 C2 30                 rep   #$30                     ;16 bit mode
9150 F197 20 16 EE              jsr   scan_alert               ;Draw the dialog contents
9151 F19A
9152 F19A E2 30                 sep   #$30                     ;8 bit mode
9153 F19C 20 C2 F3              jsr   prompt                   ;Draw the correct LI prompt
9154 F19F
9155 F19F 20 AD F1              jsr   select                   ;Get user input
9156 F1A2
9157 F1A2 C2 30                 rep   #$30                     ;16 bit mode
9158 F1A4 29 FF 00              and   #$00FF                   ;Only want low part
9159 F1A7 48                    pha                            ;Save the result
9160 F1A8 20 2A F3              jsr   restore_screen           ;Reset text area and video mode
9161 F1AB 68                    pla                            ;Get back the selection code
9162 F1AC
9163 F1AC 60                    rts   
9164 F1AD
9165 F1AD                       end_proc 
9166 F1AD                       eject 
9167 F1AD              ;======================================================================
9168 F1AD              ; select : Allow selection of an option on the text screen
9169 F1AD              ;
9170 F1AD              ;Created:       January 12, 1988
9171 F1AD              ;Modified:      January 12, 1988
9172 F1AD              ;Author:        Mike Askins
9173 F1AD              ;
9174 F1AD              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9175 F1AD              ;
9176 F1AD              ;Input:         A = <undefined>
9177 F1AD              ;               X = <undefined>
9178 F1AD              ;               Y = <undefined>
9179 F1AD              ;               P = nvmxdizc
9180 F1AD              ;                   ..100...
9181 F1AD              ;  default_button = initially highlighted option
9182 F1AD              ;     num_buttons = number of options to cycle through
9183 F1AD              ;    button_table = position and length of each button
9184 F1AD              ;
9185 F1AD              ;Output:        A = Selected Option Number  <0..number_buttons-1>
9186 F1AD              ;               X = <trashed>
9187 F1AD              ;               Y = <trashed>
9188 F1AD              ;               P = nvmxdizc
9189 F1AD              ;                   ..1...
9190 F1AD              ;               b = preserved
9191 F1AD              ; selected_button = Selected Option Number
9192 F1AD              ;
9193 F1AD              ;======================================================================
9194 F1AD
9195 F1AD              ; This routine gets keys from the keyboard or event manager and allows
9196 F1AD              ;  the user to select one of the options on the screen.  The forward and
9197 F1AD              ;  backward arrows rotate around the options highlighting them.  When a CR
9198 F1AD              ;  is encountered, the highlighted option is passed back to the caller.
9199 F1AD
9200 F1AD              select   proc 
9201 F1AD
9202 F1AD                       longa off                      ;This routine is only in 8 bit land
9203 F1AD
9204 F1AD A5 03                 lda   <default_button
9205 F1AF              storeninverse  
9206 F1AF 85 21                 sta   <selected_button
9207 F1B1 20 00 F2              jsr   inverse
9208 F1B4              loop      
9209 F1B4 22 7D DF E1           jsl   getkey
9210 F1B8 C9 15                 cmp   #right_arrow             ;Allow both the right and down arrows
9211 F1BA F0 04                 beq   its_right
9212 F1BC C9 0A                 cmp   #down_arrow
9213 F1BE D0 12                 bne   not_right
9214 F1C0
9215 F1C0              its_right  
9216 F1C0 A5 21                 lda   <selected_button
9217 F1C2 1A                    inc   a
9218 F1C3 C5 01                 cmp   <num_buttons
9219 F1C5 90 02                 blt   switch
9220 F1C7 A9 00                 lda   #0                       ;Wrap
9221 F1C9
9222 F1C9              switch    
9223 F1C9 48                    pha                            ;Save off new setting for a second
9224 F1CA A5 21                 lda   <selected_button
9225 F1CC 20 00 F2              jsr   inverse
9226 F1CF 68                    pla   
9227 F1D0 80 DD                 bra   storeninverse
9228 F1D2
9229 F1D2              not_right  
9230 F1D2 C9 08                 cmp   #left_arrow              ;Allow both the left and up arrows
9231 F1D4 F0 04                 beq   its_left
9232 F1D6 C9 0B                 cmp   #up_arrow
9233 F1D8 D0 0A                 bne   not_left
9234 F1DA
9235 F1DA              its_left  
9236 F1DA A5 21                 lda   <selected_button
9237 F1DC              *** optimized 20-Aug-92 DAL
9238 F1DC              ;;;	sec
9239 F1DC              ;;;	sbc	#$01	;Set N flag
9240 F1DC 3A                    dec   a
9241 F1DD              *** end 20-Aug-92
9242 F1DD 10 03                 bpl   nowrap
9243 F1DF A5 01                 lda   <num_buttons
9244 F1E1 3A                    dec   a
9245 F1E2              nowrap    
9246 F1E2 80 E5                 bra   switch
9247 F1E4
9248 F1E4              not_left  
9249 F1E4 C9 0D                 cmp   #return_key
9250 F1E6 D0 03                 bne   not_return
9251 F1E8
9252 F1E8 A5 21                 lda   <selected_button
9253 F1EA 60                    rts   
9254 F1EB
9255 F1EB              not_return  
9256 F1EB              *** optimized 20-Aug-92 DAL
9257 F1EB              ;	cmp	#$5A	;special flag for disk insertion?
9258 F1EB              ;	bne	no_insertion	;no...
9259 F1EB              *** end 20-Aug-92
9260 F1EB EB                    xba                            ;must check high byte too
9261 F1EC C9 A5                 cmp   #$A5
9262 F1EE D0 03                 bne   no_insertion
9263 F1F0 A5 03                 lda   <default_button          ;else simulate a default keypress
9264 F1F2 60                    rts   
9265 F1F3
9266 F1F3 C2 30        no_insertion rep   #$30
9267 F1F5 A2 03 2C              ldx   #$2C03                   ;SysBeep
9268 F1F8 22 00 00 E1           jsl   $E10000
9269 F1FC E2 30                 sep   #$30
9270 F1FE 80 B4                 bra   loop
9271 F200
9272 F200                       longa on
9273 F200                       end_proc 
9274 F200                       eject 
9275 F200              ;======================================================================
9276 F200              ; inverse : Inverse the option screen text specified in the acculumulator
9277 F200              ;
9278 F200              ;Created:       January 12, 1988
9279 F200              ;Modified:      January 12, 1988
9280 F200              ;Author:        Mike Askins
9281 F200              ;
9282 F200              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9283 F200              ;
9284 F200              ;Input:         A = Option Text to Highlight <0..num_buttons-1>
9285 F200              ;               X = <undefined>
9286 F200              ;               Y = <undefined>
9287 F200              ;               P = nvmxdizc
9288 F200              ;                   ..110...
9289 F200              ;    button_table = position and length of each button
9290 F200              ;
9291 F200              ;Output:        A = <trashed>
9292 F200              ;               X = <trashed>
9293 F200              ;               Y = <trashed>
9294 F200              ;               P = nvmxdizc
9295 F200              ;                   ..110...
9296 F200              ;               b = preserved
9297 F200              ;
9298 F200              ;======================================================================
9299 F200
9300 F200              inverse  proc 
9301 F200                       entry loop45
9302 F200
9303 F200                       longa off
9304 F200                       longi off
9305 F200
9306 F200              ; Get to the button_table entry for the option specified, and pull the
9307 F200              ;  position and length data.
9308 F200
9309 F200 0A                    asl   a
9310 F201 0A                    asl   a
9311 F202 AA                    tax   
9312 F203 B5 07                 lda   <button_table+2,x
9313 F205 48                    pha                            ;Keep the length of the option text
9314 F206 B5 05                 lda   <button_table,x
9315 F208 18                    clc   
9316 F209 69 01                 adc   #box_orig_x+xbias        ;Convert to screen coords
9317 F20B A8                    tay                            ;Keep around the X value
9318 F20C B5 06                 lda   <button_table+1,x        ;Get the Y value
9319 F20E 18                    clc   
9320 F20F 69 08                 adc   #box_orig_y+ybias        ;Convert to screen coords
9321 F211
9322 F211              ; Now set up the offsets into the text page for the line that the text is on.
9323 F211
9324 F211 20 39 F2              jsr   mybc                     ;Set up the pointers into the text area
9325 F214 BB                    tyx                            ;Y was preserved
9326 F215 7A                    ply                            ;Text length -> Y
9327 F216
9328 F216              ; Now walk through the characters on the screen reversing their 'inverse'
9329 F216              ;  status.  Stop after Y characters.
9330 F216
9331 F216              loop45                                  ;        ;*** Don't move without the lda below **
9332 F216 BF 00 00 E0           lda   >$E00000,x               ;Non bank part set by mybc routine
9333 F21A
9334 F21A              ; Inversing is normally done by flipping the top bit.  This doesn't work for
9335 F21A              ;  characters in the range $C0-$DF (Normal Uppercase).  Just flipping their
9336 F21A              ;  top bit turns them into MouseText.  The range $C0-DF must become $00-1F.
9337 F21A
9338 F21A C9 C0                 cmp   #$C0
9339 F21C 90 06                 blt   nonissue
9340 F21E C9 E0                 cmp   #$E0
9341 F220 B0 02                 bge   nonissue
9342 F222 29 BF                 and   #%10111111               ;A <- 100xxxxx
9343 F224
9344 F224              ; Do the inverse, dec the count and maybe go back
9345 F224
9346 F224              nonissue  
9347 F224 49 80                 eor   #%10000000
9348 F226 20 4E F2              jsr   out2                     ;Y preserved
9349 F229 88                    dey   
9350 F22A D0 EA                 bne   loop45
9351 F22C
9352 F22C 60                    rts   
9353 F22D
9354 F22D                       longi on
9355 F22D                       longa on
9356 F22D                       end_proc 
9357 F22D                       eject 
9358 F22D
9359 F22D              *** Coordinates Diagram ***
9360 F22D
9361 F22D              ;    0123456789012345678901234567890123456789
9362 F22D              ;  00
9363 F22D              ;  01
9364 F22D              ;  --
9365 F22D              ;  06________________________________________
9366 F22D              ;  07|                                      |
9367 F22D              ;  08| * (prompt line 1)                    |
9368 F22D              ;  09|   (prompt line 2)                    |
9369 F22D              ;  10|   (prompt line 3)                    |
9370 F22D              ;  11|   (prompt line 4)                    |
9371 F22D              ;  12| blank                                |
9372 F22D              ;  13|   (button line 1)                    |
9373 F22D              ;  14| blank                                |
9374 F22D              ;  15|   (button line 2)                    |
9375 F22D              ;  16| blank                                |
9376 F22D              ;  17----------------------------------------
9377 F22D              ;  18
9378 F22D              ;  --
9379 F22D              ;  23
9380 F22D
9381 F22D              ; The asterisk marks the (0,0) point for gotoxy, out, mybc, etc.
9382 F22D                       eject 
9383 F22D              ;======================================================================
9384 F22D              ; gotoxy : Position the output cursor
9385 F22D              ;
9386 F22D              ;Created:       January 12, 1988
9387 F22D              ;Modified:      January 12, 1988
9388 F22D              ;Author:        Mike Askins
9389 F22D              ;
9390 F22D              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9391 F22D              ;
9392 F22D              ;Input:         A = <undefined>
9393 F22D              ;               X = Horizontal offset
9394 F22D              ;               Y = Vertical offset
9395 F22D              ;               P = nvmxdizc
9396 F22D              ;                   ..110...
9397 F22D              ;
9398 F22D              ;Output:        A = Selected Option Number  <0..number_buttons-1>
9399 F22D              ;               X = <trashed>
9400 F22D              ;               Y = <trashed>
9401 F22D              ;               P = nvmxdizc
9402 F22D              ;                   ..110...
9403 F22D              ;               b = preserved
9404 F22D              ;
9405 F22D              ;
9406 F22D              ;======================================================================
9407 F22D
9408 F22D              gotoxy   proc 
9409 F22D                       entry mybc
9410 F22D
9411 F22D                       longa off
9412 F22D                       longi off
9413 F22D
9414 F22D 8A                    txa   
9415 F22E 18                    clc   
9416 F22F 69 01                 adc   #xbias+box_orig_x
9417 F231 85 23                 sta   <ch
9418 F233 98                    tya   
9419 F234 18                    clc   
9420 F235 69 08                 adc   #ybias+box_orig_y
9421 F237 85 24                 sta   <cv
9422 F239
9423 F239              mybc                                    ;Preserve Y
9424 F239 0A                    asl   a
9425 F23A AA                    tax   
9426 F23B C2 20                 rep   #$20                     ;16 bit M
9427 F23D BF D6 DF E1           lda   >vidtab-12,x
9428 F241 8D 5D F2              sta   snuggles+1               ;Modify instruction in out
9429 F244 8D 17 F2              sta   loop45+1                 ;Modify instruction in inverse
9430 F247 E2 20                 sep   #$20
9431 F249 60                    rts   
9432 F24A
9433 F24A
9434 F24A                       longi on
9435 F24A                       longa on
9436 F24A                       end_proc 
9437 F24A                       eject 
9438 F24A              ;======================================================================
9439 F24A              ; out, out80, out2 : Put a character onto the text screen
9440 F24A              ;
9441 F24A              ;Created:       January 12, 1988
9442 F24A              ;Modified:      January 12, 1988
9443 F24A              ;Author:        Mike Askins
9444 F24A              ;
9445 F24A              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9446 F24A              ;
9447 F24A              ;Input:         A = Character to output
9448 F24A              ;               X = <undefined except in out2>
9449 F24A              ;               Y = <undefined>
9450 F24A              ;               P = nvmxdizc
9451 F24A              ;                   ..100...
9452 F24A              ;                     ch = horizontal cursor position
9453 F24A              ;
9454 F24A              ;Output:        A = Selected Option Number  <0..number_buttons-1>
9455 F24A              ;               X = Current cursor position (horizontal)
9456 F24A              ;               Y = preserved
9457 F24A              ;               P = nvmxdizc
9458 F24A              ;                   ..100...
9459 F24A              ;               b = preserved
9460 F24A              ;
9461 F24A              ;======================================================================
9462 F24A
9463 F24A              ; Warning!  These output routines do not wrap to the next line.  Outputting
9464 F24A              ;  something beyond the end of a line will result in the last character in
9465 F24A              ;  the line being overwritten.
9466 F24A
9467 F24A              out80    proc 
9468 F24A                       entry snuggles
9469 F24A                       entry out
9470 F24A                       entry out2
9471 F24A
9472 F24A                       longa off
9473 F24A                       longi off
9474 F24A
9475 F24A              ;	eor #$80
9476 F24A              ;	bmi @noTrans
9477 F24A              ;	tax
9478 F24A              ;	lda >transtbl-$80,x
9479 F24A              ;@noTrans
9480 F24A              ; NOTE: Replace ora below, and out = @noTrans
9481 F24A
9482 F24A 09 80                 ora   #$80                     ;If you'd rather not flip the msb
9483 F24C
9484 F24C              out       
9485 F24C A6 23                 ldx   <ch                      ;If you just want the cursor pos
9486 F24E
9487 F24E              out2      
9488 F24E C9 8D                 cmp   #return_key+$80
9489 F250 D0 0A                 bne   snuggles
9490 F252 A9 01                 lda   #box_orig_x+xbias        ;Back to left margin
9491 F254 85 23                 sta   <ch
9492 F256 E6 24                 inc   <cv
9493 F258 A5 24                 lda   <cv
9494 F25A              *** optimized 20-Aug-92 DAL
9495 F25A              ;;;	jsr	mybc
9496 F25A              ;;;	bra	bye
9497 F25A 80 DD                 bra   mybc
9498 F25C              *** end 20-Aug-92
9499 F25C
9500 F25C              snuggles                                ;Warning- keep with store!
9501 F25C 9F 00 00 E0           sta   >$E00000,x
9502 F260 E0 27                 cpx   #39
9503 F262 B0 03                 bge   bye                      ;Oops, at end of line
9504 F264
9505 F264 E8                    inx                            ;Next guy
9506 F265 86 23                 stx   <ch
9507 F267
9508 F267              bye       
9509 F267 60                    rts   
9510 F268
9511 F268                       longi on
9512 F268                       longa on
9513 F268                       end_proc 
9514 F268                       eject 
9515 F268              ;======================================================================
9516 F268              ; draw_box : Draw the box onto the text screen
9517 F268              ;
9518 F268              ;Created:       January 12, 1988
9519 F268              ;Modified:      January 12, 1988
9520 F268              ;Author:        Mike Askins
9521 F268              ;
9522 F268              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9523 F268              ;
9524 F268              ;Input:         A = <undefined>
9525 F268              ;               X = <undefined>
9526 F268              ;               Y = <undefined>
9527 F268              ;               P = nvmxdizc
9528 F268              ;                   ..100...
9529 F268              ;
9530 F268              ;Output:        A = <trashed>
9531 F268              ;               X = <trashed>
9532 F268              ;               Y = <trashed>
9533 F268              ;               P = nvmxdizc
9534 F268              ;                   ..100...
9535 F268              ;               b = preserved
9536 F268              ;
9537 F268              ;======================================================================
9538 F268
9539 F268              draw_box proc 
9540 F268                       longa off
9541 F268                       longi off
9542 F268
9543 F268 A9 00                 lda   #box_orig_x
9544 F26A 85 23                 sta   <ch
9545 F26C A9 06                 lda   #box_orig_y
9546 F26E 85 24                 sta   <cv
9547 F270 20 39 F2              jsr   mybc                     ;Returns in 16 bit mode
9548 F273
9549 F273 E2 30                 sep   #$30
9550 F275 A9 DF                 lda   #$DF                     ;ASCII '_'
9551 F277 20 94 F2              jsr   outline
9552 F27A
9553 F27A              loop3     
9554 F27A 20 9D F2              jsr   next_line                ;Reset to box edge on next line
9555 F27D
9556 F27D A9 5F                 lda   #$5F                     ;Mousetext left side
9557 F27F 20 4C F2              jsr   out
9558 F282 A2 27                 ldx   #box_orig_x+box_width-1
9559 F284 A9 5A                 lda   #$5A
9560 F286 20 4E F2              jsr   out2
9561 F289
9562 F289 A4 24                 ldy   <cv
9563 F28B C0 11                 cpy   #box_orig_y+box_height-2
9564 F28D 90 EB                 blt   loop3
9565 F28F
9566 F28F 20 9D F2              jsr   next_line                ;Reset to box edge on next line
9567 F292
9568 F292 A9 4C                 lda   #$4C                     ;MouseText bottom line
9569 F294              *** optimized 20-Jul-92 DAL
9570 F294              ;;;	jsr	outline
9571 F294              ;;;	rts
9572 F294              ;;; FALL THROUGH!
9573 F294              *** end 20-Jul-92
9574 F294
9575 F294 A0 28        outline  ldy   #box_width
9576 F296 20 4C F2     loopx    jsr   out
9577 F299 88                    dey   
9578 F29A D0 FA                 bne   loopx
9579 F29C 60                    rts   
9580 F29D
9581 F29D E6 24        next_line inc   <cv
9582 F29F A5 24                 lda   <cv
9583 F2A1 20 39 F2              jsr   mybc
9584 F2A4 A9 00                 lda   #box_orig_x
9585 F2A6 85 23                 sta   <ch
9586 F2A8 60                    rts   
9587 F2A9
9588 F2A9                       longi on
9589 F2A9                       longa on
9590 F2A9                       end_proc 
9591 F2A9                       eject 
9592 F2A9              ;======================================================================
9593 F2A9              ; save_screen : Copy the text screen to save area (clearing the screen)
9594 F2A9              ;
9595 F2A9              ;Created:       January 13, 1988
9596 F2A9              ;Modified:      January 13, 1988
9597 F2A9              ;Author:        Mike Askins
9598 F2A9              ;
9599 F2A9              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9600 F2A9              ;
9601 F2A9              ;Input:         A = <undefined>
9602 F2A9              ;               X = <undefined>
9603 F2A9              ;               Y = <undefined>
9604 F2A9              ;               P = nvmxdizc
9605 F2A9              ;                   ..000...
9606 F2A9              ;
9607 F2A9              ;Output:        A = <trashed>
9608 F2A9              ;               X = <trashed>
9609 F2A9              ;               Y = <trashed>
9610 F2A9              ;               P = nvmxdizc
9611 F2A9              ;                   ..000...
9612 F2A9              ;               b = preserved
9613 F2A9              ;
9614 F2A9              ;======================================================================
9615 F2A9
9616 F2A9              save_screen proc 
9617 F2A9
9618 F2A9                       entry switchtab
9619 F2A9                       entry modesave
9620 F2A9                       entry textsv
9621 F2A9                       entry mixsv
9622 F2A9                       entry page2sv
9623 F2A9                       entry hiressv
9624 F2A9                       entry altcharsv
9625 F2A9                       entry vid80sv
9626 F2A9                       entry col80sv
9627 F2A9                       entry newvidsv
9628 F2A9
9629 F2A9              *
9630 F2A9              * Save page2 switch status...
9631 F2A9              *
9632 F2A9 AD 1C C0              lda   |rdpage2                 ;Save rdpage2 and rdhires
9633 F2AC 8D 24 F3              sta   |page2sv
9634 F2AF
9635 F2AF              ; Get access to the save area in $E0 language card
9636 F2AF
9637 F2AF                       longa off
9638 F2AF E2 20                 sep   #$20
9639 F2B1
9640 F2B1 AD 68 C0              lda   |statereg
9641 F2B4 48                    pha   
9642 F2B5
9643 F2B5 AD 83 C0              lda   |lcbank2                 ;Write enable bank 2
9644 F2B8 AD 83 C0              lda   |lcbank2
9645 F2BB              *
9646 F2BB              * Switch in page 1...
9647 F2BB              *
9648 F2BB AD 54 C0              lda   txtpage1                 ;Turn on text page 1.
9649 F2BE
9650 F2BE              ; Set up the pointer
9651 F2BE
9652 F2BE                       longa on
9653 F2BE C2 20                 rep   #$20
9654 F2C0
9655 F2C0 A9 00 D0              lda   #<storage
9656 F2C3 85 25                 sta   <aptr
9657 F2C5 A9 E0 00              lda   #^storage
9658 F2C8 85 27                 sta   <aptr+2
9659 F2CA
9660 F2CA A0 FE 03              ldy   #$03FE
9661 F2CD
9662 F2CD              loop1     
9663 F2CD BB                    tyx   
9664 F2CE BF 00 04 E0           lda   >$E00400,x               ;Get a value to save
9665 F2D2 97 25                 sta   [<aptr],y
9666 F2D4 A9 A0 A0              lda   #$A0A0                   ;Two spaces
9667 F2D7 9F 00 04 E0           sta   >$E00400,x               ;Clear that area
9668 F2DB 88                    dey   
9669 F2DC 88                    dey   
9670 F2DD 10 EE                 bpl   loop1
9671 F2DF
9672 F2DF              ; Restore bank 1 language card
9673 F2DF
9674 F2DF                       longa off
9675 F2DF E2 20                 sep   #$20
9676 F2E1
9677 F2E1 68                    pla   
9678 F2E2 8D 68 C0              sta   |statereg
9679 F2E5
9680 F2E5              ; Now preserve the current state of the video switches
9681 F2E5
9682 F2E5 AD 18 C0              lda   |rd80col
9683 F2E8 8D 28 F3              sta   |col80sv
9684 F2EB AD 29 C0              lda   $C029
9685 F2EE 8D 29 F3              sta   |newvidsv
9686 F2F1
9687 F2F1                       longa on
9688 F2F1 C2 20                 rep   #$20
9689 F2F3
9690 F2F3 AD 1A C0              lda   |rdtext                  ;Save rdtext and rdmix
9691 F2F6 8D 22 F3              sta   |textsv
9692 F2F9 AD 1E C0              lda   |altcharset              ;Save altcharset and rd80vid
9693 F2FC 8D 26 F3              sta   |altcharsv
9694 F2FF
9695 F2FF              ; Now set up page 1 40 columns, nomix, with MouseText w/ 80colstore off
9696 F2FF
9697 F2FF                       longa off
9698 F2FF E2 20                 sep   #$20
9699 F301
9700 F301              *** optimized 20-Aug-92 DAL
9701 F301              ;	lda	$C029
9702 F301              ;	and	#%01111111
9703 F301              ;	sta	$C029
9704 F301 A9 80                 lda   #$80
9705 F303 1C 29 C0              trb   $C029
9706 F306              *** end 20-Aug-92
9707 F306
9708 F306 8D 0C C0              sta   |clr80vid
9709 F309 8D 00 C0              sta   |clr80col
9710 F30C 8D 51 C0              sta   |txtset
9711 F30F 8D 52 C0              sta   |mixclr
9712 F312 8D 54 C0              sta   |txtpage1
9713 F315 8D 0F C0              sta   |setaltchar
9714 F318
9715 F318                       longa on
9716 F318 C2 20                 rep   #$20
9717 F31A
9718 F31A 60                    rts   
9719 F31B
9720 F31B
9721 F31B              ; The entries in switchtab correspond to the first seven save locations.  They
9722 F31B              ;  indicate the low byte (hi = $C0) of the first of two switches which control
9723 F31B              ;  the mode who's value was preserved in the 'sv' area.  The table is used by
9724 F31B              ;  the restore routine.  (The scheme depends on the fact that the switch pairs
9725 F31B              ;  are ordered the way they are.)
9726 F31B              ;
9727 F31B              ;NOTE: The '**$ff' after each label is the MAX syntax for AND with $ff (i.e. take
9728 F31B              ;      the low byte only)
9729 F31B
9730 F31B              switchtab  
9731 F31B 50 52 54              DC B:txtclr**$ff,mixclr**$ff,txtpage1**$ff
9732 F31E 56 0E 0C 00           DC B:lores**$ff,clraltchar**$ff,clr80vid**$ff,clr80col**$ff
9733 F322
9734 F322              modesave          
9735 F322 00           textsv   DC B:0
9736 F323 00           mixsv    DC B:0
9737 F324 00           page2sv  DC B:0
9738 F325 00           hiressv  DC B:0
9739 F326 00           altcharsv DC B:0
9740 F327 00           vid80sv  DC B:0
9741 F328 00           col80sv  DC B:0
9742 F329 00           newvidsv DC B:0
9743 F32A
9744 F32A                       end_proc 
9745 F32A                       eject 
9746 F32A              ;======================================================================
9747 F32A              ; restore_screen : Recover the screen from the save area
9748 F32A              ;
9749 F32A              ;Created:       January 13, 1988
9750 F32A              ;Modified:      January 13, 1988
9751 F32A              ;Author:        Mike Askins
9752 F32A              ;
9753 F32A              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9754 F32A              ;
9755 F32A              ;Input:         A = <undefined>
9756 F32A              ;               X = <undefined>
9757 F32A              ;               Y = <undefined>
9758 F32A              ;               P = nvmxdizc
9759 F32A              ;                   ..000...
9760 F32A              ;
9761 F32A              ;Output:        A = <trashed>
9762 F32A              ;               X = <trashed>
9763 F32A              ;               Y = <trashed>
9764 F32A              ;               P = nvmxdizc
9765 F32A              ;                   ..000...
9766 F32A              ;               b = preserved
9767 F32A              ;
9768 F32A              ;======================================================================
9769 F32A
9770 F32A              restore_screen proc 
9771 F32A
9772 F32A              ; Restore the original video mode
9773 F32A
9774 F32A                       longa off
9775 F32A                       longi off
9776 F32A E2 30                 sep   #$30
9777 F32C
9778 F32C AD 29 F3              lda   |newvidsv                ;Fix gs video mode
9779 F32F 8D 29 C0              sta   $C029
9780 F332
9781 F332              ; Now march through the save area and use the switches specified to restore
9782 F332              ;  the rest of the video mode state.
9783 F332
9784 F332 A2 06                 ldx   #6                       ;There are seven switches
9785 F334              moreswitches  
9786 F334 BD 22 F3              lda   |modesave,x              ;Get a preserved state
9787 F337 0A                    asl   a                        ;Move the state into carry
9788 F338 2A                    rol   a                        ; ... into lsb
9789 F339 29 01                 and   #$01                     ;Isolate
9790 F33B A8                    tay   
9791 F33C BD 1B F3              lda   |switchtab,x             ;Get the low part of this switch pair
9792 F33F 8D 43 F3              sta   selfmod+1                ;Sneak it into store instruction
9793 F342              selfmod   
9794 F342 99 00 C0              sta   $C000,y                  ;FLIP IT! (Low part updated each time)
9795 F345 CA                    dex   
9796 F346 10 EC                 bpl   moreswitches
9797 F348
9798 F348              ; Get access to the save area in $E0 language card
9799 F348
9800 F348 AD 68 C0              lda   |statereg
9801 F34B 48                    pha   
9802 F34C
9803 F34C AD 83 C0              lda   |lcbank2                 ;Write enable bank 2
9804 F34F AD 83 C0              lda   |lcbank2
9805 F352
9806 F352              *
9807 F352              * Switch in page 1...
9808 F352              *
9809 F352 AD 54 C0              lda   txtpage1                 ;Turn on text page 1.
9810 F355
9811 F355                       longa on
9812 F355                       longi on
9813 F355 C2 30                 rep   #$30
9814 F357
9815 F357              ; Now restore the text area we destroyed
9816 F357
9817 F357 A9 00 D0              lda   #<storage
9818 F35A 85 25                 sta   <aptr
9819 F35C A9 E0 00              lda   #^storage
9820 F35F 85 27                 sta   <aptr+2
9821 F361
9822 F361 A0 FE 03              ldy   #$03FE
9823 F364
9824 F364              loop1     
9825 F364 BB                    tyx   
9826 F365 B7 25                 lda   [<aptr],y
9827 F367 9F 00 04 E0           sta   >$E00400,x               ;Get a value to save
9828 F36B 88                    dey   
9829 F36C 88                    dey   
9830 F36D 10 F5                 bpl   loop1
9831 F36F
9832 F36F              ; Restore bank 1 language card
9833 F36F
9834 F36F                       longa off
9835 F36F E2 20                 sep   #$20
9836 F371
9837 F371 68                    pla   
9838 F372 8D 68 C0              sta   |statereg
9839 F375
9840 F375                       longa on
9841 F375 C2 30                 rep   #$30
9842 F377
9843 F377 60                    rts   
9844 F378
9845 F378                       end_proc 
9846 F378                       eject 
9847 F378              ;======================================================================
9848 F378              ; which_one : Determines which video mode should be used
9849 F378              ;
9850 F378              ;Created:       January 13, 1988
9851 F378              ;Modified:      January 13, 1988
9852 F378              ;Author:        Mike Askins
9853 F378              ;
9854 F378              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
9855 F378              ;
9856 F378              ;Input:         A = <undefined>
9857 F378              ;               X = <undefined>
9858 F378              ;               Y = <undefined>
9859 F378              ;               P = nvmxdizc
9860 F378              ;                   ..000...
9861 F378              ;
9862 F378              ;Output:        A = <trashed>
9863 F378              ;               X = <trashed>
9864 F378              ;               Y = <trashed>
9865 F378              ;               P = nvmxdizc
9866 F378              ;                   ..000..0 -> Okay to use SuperHires
9867 F378              ;                          1 -> Must use text
9868 F378              ;               b = preserved
9869 F378              ;
9870 F378              ;======================================================================
9871 F378
9872 F378              which_one proc 
9873 F378
9874 F378              *** added 17-Jul-92 DAL -- Force screen dimmers to un-dim before we decide
9875 F378              *** whether to use the Super Hi-Res screen or the text screen.  It's annoying
9876 F378              *** if we decide to use the text screen & then the dimmer goes back to the
9877 F378              *** graphics screen when the user hits a key.  Very annoying.  (That is, for
9878 F378              *** dimmers that switch to the text screen & change all the text colors to
9879 F378              *** black.)
9880 F378 A2 00 00              ldx   #0
9881 F37B F4 0D 00              pea   $000D                    ;srqForceUndim
9882 F37E DA                    phx                            ;sendToAll
9883 F37F DA                    phx   
9884 F380 DA                    phx                            ;target=NIL
9885 F381 DA                    phx   
9886 F382 DA                    phx                            ;dataIn=NIL
9887 F383 DA                    phx   
9888 F384 DA                    phx                            ;dataOut=NIL
9889 F385 A2 01 1C              ldx   #$1C01
9890 F388 22 00 00 E1           jsl   $e10000
9891 F38C              ;	_SendRequest
9892 F38C              *** added 20-Jul-92 DAL -- Clean up the stack if we got a dispatcher error
9893 F38C 90 0A                 bcc   @noCleanUp
9894 F38E C9 10 00              cmp   #$0010
9895 F391 B0 05                 bcs   @noCleanUp
9896 F393 3B                    tsc   
9897 F394 69 10 00              adc   #$0010                   ;16 bytes of input parameters to strip
9898 F397 1B                    tcs   
9899 F398              @noCleanUp  
9900 F398              *** end 20-Jul-92 DAL
9901 F398              *** end 17-Jul-92 DAL
9902 F398
9903 F398              ; This routine checks the Window Manager to see if it is loaded.  If it is
9904 F398              ;  and we're displaying SuperHires and there is 64K of memory available in
9905 F398              ;  the system, we choose SuperHires, and 40 column text otherwise.
9906 F398
9907 F398              *** rewritten to use table, 17-Jul-92 DAL
9908 F398              ;	pha		;Space for result
9909 F398              ;	_WindStatus
9910 F398              ;	pla		;See if window manager is active
9911 F398              ;	bcs	text
9912 F398              ;	beq	text
9913 F398              ;
9914 F398              ;	pha
9915 F398              ;	_CtlStatus
9916 F398              ;	pla		;How 'bout the control manager
9917 F398              ;	bcs	text
9918 F398              ;	beq	text
9919 F398              ;
9920 F398              ;	pha
9921 F398              ;	_LEStatus
9922 F398              ;	pla		;...and linedit while we're at it
9923 F398              ;	bcs	text
9924 F398              ;	beq	text
9925 F398
9926 F398 A2 04 00              ldx   #statusTableEnd-statusTable-2
9927 F39B DA           @nextStatus phx                         ;save index
9928 F39C BD BC F3              lda   statusTable,x
9929 F39F AA                    tax   
9930 F3A0 48                    pha                            ;space for xxxStatus result
9931 F3A1 22 00 00 E1           jsl   $e10000
9932 F3A5 68                    pla                            ;result
9933 F3A6 FA                    plx                            ;index
9934 F3A7 B0 11                 bcs   text
9935 F3A9 A8                    tay   
9936 F3AA F0 0E                 beq   text
9937 F3AC CA                    dex   
9938 F3AD CA                    dex   
9939 F3AE 10 EB                 bpl   @nextStatus
9940 F3B0              *** end 17-Jul-92
9941 F3B0
9942 F3B0              ;All of these guys are active...
9943 F3B0
9944 F3B0 AD 29 C0              lda   $C029                    ;Check the NewVideo switch
9945 F3B3
9946 F3B3 29 80 00              and   #$0080                   ;Check the SuperHires bit
9947 F3B6 F0 02                 beq   text
9948 F3B8              *** attempted change 17-Jul-92 DAL:  This works on my ROM 3 system but hangs thoroughly on my ROM 1.
9949 F3B8              ;;;	lda $C029-1	;check the NewVideo switch (bit 7 of $C029)
9950 F3B8              ;;;	bpl text
9951 F3B8              *** end 17-Jul-92
9952 F3B8
9953 F3B8              ; Here's where the memory check should be made
9954 F3B8
9955 F3B8
9956 F3B8 38           shires   sec   
9957 F3B9 60                    rts                            ;Carry is still clear here
9958 F3BA
9959 F3BA 18           text     clc   
9960 F3BB                       export doneit 
9961 F3BB 60           doneit   rts   
9962 F3BC
9963 F3BC 14 06 10 06  statusTable DC W:$0614,$0610,$060E      ;LEStatus, CtlStatus, WindStatus (17-Jul-92 DAL)
9964 F3C2              statusTableEnd  
9965 F3C2
9966 F3C2                       end_proc 
9967 F3C2
9968 F3C2              prompt   proc 
9969 F3C2                       longa off
9970 F3C2                       longi off
9971 F3C2
9972 F3C2              ; Display non-language-oriented prompt.  If less than two buttons are up, just
9973 F3C2              ;  display the last character of the string which is the
9974 F3C2
9975 F3C2 A0 00                 ldy   #0
9976 F3C4 A9 22                 lda   #34                      ;Get us positioned
9977 F3C6 A6 01                 ldx   <num_buttons
9978 F3C8 E0 02                 cpx   #2
9979 F3CA B0 04                 bge   lesmess
9980 F3CC A0 04                 ldy   #4
9981 F3CE A9 26                 lda   #38                      ;Get us positioned
9982 F3D0              lesmess   
9983 F3D0 85 23                 sta   <ch
9984 F3D2 A9 11                 lda   #box_orig_y+box_height-2
9985 F3D4 85 24                 sta   <cv
9986 F3D6 20 39 F2              jsr   mybc                     ;Y is preserved here
9987 F3D9
9988 F3D9              mormess   
9989 F3D9 B9 E4 F3              lda   msgtab,y
9990 F3DC                       import doneit 
9991 F3DC F0 DD                 beq   doneit
9992 F3DE 20 4C F2              jsr   out
9993 F3E1 C8                    iny   
9994 F3E2 80 F5                 bra   mormess
9995 F3E4
9996 F3E4              ;;;doneit	rts
9997 F3E4
9998 F3E4
9999 F3E4 48           msgtab   DC B:$48
0000 F3E5 A0                    DC B:$A0
0001 F3E6 55                    DC B:$55
0002 F3E7 A0                    DC B:$A0
0003 F3E8 4D                    DC B:$4D
0004 F3E9 00                    DC B:$00
0005 F3EA
0006 F3EA                       longa on
0007 F3EA                       longi on
0008 F3EA
0009 F3EA                       end_proc 
0010 F3EA                       eject 
0011 F3EA              *******************************************************************************
0012 F3EA              *
0013 F3EA              *        Name:  xlate_path2_l
0014 F3EA              *
0015 F3EA              * Description:  External entry point for xlate_path2.
0016 F3EA              *
0017 F3EA              *      Author:  Bryan Atsatt
0018 F3EA              *     Created:  May 17, 1989
0019 F3EA              *    Modified:
0020 F3EA              *
0021 F3EA              *       Entry:  jsl
0022 F3EA              *
0023 F3EA              *       Input:  A = offset into parameter list
0024 F3EA              *               X = undefined
0025 F3EA              *               Y = undefined.
0026 F3EA              *               P = nvmxdizc
0027 F3EA              *                   ..000...
0028 F3EA              *
0029 F3EA              *      Output:  A = error code if error.
0030 F3EA              *               X = undefined
0031 F3EA              *               Y = undefined
0032 F3EA              *               P = nvmxdizc
0033 F3EA              *                   ..000..0 = no error
0034 F3EA              *                          1 = error
0035 F3EA              *
0036 F3EA              *        Exit:  rtl
0037 F3EA              *
0038 F3EA              *        Uses:  xlate_path2
0039 F3EA              *
0040 F3EA              * Copyright Apple Computer, Inc. 1989  All rights reserved.
0041 F3EA              *******************************************************************************
0042 F3EA
0043 F3EA              xlate_path2_l proc 
0044 F3EA
0045 F3EA              *
0046 F3EA              * Call xlate_path2 and exit...
0047 F3EA              *
0048 F3EA A2 00 00              ldx   #0                       ;Want to use prefix #0, if any.
0049 F3ED 20 29 DD              jsr   xlate_path2              ;Do translation.
0050 F3F0 6B                    rtl                            ;Exit.
0051 F3F1
0052 F3F1                       end_proc 
0053 F3F1                       eject 
0054 F3F1              *******************************************************************************
0055 F3F1              * Segment 2 miscellaneous data
0056 F3F1              *******************************************************************************
0057 F3F1
0058 F3F1              seg_2_data proc 
0059 F3F1                       entry event_queue
0060 F3F1                       entry event_flags
0061 F3F1                       entry event_code
0062 F3F1                       entry entry_point
0063 F3F1              *
0064 F3F1              * The following structure is used by the add_os_queue and del_os_queue calls. 
0065 F3F1              *
0066 F3F1 74 B5 02 00  event_queue DC L:$00000000              ;Link pointer: MUST BE SAVED
0067 F3F5                                                      ; ACROSS P8-GS/OS SWITCH!!!
0068 F3F5 00 00                 DC W:$0000                     ;Reserved word.
0069 F3F7 5A A5                 DC W:$a55a                     ;Queue signature.
0070 F3F9 00 00 00 00  event_flags DC L:$00000000              ;Event flags (none for us).
0071 F3FD 00 00 00 00  event_code DC L:$00000000               ;Event code goes here.
0072 F401              entry_point                             ;Code entry point.
0073 F401
0074 F401                       end_proc 
0075 F401                       eject 
0076 F401              ;======================================================================
0077 F401              ; init : Startup Global Info Manager
0078 F401              ;
0079 F401              ;Created:       April 2, 1987
0080 F401              ;Modified:      August 13, 1987
0081 F401              ;Author:        Mike Askins
0082 F401              ;
0083 F401              ;Copyright Apple Computer Inc. 1987  All rights reserved
0084 F401              ;
0085 F401              ;Input:         A = <undefined>
0086 F401              ;               X = <undefined>
0087 F401              ;               Y = <undefined>
0088 F401              ;               P = nvmxdizc
0089 F401              ;                   ..000...
0090 F401              ;
0091 F401              ;Output:        A = trashed
0092 F401              ;               X = trashed
0093 F401              ;               Y = trashed
0094 F401              ;               P = nvmxdizc
0095 F401              ;                   ..000...
0096 F401              ;               b = preserved
0097 F401              ;         seg_tab = pointer to segment table (locked)
0098 F401              ;    seg_tab_hand = handle to segment table
0099 F401              ;     vcr_id_hand = handle of VCR ID list
0100 F401              ;     fst_id_hand = handle of FST ID list
0101 F401              ;
0102 F401              ;======================================================================
0103 F401
0104 F401              init_gim proc 
0105 F401                       entry prefices
0106 F401                       entry obj_list_tab
0107 F401
0108 F401              ; Start out by getting a memory manager ID.
0109 F401
0110 F401 22 7E DC E1           jsl   get_mm_id
0111 F405
0112 F405              ; Allocate memory for the segment address table (eventually must lock it down).
0113 F405
0114 F405 38                    sec                            ;Select large list.
0115 F406 20 55 FF              jsr   init_spcl_list           ;Make a new list.
0116 F409 8A                    txa   
0117 F40A 8F 82 FF 00           sta   >seg_tab_hand
0118 F40E 98                    tya   
0119 F40F 8F 84 FF 00           sta   >seg_tab_hand+2
0120 F413
0121 F413 20 D9 FF              jsr   lock_hand                ;Keep it locked down
0122 F416
0123 F416              ; Start things out right by allocating one segment (probably two later)
0124 F416              ;   If we can't make any segments then shutdown the system (at least return CS)
0125 F416
0126 F416 20 C2 FB              jsr   make_seg
0127 F419 B0 4D                 bcs   init_err                 ;Segtab locked, seg_tab defined
0128 F41B
0129 F41B              ; Zero out the object list table
0130 F41B
0131 F41B A9 00 00              lda   #$0000
0132 F41E A2 6A 00              ldx   #num_obj_lists*4-2
0133 F421              loop      
0134 F421 9F 69 F4 00           sta   >obj_list_tab,x
0135 F425 CA                    dex   
0136 F426 CA                    dex   
0137 F427 10 F8                 bpl   loop
0138 F429
0139 F429              ; Start the record id tables
0140 F429
0141 F429 20 54 FF              jsr   init_list
0142 F42C B0 3A                 bcs   init_err
0143 F42E 8A                    txa   
0144 F42F 8F 86 FF 00           sta   >vcr_id_hand             ;Global Handle
0145 F433 98                    tya   
0146 F434 8F 88 FF 00           sta   >vcr_id_hand+2
0147 F438
0148 F438 20 54 FF              jsr   init_list
0149 F43B B0 2B                 bcs   init_err
0150 F43D 8A                    txa   
0151 F43E 8F 8A FF 00           sta   >fcr_id_hand             ;Global Handle
0152 F442 98                    tya   
0153 F443 8F 8C FF 00           sta   >fcr_id_hand+2
0154 F447
0155 F447 20 54 FF              jsr   init_list
0156 F44A B0 1C                 bcs   init_err
0157 F44C 8A                    txa   
0158 F44D 8F 8E FF 00           sta   >icr_id_hand             ;Global Handle
0159 F451 98                    tya   
0160 F452 8F 90 FF 00           sta   >icr_id_hand+2
0161 F456
0162 F456
0163 F456              ; Null out the prefix table ($FFFF works since msb is set)
0164 F456
0165 F456 A2 86 00              ldx   #number_prefix*4-2
0166 F459 A9 FF FF              lda   #$FFFF
0167 F45C              loop2     
0168 F45C 9F D7 F4 00           sta   >prefices,x
0169 F460 CA                    dex   
0170 F461 CA                    dex   
0171 F462 10 F8                 bpl   loop2
0172 F464
0173 F464              ; Pull the boot volume name from g_quit and set it up as prefix 32, commonly
0174 F464              ;  known as the '*' prefix.
0175 F464
0176 F464 20 5F F5              jsr   set_pfx_32
0177 F467
0178 F467 18                    clc   
0179 F468              init_err  
0180 F468 6B                    rtl   
0181 F469
0182 F469              obj_list_tab  
0183 F469 9C 0E 18 00           DS B:num_obj_lists*4+2
0184 F4D7
0185 F4D7              prefices  
0186 F4D7 EF 0F 04 00           DS B:number_prefix*4
0187 F55F
0188 F55F                       end_proc 
0189 F55F
0190 F55F                       DATACHK OFF 
0191 F55F              set_pfx_32 proc 
0192 F55F                       entry set_pfx_32_alt
0193 F55F
0194 F55F              ; Set pb_ptr to point to the volume name - the destination - grab the length
0195 F55F
0196 F55F A9 F7 D6              lda   #e1_volname
0197 F562 85 FC                 sta   <pb_ptr
0198 F564 A9 E1 00              lda   #^e1_volname
0199 F567 85 FE                 sta   <pb_ptr+2
0200 F569
0201 F569              set_pfx_32_alt  
0202 F569 A7 FC                 lda   [<pb_ptr]                ;Get the two byte length
0203 F56B
0204 F56B              ; Get a buffer big enough to hold the sucker, deref vp and store the length
0205 F56B
0206 F56B 48                    pha                            ;Keep for later
0207 F56C 1A                    inc   a                        ;One for the high part of the count
0208 F56D 1A                    inc   a                        ; and one for the low part
0209 F56E 1A                    inc   a                        ; and one for the zero at the end
0210 F56F 22 4C FB 00           jsl   allocate                 ;Get a buffer
0211 F573 5A                    phy   
0212 F574 DA                    phx                            ;Keep the VP to hand to set_pfx
0213 F575
0214 F575 22 09 FE 00           jsl   deref2                   ;Get a pointer to the contents
0215 F579 86 E8                 stx   <ptr
0216 F57B 84 EA                 sty   <ptr+2                   ;Points to the destination
0217 F57D A3 05                 lda   5,s                      ;Get the length back
0218 F57F 87 E8                 sta   [<ptr]                   ;Store at destination
0219 F581
0220 F581 AA                    tax                            ;Use the length as a countdown clock
0221 F582
0222 F582              ; Do the copy; we gotta store a trailing zero... no big deal.
0223 F582
0224 F582                       longa off
0225 F582 E2 20                 sep   #$20                     ;Get into 8 bit M to make it easier
0226 F584
0227 F584 A0 02 00              ldy   #2                       ;Start at the first character
0228 F587
0229 F587              loop      
0230 F587 B7 FC                 lda   [<pb_ptr],y              ;Get a char to copy
0231 F589              cheater   
0232 F589 97 E8                 sta   [<ptr],y
0233 F58B C8                    iny   
0234 F58C CA                    dex   
0235 F58D D0 F8                 bne   loop
0236 F58F
0237 F58F A9 00                 lda   #$00                     ;The $00 makes it a real g-string
0238 F591 97 E8                 sta   [<ptr],y
0239 F593
0240 F593 C2 20                 rep   #$20
0241 F595                       longa on
0242 F595
0243 F595              ; Clean up, store it, and have a nice/lousy day/night.
0244 F595
0245 F595 FA                    plx                            ;Pull back the vp
0246 F596 7A                    ply   
0247 F597 68                    pla                            ;This was length... don't need it
0248 F598
0249 F598 A9 20 00              lda   #32
0250 F59B 20 BC E3              jsr   set_pfx
0251 F59E
0252 F59E 60                    rts   
0253 F59F
0254 F59F                       end_proc 
0255 F59F                       DATACHK ON 
0256 F59F                       eject 
0257 F59F              ;=====================================================================
0258 F59F              ; alloc_record : Allocate a Volume or File Control Record
0259 F59F              ;
0260 F59F              ; Created:      April  9, 1987
0261 F59F              ; Modified:     April 13, 1988
0262 F59F              ; Author:       Mike Askins
0263 F59F              ;
0264 F59F              ; Copyright Apple Computer Inc. 1987  All rights reserved
0265 F59F              ;
0266 F59F              ; Input:        A = Size of VCR including FST specific data
0267 F59F              ;               X = Device Name Pointer (low)
0268 F59F              ;               Y = Device Name Pointer (high)
0269 F59F              ;               P = nvmxdizc
0270 F59F              ;                   ..000...
0271 F59F              ;
0272 F59F              ; Output:       A = trashed or error code if carry set
0273 F59F              ;               X = VP to VCR or FCR (low)
0274 F59F              ;               Y = VP to VCR or FCR (high)
0275 F59F              ;               P = nvmxdizc
0276 F59F              ;                   ..000..E -> 'Out of Memory' or 'Bad Request Size'
0277 F59F              ;               b = preserved
0278 F59F              ;
0279 F59F              ;======================================================================
0280 F59F
0281 F59F              allocvcr proc 
0282 F59F                       entry allocfcr
0283 F59F                       entry alloc_record
0284 F59F
0285 F59F 18                    clc   
0286 F5A0 80 01                 bra   alloc_record
0287 F5A2
0288 F5A2              allocfcr  
0289 F5A2 38                    sec   
0290 F5A3
0291 F5A3              alloc_record  
0292 F5A3
0293 F5A3 20 4B B7              jsr   set_type                 ;Record whether this is a VCR or FCR
0294 F5A6
0295 F5A6 5A                    phy   
0296 F5A7 DA                    phx   
0297 F5A8
0298 F5A8              ; Try to grab a piece of memory to hold the record; zero it out
0299 F5A8
0300 F5A8 38                    sec                            ;Make sure to zero out
0301 F5A9 22 E8 FC 00           jsl   alloc_zero
0302 F5AD 90 03                 bcc   wegotit                  ;We've had a problem
0303 F5AF 4C D0 F6              jmp   bad_exit                 ;Avoid the branch long problem
0304 F5B2              wegotit   
0305 F5B2
0306 F5B2              ; Now get and store the ID into the VCR
0307 F5B2
0308 F5B2 20 3C B7              jsr   deref2_vp                ;Set the vcr correctly
0309 F5B5 20 1C B7              jsr   ldxy_idhand
0310 F5B8 20 83 FE              jsr   reserve_id
0311 F5BB 90 03                 bcc   set
0312 F5BD 4C C5 F6              jmp   rel_vcr
0313 F5C0
0314 F5C0 20 D9 F6     set      jsr   set_vcr                  ;The reserve might have compacted memory
0315 F5C3 A0 00 00              ldy   #vcr_id
0316 F5C6 97 F8                 sta   [vcr],y
0317 F5C8 8F D3 F6 00           sta   >id_temp                 ;Keep in case need to deallocate.
0318 F5CC
0319 F5CC              *
0320 F5CC              * Save name pointer...
0321 F5CC              *
0322 F5CC FA                    plx   
0323 F5CD 7A                    ply                            ;Got name buffer pointer
0324 F5CE 86 E8                 stx   <ptr
0325 F5D0 84 EA                 sty   <ptr+2
0326 F5D2 A7 E8                 lda   [<ptr]                   ;Got the length
0327 F5D4 8F D5 F6 00           sta   >length_temp             ;Save it.
0328 F5D8              *
0329 F5D8              * If this is an FCR, we need to set the level field to the current system level
0330 F5D8              * and set last_ref_num to ID...
0331 F5D8              *
0332 F5D8 A9 00 00              lda   #0000
0333 F5DB 8F 23 B9 00           sta   >last_ref_num            ;Init to zero in case VCR.
0334 F5DF 8F D7 F6 00           sta   >full_path_flag          ;Init to zero.
0335 F5E3
0336 F5E3 AF 3A B7 00           lda   >obj_type                ;Is VCR?
0337 F5E7 10 50                 bpl   do_allocate              ;Yep.
0338 F5E9 A0 0A 00              ldy   #fcr_level               ;Nope, so set system level.
0339 F5EC AF 58 E4 00           lda   >system_level
0340 F5F0 97 F8                 sta   [<vcr],y
0341 F5F2 AF D3 F6 00           lda   >id_temp                 ;And set last_ref_num to ID.
0342 F5F6 8F 23 B9 00           sta   >last_ref_num
0343 F5FA              *
0344 F5FA              * Now we need to decide if we need to build a full pathname for this FCR or if
0345 F5FA              * it is already pointed to by path1_ptr.  If it is already pointed to by
0346 F5FA              * path1_ptr, set ptr=path1_ptr and length_temp=new length...
0347 F5FA              *
0348 F5FA A5 42                 lda   <path_flag               ;Get path flags.
0349 F5FC 29 00 40              and   #$4000                   ;Does path1_ptr point to something?
0350 F5FF F0 38                 beq   do_allocate              ;No so use volume name.
0351 F601
0352 F601 A0 02 00              ldy   #0002                    ;Yes, get the first character.
0353 F604 B7 3A                 lda   [<path1_ptr],y
0354 F606 29 7F 00              and   #%0000000001111111
0355 F609 C9 3A 00              cmp   #$003a                   ;Is it a colon?
0356 F60C D0 10                 bne   build_full_path          ;Nope, so need to build path.
0357 F60E
0358 F60E A5 3A                 lda   <path1_ptr               ;Yes, copy path1_ptr to ptr.
0359 F610 85 E8                 sta   <ptr
0360 F612 A5 3C                 lda   <path1_ptr+2
0361 F614 85 EA                 sta   <ptr+2
0362 F616 A7 3A                 lda   [<path1_ptr]             ;Get new length.
0363 F618 8F D5 F6 00           sta   >length_temp             ;Set length.
0364 F61C 80 1B                 bra   do_allocate              ;Go allocate string.
0365 F61E              *
0366 F61E              * We need to build it, change length_temp to the combined length +1 for colon...
0367 F61E              *
0368 F61E A9 01 00     build_full_path lda   #0001             ;Set flag.
0369 F621 8F D7 F6 00           sta   >full_path_flag          ;Indicate that we need to build full.
0370 F625
0371 F625 18                    clc                            ;Add both lengths.
0372 F626 A7 E8                 lda   [<ptr]
0373 F628 67 3A                 adc   [<path1_ptr]
0374 F62A 69 01 00              adc   #0001                    ;Add 1 for colon.
0375 F62D 8F D5 F6 00           sta   >length_temp             ;Save it.  Overflow?
0376 F631 90 06                 bcc   do_allocate              ;Nope.
0377 F633 A9 54 00              lda   #out_of_mem              ;Yes, simulate out of memory.
0378 F636 4C B9 F6              jmp   rel_id                   ;Out of here.
0379 F639              *
0380 F639              * Allocate VP for name string...
0381 F639              *
0382 F639              do_allocate  
0383 F639 AF D5 F6 00           lda   >length_temp             ;Get string length.
0384 F63D 1A                    inc   a                        ;Dont forget the count word & terminator
0385 F63E 1A                    inc   a
0386 F63F 1A                    inc   a
0387 F640 D4 E8                 pei   <ptr                     ;Save pointer.
0388 F642 D4 EA                 pei   <ptr+2
0389 F644
0390 F644 22 4C FB 00           jsl   allocate                 ;Invalidates vcr
0391 F648 B0 6F                 bcs   rel_id                   ;Couldn't get memory for name buffer
0392 F64A
0393 F64A              ; The allocate might have caused a memory compaction... must deref the VP
0394 F64A              ;  one last time... updating <vcr if necessary.
0395 F64A
0396 F64A 20 D9 F6              jsr   set_vcr                  ;Preserves all three reggies
0397 F64D
0398 F64D              ; Now store the VP returned in the VCR's name field
0399 F64D
0400 F64D 5A                    phy   
0401 F64E 98                    tya   
0402 F64F A0 04 00              ldy   #vcr_name+2
0403 F652 97 F8                 sta   [vcr],y
0404 F654 8A                    txa   
0405 F655 88                    dey   
0406 F656 88                    dey   
0407 F657 97 F8                 sta   [vcr],y
0408 F659 7A                    ply   
0409 F65A
0410 F65A              ; Dereference the VP (adding the block overhead in)
0411 F65A
0412 F65A 22 09 FE 00           jsl   deref2                   ;Takes account of the block overhead
0413 F65E 86 E8                 stx   ptr                      ;Got the pointer to the destination
0414 F660 84 EA                 sty   ptr+2
0415 F662              *
0416 F662              * Get back the pointer to the source...
0417 F662              *
0418 F662 7A                    ply   
0419 F663 FA                    plx   
0420 F664 86 EC                 stx   m_temp
0421 F666 84 EE                 sty   m_temp+2                 ;Place for zero page indirect
0422 F668              *
0423 F668              * We now have m_temp pointing to the source string and ptr pointing to the destination
0424 F668              * space.  Do copy.  Do we need to concatenate strings?
0425 F668              *
0426 F668 20 05 B7              jsr   copy_gstring             ;Do copy.
0427 F66B AF D7 F6 00           lda   >full_path_flag          ;Need to concatenate?
0428 F66F F0 33                 beq   do_link                  ;Nope.
0429 F671              *
0430 F671              * Yes, so do it, inserting colon between...
0431 F671              *
0432 F671 A7 E8                 lda   [<ptr]                   ;Get length of volume name.
0433 F673 1A                    inc   a                        ;Adjust for length word.
0434 F674 1A                    inc   a
0435 F675 A8                    tay                            ;Y points to end of volume name.
0436 F676 A9 3A 00              lda   #$003a                   ;Add colon to end.
0437 F679 97 E8                 sta   [<ptr],y
0438 F67B C8                    iny                            ;Point Y past colon.
0439 F67C
0440 F67C AF D5 F6 00           lda   >length_temp             ;Get full length.
0441 F680 87 E8                 sta   [<ptr]                   ;Set correct length.
0442 F682
0443 F682 18                    clc                            ;Set ptr to end of volume name.
0444 F683 98                    tya   
0445 F684 65 E8                 adc   <ptr
0446 F686 85 E8                 sta   <ptr
0447 F688 A9 00 00              lda   #0000
0448 F68B 65 EA                 adc   <ptr+2
0449 F68D 85 EA                 sta   <ptr+2
0450 F68F
0451 F68F A7 3A                 lda   [<path1_ptr]             ;Get length of partial path in Y.
0452 F691 A8                    tay   
0453 F692
0454 F692 18                    clc                            ;Set m_temp = path_ptr+2.
0455 F693 A9 02 00              lda   #0002
0456 F696 65 3A                 adc   <path1_ptr
0457 F698 85 EC                 sta   <m_temp
0458 F69A A9 00 00              lda   #0000
0459 F69D 65 3C                 adc   <path1_ptr+2
0460 F69F 85 EE                 sta   <m_temp+2
0461 F6A1
0462 F6A1 20 0A B7              jsr   more                     ;Do copy.
0463 F6A4
0464 F6A4              ; Finally (!) link the new VCR into the VCR list and haveniceday.
0465 F6A4              ;  (vp is already set)
0466 F6A4
0467 F6A4 A6 F4        do_link  ldx   vp
0468 F6A6 A4 F6                 ldy   vp+2
0469 F6A8 20 8A FD              jsr   map_vp                   ;Regenerate seg and get index
0470 F6AB A8                    tay                            ;Move segment offset into Y
0471 F6AC
0472 F6AC 20 53 B7              jsr   list_index
0473 F6AF AA                    tax   
0474 F6B0 20 BF F7              jsr   link_record
0475 F6B3
0476 F6B3 A6 F4                 ldx   vp
0477 F6B5 A4 F6                 ldy   vp+2
0478 F6B7
0479 F6B7 18                    clc   
0480 F6B8 6B                    rtl                            ;(whew!)
0481 F6B9
0482 F6B9              rel_id    
0483 F6B9 48                    pha   
0484 F6BA AF D3 F6 00           lda   >id_temp                 ;Get the ID we allocated
0485 F6BE 20 1C B7              jsr   ldxy_idhand
0486 F6C1 20 93 FE              jsr   free_id                  ; and give it back.
0487 F6C4 68                    pla                            ;Preserve the error code
0488 F6C5
0489 F6C5              rel_vcr   
0490 F6C5
0491 F6C5              ; Oh my... out of memory.  Well, let's release the VCR even though we're
0492 F6C5              ;  probably going to run out of memory on some other call real soon.
0493 F6C5
0494 F6C5 48                    pha                            ;Preserve the error code
0495 F6C6 A6 F4                 ldx   vp
0496 F6C8 A4 F6                 ldy   vp+2
0497 F6CA 22 15 FD 00           jsl   deallocate
0498 F6CE
0499 F6CE 68                    pla                            ;Restore the error code
0500 F6CF 38                    sec                            ;The alloc_vcr failed irreregardlessless
0501 F6D0
0502 F6D0              bad_exit  
0503 F6D0 FA                    plx   
0504 F6D1 7A                    ply   
0505 F6D2 6B                    rtl                            ;Carry is already set
0506 F6D3
0507 F6D3
0508 F6D3 02 00        id_temp  DC W:0000                      ;Temp storage for the id.
0509 F6D5 06 00        length_temp DC W:0000                   ;Temp storage for length.
0510 F6D7 00 00        full_path_flag DC W:0000                ;Set if need to build full path.
0511 F6D9
0512 F6D9              set_vcr   
0513 F6D9 48                    pha   
0514 F6DA 5A                    phy   
0515 F6DB DA                    phx   
0516 F6DC A6 F4                 ldx   vp
0517 F6DE A4 F6                 ldy   vp+2
0518 F6E0 20 3C B7              jsr   deref2_vp                ;Setup the vcr page zero location
0519 F6E3 FA                    plx   
0520 F6E4 7A                    ply   
0521 F6E5 68                    pla   
0522 F6E6 60                    rts   
0523 F6E7
0524 F6E7
0525 F6E7                       end_proc 
0526 F6E7                       eject 
0527 F6E7
0528 F6E7              ;======================================================================
0529 F6E7              ; release_record : Release a Volume or File Control Record
0530 F6E7              ;
0531 F6E7              ; Created:      April  9, 1987
0532 F6E7              ; Modified:     January 25, 1988
0533 F6E7              ; Author:       Mike Askins
0534 F6E7              ;
0535 F6E7              ; Copyright Apple Computer Inc. 1987  All rights reserved
0536 F6E7              ;
0537 F6E7              ; Input:        A = VCR ID
0538 F6E7              ;               X = <undefined>
0539 F6E7              ;               Y = <undefined>
0540 F6E7              ;               P = nvmxdizc
0541 F6E7              ;                   ..000...
0542 F6E7              ;
0543 F6E7              ; Output:       A = trashed
0544 F6E7              ;               X = trashed
0545 F6E7              ;               Y = trashed
0546 F6E7              ;               P = nvmxdizc
0547 F6E7              ;                   ..000..E -> A=$43: 'Unknown VCR ID', rarely 'Memory Problem'
0548 F6E7              ;                               A=$50: 'Files are open on this VCR'
0549 F6E7              ;               b = preserved
0550 F6E7              ;
0551 F6E7              ;======================================================================
0552 F6E7
0553 F6E7              alt_rel_vcr proc                        ;Entry for swap_out
0554 F6E7                       entry releasevcr
0555 F6E7                       entry releasefcr
0556 F6E7                       entry release_record
0557 F6E7
0558 F6E7 8B                    phb   
0559 F6E8 4B                    phk   
0560 F6E9 AB                    plb   
0561 F6EA 48                    pha                            ;Push the ID
0562 F6EB 80 19                 bra   okay
0563 F6ED
0564 F6ED              releasevcr  
0565 F6ED
0566 F6ED
0567 F6ED              ; Releasing a VCR is more involved than releasing an FCR.  If there are any open
0568 F6ED              ;  files an error is returned.  Otherwise the correct FST is called to flush
0569 F6ED              ;  any deferred blocks.  Then call same FST to remove all FST specific info
0570 F6ED              ;  from the VCR.  Finally release the record.
0571 F6ED
0572 F6ED 8B                    phb                            ;Preserve the DBR
0573 F6EE 4B                    phk   
0574 F6EF AB                    plb   
0575 F6F0
0576 F6F0 48                    pha   
0577 F6F1 22 6F F8 00           jsl   findvcr                  ;Get a VP to the VCR
0578 F6F5 20 3C B7              jsr   deref2_vp                ;Get a pointer into VCR
0579 F6F8
0580 F6F8 A0 08 00              ldy   #vcr_open_cnt            ;Peek at the open count
0581 F6FB B7 F8                 lda   [vcr],y
0582 F6FD F0 07                 beq   okay                     ;Can release if files are open
0583 F6FF 68                    pla                            ;Fix the stack for error case
0584 F700 A9 50 00              lda   #file_busy               ;File is open
0585 F703 38                    sec   
0586 F704 80 5B                 bra   oops2                    ;Return the error
0587 F706
0588 F706              ; Pass a pointer to the FST in question in vcr_ptr.  Preserve original value
0589 F706
0590 F706              okay      
0591 F706              ;	lda	<vcr_ptr+2
0592 F706              ;	pha
0593 F706              ;	lda	<vcr_ptr
0594 F706              ;	pha
0595 F706              *** optimized 17-Jul-92 DAL
0596 F706 D4 40                 pei   <vcr_ptr+2
0597 F708 D4 3E                 pei   <vcr_ptr
0598 F70A              *** end 17-Jul-92
0599 F70A A5 F8                 lda   <vcr
0600 F70C 85 3E                 sta   <vcr_ptr
0601 F70E A5 FA                 lda   <vcr+2
0602 F710 85 40                 sta   <vcr_ptr+2
0603 F712
0604 F712 A0 0A 00              ldy   #vcr_fst_id
0605 F715 B7 F8                 lda   [vcr],y                  ;Who is responsible for this?
0606 F717 20 46 E2              jsr   find_fst                 ;Convert to index in FST table
0607 F71A AA                    tax   
0608 F71B A9 06 00              lda   #kill_vcr                ;Ask FST to remove it's specific data
0609 F71E 20 3B D5              jsr   do_fst
0610 F721
0611 F721 68                    pla                            ;Get back old value of vcr_ptr
0612 F722 85 3E                 sta   <vcr_ptr
0613 F724 68                    pla   
0614 F725 85 40                 sta   <vcr_ptr+2
0615 F727
0616 F727 68                    pla                            ;Retrieve the ID
0617 F728 18                    clc   
0618 F729 80 04                 bra   release_record           ;Trash the rest of the VCR
0619 F72B
0620 F72B              releasefcr  
0621 F72B 38                    sec   
0622 F72C 8B                    phb                            ;Preserve DBR
0623 F72D 4B                    phk   
0624 F72E AB                    plb   
0625 F72F
0626 F72F              release_record  
0627 F72F
0628 F72F 20 4B B7              jsr   set_type                 ;Set the obj_type flag
0629 F732 20 1C B7              jsr   ldxy_idhand              ;Load vcr list handle into x,y (save A)
0630 F735 20 93 FE              jsr   free_id                  ;Free the ID in A
0631 F738 B0 24                 bcs   oops
0632 F73A
0633 F73A 5A                    phy                            ;Save the VP of the VCR
0634 F73B DA                    phx   
0635 F73C 20 53 B7              jsr   list_index               ;Unlink the VCR from the list
0636 F73F 20 05 F8              jsr   unlink_record
0637 F742
0638 F742 FA                    plx                            ;Get back the VP for the VCR
0639 F743 7A                    ply   
0640 F744 20 3C B7              jsr   deref2_vp                ;Set VCR to thing to release
0641 F747
0642 F747              ; Release the name buffer
0643 F747
0644 F747 A0 02 00              ldy   #vcr_name
0645 F74A B7 F8                 lda   [vcr],y
0646 F74C AA                    tax   
0647 F74D C8                    iny   
0648 F74E C8                    iny   
0649 F74F B7 F8                 lda   [vcr],y
0650 F751 A8                    tay   
0651 F752 22 15 FD 00           jsl   deallocate
0652 F756
0653 F756              ; Finally release the record area itself
0654 F756
0655 F756 A6 F4                 ldx   vp
0656 F758 A4 F6                 ldy   vp+2
0657 F75A 22 15 FD 00           jsl   deallocate
0658 F75E
0659 F75E              oops      
0660 F75E A9 43 00              lda   #invalid_ref_num
0661 F761              oops2     
0662 F761 AB                    plb   
0663 F762 6B                    rtl   
0664 F763
0665 F763                       end_proc 
0666 F763                       eject 
0667 F763              ;======================================================================
0668 F763              ; rename_record : Change the name of a VCR or FCR
0669 F763              ;
0670 F763              ; Created:      July 6, 1987
0671 F763              ; Modified:     July 15, 1987
0672 F763              ; Author:       Mike Askins
0673 F763              ;
0674 F763              ; Copyright Apple Computer Inc. 1987  All rights reserved
0675 F763              ;
0676 F763              ; Input:        A = ID (vcr_id or refnum)
0677 F763              ;               X = Pointer to new name (low)
0678 F763              ;               Y = Pointer to new name (high)
0679 F763              ;               P = nvmxdizc
0680 F763              ;                   ..000...
0681 F763              ;
0682 F763              ; Output:       A = trashed
0683 F763              ;               X = trashed
0684 F763              ;               Y = trashed
0685 F763              ;               P = nvmxdizc
0686 F763              ;                   ..000..E -> 'Out of Memory on Rename'
0687 F763              ;               b = preserved
0688 F763              ;
0689 F763              ;======================================================================
0690 F763
0691 F763              renamevcr proc 
0692 F763                       entry renamefcr
0693 F763                       entry rename_record
0694 F763
0695 F763 18                    clc   
0696 F764 80 01                 bra   rename_record
0697 F766
0698 F766              renamefcr  
0699 F766 38                    sec   
0700 F767
0701 F767              rename_record  
0702 F767 5A                    phy   
0703 F768 DA                    phx   
0704 F769 22 73 F8 00           jsl   find_record              ;Get the appropriate VP
0705 F76D B0 4D                 bcs   rename_err
0706 F76F
0707 F76F 20 3C B7              jsr   deref2_vp                ;Set up VP and VCR
0708 F772
0709 F772 A3 01                 lda   1,s                      ;Set up the ptr to the new string
0710 F774 85 E8                 sta   ptr
0711 F776 A3 03                 lda   3,s
0712 F778 85 EA                 sta   ptr+2
0713 F77A
0714 F77A A7 E8                 lda   [ptr]
0715 F77C 1A                    inc   a
0716 F77D 1A                    inc   a
0717 F77E 1A                    inc   a                        ;Got count plus lenword plus terminator
0718 F77F
0719 F77F 22 4C FB 00           jsl   allocate                 ;Get space for the new name
0720 F783 B0 37                 bcs   rename_err
0721 F785
0722 F785 5A                    phy                            ;Save away VP to new name area
0723 F786 DA                    phx   
0724 F787
0725 F787              ; Now deallocate the original buffer
0726 F787
0727 F787 A0 02 00              ldy   #vcr_name
0728 F78A B7 F8                 lda   [vcr],y
0729 F78C AA                    tax   
0730 F78D C8                    iny   
0731 F78E C8                    iny   
0732 F78F B7 F8                 lda   [vcr],y
0733 F791 A8                    tay   
0734 F792 22 15 FD 00           jsl   deallocate               ;Trashes ptr
0735 F796 B0 22                 bcs   rename_err2
0736 F798
0737 F798              ; Install the new buffer
0738 F798
0739 F798 A0 02 00              ldy   #vcr_name
0740 F79B A3 01                 lda   1,s
0741 F79D 97 F8                 sta   [vcr],y
0742 F79F C8                    iny   
0743 F7A0 C8                    iny   
0744 F7A1 A3 03                 lda   3,s
0745 F7A3 97 F8                 sta   [vcr],y
0746 F7A5
0747 F7A5              ; Set up the pointers to do the copying
0748 F7A5
0749 F7A5 FA                    plx   
0750 F7A6 7A                    ply                            ;Got back the destination VP
0751 F7A7 22 09 FE 00           jsl   deref2                   ;Get pointer to destination
0752 F7AB 86 E8                 stx   ptr
0753 F7AD 84 EA                 sty   ptr+2
0754 F7AF
0755 F7AF FA                    plx                            ;This is already a pointer
0756 F7B0 7A                    ply   
0757 F7B1 86 EC                 stx   m_temp
0758 F7B3 84 EE                 sty   m_temp+2                 ;Got the source pointer set up
0759 F7B5
0760 F7B5 20 05 B7              jsr   copy_gstring
0761 F7B8
0762 F7B8 18                    clc   
0763 F7B9 6B                    rtl                            ;Did it!  Return error free
0764 F7BA
0765 F7BA              rename_err2  
0766 F7BA FA                    plx   
0767 F7BB 7A                    ply   
0768 F7BC
0769 F7BC              rename_err  
0770 F7BC FA                    plx   
0771 F7BD 7A                    ply   
0772 F7BE
0773 F7BE 6B                    rtl   
0774 F7BF
0775 F7BF                       end_proc 
0776 F7BF                       eject 
0777 F7BF              ;======================================================================
0778 F7BF              ; link_record : Insert an object into a list
0779 F7BF              ;
0780 F7BF              ; Created:      May  8, 1987
0781 F7BF              ; Modified:     May 13, 1987
0782 F7BF              ; Author:       Mike Askins
0783 F7BF              ;
0784 F7BF              ; Copyright Apple Computer Inc. 1987  All rights reserved
0785 F7BF              ;
0786 F7BF              ; Input:        A = Undefined
0787 F7BF              ;               X = Object Table Index (object type)
0788 F7BF              ;               Y = Target's Segment Index
0789 F7BF              ;               P = nvmxdizc
0790 F7BF              ;                   ..000...
0791 F7BF              ;             seg = Target's Segment Address
0792 F7BF              ;              vp = Target's Virtual Pointer
0793 F7BF              ;
0794 F7BF              ; Output:       A = trashed
0795 F7BF              ;               X = trashed
0796 F7BF              ;               Y = trashed
0797 F7BF              ;               P = nvmxdizc
0798 F7BF              ;                   ..000...
0799 F7BF              ;               b = preserved
0800 F7BF              ;             ptr = trashed
0801 F7BF              ;
0802 F7BF              ;======================================================================
0803 F7BF
0804 F7BF              link_record proc 
0805 F7BF
0806 F7BF              ; Point the object list header at the target and set the target's next
0807 F7BF              ;  field to the original value of the list header.
0808 F7BF
0809 F7BF C8                    iny                            ;Move to target's forward link (low)
0810 F7C0 C8                    iny   
0811 F7C1 BF 69 F4 00           lda   >obj_list_tab,x          ;Get list header (low)
0812 F7C5 97 F0                 sta   [seg],y                  ;Put into target's flink field
0813 F7C7 48                    pha                            ;Keep list header (low) around
0814 F7C8 A5 F4                 lda   vp                       ;Get target's VP (low)...
0815 F7CA 9F 69 F4 00           sta   >obj_list_tab,x          ; and store in the header
0816 F7CE
0817 F7CE C8                    iny                            ;Move to targ's flink (high)
0818 F7CF C8                    iny   
0819 F7D0 BF 6B F4 00           lda   >obj_list_tab+2,x        ;Get list header (high)
0820 F7D4 97 F0                 sta   [seg],y                  ;Store list header value in flink (high)
0821 F7D6 48                    pha                            ;Keep list header (high)
0822 F7D7 A5 F6                 lda   vp+2                     ;Get target's VP (high)...
0823 F7D9 9F 6B F4 00           sta   >obj_list_tab+2,x        ; and store in the list header
0824 F7DD
0825 F7DD C8                    iny                            ;Null out the backward link
0826 F7DE C8                    iny   
0827 F7DF A9 00 00              lda   #$0000
0828 F7E2 97 F0                 sta   [seg],y
0829 F7E4 C8                    iny   
0830 F7E5 C8                    iny   
0831 F7E6 97 F0                 sta   [seg],y
0832 F7E8
0833 F7E8              ; Now go to the targ's successor and alter it's back link to point to the targ
0834 F7E8              ;  Don't do this if the free header was originally null, since that means
0835 F7E8              ;  that there WAS NO successor.
0836 F7E8
0837 F7E8 7A                    ply                            ;Pull back successor's VP
0838 F7E9 FA                    plx   
0839 F7EA D0 03                 bne   non_null
0840 F7EC 98                    tya   
0841 F7ED F0 15                 beq   no_successor
0842 F7EF
0843 F7EF              non_null  
0844 F7EF 22 F0 FD 00           jsl   gderef                   ;Get a pointer to the successor
0845 F7F3 86 E8                 stx   ptr
0846 F7F5 84 EA                 sty   ptr+2
0847 F7F7
0848 F7F7 A0 06 00              ldy   #pred                    ;Point to backward link
0849 F7FA A5 F4                 lda   vp
0850 F7FC 97 E8                 sta   [ptr],y
0851 F7FE C8                    iny   
0852 F7FF C8                    iny   
0853 F800 A5 F6                 lda   vp+2
0854 F802 97 E8                 sta   [ptr],y
0855 F804
0856 F804              no_successor  
0857 F804 60                    rts   
0858 F805
0859 F805                       end_proc 
0860 F805                       eject 
0861 F805              ;======================================================================
0862 F805              ; unlink_record : Pull a record out of it's record list
0863 F805              ;
0864 F805              ; Created:      May 11, 1987
0865 F805              ; Modified:     May 11, 1987
0866 F805              ; Author:       Mike Askins
0867 F805              ;
0868 F805              ; Copyright Apple Computer Inc. 1987  All rights reserved
0869 F805              ;
0870 F805              ; Input:        A = Object Table Index (Object Type)
0871 F805              ;               X = Virtual Pointer (low)
0872 F805              ;               Y = Virtual Pointer (high)
0873 F805              ;               P = nvmxdizc
0874 F805              ;                   ..000...
0875 F805              ;
0876 F805              ; Output:       A = trashed
0877 F805              ;               X = trashed
0878 F805              ;               Y = trashed
0879 F805              ;               P = nvmxdizc
0880 F805              ;                   ..000...
0881 F805              ;               b = preserved
0882 F805              ;          m_temp = trashed
0883 F805              ;             ptr = trashed
0884 F805              ;
0885 F805              ;======================================================================
0886 F805
0887 F805              unlink_record proc 
0888 F805
0889 F805 48                    pha                            ;Save for later
0890 F806
0891 F806              ; Start by getting a pointer to the item to be unlinked
0892 F806
0893 F806 22 F0 FD 00           jsl   gderef
0894 F80A 86 EC                 stx   m_temp
0895 F80C 84 EE                 sty   m_temp+2
0896 F80E
0897 F80E              ; Get the VP of the predecessor
0898 F80E
0899 F80E FA                    plx                            ;Get back Object Table index
0900 F80F A0 08 00              ldy   #pred+2
0901 F812 B7 EC                 lda   [m_temp],y
0902 F814 48                    pha                            ;Keep around the predecessor's VP
0903 F815 88                    dey   
0904 F816 88                    dey   
0905 F817 B7 EC                 lda   [m_temp],y
0906 F819 7A                    ply                            ;Move a copy of pred (high) into Y
0907 F81A 5A                    phy   
0908 F81B 48                    pha                            ;... the low part of the pred's vp
0909 F81C DA                    phx                            ;Keep Object Table index around
0910 F81D AA                    tax                            ;...and a copy of pred (low) into X
0911 F81E
0912 F81E              ; If there was no predecessor, kludge X and Y to the address of the list header
0913 F81E
0914 F81E 03 05                 ora   5,s                      ;Check for nil VP
0915 F820 D0 0D                 bne   gotapred
0916 F822 68                    pla                            ;Get Object Table index
0917 F823 3A                    dec   a
0918 F824 3A                    dec   a
0919 F825 18                    clc   
0920 F826 69 69 F4              adc   #obj_list_tab
0921 F829 AA                    tax   
0922 F82A A0 00 00              ldy   #^obj_list_tab           ;Must be same bnk, code no cross banks
0923 F82D 80 05                 bra   nopred
0924 F82F
0925 F82F              ; Get a pointer to the predecessor
0926 F82F
0927 F82F              gotapred  
0928 F82F 68                    pla                            ;Toss the Object Table Index
0929 F830 22 F0 FD 00           jsl   gderef
0930 F834              nopred    
0931 F834 86 E8                 stx   ptr
0932 F836 84 EA                 sty   ptr+2
0933 F838
0934 F838              ; Now get the VP of the successor and store it in the predecessor's forward link
0935 F838
0936 F838 A0 02 00              ldy   #succ
0937 F83B B7 EC                 lda   [m_temp],y
0938 F83D 97 E8                 sta   [ptr],y                  ;Store in the predecessor's flink
0939 F83F AA                    tax   
0940 F840 C8                    iny   
0941 F841 C8                    iny   
0942 F842 B7 EC                 lda   [m_temp],y
0943 F844 97 E8                 sta   [ptr],y
0944 F846 A8                    tay   
0945 F847
0946 F847              ; If the pred's flink was nil, then you're done
0947 F847
0948 F847 D0 03                 bne   otherhalf
0949 F849 8A                    txa   
0950 F84A F0 14                 beq   endofline2
0951 F84C
0952 F84C              ; There was a successor and we need to point it's blink to the predecessor
0953 F84C
0954 F84C              otherhalf  
0955 F84C 22 F0 FD 00           jsl   gderef
0956 F850 86 E8                 stx   ptr
0957 F852 84 EA                 sty   ptr+2
0958 F854
0959 F854 A0 06 00              ldy   #pred
0960 F857 68                    pla   
0961 F858 97 E8                 sta   [ptr],y
0962 F85A C8                    iny   
0963 F85B C8                    iny   
0964 F85C 68                    pla   
0965 F85D 97 E8                 sta   [ptr],y
0966 F85F              endofline  
0967 F85F 60                    rts   
0968 F860
0969 F860              endofline2  
0970 F860 68                    pla   
0971 F861 68                    pla   
0972 F862 60                    rts   
0973 F863
0974 F863                       end_proc 
0975 F863                       eject 
0976 F863              ;======================================================================
0977 F863              ; find_record : Find a Volume or File Control Record by ID or name
0978 F863              ;
0979 F863              ; Created:      April  9, 1987
0980 F863              ; Modified:     June 22, 1988
0981 F863              ;               August 12, 1988
0982 F863              ; Author:       Mike Askins
0983 F863              ;
0984 F863              ; Copyright Apple Computer Inc. 1987  All rights reserved
0985 F863              ;
0986 F863              ; Input:        A = ID or refnum or $0000
0987 F863              ;               X = Pointer to name string (low, if Acc =$0000)
0988 F863              ;               Y = Pointer to name string (high, if Acc = $0000)
0989 F863              ;               P = nvmxdizc
0990 F863              ;                   ..000...
0991 F863              ;
0992 F863              ; Output:       A = trashed or error code
0993 F863              ;               X = Pointer to record matching criteria (VP low)
0994 F863              ;               Y = Pointer to record (VP high)
0995 F863              ;               P = nvmxdizc
0996 F863              ;                   ..000..E -> 'Could not find record'
0997 F863              ;               b = preserved
0998 F863              ;
0999 F863              ;======================================================================
1000 F863
1001 F863              findvcrcase proc 
1002 F863                       entry findvcr
1003 F863                       entry findfcr
1004 F863                       entry find_record
1005 F863                       entry case_mask
1006 F863
1007 F863 48                    pha   
1008 F864 A9 20 00              lda   #$0020                   ;mask for case insensitive comparison
1009 F867 8F BF F8 00           sta   >case_mask
1010 F86B 68                    pla   
1011 F86C 18                    clc   
1012 F86D 80 0D                 bra   find_record1
1013 F86F
1014 F86F              findvcr   
1015 F86F 18                    clc   
1016 F870 80 01                 bra   find_record
1017 F872
1018 F872              findfcr   
1019 F872 38                    sec   
1020 F873
1021 F873              find_record  
1022 F873 48                    pha                            ;save value in A
1023 F874 A9 00 00              lda   #$0000                   ;set mask to indicate case sensitive
1024 F877 8F BF F8 00           sta   >case_mask               ;...compares
1025 F87B 68                    pla                            ;restore A
1026 F87C
1027 F87C 20 4B B7     find_record1 jsr   set_type             ;Sets N and Z per Acc
1028 F87F
1029 F87F              ; If Acc is non zero, use as an index into the VCR ID list.  If zero, do a
1030 F87F              ;  pattern search on the name passed in X,Y (pointer).
1031 F87F
1032 F87F F0 27                 beq   find_name
1033 F881 0A                    asl   a
1034 F882 B0 1F                 bcs   prob                     ;BUG FIX 6/88; bit 15 set is invalid
1035 F884 0A                    asl   a
1036 F885 B0 1C                 bcs   prob                     ;BUG FIX 6/88; bit 14 set is invalid
1037 F887 48                    pha   
1038 F888 20 1C B7              jsr   ldxy_idhand
1039 F88B 20 79 FC              jsr   mm_deref
1040 F88E
1041 F88E 86 E8                 stx   ptr
1042 F890 84 EA                 sty   ptr+2
1043 F892
1044 F892 7A                    ply   
1045 F893
1046 F893 98                    tya                            ;Added 2/15; check limit of ID or refnum
1047 F894 C7 E8                 cmp   [ptr]
1048 F896 B0 0B                 bge   prob
1049 F898
1050 F898 B7 E8                 lda   [ptr],y
1051 F89A AA                    tax   
1052 F89B C8                    iny   
1053 F89C C8                    iny   
1054 F89D B7 E8                 lda   [ptr],y
1055 F89F A8                    tay   
1056 F8A0 18                    clc   
1057 F8A1 10 01                 bpl   no_prob
1058 F8A3              prob      
1059 F8A3 38                    sec   
1060 F8A4              no_prob   
1061 F8A4 A9 43 00              lda   #invalid_ref_num
1062 F8A7 6B                    rtl   
1063 F8A8
1064 F8A8              ; Do a search of all records looking for one with a specific name
1065 F8A8
1066 F8A8              find_name  
1067 F8A8 86 EC                 stx   m_temp                   ;Keep the pointer to the target name
1068 F8AA 84 EE                 sty   m_temp+2
1069 F8AC
1070 F8AC              ; Get a VP to the first guy in the list in X,Y
1071 F8AC
1072 F8AC 20 53 B7              jsr   list_index
1073 F8AF AA                    tax   
1074 F8B0 BF 6B F4 00           lda   >obj_list_tab+2,x
1075 F8B4 A8                    tay   
1076 F8B5 BF 69 F4 00           lda   >obj_list_tab,x
1077 F8B9 AA                    tax   
1078 F8BA
1079 F8BA              ; Do the search and return the results
1080 F8BA
1081 F8BA 20 EF F8              jsr   name_search
1082 F8BD
1083 F8BD 80 E5                 bra   no_prob                  ;If error, make sure return A with code
1084 F8BF
1085 F8BF              case_mask                               ; ;mask value that determines whether
1086 F8BF 20 00                 DC W:0000                      ;...comparison is case sensitive
1087 F8C1
1088 F8C1                       end_proc 
1089 F8C1
1090 F8C1              ;
1091 F8C1              ; string_compare - compare strings pointed to by m_temp and ptr
1092 F8C1              ; returns Z flag set if strings are equal
1093 F8C1              ;
1094 F8C1              string_compare proc 
1095 F8C1              ; Compare the lengths
1096 F8C1
1097 F8C1 A7 E8                 lda   [ptr]
1098 F8C3 C7 EC                 cmp   [m_temp]                 ;Checked length and first character
1099 F8C5 D0 25                 bne   no_match                 ;No match
1100 F8C7
1101 F8C7              ; Now check the rest of the string starting from the rear
1102 F8C7
1103 F8C7 A8                    tay   
1104 F8C8 C8                    iny                            ;Compensate for lenword
1105 F8C9
1106 F8C9 E2 20                 sep   #$20                     ;8-bit m
1107 F8CB                       longa off
1108 F8CB
1109 F8CB              maybe_match  
1110 F8CB B7 E8                 lda   [<ptr],y
1111 F8CD D7 EC                 cmp   [<m_temp],y
1112 F8CF F0 18                 beq   it_matched
1113 F8D1
1114 F8D1 C9 41                 cmp   #'A'                     ;'A'
1115 F8D3 90 17                 blt   no_match
1116 F8D5 C9 5B                 cmp   #'Z'+1                   ;'Z'+1
1117 F8D7 90 08                 blt   isalpha
1118 F8D9 C9 61                 cmp   #'a'                     ;'a'
1119 F8DB 90 0F                 blt   no_match
1120 F8DD C9 7B                 cmp   #'z'+1                   ;'z'+1
1121 F8DF B0 0B                 bge   no_match
1122 F8E1
1123 F8E1 57 EC        isalpha  eor   [<m_temp],y
1124 F8E3 4F BF F8 00           eor   >case_mask
1125 F8E7 D0 03                 bne   no_match
1126 F8E9
1127 F8E9 88           it_matched dey   
1128 F8EA D0 DF                 bne   maybe_match
1129 F8EC
1130 F8EC              match     
1131 F8EC              no_match  
1132 F8EC C2 20                 rep   #$20                     ;back to 16-bit m
1133 F8EE                       longa on
1134 F8EE 60                    rts                            ;with Z flag conditioned appropriately
1135 F8EF
1136 F8EF                       end_proc 
1137 F8EF
1138 F8EF              ; Target Pascal string pointed to by m_temp, m_temp+2
1139 F8EF              ; VP of first guy in chain to search
1140 F8EF              ; Return carry set if search is unsuccessful
1141 F8EF
1142 F8EF              name_search proc 
1143 F8EF
1144 F8EF
1145 F8EF              ; Check if we've come to the end of the chain (null VP)
1146 F8EF
1147 F8EF 98                    tya   
1148 F8F0 D0 05                 bne   keep_goin
1149 F8F2 8A                    txa   
1150 F8F3 D0 02                 bne   keep_goin
1151 F8F5 38                    sec                            ;No match
1152 F8F6 60                    rts   
1153 F8F7
1154 F8F7              ; We should check this record to see if we have a match
1155 F8F7
1156 F8F7              keep_goin  
1157 F8F7 86 F4                 stx   vp
1158 F8F9 84 F6                 sty   vp+2
1159 F8FB 22 09 FE 00           jsl   deref2
1160 F8FF 86 E8                 stx   ptr                      ;Got pointer to the record
1161 F901 84 EA                 sty   ptr+2
1162 F903
1163 F903 A0 02 00              ldy   #vcr_name
1164 F906 B7 E8                 lda   [ptr],y
1165 F908 AA                    tax   
1166 F909 C8                    iny   
1167 F90A C8                    iny   
1168 F90B B7 E8                 lda   [ptr],y
1169 F90D A8                    tay   
1170 F90E 22 09 FE 00           jsl   deref2                   ;Got pointer to name buffer
1171 F912 86 E8                 stx   ptr
1172 F914 84 EA                 sty   ptr+2
1173 F916
1174 F916 20 C1 F8              jsr   string_compare           ;compare the strings
1175 F919 D0 06                 bne   continue                 ;no match
1176 F91B
1177 F91B              ; We got a match.  Return the VP we saved and have a nice day.
1178 F91B
1179 F91B A6 F4                 ldx   vp
1180 F91D A4 F6                 ldy   vp+2
1181 F91F 18                    clc   
1182 F920 60                    rts                            ;Got it
1183 F921
1184 F921              ; Walk to the next record and see if there's a match there.
1185 F921
1186 F921              continue  
1187 F921 C2 20                 rep   #$20                     ;back to 16-bit m
1188 F923 A6 F4                 ldx   vp
1189 F925 A4 F6                 ldy   vp+2
1190 F927 22 F0 FD 00           jsl   gderef
1191 F92B 86 F4                 stx   vp
1192 F92D 84 F6                 sty   vp+2
1193 F92F
1194 F92F A0 02 00              ldy   #succ                    ;Changed from flink... wrong usage!
1195 F932 B7 F4                 lda   [vp],y
1196 F934 AA                    tax   
1197 F935 C8                    iny   
1198 F936 C8                    iny   
1199 F937 B7 F4                 lda   [vp],y
1200 F939 A8                    tay   
1201 F93A 80 B3                 bra   name_search
1202 F93C
1203 F93C                       end_proc 
1204 F93C                       eject 
1205 F93C              ;======================================================================
1206 F93C              ; get_record : Retrieve an active Volume or File Control Record
1207 F93C              ;
1208 F93C              ; Created:      April  9, 1987
1209 F93C              ; Modified:     July 15, 1987
1210 F93C              ; Author:       Mike Askins
1211 F93C              ;
1212 F93C              ; Copyright Apple Computer Inc. 1987  All rights reserved
1213 F93C              ;
1214 F93C              ; Input:        A = Record Index { =$0000 asks for next record }
1215 F93C              ;               X = <undefined>
1216 F93C              ;               Y = <undefined>
1217 F93C              ;               P = nvmxdizc
1218 F93C              ;                   ..000...
1219 F93C              ;
1220 F93C              ; Output:       A = trashed
1221 F93C              ;               X = VP of
1222 F93C              ;               Y = trashed
1223 F93C              ;               P = nvmxdizc
1224 F93C              ;                   ..000..E -> 'Attempt to Walk Past Last Record'
1225 F93C              ;               b = preserved
1226 F93C              ;
1227 F93C              ;======================================================================
1228 F93C
1229 F93C              ; These routines let the caller walk through the list of VCRs or that of FCRs.
1230 F93C              ;  The acc value refers to a record's relative position in its list, rather
1231 F93C              ;  than an intrinsic ID value.  (Acc=2 will retrieve the 2nd record in the
1232 F93C              ;  list, if there are at least two in the list.)  The routine keeps around
1233 F93C
1234 F93C              getvcr   proc 
1235 F93C                       entry getfcr
1236 F93C                       entry get_record
1237 F93C
1238 F93C 18                    clc   
1239 F93D AA                    tax   
1240 F93E AF 93 F9 00           lda   >last_vcr                ;Get the last index
1241 F942 80 06                 bra   get_record
1242 F944
1243 F944              getfcr    
1244 F944 38                    sec   
1245 F945 AA                    tax   
1246 F946 AF 95 F9 00           lda   >last_fcr                ;Get the last index
1247 F94A
1248 F94A              get_record  
1249 F94A 1A                    inc   a
1250 F94B 9B                    txy                            ;Check if caller parm = $0000
1251 F94C F0 01                 beq   call_set                 ;Use our stored value for the index
1252 F94E 8A                    txa   
1253 F94F              call_set  
1254 F94F 85 EC                 sta   m_temp                   ;Whatever index, store for decrementing
1255 F951 B0 09                 bcs   its_fcr                  ;If not vcr skip down
1256 F953
1257 F953 8F 93 F9 00           sta   >last_vcr                ;Update our stored index for next time
1258 F957 A2 00 00              ldx   #vcr_list                ;Pick up the index into the head table
1259 F95A 80 07                 bra   cont
1260 F95C
1261 F95C              its_fcr   
1262 F95C 8F 95 F9 00           sta   >last_fcr
1263 F960 A2 04 00              ldx   #fcr_list
1264 F963
1265 F963              cont      
1266 F963 BF 6B F4 00           lda   >obj_list_tab+2,x
1267 F967 A8                    tay   
1268 F968 BF 69 F4 00           lda   >obj_list_tab,x          ;Get the head pointer for this list
1269 F96C AA                    tax   
1270 F96D
1271 F96D              null_check  
1272 F96D 8A                    txa   
1273 F96E D0 05                 bne   non_null
1274 F970 98                    tya   
1275 F971 D0 02                 bne   non_null
1276 F973
1277 F973              ; The requested record does not exist.  Inform the poor unsuspecting caller.
1278 F973
1279 F973 38                    sec   
1280 F974 6B                    rtl   
1281 F975
1282 F975              ; Now find the record corresponding to the index.  The current VP is in X,Y
1283 F975
1284 F975              non_null  
1285 F975 A5 EC                 lda   m_temp
1286 F977 3A                    dec   a
1287 F978 F0 17                 beq   got_it
1288 F97A
1289 F97A              ; Move to the next guy
1290 F97A
1291 F97A 85 EC                 sta   m_temp
1292 F97C
1293 F97C 22 F0 FD 00           jsl   gderef
1294 F980 86 F8                 stx   vcr
1295 F982 84 FA                 sty   vcr+2
1296 F984 A0 02 00              ldy   #succ
1297 F987 B7 F8                 lda   [vcr],y
1298 F989 AA                    tax   
1299 F98A C8                    iny   
1300 F98B C8                    iny   
1301 F98C B7 F8                 lda   [vcr],y
1302 F98E A8                    tay   
1303 F98F 80 DC                 bra   null_check
1304 F991
1305 F991              got_it    
1306 F991 18                    clc                            ;Indicate requested record returned
1307 F992 6B                    rtl   
1308 F993
1309 F993 00 00        last_vcr DC W:0                         ;Index of last vcr retrieved by get_vcr
1310 F995 04 00        last_fcr DC W:0                         ;Index of last fcr retrieved by get_fcr
1311 F997
1312 F997                       end_proc 
1313 F997                       eject 
1314 F997              ;======================================================================
1315 F997              ; swap_out : Mark a volume as swapped out
1316 F997              ;
1317 F997              ; Created:      September 25, 1987
1318 F997              ; Modified:     September 25, 1987
1319 F997              ; Author:       Mike Askins
1320 F997              ;
1321 F997              ; Copyright Apple Computer Inc. 1987  All rights reserved
1322 F997              ;
1323 F997              ; Input:        A = Device Number
1324 F997              ;               X = <undefined>
1325 F997              ;               Y = <undefined>
1326 F997              ;               P = nvmxdizc
1327 F997              ;                   ..000...
1328 F997              ;
1329 F997              ; Output:       A = Device Number
1330 F997              ;               X = trashed
1331 F997              ;               Y = trashed
1332 F997              ;               P = nvmxdizc
1333 F997              ;                   ..000..0
1334 F997              ;               b = preserved
1335 F997              ;
1336 F997              ;======================================================================
1337 F997
1338 F997              swapout  proc 
1339 F997
1340 F997              ; This routine walks the list of active VCRs and marks as swapped out any and
1341 F997              ;  all VCRs with open files having the correct dev number.  Note that in
1342 F997              ;  every legitimate case there will be only one swapped in VCR with the device
1343 F997              ;  number passed this routine swaps out any and all volumes corresponding to
1344 F997              ;  the passed device number.  If a VCR with the correct device number is found
1345 F997              ;  with no open files, a release_vcr call is done on that VCR.
1346 F997
1347 F997
1348 F997 48                    pha                            ;Push the target devnum for comparisons
1349 F998
1350 F998 A9 01 00              lda   #1                       ;Set to get the initial volume
1351 F99B              more      
1352 F99B 22 3C F9 00           jsl   getvcr                   ;Get a VP to a VCR
1353 F99F B0 30                 bcs   done                     ;'End of the line.  Everybody out.'
1354 F9A1
1355 F9A1 20 3C B7              jsr   deref2_vp                ;Put pointer into dirpg vcr
1356 F9A4
1357 F9A4 A0 0C 00              ldy   #vcr_dev
1358 F9A7 B7 F8                 lda   [<vcr],y                 ;Get the last known device no this vol
1359 F9A9 C3 01                 cmp   1,s                      ;Compare with the target
1360 F9AB D0 1F                 bne   noact                    ;Don't deal with it
1361 F9AD
1362 F9AD A0 08 00              ldy   #vcr_open_cnt            ;Check if there are any open files.
1363 F9B0 B7 F8                 lda   [<vcr],y
1364 F9B2 D0 0B                 bne   markit
1365 F9B4
1366 F9B4              ; There were no open files here, so as far as we know we won't ever look at
1367 F9B4              ;  this volume again.  Get rid of the VCR.
1368 F9B4
1369 F9B4 A0 00 00              ldy   #vcr_id
1370 F9B7 B7 F8                 lda   [<vcr],y
1371 F9B9 22 E7 F6 00           jsl   alt_rel_vcr
1372 F9BD 80 12                 bra   done
1373 F9BF
1374 F9BF              markit    
1375 F9BF A0 06 00              ldy   #vcr_status              ;Now clear the bit
1376 F9C2 B7 F8                 lda   [<vcr],y
1377 F9C4 09 00 40              ora   #vcr_swapped
1378 F9C7 29 FF DF              and   #vcr_wr_unknown
1379 F9CA 97 F8                 sta   [<vcr],y
1380 F9CC
1381 F9CC A9 00 00     noact    lda   #0                       ;Set to get the next active VCR
1382 F9CF 80 CA                 bra   more
1383 F9D1
1384 F9D1              done      
1385 F9D1 68                    pla                            ;Thanks Mikala for straightening up
1386 F9D2 18                    clc                            ;I love situations where you can't fail
1387 F9D3 6B                    rtl                            ;'I shall return.'
1388 F9D4
1389 F9D4                       end_proc 
1390 F9D4                       eject 
1391 F9D4              ;=====================================================================
1392 F9D4              ; alloc_icr : Allocate an Interrupt Control Record
1393 F9D4              ;
1394 F9D4              ; Created:      November 17, 1987
1395 F9D4              ; Modified:     November 17, 1987
1396 F9D4              ; Author:       Mike Askins
1397 F9D4              ;
1398 F9D4              ; Copyright Apple Computer Inc. 1987  All rights reserved
1399 F9D4              ;
1400 F9D4              ; Input:        A = undefined
1401 F9D4              ;               X = undefined
1402 F9D4              ;               Y = undefined
1403 F9D4              ;               P = nvmxdizc
1404 F9D4              ;                   ..000...
1405 F9D4              ;
1406 F9D4              ; Output:       A = ID of allocated ICR
1407 F9D4              ;               X = VP to ICR (low)
1408 F9D4              ;               Y = VP to ICR (high)
1409 F9D4              ;               P = nvmxdizc
1410 F9D4              ;                   ..000..E -> 'Out of Memory'
1411 F9D4              ;               b = preserved
1412 F9D4              ;
1413 F9D4              ;======================================================================
1414 F9D4
1415 F9D4              alloc_icr proc 
1416 F9D4
1417 F9D4 A9 06 00              lda   #icr_size
1418 F9D7 18                    clc                            ;Don't bother to zero it out
1419 F9D8 22 4C FB 00           jsl   allocate                 ;Conception
1420 F9DC B0 11                 bcs   outomem
1421 F9DE
1422 F9DE 86 F4                 stx   vp
1423 F9E0 84 F6                 sty   vp+2
1424 F9E2 AE 8E FF              ldx   |icr_id_hand
1425 F9E5 AC 90 FF              ldy   |icr_id_hand+2
1426 F9E8 20 83 FE              jsr   reserve_id               ;Registration
1427 F9EB
1428 F9EB A6 F4                 ldx   <vp
1429 F9ED A4 F6                 ldy   <vp+2
1430 F9EF
1431 F9EF              outomem   
1432 F9EF 60                    rts   
1433 F9F0
1434 F9F0                       end_proc 
1435 F9F0                       eject 
1436 F9F0              ;======================================================================
1437 F9F0              ; release_icr : Release an Interrupt Control Record
1438 F9F0              ;
1439 F9F0              ; Created:      November 17, 1987
1440 F9F0              ; Modified:     November 17, 1987
1441 F9F0              ; Author:       Mike Askins
1442 F9F0              ;
1443 F9F0              ; Copyright Apple Computer Inc. 1987  All rights reserved
1444 F9F0              ;
1445 F9F0              ; Input:        A = ICR ID
1446 F9F0              ;               X = <undefined>
1447 F9F0              ;               Y = <undefined>
1448 F9F0              ;               P = nvmxdizc
1449 F9F0              ;                   ..000...
1450 F9F0              ;
1451 F9F0              ; Output:       A = trashed
1452 F9F0              ;               X = VP of now-freed ICR (low)
1453 F9F0              ;               Y = VP of now-freed ICR (high)
1454 F9F0              ;               P = nvmxdizc
1455 F9F0              ;                   ..000..E -> 'Unknown or unreleaseable ICR'
1456 F9F0              ;               b = preserved
1457 F9F0              ;
1458 F9F0              ;======================================================================
1459 F9F0
1460 F9F0              release_icr proc 
1461 F9F0
1462 F9F0 AE 8E FF              ldx   |icr_id_hand
1463 F9F3 AC 90 FF              ldy   |icr_id_hand+2
1464 F9F6 20 93 FE              jsr   free_id                  ;File death certificate
1465 F9F9 B0 08                 bcs   bad_id
1466 F9FB
1467 F9FB 5A                    phy   
1468 F9FC DA                    phx   
1469 F9FD 22 15 FD 00           jsl   deallocate               ;Bury
1470 FA01 FA                    plx                            ;Reclaim the VP of the freed ICR
1471 FA02 7A                    ply   
1472 FA03
1473 FA03              bad_id    
1474 FA03 60                    rts   
1475 FA04
1476 FA04                       end_proc 
1477 FA04                       eject 
1478 FA04              ;=====================================================================
1479 FA04              ; build_icr : Allocate an ICR, link into list, and set ICR values
1480 FA04              ;
1481 FA04              ; Created:      November 19, 1987
1482 FA04              ; Modified:     November 19, 1987
1483 FA04              ; Author:       Mike Askins
1484 FA04              ;
1485 FA04              ; Copyright Apple Computer Inc. 1987  All rights reserved
1486 FA04              ;
1487 FA04              ; Input:        A = Vector Reference Number (index)
1488 FA04              ;               X = Interrupt Handler Address (low)
1489 FA04              ;               Y = Interrupt Handler Address (high)
1490 FA04              ;               P = nvmxdizc
1491 FA04              ;                   ..000...
1492 FA04              ;
1493 FA04              ; Output:       A = ICR ID (or error code if CS; 1->'Invalid VRN', 2->'OutOfMem'
1494 FA04              ;               X = trashed
1495 FA04              ;               Y = trashed
1496 FA04              ;               P = nvmxdizc
1497 FA04              ;                   ..000..E -> 'ICR was not allocated'
1498 FA04              ;               b = preserved
1499 FA04              ;
1500 FA04              ;======================================================================
1501 FA04
1502 FA04              build_icr proc 
1503 FA04
1504 FA04              no_mem_err equ   2                      ;Belongs in common.equ
1505 FA04
1506 FA04 08                    php                            ;We may disable interrupts...
1507 FA05 DA                    phx                            ;Keep the handler address for later
1508 FA06 5A                    phy                            ;... hi order last
1509 FA07
1510 FA07              ; Validate and map the vector reference number.  If VRN was okay, allocate the
1511 FA07              ;  record.
1512 FA07
1513 FA07 48                    pha                            ;Keep to place in the alloc'd ICR
1514 FA08 20 42 FA              jsr   map_vrn
1515 FA0B B0 2D                 bcs   bad_vrn
1516 FA0D 48                    pha                            ; and the VRN offset
1517 FA0E
1518 FA0E 20 D4 F9              jsr   alloc_icr                ;Procure the real estate
1519 FA11 B0 23                 bcs   no_mem                   ;None available
1520 FA13 8D 40 FA              sta   |id_temp                 ;Keep the ICR ID to return to caller
1521 FA16 5A                    phy   
1522 FA17 DA                    phx   
1523 FA18 20 3C B7              jsr   deref2_vp                ;Set up VP and VCR pointer
1524 FA1B FA                    plx   
1525 FA1C 7A                    ply   
1526 FA1D
1527 FA1D              ; Now set up and link the ICR into the list specified by the VRN offset.
1528 FA1D
1529 FA1D 20 8A FD              jsr   map_vp                   ;Set up for link_record
1530 FA20 A8                    tay   
1531 FA21 FA                    plx                            ;Get back the VRN offset
1532 FA22 78                    sei                            ;Disable for critical section
1533 FA23 20 BF F7              jsr   link_record              ;Insert into the list
1534 FA26
1535 FA26              ; Now fill in the fields of the ICR
1536 FA26
1537 FA26 A0 04 00              ldy   #4
1538 FA29              loop      
1539 FA29 68                    pla                            ;Pull back a byte
1540 FA2A 97 F8                 sta   [<vcr],y                 ;Place in ICR
1541 FA2C 88                    dey   
1542 FA2D 88                    dey   
1543 FA2E 10 F9                 bpl   loop
1544 FA30
1545 FA30 28                    plp                            ;reset interrupts to old state
1546 FA31
1547 FA31 AD 40 FA              lda   |id_temp                 ;Get the ID back and return
1548 FA34 18                    clc   
1549 FA35 60                    rts   
1550 FA36
1551 FA36              no_mem    
1552 FA36 A9 02 00              lda   #no_mem_err
1553 FA39 7A                    ply                            ;fix stack
1554 FA3A              bad_vrn   
1555 FA3A 7A                    ply                            ;Pop off the stray VRN
1556 FA3B 7A                    ply   
1557 FA3C FA                    plx   
1558 FA3D 28                    plp                            ;Restore interrupt state
1559 FA3E 38                    sec   
1560 FA3F 60                    rts                            ;Return carry set with error code in A
1561 FA40
1562 FA40 00 00        id_temp  DC W:0000                      ;Temp storage for the ICR id
1563 FA42
1564 FA42                       end_proc 
1565 FA42                       eject 
1566 FA42              ;=====================================================================
1567 FA42              ; map_vrn : Validate and map a Vector reference number
1568 FA42              ;
1569 FA42              ; Created:      November 19, 1987
1570 FA42              ; Modified:     November 19, 1987
1571 FA42              ; Author:       Mike Askins
1572 FA42              ;
1573 FA42              ; Copyright Apple Computer Inc. 1987  All rights reserved
1574 FA42              ;
1575 FA42              ; Input:        A = Vector Reference Number (index)
1576 FA42              ;               X = undefined
1577 FA42              ;               Y = undefined
1578 FA42              ;               P = nvmxdizc
1579 FA42              ;                   ..000...
1580 FA42              ;    vrn_to_index = mapping table
1581 FA42              ;
1582 FA42              ; Output:       A = VRN Offset (or error code if CS; 1->'Invalid VRN')
1583 FA42              ;               X = Vector Index
1584 FA42              ;               Y = preserved
1585 FA42              ;               P = nvmxdizc
1586 FA42              ;                   ..000..E -> 'Invalid VRN'
1587 FA42              ;               b = preserved
1588 FA42              ;
1589 FA42              ;======================================================================
1590 FA42
1591 FA42              map_vrn  proc 
1592 FA42                       entry map_vi
1593 FA42
1594 FA42              invalid_vrn_err equ   1                 ;Belongs in common.equ
1595 FA42
1596 FA42 48                    pha                            ;Keep for compares
1597 FA43 AA                    tax                            ;Check for zero
1598 FA44 F0 21                 beq   found_it                 ;If zero, we know it's good
1599 FA46
1600 FA46 A2 FE FF              ldx   #$FFFE                   ;Prep for the first time thru the loop
1601 FA49              not_it    
1602 FA49 E8                    inx                            ;Move to lower bound of next range
1603 FA4A E8                    inx   
1604 FA4B BD 34 EA              lda   |vrn_to_index,x          ;Check for end of table
1605 FA4E F0 1F                 beq   no_vrn                   ;Couldn't find a mapping range
1606 FA50 C3 01                 cmp   1,s                      ;Check if we're too far in the table
1607 FA52 F0 02                 beq   skip                     ;I wish we had a BGT instruction
1608 FA54 B0 19                 bge   no_vrn                   ;We've passed all ranges less than VRN
1609 FA56              skip      
1610 FA56
1611 FA56 E8                    inx                            ;Move to upper bound of this range
1612 FA57 E8                    inx   
1613 FA58 BD 34 EA              lda   |vrn_to_index,x          ;Pull bound
1614 FA5B E8                    inx                            ;Move index to the last field in range
1615 FA5C E8                    inx   
1616 FA5D C3 01                 cmp   1,s                      ;Compare against the VRN
1617 FA5F 90 E8                 blt   not_it                   ;Possibly the next range will do it
1618 FA61
1619 FA61 38                    sec   
1620 FA62 68                    pla   
1621 FA63 FD 34 EA              sbc   |vrn_to_index,x          ;Make the 'vector index'
1622 FA66              map_vi    
1623 FA66 48                    pha                            ;Keep for misuse later
1624 FA67              found_it  
1625 FA67 0A                    asl   a
1626 FA68 0A                    asl   a
1627 FA69 18                    clc   
1628 FA6A 69 08 00              adc   #icr_list
1629 FA6D FA                    plx                            ;Return 'vector index'
1630 FA6E 60                    rts   
1631 FA6F
1632 FA6F              no_vrn    
1633 FA6F 68                    pla   
1634 FA70 A9 01 00              lda   #invalid_vrn_err
1635 FA73 38                    sec   
1636 FA74 60                    rts   
1637 FA75
1638 FA75                       end_proc 
1639 FA75                       eject 
1640 FA75              ;=====================================================================
1641 FA75              ; patch_vector : Patches a firmware interrupt vector, builds an ICR
1642 FA75              ;                 and stores in it the vector's original value.
1643 FA75              ;
1644 FA75              ; Created:      November 19, 1987
1645 FA75              ; Modified:     November 19, 1987
1646 FA75              ; Author:       Mike Askins
1647 FA75              ;
1648 FA75              ; Copyright Apple Computer Inc. 1987  All rights reserved
1649 FA75              ;
1650 FA75              ; Input:        A = Vector Reference Number (index)
1651 FA75              ;               X = undefined
1652 FA75              ;               Y = undefined
1653 FA75              ;               P = nvmxdizc
1654 FA75              ;                   ..000...
1655 FA75              ;
1656 FA75              ; Output:       A = trashed
1657 FA75              ;               X = trashed
1658 FA75              ;               Y = trashed
1659 FA75              ;               P = nvmxdizc
1660 FA75              ;                   ..000..E -> 'No room for ICR''
1661 FA75              ;               b = preserved
1662 FA75              ;
1663 FA75              ;======================================================================
1664 FA75
1665 FA75              patch_vector proc 
1666 FA75
1667 FA75
1668 FA75 48                    pha                            ;Save away the VRN
1669 FA76
1670 FA76              ; Build an ICR which will hold the current value of the interrupt vector
1671 FA76
1672 FA76 20 04 FA              jsr   build_icr                ;Sets VCR to point to the contents
1673 FA79 B0 3C                 bcs   pv2
1674 FA7B
1675 FA7B              ; We don't need this 'ICR' to have an ID associated with it.  It would be
1676 FA7B              ;  difficult to dispose of later and so we just dispose of it now.
1677 FA7B
1678 FA7B AE 8E FF              ldx   |icr_id_hand
1679 FA7E AC 90 FF              ldy   |icr_id_hand+2
1680 FA81 20 93 FE              jsr   free_id                  ;Free up the ID
1681 FA84
1682 FA84              ; Get the current value of the vector we're about to modify
1683 FA84
1684 FA84 A3 01                 lda   1,s                      ;Get back VRN; still there for SetVector
1685 FA86 A8                    tay                            ;Hang on to this for a second
1686 FA87 20 42 FA              jsr   map_vrn                  ;Vector index in X; preserves Y
1687 FA8A DA                    phx                            ;Keep index for later
1688 FA8B
1689 FA8B 5A                    phy                            ;Space for value returned
1690 FA8C 5A                    phy                            ; ... it's a long word
1691 FA8D 5A                    phy                            ;Send VRN to GetVector
1692 FA8E A2 03 11 22           _GetVector                     ;Get the value of the vector
1693 FA95
1694 FA95              ; Now record this information in this special ICR.  (Remember that non-special
1695 FA95              ;  ICRs record the original value of the firmware interrupt vector.)
1696 FA95
1697 FA95 A0 00 00              ldy   #0
1698 FA98 68                    pla                            ;Pull low byte of current vector value
1699 FA99 97 F8                 sta   [vcr],y
1700 FA9B C8                    iny   
1701 FA9C C8                    iny   
1702 FA9D 68                    pla                            ; ... and hi byte
1703 FA9E 97 F8                 sta   [vcr],y
1704 FAA0
1705 FAA0              ; Now set the vector to point into our vector dispatch table.
1706 FAA0
1707 FAA0 68                    pla                            ;Get back vector index
1708 FAA1 AE 54 EA              ldx   |vect_disp_base+2        ;Get table base (high)
1709 FAA4 0A                    asl   a                        ;Convert to a point in our dispatch tabl
1710 FAA5 0A                    asl   a
1711 FAA6 18                    clc   
1712 FAA7 6D 52 EA              adc   |vect_disp_base
1713 FAAA 90 01                 bcc   pv1
1714 FAAC E8                    inx                            ;There was a carry
1715 FAAD              pv1       
1716 FAAD DA                    phx                            ;Push on the value to set vector to
1717 FAAE 48                    pha                            ; ... and the low part
1718 FAAF A2 03 10 22           _SetVector                     ;Do it
1719 FAB6 60                    rts   
1720 FAB7
1721 FAB7              pv2       
1722 FAB7 68                    pla   
1723 FAB8 60                    rts   
1724 FAB9
1725 FAB9                       end_proc 
1726 FAB9
1727 FAB9              empty_vect proc 
1728 FAB9
1729 FAB9              ; Check if the vector corresponding to the VRN in Acc is now null.  Return this
1730 FAB9              ;  info in the Z flag, Z set means VRN list element is null, clear ow.
1731 FAB9
1732 FAB9 20 42 FA              jsr   map_vrn
1733 FABC A8                    tay   
1734 FABD B9 69 F4              lda   |obj_list_tab,y
1735 FAC0 19 6B F4              ora   |obj_list_tab+2,y
1736 FAC3 60                    rts   
1737 FAC4
1738 FAC4                       end_proc 
1739 FAC4                       eject 
1740 FAC4              ;=====================================================================
1741 FAC4              ; wreck_icr : Deallocate an ICR, unlink it and free the ID
1742 FAC4              ;
1743 FAC4              ; Created:      November 19, 1987
1744 FAC4              ; Modified:     November 19, 1987
1745 FAC4              ; Author:       Mike Askins
1746 FAC4              ;
1747 FAC4              ; Copyright Apple Computer Inc. 1987  All rights reserved
1748 FAC4              ;
1749 FAC4              ; Input:        A = ID number
1750 FAC4              ;               X = undefined
1751 FAC4              ;               Y = undefined
1752 FAC4              ;               P = nvmxdizc
1753 FAC4              ;                   ..000...
1754 FAC4              ;
1755 FAC4              ; Output:       A = Vector Index of removed ICR (if CS; 1->'Invalid ID')
1756 FAC4              ;               X = Handler Address from removed ICR (low)
1757 FAC4              ;               Y = Handler Address from removed ICR (high)
1758 FAC4              ;               P = nvmxdizc
1759 FAC4              ;                   ..000..E -> 'ID was never allocated'
1760 FAC4              ;               b = preserved
1761 FAC4              ;
1762 FAC4              ;======================================================================
1763 FAC4
1764 FAC4              wreck_icr proc 
1765 FAC4
1766 FAC4
1767 FAC4              ; Start by setting up the locations hand and ptr for use later
1768 FAC4
1769 FAC4 48                    pha   
1770 FAC5 AE 8E FF              ldx   |icr_id_hand
1771 FAC8 AC 90 FF              ldy   |icr_id_hand+2
1772 FACB 20 92 FF              jsr   set_tab_ptr
1773 FACE 68                    pla   
1774 FACF
1775 FACF              ; Now get the VP corresponding to the ID we were passed
1776 FACF
1777 FACF 48                    pha                            ;Keep the ID around
1778 FAD0 0A                    asl   a
1779 FAD1 0A                    asl   a
1780 FAD2 C7 E8                 cmp   [ptr]                    ;See if beyond end of table
1781 FAD4 B0 36                 bge   bad_id2                  ;Beyond end of table
1782 FAD6 A8                    tay   
1783 FAD7 B7 E8                 lda   [ptr],y                  ;Get VP (lo)
1784 FAD9 48                    pha   
1785 FADA C8                    iny   
1786 FADB C8                    iny   
1787 FADC B7 E8                 lda   [ptr],y                  ;Get VP (hi)
1788 FADE 30 2B                 bmi   bad_id                   ;If the MSB=1, this icr is unallocated
1789 FAE0 A8                    tay                            ;VP (hi) -> Y
1790 FAE1 FA                    plx                            ;VP (lo) -> X
1791 FAE2
1792 FAE2              ; Pull the contents out of the ICR and shove into the stack
1793 FAE2
1794 FAE2 20 3C B7              jsr   deref2_vp                ;Set vcr to point to the contents
1795 FAE5 A0 02 00              ldy   #o_int_hand_addr+2
1796 FAE8 B7 F8                 lda   [vcr],y                  ;Hi part of stored handler address
1797 FAEA FA                    plx                            ;Get back the ID to manage stack...
1798 FAEB 48                    pha                            ;Keep to return
1799 FAEC 88                    dey   
1800 FAED 88                    dey   
1801 FAEE B7 F8                 lda   [vcr],y                  ;Lo part of stored handler address
1802 FAF0 48                    pha                            ;Keep to return
1803 FAF1 A0 04 00              ldy   #o_vrn
1804 FAF4 B7 F8                 lda   [vcr],y                  ;Stored VRN
1805 FAF6 48                    pha                            ;Keep to return
1806 FAF7 DA                    phx                            ; ...keep the ID at the top of stack
1807 FAF8
1808 FAF8              ; Now use the index to get a list offset which we will use to unlink the
1809 FAF8              ;  record from the appropriate list.
1810 FAF8
1811 FAF8 20 42 FA              jsr   map_vrn                  ;Convert the VRN to an obj_tab offset
1812 FAFB
1813 FAFB A6 F4                 ldx   vp
1814 FAFD A4 F6                 ldy   vp+2
1815 FAFF 20 05 F8              jsr   unlink_record
1816 FB02
1817 FB02              ; Finally deallocate the ICR, removing it from the Dynalist and relinquishing
1818 FB02              ;  the ID.
1819 FB02
1820 FB02 68                    pla                            ;Recover the ID
1821 FB03 20 F0 F9              jsr   release_icr
1822 FB06
1823 FB06 68                    pla                            ;Recover the vrn
1824 FB07 FA                    plx                            ;Recover the address (lo)
1825 FB08 7A                    ply                            ;Recover the address (hi)
1826 FB09 18                    clc                            ;Force no error condition
1827 FB0A 60                    rts   
1828 FB0B
1829 FB0B              bad_id    
1830 FB0B 68                    pla   
1831 FB0C              bad_id2   
1832 FB0C 68                    pla                            ;Straighten the stack up
1833 FB0D A9 53 00              lda   #parm_range_err
1834 FB10 38                    sec   
1835 FB11 60                    rts   
1836 FB12
1837 FB12                       end_proc 
1838 FB12                       eject 
1839 FB12              ;=====================================================================
1840 FB12              ; restore_vector : Restore an int vector to its original value
1841 FB12              ;
1842 FB12              ; Created:      November 25, 1987
1843 FB12              ; Modified:     November 25, 1987
1844 FB12              ; Author:       Mike Askins
1845 FB12              ;
1846 FB12              ; Copyright Apple Computer Inc. 1987  All rights reserved
1847 FB12              ;
1848 FB12              ; Input:        A = Vector Reference Number
1849 FB12              ;               X = undefined
1850 FB12              ;               Y = undefined
1851 FB12              ;               P = nvmxdizc
1852 FB12              ;                   ..000...
1853 FB12              ;
1854 FB12              ; Output:       A = trashed
1855 FB12              ;               X = trashed
1856 FB12              ;               Y = trashed
1857 FB12              ;               P = nvmxdizc
1858 FB12              ;                   ..000..E -> 'Bad VRN' or 'Could not deallocate ICR'
1859 FB12              ;               b = preserved
1860 FB12              ;
1861 FB12              ;======================================================================
1862 FB12
1863 FB12              restore_vector proc 
1864 FB12
1865 FB12
1866 FB12 48                    pha                            ;Keep the VRN for SetVector
1867 FB13 20 42 FA              jsr   map_vrn
1868 FB16 B0 33                 bcs   bad_vrn
1869 FB18
1870 FB18 AA                    tax   
1871 FB19 BD 6B F4              lda   |obj_list_tab+2,x        ;Pull VP
1872 FB1C A8                    tay   
1873 FB1D A9 00 00              lda   #0
1874 FB20 9D 6B F4              sta   |obj_list_tab+2,x        ;We can null out this list
1875 FB23 BD 69 F4              lda   |obj_list_tab,x          ;Pull VP (lo)
1876 FB26 48                    pha   
1877 FB27 A9 00 00              lda   #0
1878 FB2A 9D 69 F4              sta   |obj_list_tab,x
1879 FB2D FA                    plx                            ;VP is now in X,Y
1880 FB2E
1881 FB2E 20 3C B7              jsr   deref2_vp                ;Set VP and VCR
1882 FB31
1883 FB31 A0 02 00              ldy   #o_int_hand_addr+2
1884 FB34 B7 F8                 lda   [vcr],y
1885 FB36 48                    pha   
1886 FB37 88                    dey   
1887 FB38 88                    dey   
1888 FB39 B7 F8                 lda   [vcr],y
1889 FB3B 48                    pha   
1890 FB3C A2 03 10 22           _SetVector 
1891 FB43
1892 FB43 A6 F4                 ldx   vp
1893 FB45 A4 F6                 ldy   vp+2
1894 FB47 22 15 FD 00           jsl   deallocate
1895 FB4B
1896 FB4B              bad_vrn   
1897 FB4B 60                    rts   
1898 FB4C
1899 FB4C                       end_proc 
1900 FB4C                       eject 
1901 FB4C              ;======================================================================
1902 FB4C              ; allocate: Allocate a block of memory and return a VP to it.
1903 FB4C              ;
1904 FB4C              ;       Note: This routine calls low_allocate to try to get a block.
1905 FB4C              ;              If we're out of memory it attempts a purge of the cache and
1906 FB4C              ;              tries again.
1907 FB4C              ;
1908 FB4C              ;Created:       March 22, 1988
1909 FB4C              ;Modified:      August 13, 1988
1910 FB4C              ;Author:        Mike Askins
1911 FB4C              ;
1912 FB4C              ;Copyright Apple Computer Inc. 1987  All rights reserved
1913 FB4C              ;
1914 FB4C              ;Input:         A = Requested Size
1915 FB4C              ;               X = <undefined>
1916 FB4C              ;               Y = <undefined>
1917 FB4C              ;               P = nvmxdizc
1918 FB4C              ;                   ..000...
1919 FB4C              ;         seg_tab = Pointer to segment table
1920 FB4C              ;
1921 FB4C              ;Output:        A = trashed or error code if carry set
1922 FB4C              ;               X = VP (low)
1923 FB4C              ;               Y = VP (high)
1924 FB4C              ;               P = nvmxdizc
1925 FB4C              ;                   ..000..E -> 'Out of Memory' or 'Bad Parameter' (req size)
1926 FB4C              ;               b = preserved
1927 FB4C              ;          m_temp = trashed
1928 FB4C              ;             seg = segment containing allocated block
1929 FB4C              ;            size = size of segment allocated
1930 FB4C              ;
1931 FB4C              ;======================================================================
1932 FB4C              allocate proc 
1933 FB4C
1934 FB4C 8F 7A FB 00           sta   >req_size                ;In case we need to retry
1935 FB50 22 7C FB 00           jsl   low_allocate             ;Try to get block
1936 FB54 08                    php   
1937 FB55 90 21                 bcc   got_it                   ;If okay, no retries
1938 FB57
1939 FB57 C9 54 00              cmp   #out_of_mem              ;Check if failure was due to no memory
1940 FB5A D0 1C                 bne   got_it                   ;It wasn't an out of memory issue
1941 FB5C
1942 FB5C 28                    plp                            ;Straighten stack
1943 FB5D
1944 FB5D              ;	lda	<drvr_dev_num	;Preserve these around cache_del_vol
1945 FB5D              ;	pha
1946 FB5D              ;	lda	<drvr_fst_num
1947 FB5D              ;	pha
1948 FB5D              *** optimized 17-Jul-92 DAL
1949 FB5D D4 00                 pei   <drvr_dev_num            ;Preserve these around cache_del_vol
1950 FB5F D4 16                 pei   <drvr_fst_num
1951 FB61              *** end 17-Jul-92
1952 FB61
1953 FB61 64 00                 stz   <drvr_dev_num            ;Purge all non-deferred cached blocks
1954 FB63 64 16                 stz   <drvr_fst_num
1955 FB65 22 18 FC 01           jsl   cache_del_vol
1956 FB69
1957 FB69 68                    pla   
1958 FB6A 85 16                 sta   <drvr_fst_num            ;Restore these around cache_del_vol
1959 FB6C 68                    pla   
1960 FB6D 85 00                 sta   <drvr_dev_num
1961 FB6F
1962 FB6F AF 7A FB 00           lda   >req_size
1963 FB73 22 7C FB 00           jsl   low_allocate
1964 FB77 08                    php   
1965 FB78
1966 FB78              got_it    
1967 FB78 28                    plp   
1968 FB79 6B                    rtl   
1969 FB7A
1970 FB7A              snr_drvr_parms  
1971 FB7A
1972 FB7A              ; Save / Restore driver parameters
1973 FB7A              ; Copies data between driver direct page and a save area in either direction
1974 FB7A
1975 FB7A              ;	ldx	#$1A
1976 FB7A              ;loop	anop
1977 FB7A              ;	lda	<drvr_dev_num,x
1978 FB7A              ;	bcc	skipper_do
1979 FB7A              ;	lda	>save_drvr_stuff,x
1980 FB7A              ;skipper_do	anop
1981 FB7A              ;	sta	>save_drvr_stuff,x
1982 FB7A              ;	sta	<drvr_dev_num,x
1983 FB7A              ;	dex
1984 FB7A              ;	dex
1985 FB7A              ;	bpl	loop
1986 FB7A              ;	rts
1987 FB7A
1988 FB7A 16 00        req_size DC W:0
1989 FB7C
1990 FB7C              ;save_drvr_stuff ds      $1C
1991 FB7C
1992 FB7C                       end_proc 
1993 FB7C                       eject 
1994 FB7C              ;======================================================================
1995 FB7C              ; low_allocate: Allocate a block of memory and return a VP to it.
1996 FB7C              ;
1997 FB7C              ;       Note: This routine is called only by allocate.  The latter
1998 FB7C              ;              is the one who worries about purging cache blocks in the
1999 FB7C              ;              event of an out of memory error.
2000 FB7C              ;
2001 FB7C              ;Created:       April 2, 1987
2002 FB7C              ;Modified:      March 22, 1988
2003 FB7C              ;Author:        Mike Askins
2004 FB7C              ;
2005 FB7C              ;Copyright Apple Computer Inc. 1987  All rights reserved
2006 FB7C              ;
2007 FB7C              ;Input:         A = Requested Size
2008 FB7C              ;               X = <undefined>
2009 FB7C              ;               Y = <undefined>
2010 FB7C              ;               P = nvmxdizc
2011 FB7C              ;                   ..000...
2012 FB7C              ;         seg_tab = Pointer to segment table
2013 FB7C              ;
2014 FB7C              ;Output:        A = trashed or error code if carry set
2015 FB7C              ;               X = VP (low)
2016 FB7C              ;               Y = VP (high)
2017 FB7C              ;               P = nvmxdizc
2018 FB7C              ;                   ..000..E -> 'Out of Memory' or 'Bad Parameter' (req size)
2019 FB7C              ;               b = preserved
2020 FB7C              ;          m_temp = trashed
2021 FB7C              ;             seg = segment containing allocated block
2022 FB7C              ;            size = size of segment allocated
2023 FB7C              ;
2024 FB7C              ;======================================================================
2025 FB7C
2026 FB7C              low_allocate proc 
2027 FB7C
2028 FB7C C9 FB 1F              cmp   #max_blk_size+1
2029 FB7F B0 20                 bge   too_big                  ;Bad request size from FST
2030 FB81
2031 FB81 69 0C 00              adc   #block_ovrhd             ;Carry is already clear
2032 FB84 85 50                 sta   size                     ;Save request size (zp)
2033 FB86 A9 00 00              lda   #$0000                   ;Start us just before start of segtab 
2034 FB89
2035 FB89              next_seg  
2036 FB89 20 A9 FB              jsr   select_seg               ;Return offset to entry in segtab (y)
2037 FB8C 90 05                 bcc   seg_avail                ;Found a segment
2038 FB8E
2039 FB8E              ; We're out of segments to search
2040 FB8E
2041 FB8E 20 C2 FB              jsr   make_seg                 ;Grab another segment from MM
2042 FB91 B0 12                 bcs   alloc_err
2043 FB93
2044 FB93              seg_avail  
2045 FB93 5A                    phy   
2046 FB94 20 50 FC              jsr   search_seg               ;Ret with offset into segment (y)
2047 FB97 68                    pla   
2048 FB98 B0 EF                 bcs   next_seg                 ;This segment has too little space
2049 FB9A
2050 FB9A 48                    pha                            ;Segment table offset
2051 FB9B
2052 FB9B              found_space  
2053 FB9B 20 87 FC              jsr   res_block                ;Reserve a block in segment    
2054 FB9E
2055 FB9E              ; Now synthesize a VP out of the segtab offset and segment offset
2056 FB9E
2057 FB9E BB                    tyx                            ;Offset into segment
2058 FB9F 7A                    ply                            ;Offset into segment table
2059 FBA0
2060 FBA0 18                    clc                            ;No error
2061 FBA1              too_big   
2062 FBA1 A9 53 00              lda   #parm_range_err          ;Request size too large
2063 FBA4 6B                    rtl   
2064 FBA5
2065 FBA5              alloc_err  
2066 FBA5 A9 54 00              lda   #out_of_mem              ;In case of fail here, return code
2067 FBA8 6B                    rtl   
2068 FBA9
2069 FBA9                       end_proc 
2070 FBA9                       eject 
2071 FBA9              ;======================================================================
2072 FBA9              ; select_seg : Find the next segment in the segment table
2073 FBA9              ;
2074 FBA9              ;Created:       April 8, 1987
2075 FBA9              ;Modified:      April 24, 1987
2076 FBA9              ;Author:        Mike Askins
2077 FBA9              ;
2078 FBA9              ;Copyright Apple Computer Inc. 1987  All rights reserved
2079 FBA9              ;
2080 FBA9              ;Input:         A = Offset of last segment searched
2081 FBA9              ;               X = <undefined>
2082 FBA9              ;               Y = <undefined>
2083 FBA9              ;               P = nvmxdizc
2084 FBA9              ;                   ..000...
2085 FBA9              ;         seg_tab = Pointer to segment table
2086 FBA9              ;
2087 FBA9              ;Output:        A = trashed
2088 FBA9              ;               X = preserved
2089 FBA9              ;               Y = Offset of newly found segment
2090 FBA9              ;               P = nvmxdizc
2091 FBA9              ;                   ..000..E  1 -> End of segment table
2092 FBA9              ;               b = preserved
2093 FBA9              ;          m_temp = trashed
2094 FBA9              ;
2095 FBA9              ;======================================================================
2096 FBA9
2097 FBA9              select_seg proc 
2098 FBA9 A8                    tay   
2099 FBAA A7 4C                 lda   [seg_tab]
2100 FBAC 85 EC                 sta   m_temp
2101 FBAE 80 09                 bra   next_element
2102 FBB0
2103 FBB0              valid_entry  
2104 FBB0 C8                    iny                            ;Move up to high word of entry
2105 FBB1 C8                    iny   
2106 FBB2 B7 4C                 lda   [seg_tab],y              ;Check IT out...
2107 FBB4 30 05                 bmi   next_element2            ;If the MSB is set, free block
2108 FBB6 88                    dey                            ;Get back the current offset
2109 FBB7 88                    dey   
2110 FBB8 60                    rts                            ;Return with carry clear and Y
2111 FBB9
2112 FBB9              next_element  
2113 FBB9 C8                    iny                            ;Move to next position
2114 FBBA C8                    iny   
2115 FBBB              next_element2  
2116 FBBB C8                    iny   
2117 FBBC C8                    iny   
2118 FBBD C4 EC                 cpy   m_temp                   ;Off the end
2119 FBBF 90 EF                 blt   valid_entry              ;Still less than the limit
2120 FBC1
2121 FBC1              high_tail_it  
2122 FBC1 60                    rts                            ;Return CS : off end of table 
2123 FBC2
2124 FBC2                       end_proc 
2125 FBC2                       eject 
2126 FBC2              ;======================================================================
2127 FBC2              ; make_seg : Create a segment and link it into the segment table.  Return
2128 FBC2              ;               the offset into the segment table for the new seg in Y. 
2129 FBC2              ;
2130 FBC2              ; Created:      April 7, 1987
2131 FBC2              ; Modified:     April 6, 1990 CAF (see revision history)
2132 FBC2              ; Author:       Mike Askins
2133 FBC2              ;
2134 FBC2              ; Copyright Apple Computer Inc. 1987  All rights reserved
2135 FBC2              ;
2136 FBC2              ; Input:        A = <undefined>
2137 FBC2              ;               X = <undefined>
2138 FBC2              ;               Y = <undefined>
2139 FBC2              ;               P = nvmxdizc
2140 FBC2              ;                   ..000...
2141 FBC2              ;    seg_tab_hand = Handle to segment table
2142 FBC2              ;
2143 FBC2              ; Output:       A = trashed
2144 FBC2              ;               X = trashed
2145 FBC2              ;               Y = Segment Table Offset for new segment
2146 FBC2              ;               P = nvmxdizc
2147 FBC2              ;                   ..000..E
2148 FBC2              ;               b = preserved
2149 FBC2              ;             seg = pointer to new segment
2150 FBC2              ;         seg_tab = pointer to segment table
2151 FBC2              ;======================================================================
2152 FBC2
2153 FBC2              make_seg proc 
2154 FBC2
2155 FBC2              ; Set up ptr and hand for the link into the segment table
2156 FBC2
2157 FBC2 AF 82 FF 00           lda   >seg_tab_hand
2158 FBC6 AA                    tax   
2159 FBC7 AF 84 FF 00           lda   >seg_tab_hand+2
2160 FBCB A8                    tay   
2161 FBCC 20 92 FF              jsr   set_tab_ptr              ;Set up hand and pointer
2162 FBCF
2163 FBCF              ; Get the segment
2164 FBCF
2165 FBCF 20 0D FC              jsr   create_seg               ;Handle returned in X,Y
2166 FBD2 B0 38                 bcs   ms_nomem_err
2167 FBD4
2168 FBD4              ; Add it into the segment table
2169 FBD4
2170 FBD4 5A                    phy   
2171 FBD5 DA                    phx   
2172 FBD6 A6 FC                 ldx   hand
2173 FBD8 A4 FE                 ldy   hand+2
2174 FBDA 20 D7 FF              jsr   unlock_hand              ;Unlock handle in case it moves
2175 FBDD FA                    plx   
2176 FBDE 7A                    ply   
2177 FBDF 20 9D FE              jsr   add_element
2178 FBE2 08                    php                            ;Carry set per add_element results
2179 FBE3 5A                    phy                            ;Save offset into segtab
2180 FBE4
2181 FBE4 A5 E8                 lda   ptr                      ;Get current segtab address
2182 FBE6 85 4C                 sta   seg_tab                  ;Make it really current
2183 FBE8 8F 31 A0 00           sta   >seg_tab_copy            ;Keep a copy for deref_int
2184 FBEC A5 EA                 lda   ptr+2
2185 FBEE 85 4E                 sta   seg_tab+2
2186 FBF0 8F 33 A0 00           sta   >seg_tab_copy+2
2187 FBF4
2188 FBF4 A6 FC                 ldx   hand                     ;Now lock segtab down again
2189 FBF6 A4 FE                 ldy   hand+2
2190 FBF8 20 D9 FF              jsr   lock_hand
2191 FBFB
2192 FBFB 7A                    ply                            ;Get back offset.
2193 FBFC              *
2194 FBFC              * We want to keep track of the highest element in the segment table so we can
2195 FBFC              * avoid walking the entire table (which is usually no where near full) during
2196 FBFC              * the lock and unlock calls.  Y now contains the offset of the element we just
2197 FBFC              * added, so we'll first add 4 to it (that's how the lock and unlock calls want
2198 FBFC              * it), then compare it to the current value.  If it's larger, we save it as the
2199 FBFC              * new value...
2200 FBFC              *
2201 FBFC 18                    clc                            ;Add 4 to offset.
2202 FBFD 98                    tya   
2203 FBFE 69 04 00              adc   #4
2204 FC01 CF 81 FE 00           cmp   >seg_tab_last            ;Larger than current?
2205 FC05 90 04                 bcc   exit                     ;Nope, so exit.
2206 FC07 8F 81 FE 00           sta   >seg_tab_last            ;Yes, so make it the new value.
2207 FC0B              *
2208 FC0B              * We're all done, recover status from add_element and exit...
2209 FC0B              *
2210 FC0B 28           exit     plp                            ;Get back stat from add element
2211 FC0C              ms_nomem_err  
2212 FC0C 60                    rts   
2213 FC0D
2214 FC0D                       end_proc 
2215 FC0D                       eject 
2216 FC0D              ;======================================================================
2217 FC0D              ; create_seg : Make a new segment
2218 FC0D              ;
2219 FC0D              ; Created:      April  7, 1987
2220 FC0D              ; Modified:     June 20, 1988
2221 FC0D              ; Author:       Mike Askins
2222 FC0D              ;
2223 FC0D              ; Copyright Apple Computer Inc. 1987  All rights reserved
2224 FC0D              ;
2225 FC0D              ; Input:        A = <undefined>
2226 FC0D              ;               X = <undefined>
2227 FC0D              ;               Y = <undefined>
2228 FC0D              ;               P = nvmxdizc
2229 FC0D              ;                   ..000...
2230 FC0D              ;
2231 FC0D              ; Output:       A = <trashed>
2232 FC0D              ;               X = handle to new segment (low)
2233 FC0D              ;               Y = handle to new segment (high)
2234 FC0D              ;               P = nvmxdizc
2235 FC0D              ;                   ..000..E -> 'Out of Memory Error'
2236 FC0D              ;               b = preserved
2237 FC0D              ;             seg = pointer to newly created segment
2238 FC0D              ;
2239 FC0D              ;======================================================================
2240 FC0D
2241 FC0D              create_seg proc 
2242 FC0D
2243 FC0D              ; First grab an 8K segment from the memory manager
2244 FC0D
2245 FC0D A9 00 20              lda   #segment_size            ;8K currently
2246 FC10 20 A0 FF              jsr   grab_MM_seg              ;Return handle in Y,X
2247 FC13 B0 1E                 bcs   make_seg_err
2248 FC15
2249 FC15              *** optimized 15-Dec-92 DAL -- grab_MM_seg already allocates locked memory if lock_flag is set (Greg did that in 6.0)
2250 FC15              *** Saved 13 bytes, yahoo!  (I only needed a few to make this build.)
2251 FC15              ;;;	lda	>lock_flag	;If we're locked now, lock this one too
2252 FC15              ;;;	beq	cskip	;Skip the lock if we're unlocked now.
2253 FC15              ;;;	phx
2254 FC15              ;;;	phy
2255 FC15              ;;;	jsr	lock_hand	;Lock this segment like the rest
2256 FC15              ;;;	ply
2257 FC15              ;;;	plx
2258 FC15              ;;;cskip
2259 FC15              *** end 15-Dec-92
2260 FC15
2261 FC15              ; Keep handle around to return; dereference the mm handle to keep in zero page 
2262 FC15
2263 FC15 DA                    phx   
2264 FC16 5A                    phy   
2265 FC17 20 79 FC              jsr   mm_deref
2266 FC1A 86 F0                 stx   seg
2267 FC1C 84 F2                 sty   seg+2
2268 FC1E
2269 FC1E              ; Now make the whole segment look like one big free block
2270 FC1E
2271 FC1E A2 0C 00              ldx   #cst_size*2-2
2272 FC21              loop      
2273 FC21 BF 34 FC 00           lda   >cst_locat,x
2274 FC25 A8                    tay   
2275 FC26 BF 42 FC 00           lda   >cst_value,x
2276 FC2A 97 F0                 sta   [seg],y
2277 FC2C CA                    dex   
2278 FC2D CA                    dex   
2279 FC2E 10 F1                 bpl   loop
2280 FC30
2281 FC30 7A                    ply   
2282 FC31 FA                    plx   
2283 FC32 18                    clc   
2284 FC33              make_seg_err  
2285 FC33 60                    rts   
2286 FC34
2287 FC34
2288 FC34              cst_size equ   7
2289 FC34
2290 FC34 02 00 FE 1F  cst_locat DC W:dtag1_posn,dtag2_posn,size1_posn,size2_posn
2291 FC3C 06 00 08 00           DC W:fwd_posn,back_posn,free_posn
2292 FC42 00 80 00 80  cst_value DC W:dtag1_valu,dtag2_valu,max_blk_size,max_blk_size
2293 FC4A 00 00 FE FF           DC W:0,head_valu,init_block
2294 FC50
2295 FC50                       end_proc 
2296 FC50                       eject 
2297 FC50              ;======================================================================
2298 FC50              ; search_seg : Search a segment for a free block of sufficient size
2299 FC50              ;
2300 FC50              ;
2301 FC50              ;Created:       April 8, 1987
2302 FC50              ;Modified:      April 24, 1987
2303 FC50              ;Author:        Mike Askins
2304 FC50              ;
2305 FC50              ;Copyright Apple Computer Inc. 1987  All rights reserved
2306 FC50              ;
2307 FC50              ;Input:         A = <undefined>
2308 FC50              ;               X = <undefined>
2309 FC50              ;               Y = Segment to be searched (offset in segment table)
2310 FC50              ;               P = nvmxdizc
2311 FC50              ;                   ..000...
2312 FC50              ;            size = size of requested segment (bytes - including overhead)
2313 FC50              ;         seg_tab = Pointer to segment table
2314 FC50              ;
2315 FC50              ;
2316 FC50              ;Output:        A = trashed
2317 FC50              ;               X = trashed
2318 FC50              ;               Y = Offset in segment of block of sufficient size
2319 FC50              ;               P = nvmxdizc
2320 FC50              ;                   ..000..E  1 -> search unsuccessful
2321 FC50              ;               b = preserved
2322 FC50              ;             seg = pointer to segment searched
2323 FC50              ;
2324 FC50              ;======================================================================
2325 FC50
2326 FC50              search_seg proc 
2327 FC50
2328 FC50              ; Generate the base pointer 'seg' which points to the segment to search
2329 FC50              ;  Remember that the seement entry is a MM handle, not a pointer.
2330 FC50
2331 FC50 B7 4C                 lda   [seg_tab],y
2332 FC52 AA                    tax                            ;Low part for dereferencing
2333 FC53 C8                    iny   
2334 FC54 C8                    iny   
2335 FC55 B7 4C                 lda   [seg_tab],y
2336 FC57 A8                    tay                            ;High part
2337 FC58 20 79 FC              jsr   mm_deref
2338 FC5B 86 F0                 stx   seg
2339 FC5D 84 F2                 sty   seg+2                    ;Got the pointer to the segment
2340 FC5F
2341 FC5F              ; Find a free area
2342 FC5F
2343 FC5F A0 00 00              ldy   #$0000                   ;Start at the free list header 
2344 FC62
2345 FC62              ; Grab this free area pointer
2346 FC62
2347 FC62              try_again  
2348 FC62 B7 F0                 lda   [seg],y
2349 FC64 38                    sec                            ;Assume the worst
2350 FC65 A8                    tay                            ;Offset to available free block 
2351 FC66 F0 0B                 beq   out                      ;No free block of sufficient size
2352 FC68
2353 FC68              ; Look at the size field and determine if this free block is large enough
2354 FC68
2355 FC68 B7 F0                 lda   [seg],y
2356 FC6A C5 50                 cmp   size                     ;Is this one big enough?
2357 FC6C B0 04                 bge   end_quest                ;Eureka
2358 FC6E
2359 FC6E C8                    iny   
2360 FC6F C8                    iny   
2361 FC70 80 F0                 bra   try_again
2362 FC72
2363 FC72              end_quest  
2364 FC72 18                    clc   
2365 FC73              out       
2366 FC73 60                    rts   
2367 FC74
2368 FC74                       end_proc 
2369 FC74                       eject 
2370 FC74              ;======================================================================
2371 FC74              ; grab_deref : Gets a new memory manager segment of a particular size
2372 FC74              ;                Returns a dereferenced pointer to the segment.
2373 FC74              ;
2374 FC74              ; Created:      April 14, 1987
2375 FC74              ; Modified:     April 22, 1987
2376 FC74              ; Author:       Mike Askins
2377 FC74              ;
2378 FC74              ; Copyright Apple Computer Inc. 1987  All rights reserved
2379 FC74              ;
2380 FC74              ; Input:        A = Segment Size Requested
2381 FC74              ;               X = <reserved>
2382 FC74              ;               Y = <reserved>
2383 FC74              ;               P = nvmxdizc
2384 FC74              ;                   ..000...
2385 FC74              ;         gsos_id = the OS ID
2386 FC74              ;
2387 FC74              ; Output:       A = trashed
2388 FC74              ;               X = New segment (pointer low)
2389 FC74              ;               Y = New segment (pointer high)
2390 FC74              ;               P = nvmxdizc
2391 FC74              ;                   ..000..E
2392 FC74              ;               b = preserved
2393 FC74              ;
2394 FC74              ;======================================================================
2395 FC74
2396 FC74              grab_deref proc 
2397 FC74                       entry mm_deref
2398 FC74
2399 FC74 20 A0 FF              jsr   grab_mm_seg              ;Get the segment and return a handle
2400 FC77 B0 0D                 bcs   nevermind
2401 FC79
2402 FC79              * Dereference the handle and get the buffer address
2403 FC79
2404 FC79              mm_deref                                ;Entry just to dereference a mm handle
2405 FC79
2406 FC79 98                    tya                            ;Move the high part into the acc
2407 FC7A 8B                    phb                            ;Save current DBR
2408 FC7B 48                    pha                            ;Push bank and garbage
2409 FC7C AB                    plb                            ;DBR now set for handle
2410 FC7D
2411 FC7D BC 02 00              ldy   |$0002,x                 ;Get high part
2412 FC80 BD 00 00              lda   |$0000,x                 ;Get low part
2413 FC83 AA                    tax   
2414 FC84 AB                    plb                            ;pull extra byte of garbage
2415 FC85 AB                    plb                            ;restore our DBR
2416 FC86
2417 FC86              nevermind  
2418 FC86 60                    rts   
2419 FC87
2420 FC87                       end_proc 
2421 FC87                       eject 
2422 FC87              ;======================================================================
2423 FC87              ; res_block : Create a reserved block out of a free one
2424 FC87              ;
2425 FC87              ;
2426 FC87              ;Created:       April 8, 1987
2427 FC87              ;Modified:      April 27, 1987
2428 FC87              ;Author:        Mike Askins
2429 FC87              ;
2430 FC87              ;Copyright Apple Computer Inc. 1987  All rights reserved
2431 FC87              ;
2432 FC87              ;Input:         A = <undefined>
2433 FC87              ;               X = <undefined>
2434 FC87              ;               Y = Free Area segment offset
2435 FC87              ;               P = nvmxdizc
2436 FC87              ;                   ..000...
2437 FC87              ;            size = size of block to reserve
2438 FC87              ;             seg = pointer to the segment      
2439 FC87              ;
2440 FC87              ;
2441 FC87              ;Output:        A = trashed
2442 FC87              ;               X = trashed
2443 FC87              ;               Y = Offset into seg of new block
2444 FC87              ;               P = nvmxdizc
2445 FC87              ;                   ..000...
2446 FC87              ;               b = preserved
2447 FC87              ;          m_temp = trashed
2448 FC87              ;            size = altered in some cases
2449 FC87              ;
2450 FC87              ;======================================================================
2451 FC87
2452 FC87              res_block proc 
2453 FC87
2454 FC87 A5 50                 lda   size                     ;This is request size + overhead
2455 FC89 18                    clc   
2456 FC8A 69 0F 00              adc   #min_blk_size-1          ;Smallest usable block size
2457 FC8D D7 F0                 cmp   [seg],y                  ; (-1 above cuz we don't have BLE !)
2458 FC8F 90 09                 blt   fission                  ;If A < free size, break block in two
2459 FC91
2460 FC91              ; There is not sufficient free space in this block to warrant fission.
2461 FC91              ;   Therefore the requestor will get a segment slightly longer than expected.
2462 FC91
2463 FC91 B7 F0                 lda   [seg],y                  ;Size of free block is now req size
2464 FC93 85 50                 sta   size
2465 FC95
2466 FC95              ; We must also pull the free block out of the list. 
2467 FC95
2468 FC95 20 CB FC              jsr   unfree
2469 FC98 80 14                 bra   reserve_it
2470 FC9A
2471 FC9A              fission   
2472 FC9A
2473 FC9A              ; Gotta break the free area into two pieces.  Shrink the size of the free
2474 FC9A              ;   block appropriately and place the new allocated block beyond it.
2475 FC9A
2476 FC9A B7 F0                 lda   [seg],y                  ;Get the size of the free area
2477 FC9C 38                    sec   
2478 FC9D E5 50                 sbc   size                     ;This is the size of the new freeblock
2479 FC9F 97 F0                 sta   [seg],y                  ;Update the size/tag field
2480 FCA1
2481 FCA1 48                    pha                            ;Save the size for trailing size word
2482 FCA2 98                    tya                            ;Trailsize is: Y + freesize - 2
2483 FCA3 18                    clc   
2484 FCA4 63 01                 adc   1,s
2485 FCA6 A8                    tay   
2486 FCA7 88                    dey   
2487 FCA8 88                    dey   
2488 FCA9 68                    pla   
2489 FCAA 97 F0                 sta   [seg],y                  ;Set trailing size word
2490 FCAC C8                    iny   
2491 FCAD C8                    iny                            ;Y is now set to new allocated block!
2492 FCAE
2493 FCAE              ; Set Block to point to the reserved block.
2494 FCAE
2495 FCAE              reserve_it  
2496 FCAE 5A                    phy   
2497 FCAF 98                    tya   
2498 FCB0 18                    clc   
2499 FCB1 65 F0                 adc   seg
2500 FCB3 85 EC                 sta   m_temp
2501 FCB5 A5 F2                 lda   seg+2
2502 FCB7 69 00 00              adc   #$0000
2503 FCBA 85 EE                 sta   m_temp+2
2504 FCBC
2505 FCBC              ; Finish up by storing the size/tag fields in the newly allocated block!
2506 FCBC
2507 FCBC A5 50                 lda   size
2508 FCBE 09 00 80              ora   #$8000                   ;Flip on the 'reserved' bit
2509 FCC1 97 F0                 sta   [seg],y
2510 FCC3 A4 50                 ldy   size
2511 FCC5 88                    dey   
2512 FCC6 88                    dey   
2513 FCC7 97 EC                 sta   [m_temp],y               ;A little funky but it's shorter code
2514 FCC9
2515 FCC9 7A                    ply                            ;Get back the offset into seg
2516 FCCA 60                    rts   
2517 FCCB
2518 FCCB                       end_proc 
2519 FCCB                       eject 
2520 FCCB              ;======================================================================
2521 FCCB              ; unfree : Unlinks a free block from the free list
2522 FCCB              ;
2523 FCCB              ;Created:       April  9, 1987
2524 FCCB              ;Modified:      April 21, 1987
2525 FCCB              ;Author:        Mike Askins
2526 FCCB              ;
2527 FCCB              ;Copyright Apple Computer Inc. 1987  All rights reserved
2528 FCCB              ;
2529 FCCB              ;Input:         A = <undefined>
2530 FCCB              ;               X = <undefined>
2531 FCCB              ;               Y = Block to unlink (offset within seg)
2532 FCCB              ;               P = nvmxdizc
2533 FCCB              ;                   ..000...
2534 FCCB              ;             seg = Pointer to segment
2535 FCCB              ;
2536 FCCB              ;Output:        A = trashed
2537 FCCB              ;               X = trashed
2538 FCCB              ;               Y = Preserved
2539 FCCB              ;               P = nvmxdizc
2540 FCCB              ;                   ..000...
2541 FCCB              ;               b = preserved
2542 FCCB              ;
2543 FCCB              ;======================================================================
2544 FCCB
2545 FCCB              unfree   proc 
2546 FCCB
2547 FCCB              ; Find the successive free area
2548 FCCB
2549 FCCB 5A                    phy   
2550 FCCC C8                    iny   
2551 FCCD C8                    iny                            ;Pointing at next_link
2552 FCCE B7 F0                 lda   [seg],y                  ;Got link to next guy
2553 FCD0 AA                    tax                            ;Keep around the offset to successor
2554 FCD1 C8                    iny                            ;Advance to back_link
2555 FCD2 C8                    iny   
2556 FCD3 B7 F0                 lda   [seg],y                  ;Get offset to predecessor
2557 FCD5 48                    pha                            ;Keep that, too. 
2558 FCD6
2559 FCD6              ; Alter the predecessor's forward link
2560 FCD6
2561 FCD6 A8                    tay                            ;Get pointer to next_link of
2562 FCD7 C8                    iny                            ; predecessor
2563 FCD8 C8                    iny   
2564 FCD9 8A                    txa   
2565 FCDA 97 F0                 sta   [seg],y                  ;Pred's next_link is now our successor
2566 FCDC
2567 FCDC              ; Alter the successor's back_link
2568 FCDC
2569 FCDC 68                    pla                            ;The predecessor
2570 FCDD 9B                    txy                            ;Recover the successor's offset
2571 FCDE F0 06                 beq   no_pred                  ;There is no successor
2572 FCE0 C8                    iny                            ;Move to successor's back_link field
2573 FCE1 C8                    iny   
2574 FCE2 C8                    iny   
2575 FCE3 C8                    iny   
2576 FCE4 97 F0                 sta   [seg],y                  ;Succ's back_link is now our predecessor
2577 FCE6
2578 FCE6              no_pred   
2579 FCE6 7A                    ply                            ;Recover the offset to this block
2580 FCE7 60                    rts   
2581 FCE8
2582 FCE8                       end_proc 
2583 FCE8                       eject 
2584 FCE8              ;======================================================================
2585 FCE8              ; alloc_zero : Allocate and zero out a block of memory returning a VP
2586 FCE8              ;
2587 FCE8              ;Created:       April 2, 1987
2588 FCE8              ;Modified:      March 22, 1988
2589 FCE8              ;Author:        Mike Askins
2590 FCE8              ;
2591 FCE8              ;Copyright Apple Computer Inc. 1987  All rights reserved
2592 FCE8              ;
2593 FCE8              ;Input:         A = Requested Size
2594 FCE8              ;               X = <undefined>
2595 FCE8              ;               Y = <undefined>
2596 FCE8              ;               P = nvmxdizc
2597 FCE8              ;                   ..000..0 -> Allocate and do not zero
2598 FCE8              ;                          1 -> Allocate and zero
2599 FCE8              ;         seg_tab = Pointer to segment table
2600 FCE8              ;
2601 FCE8              ;Output:        A = trashed or error code if carry set
2602 FCE8              ;               X = VP (low)
2603 FCE8              ;               Y = VP (high)
2604 FCE8              ;               P = nvmxdizc
2605 FCE8              ;                   ..000..E -> 'Out of Memory' 'Bad request size'
2606 FCE8              ;               b = preserved
2607 FCE8              ;          m_temp = trashed
2608 FCE8              ;             seg = segment containing allocated block
2609 FCE8              ;            size = size of segment allocated
2610 FCE8              ;
2611 FCE8              ;======================================================================
2612 FCE8
2613 FCE8              ; Front end to allocate which zeros out the block if the carry is set
2614 FCE8
2615 FCE8              alloc_zero proc 
2616 FCE8
2617 FCE8 48                    pha   
2618 FCE9 08                    php                            ;Save C so we know whether to zero
2619 FCEA 08                    php                            ;...so that pulls on errorexit work OK
2620 FCEB 22 4C FB 00           jsl   allocate
2621 FCEF B0 21                 bcs   failure                  ;Couldn't get the memory space
2622 FCF1
2623 FCF1 28                    plp   
2624 FCF2 28                    plp                            ;Get back info on whether we zero
2625 FCF3 90 1B                 bcc   sneakout                 ;They didn't want us to zero the seg
2626 FCF5
2627 FCF5 DA                    phx                            ;Preserve the VP to return later
2628 FCF6 5A                    phy   
2629 FCF7 20 8A FD              jsr   map_vp                   ;A has offset
2630 FCFA 18                    clc   
2631 FCFB 69 08 00              adc   #fwd_ovrhead-2
2632 FCFE 85 EC                 sta   m_temp                   ;Keep total for later
2633 FD00 63 05                 adc   5,s                      ;Add in the requested size
2634 FD02 A8                    tay   
2635 FD03 A9 00 00              lda   #$0000
2636 FD06
2637 FD06              ; Zero the contents of the segment.  It is possible for us to zero up to two
2638 FD06              ;  bytes just before the contents, but that's okay since these bytes are in
2639 FD06              ;  the linkage area of the segment which is defined later (if at all).
2640 FD06
2641 FD06              more_zero  
2642 FD06 97 F0                 sta   [seg],y
2643 FD08 88                    dey   
2644 FD09 88                    dey   
2645 FD0A C4 EC                 cpy   m_temp
2646 FD0C B0 F8                 bge   more_zero
2647 FD0E
2648 FD0E 7A                    ply                            ;Pull back the VP
2649 FD0F FA                    plx   
2650 FD10
2651 FD10              sneakout  
2652 FD10 68                    pla                            ;Straigten the stack up
2653 FD11 6B                    rtl                            ;Carry was clear
2654 FD12
2655 FD12              failure   
2656 FD12 FA                    plx                            ;Pull off four bytes of stack refuse
2657 FD13 FA                    plx   
2658 FD14 6B                    rtl                            ;Carry ensured set by the branch
2659 FD15
2660 FD15
2661 FD15
2662 FD15                       end_proc 
2663 FD15                       eject 
2664 FD15              ;======================================================================
2665 FD15              ; deallocate  : Frees a block and merges resulting free space
2666 FD15              ;                Warning: In case of rapture, this code will be unsupported! 
2667 FD15              ;
2668 FD15              ; Created:      April  9, 1987
2669 FD15              ; Modified:     April 6, 1990 CAF (see revision history)
2670 FD15              ; Author:       Mike Askins
2671 FD15              ;
2672 FD15              ; Copyright Apple Computer Inc. 1987  All rights reserved
2673 FD15              ;
2674 FD15              ; Input:        A = undefined
2675 FD15              ;               X = Virtual Pointer (low)
2676 FD15              ;               Y = Virtual Pointer (high)
2677 FD15              ;               P = nvmxdizc
2678 FD15              ;                   ..000...
2679 FD15              ;
2680 FD15              ; Output:       A = trashed
2681 FD15              ;               X = trashed
2682 FD15              ;               Y = trashed
2683 FD15              ;               P = nvmxdizc
2684 FD15              ;                   ..000..E -> 'Tried to Deallocate a Segment and Failed'
2685 FD15              ;               b = preserved
2686 FD15              ;             ptr = trashed
2687 FD15              ;             seg = trashed
2688 FD15              ;          m_temp = trashed
2689 FD15              ;
2690 FD15              ;======================================================================
2691 FD15
2692 FD15              deallocate proc 
2693 FD15
2694 FD15              ; Disclaimer:  This implementation is not as efficient as it could be.
2695 FD15              ;  The original block being freed is always linked into the free list
2696 FD15              ;  even in cases where it is (just a few lines later) subsequently unlinked
2697 FD15              ;  from the free list.  The algorithm IS conceptually simple, but at the
2698 FD15              ;  price of inefficient 'worst case' behavior; this routine is a good
2699 FD15              ;  candidate for optimization.
2700 FD15
2701 FD15 84 EC                 sty   m_temp                   ;Keep offset into segment for later
2702 FD17
2703 FD17              ; Map the virtual pointer into a seg base pointer and offset
2704 FD17
2705 FD17 20 8A FD              jsr   map_vp
2706 FD1A A8                    tay                            ;Got the offset into the segment
2707 FD1B
2708 FD1B              ; Make this block unallocated AND link it into the front of the free list
2709 FD1B
2710 FD1B 20 9C FD              jsr   free
2711 FD1E B0 64                 bcs   cog_dis                  ;Caller's block IS ALREADY FREE! Blowup!
2712 FD20
2713 FD20              ; Check to see if the physical predecessor is a free block
2714 FD20
2715 FD20 5A                    phy   
2716 FD21 88                    dey   
2717 FD22 88                    dey   
2718 FD23 B7 F0                 lda   [seg],y
2719 FD25 30 0E                 bmi   merge_refrain1
2720 FD27
2721 FD27              ; Want to merge the previous block with the current block.  Get the
2722 FD27              ;   size of the previous block, subtract from original pointer, and merge. 
2723 FD27
2724 FD27 38                    sec   
2725 FD28 E3 01                 sbc   1,s                      ;This is the wrong order, so 2's comp
2726 FD2A 49 FF FF              eor   #$FFFF
2727 FD2D 1A                    inc   a
2728 FD2E A8                    tay                            ;First Area -
2729 FD2F FA                    plx                            ;Balance out the stack (2nd area)
2730 FD30 20 D2 FD              jsr   merge_free
2731 FD33 80 01                 bra   skip
2732 FD35
2733 FD35              ; Y now points to a free block.  If the block which follows is also free we
2734 FD35              ;   want to unlink that block from the free list and merge it with the
2735 FD35              ;   current free block.
2736 FD35
2737 FD35              merge_refrain1  
2738 FD35 7A                    ply                            ;Reclaim index to target block
2739 FD36              skip      
2740 FD36 5A                    phy   
2741 FD37 B7 F0                 lda   [seg],y                  ;Get size of this block
2742 FD39              ;;;	and	#$7FFF
2743 FD39              *** optmized 17-Jul-92 DAL
2744 FD39 0A                    asl   a
2745 FD3A 4A                    lsr   a
2746 FD3B              *** end 17-Jul-92
2747 FD3B 18                    clc   
2748 FD3C 63 01                 adc   1,s                      ;Got address of physical successor
2749 FD3E A8                    tay   
2750 FD3F B7 F0                 lda   [seg],y                  ;See if following block is free
2751 FD41 30 07                 bmi   merge_refrain2           ;If allocated, nothing to do...
2752 FD43
2753 FD43 BB                    tyx                            ;Second free area for merge_free
2754 FD44 7A                    ply                            ;Got first free area
2755 FD45 20 D2 FD              jsr   merge_free               ;We did it!
2756 FD48 80 01                 bra   free_seg_chk
2757 FD4A
2758 FD4A              merge_refrain2  
2759 FD4A 68                    pla                            ;Straighten out the stack
2760 FD4B
2761 FD4B              free_seg_chk  
2762 FD4B
2763 FD4B              ; Check to see if the liberation which we just performed resulted in an empty
2764 FD4B              ;  segment.  If so, release it and the element pointing to it in the seg tab.
2765 FD4B              ;  Note that segments larger than our managed segment size only contain one
2766 FD4B              ;  block; free space in the segment is interpreted as meaning that the
2767 FD4B              ;  whole segment is unallocated.
2768 FD4B
2769 FD4B A0 04 00              ldy   #init_block              ;See if the first phys area length
2770 FD4E B7 F0                 lda   [seg],y                  ; is allocated
2771 FD50 30 30                 bmi   still_active             ;Don't throw MM seg away if so
2772 FD52 C9 FA 1F              cmp   #max_blk_size            ;If length < maxblocksize
2773 FD55 90 2B                 blt   still_active             ; ...skip
2774 FD57
2775 FD57 A4 EC                 ldy   m_temp                   ;Get back the segment table offset
2776 FD59 B7 4C                 lda   [seg_tab],y              ;Pick up the handle
2777 FD5B AA                    tax   
2778 FD5C 5A                    phy                            ;Need ptr to element later
2779 FD5D C8                    iny   
2780 FD5E C8                    iny   
2781 FD5F B7 4C                 lda   [seg_tab],y
2782 FD61 A8                    tay   
2783 FD62
2784 FD62 20 CD FF              jsr   free_mm_seg              ;Pass handle in X,Y
2785 FD65 7A                    ply                            ;Get back pointer to element
2786 FD66 B0 1B                 bcs   no_free
2787 FD68              *
2788 FD68              * If we just freed the highest element in the list, we want to update seg_tab_last
2789 FD68              * so lockmem and unlockmem are as efficient as possible.  We keep seg_tab_last with
2790 FD68              * 4 added to it so we must account for that...
2791 FD68              *
2792 FD68 98                    tya                            ;Add 4 to offset (carry already clr).
2793 FD69 69 04 00              adc   #4
2794 FD6C CF 81 FE 00           cmp   >seg_tab_last            ;Did we remove the last one?
2795 FD70 D0 05                 bne   continue                 ;Nope.
2796 FD72 98                    tya   
2797 FD73 8F 81 FE 00           sta   >seg_tab_last            ;Yes, so dec seg_tab_last by 4.
2798 FD77              *
2799 FD77 A5 4C        continue lda   seg_tab                  ;Mod 8/12... used to be >seg_tab_hand
2800 FD79 85 E8                 sta   ptr
2801 FD7B A5 4E                 lda   seg_tab+2
2802 FD7D 85 EA                 sta   ptr+2
2803 FD7F 20 D5 FE              jsr   kill_element
2804 FD82
2805 FD82              still_active  
2806 FD82
2807 FD82 18                    clc   
2808 FD83              no_free   
2809 FD83 6B                    rtl   
2810 FD84
2811 FD84              cog_dis   
2812 FD84 A9 02 00              lda   #sd_scm_dealloc
2813 FD87 4C 02 EF              jmp   s_sys_death
2814 FD8A
2815 FD8A                       end_proc 
2816 FD8A                       eject 
2817 FD8A              ;======================================================================
2818 FD8A              ; map_vp : Return the physical address, segment address, and offset
2819 FD8A              ;            into the segment for the block pointed to by a VP 
2820 FD8A              ;
2821 FD8A              ; Created:      April  9, 1987 (no, really)
2822 FD8A              ; Modified:     May  7, 1987
2823 FD8A              ; Author:       Mike and Jim
2824 FD8A              ;
2825 FD8A              ; Copyright Apple Computer Inc. 1987  All rights reserved
2826 FD8A              ;
2827 FD8A              ; Input:        A = <undefined>
2828 FD8A              ;               X = Virtual Pointer (low)
2829 FD8A              ;               Y = Virtual Pointer (high)
2830 FD8A              ;               P = nvmxdizc
2831 FD8A              ;                   ..000...
2832 FD8A              ;
2833 FD8A              ; Output:       A = Offset into segment
2834 FD8A              ;               X = Physical address (low)
2835 FD8A              ;               Y = Physical address (high)
2836 FD8A              ;               P = nvmxdizc
2837 FD8A              ;                   ..000...
2838 FD8A              ;               b = preserved
2839 FD8A              ;             seg = Segment address
2840 FD8A              ;             ptr = trashed
2841 FD8A              ;
2842 FD8A              ;======================================================================
2843 FD8A
2844 FD8A              map_vp   proc 
2845 FD8A
2846 FD8A              ; The low part of the VP has the offset into the segment 
2847 FD8A
2848 FD8A DA                    phx                            ;Keep around for a while
2849 FD8B
2850 FD8B 22 F0 FD 00           jsl   gderef
2851 FD8F
2852 FD8F              ; Now get the segment address
2853 FD8F
2854 FD8F A7 E8                 lda   [ptr]
2855 FD91 85 F0                 sta   seg
2856 FD93 A0 02 00              ldy   #$0002
2857 FD96 B7 E8                 lda   [ptr],y
2858 FD98 85 F2                 sta   seg+2
2859 FD9A 68                    pla   
2860 FD9B
2861 FD9B 60                    rts   
2862 FD9C
2863 FD9C                       end_proc 
2864 FD9C                       eject 
2865 FD9C              ;======================================================================
2866 FD9C              ; free : Frees a block and links it into the front of the free list
2867 FD9C              ;
2868 FD9C              ;Created:       April  9, 1987
2869 FD9C              ;Modified:      May 4, 1987 !
2870 FD9C              ;Author:        Mike Askins
2871 FD9C              ;
2872 FD9C              ;Copyright Apple Computer Inc. 1987  All rights reserved
2873 FD9C              ;
2874 FD9C              ;Input:         A = <undefined>
2875 FD9C              ;               X = <undefined>
2876 FD9C              ;               Y = Block to free (offset within seg)
2877 FD9C              ;               P = nvmxdizc
2878 FD9C              ;                   ..000...
2879 FD9C              ;             seg = Pointer to segment
2880 FD9C              ;
2881 FD9C              ;Output:        A = trashed
2882 FD9C              ;               X = trashed
2883 FD9C              ;               Y = Preserved
2884 FD9C              ;               P = nvmxdizc
2885 FD9C              ;                   ..000..E -> 'Attempt to free an unallocated block'
2886 FD9C              ;               b = preserved
2887 FD9C              ;
2888 FD9C              ;======================================================================
2889 FD9C
2890 FD9C              free     proc 
2891 FD9C
2892 FD9C              ; If this block appears to be free already, branch out with an error
2893 FD9C
2894 FD9C 38                    sec   
2895 FD9D B7 F0                 lda   [seg],y                  ;Get the tag/size
2896 FD9F 10 30                 bpl   free_error               ;OOPS... ALREADY FREE! Skip out
2897 FDA1
2898 FDA1              ; Change the leading tag
2899 FDA1
2900 FDA1 5A                    phy                            ;Save off the pointer to the block
2901 FDA2              ;;;	and	#$7FFF	;Force off the tag (freeing block)
2902 FDA2              *** optimized 17-Jul-92 DAL
2903 FDA2 0A                    asl   a
2904 FDA3 4A                    lsr   a
2905 FDA4              *** end 17-Jul-92
2906 FDA4 97 F0                 sta   [seg],y
2907 FDA6
2908 FDA6              ; Change the trailing tag
2909 FDA6
2910 FDA6 48                    pha                            ;Keep the size
2911 FDA7 18                    clc   
2912 FDA8 63 03                 adc   3,s                      ;Move pointer to phys successor
2913 FDAA A8                    tay   
2914 FDAB 88                    dey   
2915 FDAC 88                    dey                            ;Pointing at tag/size of target block
2916 FDAD 68                    pla                            ;Got back altered size
2917 FDAE FA                    plx                            ;Pull block pointer off; keep in X
2918 FDAF 97 F0                 sta   [seg],y                  ;Store in trailing size word
2919 FDB1
2920 FDB1              ; Preserve the current free header link and change it to point to us
2921 FDB1
2922 FDB1              *** optimized 15-Dec-92 DAL (saves 3 bytes)
2923 FDB1              ;;;	ldy	#$0000	;Access the free header
2924 FDB1              ;;;	lda	[seg],y	;Point at the target block
2925 FDB1              ;;;	pha		;This is our new free list successor
2926 FDB1              ;;;	txa		;Get back index to target block
2927 FDB1              ;;;	sta	[seg],y	;Make this the first item in free list
2928 FDB1
2929 FDB1              ;;;	ldy	#$0000	;Access the free header
2930 FDB1 A7 F0                 lda   [seg]                    ;Point at the target block
2931 FDB3 48                    pha                            ;This is our new free list successor
2932 FDB4 8A                    txa                            ;Get back index to target block
2933 FDB5 87 F0                 sta   [seg]                    ;Make this the first item in free list
2934 FDB7              *** end 15-Dec-92
2935 FDB7
2936 FDB7              ; Alter our forward and backward link
2937 FDB7
2938 FDB7 9B                    txy   
2939 FDB8 C8                    iny   
2940 FDB9 C8                    iny                            ;Pointing at target's forward link
2941 FDBA 68                    pla                            ;Make old first free our successor
2942 FDBB 48                    pha                            ;Save our successor's index
2943 FDBC 97 F0                 sta   [seg],y
2944 FDBE C8                    iny   
2945 FDBF C8                    iny                            ;Move to the back link
2946 FDC0 A9 FE FF              lda   #head_valu               ;Use the head link kludge value
2947 FDC3 97 F0                 sta   [seg],y                  ;Set our backward link
2948 FDC5
2949 FDC5              ; Pull our successor and alter his backward link to point to us.  Note
2950 FDC5              ;  that if the free list was null on entry to this routine there was no succ.
2951 FDC5
2952 FDC5 7A                    ply   
2953 FDC6 F0 07                 beq   i_hate_it                ;... there WAS no successor!
2954 FDC8 C8                    iny   
2955 FDC9 C8                    iny   
2956 FDCA C8                    iny   
2957 FDCB C8                    iny   
2958 FDCC 8A                    txa   
2959 FDCD 97 F0                 sta   [seg],y                  ;Did it!
2960 FDCF
2961 FDCF              i_hate_it  
2962 FDCF 9B                    txy                            ;Restore Y
2963 FDD0 18                    clc   
2964 FDD1              free_error  
2965 FDD1 60                    rts   
2966 FDD2
2967 FDD2                       end_proc 
2968 FDD2                       eject 
2969 FDD2              ;======================================================================
2970 FDD2              ; merge_free : Merges a free block with free space immediately below it
2971 FDD2              ;
2972 FDD2              ; Created:       April  9, 1987
2973 FDD2              ; Modified:      April 29, 1987
2974 FDD2              ; Author:        Mike Askins
2975 FDD2              ;
2976 FDD2              ; Copyright Apple Computer Inc. 1987  All rights reserved
2977 FDD2              ;
2978 FDD2              ; Input:         A = <undefined>
2979 FDD2              ;                X = Free area2 (offset)
2980 FDD2              ;                Y = Free area1 (offset)  (Y < X)
2981 FDD2              ;                P = nvmxdizc
2982 FDD2              ;                    ..000...
2983 FDD2              ;              seg = Pointer to segment containing areas 
2984 FDD2              ;
2985 FDD2              ; Output:        A = trashed
2986 FDD2              ;                X = trashed
2987 FDD2              ;                Y = preserved
2988 FDD2              ;                P = nvmxdizc
2989 FDD2              ;                    ..000...
2990 FDD2              ;                b = preserved
2991 FDD2              ;
2992 FDD2              ;======================================================================
2993 FDD2
2994 FDD2              merge_free proc 
2995 FDD2
2996 FDD2              ; Dig out the size of the first area
2997 FDD2
2998 FDD2 5A                    phy   
2999 FDD3 B7 F0                 lda   [seg],y                  ;Got size of first area
3000 FDD5 9B                    txy   
3001 FDD6
3002 FDD6              ; Pull the 2nd free area out of the free list
3003 FDD6
3004 FDD6 48                    pha   
3005 FDD7 20 CB FC              jsr   unfree                   ;Unlink this block from free list
3006 FDDA 68                    pla   
3007 FDDB
3008 FDDB              ; Combine the sizes of the two areas to be combined
3009 FDDB
3010 FDDB 18                    clc   
3011 FDDC 77 F0                 adc   [seg],y                  ;Have combined the sizes
3012 FDDE              ;;;	and	#$7FFF	;Nullify any effect of tags
3013 FDDE              *** optimized 17-Jul-92 DAL
3014 FDDE 0A                    asl   a
3015 FDDF 4A                    lsr   a
3016 FDE0              *** end 17-Jul-92
3017 FDE0
3018 FDE0              ; Now store the new size in the leading size field
3019 FDE0
3020 FDE0 7A                    ply   
3021 FDE1 5A                    phy   
3022 FDE2 97 F0                 sta   [seg],y
3023 FDE4 AA                    tax                            ;Momemtito...
3024 FDE5
3025 FDE5              ; And finally store the new size in the trailing field
3026 FDE5
3027 FDE5 18                    clc   
3028 FDE6 63 01                 adc   1,s
3029 FDE8 3A                    dec   a
3030 FDE9 3A                    dec   a
3031 FDEA A8                    tay                            ;Got pointer to trailing size field
3032 FDEB 8A                    txa                            ;Got the new size back
3033 FDEC 97 F0                 sta   [seg],y
3034 FDEE
3035 FDEE 7A                    ply   
3036 FDEF 60                    rts   
3037 FDF0
3038 FDF0                       end_proc 
3039 FDF0                       eject 
3040 FDF0              ;======================================================================
3041 FDF0              ; gderef : Returns a physical 24 bit address corresponding to a
3042 FDF0              ;              32 bit virtual pointer.
3043 FDF0              ;
3044 FDF0              ; (Note: gderef yields a pointer to the beginning of the block overhead,
3045 FDF0              ;        whereas deref2 gives a pointer to the start of the content area.)
3046 FDF0              ;
3047 FDF0              ;              Timing: 24 microseconds typical
3048 FDF0              ;
3049 FDF0              ; Created:       APR  1, 1987 (no, really)
3050 FDF0              ; Modified:      May  7, 1987
3051 FDF0              ; Author:        Mike Askins
3052 FDF0              ;
3053 FDF0              ; Copyright Apple Computer Inc. 1987  All rights reserved
3054 FDF0              ;
3055 FDF0              ; Input:         A = <undefined>
3056 FDF0              ;                X = Virtual Pointer (low)
3057 FDF0              ;                Y = Virtual Pointer (high)
3058 FDF0              ;                P = nvmxdizc
3059 FDF0              ;                    ..000...
3060 FDF0              ;          seg_tab = Pointer to segment table 
3061 FDF0              ;
3062 FDF0              ; Output:        A = <undefined>
3063 FDF0              ;                X = Physical Address (low)
3064 FDF0              ;                Y = Physical Address (high)
3065 FDF0              ;                P = nvmxdizc
3066 FDF0              ;                    ..000...
3067 FDF0              ;                b = preserved
3068 FDF0              ;              ptr = handle of segment referenced
3069 FDF0              ;
3070 FDF0              ;======================================================================
3071 FDF0
3072 FDF0              gderef   proc 
3073 FDF0
3074 FDF0 B7 4C                 lda   [seg_tab],y              ;Pull the handle
3075 FDF2 85 E8                 sta   ptr                      ;Keep for dereferencing
3076 FDF4 C8                    iny   
3077 FDF5 C8                    iny   
3078 FDF6 B7 4C                 lda   [seg_tab],y
3079 FDF8 85 EA                 sta   ptr+2                    ;... and the low part
3080 FDFA
3081 FDFA              ; Deref and add the segment pointer to the offset
3082 FDFA
3083 FDFA 8A                    txa                            ;A now has the low part of VP
3084 FDFB 18                    clc   
3085 FDFC 67 E8                 adc   [ptr]                    ;Add offset into the base
3086 FDFE
3087 FDFE AA                    tax                            ;Got the low part of phys addr
3088 FDFF A0 02 00              ldy   #$0002                   ;Set up to access high part
3089 FE02 B7 E8                 lda   [ptr],y                  ;Get high part of phys addr
3090 FE04 90 01                 bcc   skip
3091 FE06 1A                    inc   a
3092 FE07
3093 FE07              skip      
3094 FE07 A8                    tay   
3095 FE08 6B                    rtl   
3096 FE09
3097 FE09                       end_proc 
3098 FE09
3099 FE09              deref2   proc 
3100 FE09
3101 FE09 B7 4C                 lda   [seg_tab],y              ;Pull the handle
3102 FE0B 85 E8                 sta   ptr                      ;Keep for dereferencing
3103 FE0D C8                    iny   
3104 FE0E C8                    iny   
3105 FE0F B7 4C                 lda   [seg_tab],y
3106 FE11 85 EA                 sta   ptr+2                    ;... and the low part
3107 FE13
3108 FE13              ; Deref and add the segment pointer to the offset
3109 FE13
3110 FE13 8A                    txa                            ;A now has the low part of VP
3111 FE14 18                    clc   
3112 FE15 69 0A 00              adc   #fwd_ovrhead             ;Cannot be a carry (32K+12)
3113 FE18 67 E8                 adc   [ptr]                    ;Add offset into the base
3114 FE1A
3115 FE1A AA                    tax                            ;Got the low part of phys addr
3116 FE1B A0 02 00              ldy   #$0002                   ;Set up to access high part
3117 FE1E B7 E8                 lda   [ptr],y                  ;Get high part of phys addr
3118 FE20 90 01                 bcc   skip
3119 FE22 1A                    inc   a
3120 FE23
3121 FE23              skip      
3122 FE23 A8                    tay   
3123 FE24 6B                    rtl   
3124 FE25
3125 FE25                       end_proc 
3126 FE25                       eject 
3127 FE25              ;======================================================================
3128 FE25              ; unlock_mem, lock_mem : Locks or unlocks all managed segments
3129 FE25              ;
3130 FE25              ;   Lock_mem always locks the segments.  It counts the number of times
3131 FE25              ;  that a call is made so that Unlock_mem will only unlock the segments
3132 FE25              ;  when an equal number of locks and unlocks are done.  This allows
3133 FE25              ;  nested lock/unlocks to work.
3134 FE25              ;
3135 FE25              ; Created:      July 15, 1987
3136 FE25              ; Modified:     April 6, 1990 CAF (see revision history)
3137 FE25              ; Author:       Mike Askins
3138 FE25              ;
3139 FE25              ; Copyright Apple Computer Inc. 1987  All rights reserved
3140 FE25              ;
3141 FE25              ; Input:        A = <undefined>
3142 FE25              ;               X = <undefined>
3143 FE25              ;               Y = <undefined>
3144 FE25              ;               P = nvmxdizc
3145 FE25              ;                   ..000...
3146 FE25              ;
3147 FE25              ; Output:       A = trashed
3148 FE25              ;               X = trashed
3149 FE25              ;               Y = trashed
3150 FE25              ;               P = nvmxdizc
3151 FE25              ;                   ..000..0 -> No error returnable
3152 FE25              ;               b = preserved
3153 FE25              ;
3154 FE25              ;======================================================================
3155 FE25
3156 FE25              unlockmem proc 
3157 FE25                       entry ul_mem
3158 FE25                       entry ul_mem2
3159 FE25                       entry lockmem
3160 FE25                       entry lock_flag
3161 FE25                       entry seg_tab_last
3162 FE25              *
3163 FE25              * If lock_flag is 0 or 1, unlock memory.  Otherwise just decrement counter
3164 FE25              * and exit...
3165 FE25              *
3166 FE25 18                    clc                            ;Select unlock.
3167 FE26 AF 7F FE 00           lda   >lock_flag               ;Unlock w/o Lock -> don't dec flag
3168 FE2A F0 13                 beq   ul_mem
3169 FE2C 3A                    dec   a
3170 FE2D 8F 7F FE 00           sta   >lock_flag
3171 FE31 D0 4A                 bne   exit                     ;Don't unlock if lock/unlocks unmatched
3172 FE33 80 06                 bra   ul_mem2                  ;Lock/Unlocks match -> do the unlock
3173 FE35              *
3174 FE35              * Increment flag and lock memory...
3175 FE35              *
3176 FE35 38           lockmem  sec                            ;Select lock.
3177 FE36 AF 7F FE 00           lda   >lock_flag
3178 FE3A 1A                    inc   a
3179 FE3B              ;;;	beq	ul_mem	;Restrain flag at $FFFF (never happens anyway, 15-Dec-92 DAL, save 2 bytes)
3180 FE3B
3181 FE3B 8F 7F FE 00  ul_mem2  sta   >lock_flag               ;Save flag.
3182 FE3F              *
3183 FE3F              * First save the direct page variable we will use...
3184 FE3F              *
3185 FE3F D4 FE        ul_mem   pei   <hand+2                  ;Must preserve this zp across call
3186 FE41 D4 FC                 pei   <hand
3187 FE43              *
3188 FE43              * Now set our lock/unlock mask (self-modified!) based on the carry flag and
3189 FE43              * set the loop limit (self-modified!) to seg_tab_last...
3190 FE43              *
3191 FE43 A9 00 00              lda   #0000                    ;Clear all bits.
3192 FE46 6A                    ror   a                        ;Rotate the carry into msb.
3193 FE47 8F 6B FE 00           sta   >self_mod_flag+1         ;Do the self-mod.
3194 FE4B
3195 FE4B AF 81 FE 00           lda   >seg_tab_last            ;Get loop limit.
3196 FE4F 8F 73 FE 00           sta   >self_mod_last+1         ;Do the self_mod.
3197 FE53
3198 FE53 A0 04 00              ldy   #4                       ;Initialize offset.
3199 FE56              *
3200 FE56              * Copy the handle into our direct page variable;  if the high bit is set,
3201 FE56              * we'll skip it...
3202 FE56              *
3203 FE56 B7 4C        loop     lda   [seg_tab],y
3204 FE58 85 FC                 sta   hand
3205 FE5A C8                    iny   
3206 FE5B C8                    iny   
3207 FE5C B7 4C                 lda   [seg_tab],y              ;Get high word. Active?
3208 FE5E 30 10                 bmi   next                     ;Nope, so skip it.
3209 FE60 85 FE                 sta   hand+2                   ;Yes, save high part of handle.
3210 FE62              *
3211 FE62              * Now lock or unlock the handle...
3212 FE62              *
3213 FE62 BB                    tyx                            ;Save our offset.
3214 FE63
3215 FE63 A0 04 00              ldy   #$0004                   ;Clear the lock bit.
3216 FE66 B7 FC                 lda   [hand],y
3217 FE68              *** opt 15-Dec-92 DAL (saved 1 byte)
3218 FE68              ;;;	and	#$7FFF
3219 FE68 0A                    asl   a
3220 FE69 4A                    lsr   a
3221 FE6A              *** end 15-Dec-92
3222 FE6A 09 00 00     self_mod_flag ora   #$8000              ;(SELF-MODIFIED!!)
3223 FE6D 97 FC        save_it  sta   [hand],y                 ;Save it.
3224 FE6F
3225 FE6F 9B                    txy                            ;Recover the offset.
3226 FE70              *
3227 FE70              * Bump offset to the next handle and loop if haven't done all...
3228 FE70              *
3229 FE70 C8           next     iny   
3230 FE71 C8                    iny   
3231 FE72 C0 1C 00     self_mod_last cpy   #0008               ;(SELF-MODIFIED!!)
3232 FE75 D0 DF                 bne   loop                     ;Loop if not done.
3233 FE77              *
3234 FE77              * Ok, we've done all handles, now restore our direct page location and exit...
3235 FE77              *
3236 FE77 68                    pla                            ;Restore hand zp location.
3237 FE78 85 FC                 sta   <hand
3238 FE7A 68                    pla   
3239 FE7B 85 FE                 sta   <hand+2
3240 FE7D 18           exit     clc                            ;We just can't get an error.
3241 FE7E 6B                    rtl   
3242 FE7F
3243 FE7F                       entry lock_flag
3244 FE7F 00 00        lock_flag DC W:0                        ;Lock/Unlock counter.
3245 FE81 1C 00        seg_tab_last DC W:0                     ;Last used position in seg_tab.
3246 FE83
3247 FE83                       end_proc 
3248 FE83                       eject 
3249 FE83              ****************************************************************************
3250 FE83              *                                                                          *
3251 FE83              *                 **********   D Y N A L I S T   ***********               *
3252 FE83              *                                                                          *
3253 FE83              *                      Dynamic List Management Routines                    *
3254 FE83              *                                                                          *
3255 FE83              *    All growable lists handled by the Global information manager are      *
3256 FE83              *  maintained as dynamic lists.  A dynamic list has the following format:  *
3257 FE83              *                                                                          *
3258 FE83              *  list base -> -----------------------------------------------            *
3259 FE83              *               |          total list length (bytes)          |  (word)    *
3260 FE83              *               -----------------------------------------------            *
3261 FE83              * free header-> |    first free element (offset from base)    |  (word)    *
3262 FE83              *               -----------------------------------------------            *
3263 FE83              *               |           1st list element (low)            |  (long)    *
3264 FE83              *               -                                             -            *
3265 FE83              *               |           1st list element (high)           |            *
3266 FE83              *               -----------------------------------------------            *
3267 FE83              *               |           2nd list element (low)            |  (long)    *
3268 FE83              *               -                                             -            *
3269 FE83              *               |           2nd list element (high)           |            *
3270 FE83              *               -----------------------------------------------            *
3271 FE83              *               |        (additional list elements) ...       |            *
3272 FE83              *                                                                          *
3273 FE83              *  When all existing elements are in use, the free header will be zero.  A *
3274 FE83              *  free element has the msb set; if the msb is clear then the element is   *
3275 FE83              *  in use.  A free element has in the low word the offset of the next free *
3276 FE83              *  element in the list; all free elements are linked into a list, the head *
3277 FE83              *  of which is pointed to by the free header.                              *
3278 FE83              *                                                                          *
3279 FE83              *    The segment table is an example of a dynalist and the elements        *
3280 FE83              *  of the list in this case are memory manager handles (3 byte).  The ID   *
3281 FE83              *  tables are another example; elements in these lists are VPs.            *
3282 FE83              *                                                                          *
3283 FE83              ****************************************************************************
3284 FE83                       eject 
3285 FE83              ;=====================================================================
3286 FE83              ; reserve_id : Pull the next available ID from the ID list
3287 FE83              ;
3288 FE83              ; Created:      May 20, 1987
3289 FE83              ; Modified:     November 25, 1987
3290 FE83              ; Author:       Mike Askins
3291 FE83              ;
3292 FE83              ; Copyright Apple Computer Inc. 1987  All rights reserved
3293 FE83              ;
3294 FE83              ; Input:        A = <undefined>
3295 FE83              ;               X = ID table handle (low)
3296 FE83              ;               Y = ID table handle (high)
3297 FE83              ;               P = nvmxdizc
3298 FE83              ;                   ..000...
3299 FE83              ;              vp = value to place into the list
3300 FE83              ;
3301 FE83              ; Output:       A = ID (range $20 - $FFFF)
3302 FE83              ;               X = trashed
3303 FE83              ;               Y = Element Offset
3304 FE83              ;               P = nvmxdizc
3305 FE83              ;                   ..000..E -> 'ID could not be allocated'
3306 FE83              ;               b = preserved
3307 FE83              ;          m_temp = trashed
3308 FE83              ;             ptr = trashed
3309 FE83              ;
3310 FE83              ;======================================================================
3311 FE83
3312 FE83              reserve_id proc 
3313 FE83
3314 FE83 20 92 FF              jsr   set_tab_ptr              ;Set up hand and ptr for this list
3315 FE86 A6 F4                 ldx   vp                       ;Pick up the value to install
3316 FE88 A4 F6                 ldy   vp+2
3317 FE8A 20 9D FE              jsr   add_element              ;Do the add
3318 FE8D B0 03                 bcs   no_mem
3319 FE8F 98                    tya                            ;Divide the index by 4
3320 FE90 4A                    lsr   a
3321 FE91 4A                    lsr   a                        ; ...and you have the ID value
3322 FE92              ;;;	clc		;the DynaList picture says the indexes are multiples of 4, so nuke this (15-Dec-92 DAL)
3323 FE92              no_mem    
3324 FE92 60                    rts   
3325 FE93
3326 FE93                       end_proc 
3327 FE93                       eject 
3328 FE93              ;======================================================================
3329 FE93              ; free_id : Free an allocated ID in a given ID list
3330 FE93              ;
3331 FE93              ; Created:      May 20, 1987
3332 FE93              ; Modified:     May 21, 1987
3333 FE93              ; Author:       Mike Askins
3334 FE93              ;
3335 FE93              ; Copyright Apple Computer Inc. 1987  All rights reserved
3336 FE93              ;
3337 FE93              ; Input:        A = ID to remove
3338 FE93              ;               X = ID table handle (low)
3339 FE93              ;               Y = ID table handle (high)
3340 FE93              ;               P = nvmxdizc
3341 FE93              ;                   ..000...
3342 FE93              ;
3343 FE93              ; Output:       A = trashed
3344 FE93              ;               X = Value of item removed (low)
3345 FE93              ;               Y = Value of item removed (high)
3346 FE93              ;               P = nvmxdizc
3347 FE93              ;                   ..000..E -> 'ID was not released'
3348 FE93              ;               b = preserved
3349 FE93              ;          m_temp = trashed
3350 FE93              ;             seg = trashed
3351 FE93              ;
3352 FE93              ;======================================================================
3353 FE93
3354 FE93              free_id  proc 
3355 FE93
3356 FE93 48                    pha   
3357 FE94 20 92 FF              jsr   set_tab_ptr
3358 FE97 68                    pla   
3359 FE98 0A                    asl   a
3360 FE99 0A                    asl   a
3361 FE9A A8                    tay   
3362 FE9B              ;;;	jsr	kill_element
3363 FE9B              ;;;	rts
3364 FE9B              *** optimized 17-Jul-92 DAL
3365 FE9B 80 38                 bra   kill_element             ;optimized from jmp to bra, 15-Dec-92 DAL
3366 FE9D              *** end 17-Jul-92
3367 FE9D
3368 FE9D                       end_proc 
3369 FE9D                       eject 
3370 FE9D              ;======================================================================
3371 FE9D              ; add_element : Add an element to a dynalist; may grow the list
3372 FE9D              ;
3373 FE9D              ; Created:      June  9, 1987
3374 FE9D              ; Modified:     April 5, 1988
3375 FE9D              ; Author:       Mike Askins
3376 FE9D              ;
3377 FE9D              ; Copyright Apple Computer Inc. 1987  All rights reserved
3378 FE9D              ;
3379 FE9D              ; Input:        A = <undefined>
3380 FE9D              ;               X = new element contents (low)
3381 FE9D              ;               Y = new element contents (high)
3382 FE9D              ;               P = nvmxdizc
3383 FE9D              ;                   ..000...
3384 FE9D              ;             ptr = pointer to list
3385 FE9D              ;            hand = handle for list
3386 FE9D              ;
3387 FE9D              ; Output:       A = trashed or error code
3388 FE9D              ;               X = trashed
3389 FE9D              ;               Y = Offset into list of new element
3390 FE9D              ;               P = nvmxdizc
3391 FE9D              ;                   ..000..E -> 'Could not allocate element'
3392 FE9D              ;               b = preserved
3393 FE9D              ;             ptr = maybe changed if list was grown
3394 FE9D              ;
3395 FE9D              ;======================================================================
3396 FE9D
3397 FE9D              add_element proc 
3398 FE9D
3399 FE9D 18                    clc   
3400 FE9E 5A                    phy                            ;Push contents high
3401 FE9F DA                    phx                            ;Push contents low
3402 FEA0
3403 FEA0              again     
3404 FEA0 A0 02 00              ldy   #$0002                   ;Check if there's already room
3405 FEA3 B7 E8                 lda   [ptr],y                  ;Get location of first free 'slot'
3406 FEA5 D0 11                 bne   gotroom
3407 FEA7
3408 FEA7              ; Check to see if the list is 64K.  If so, we're out of ref's.
3409 FEA7
3410 FEA7 A7 E8                 lda   [ptr]
3411 FEA9 C9 F8 FF              cmp   #$0-list_grow_inc
3412 FEAC B0 21                 bge   nomem_error
3413 FEAE
3414 FEAE A9 08 00              lda   #list_grow_inc
3415 FEB1 20 F8 FE              jsr   grow_list                ;Grow the list to make room
3416 FEB4 B0 19                 bcs   nomem_error
3417 FEB6 80 E8                 bra   again
3418 FEB8
3419 FEB8              gotroom   
3420 FEB8 FA                    plx                            ;Get new elt contents (low)
3421 FEB9 A8                    tay   
3422 FEBA B7 E8                 lda   [ptr],y                  ;Get the old free list link
3423 FEBC 48                    pha   
3424 FEBD 8A                    txa                            ;A = new elt contents (low)
3425 FEBE FA                    plx                            ;X = Old free list link 
3426 FEBF 97 E8                 sta   [ptr],y
3427 FEC1 68                    pla                            ;A = Get back new elt contents (high)
3428 FEC2 5A                    phy                            ;Save offset to return later
3429 FEC3 C8                    iny   
3430 FEC4 C8                    iny   
3431 FEC5 97 E8                 sta   [ptr],y                  ;Update the high part of the element
3432 FEC7
3433 FEC7 A0 02 00              ldy   #$0002
3434 FECA 8A                    txa   
3435 FECB 97 E8                 sta   [ptr],y                  ;Update the free list header
3436 FECD
3437 FECD 7A                    ply                            ;Return offset into list 
3438 FECE 60                    rts                            ;Carry WAS still clear...
3439 FECF
3440 FECF              nomem_error  
3441 FECF A9 54 00              lda   #out_of_mem              ;No more space
3442 FED2 7A                    ply   
3443 FED3 7A                    ply                            ;Fix the stack
3444 FED4 60                    rts   
3445 FED5
3446 FED5                       end_proc 
3447 FED5                       eject 
3448 FED5              ;======================================================================
3449 FED5              ; kill_element : Deallocate an element in the list
3450 FED5              ;
3451 FED5              ; Created:      April  9, 1987
3452 FED5              ; Modified:     April  9, 1987
3453 FED5              ; Author:       Mike Askins
3454 FED5              ;
3455 FED5              ; Copyright Apple Computer Inc. 1987  All rights reserved
3456 FED5              ;
3457 FED5              ; Input:        A = <undefined>
3458 FED5              ;               X = <undefined>
3459 FED5              ;               Y = Offset of element to kill
3460 FED5              ;               P = nvmxdizc
3461 FED5              ;                   ..000...
3462 FED5              ;             ptr = pointer to list
3463 FED5              ;
3464 FED5              ; Output:       A = trashed
3465 FED5              ;               X = Value of item removed (low)
3466 FED5              ;               Y = Value of item removed (high)
3467 FED5              ;               P = nvmxdizc
3468 FED5              ;                   ..000..E -> 'Element doesn't exist'
3469 FED5              ;               b = preserved
3470 FED5              ;
3471 FED5              ;======================================================================
3472 FED5
3473 FED5
3474 FED5              kill_element proc 
3475 FED5
3476 FED5 38                    sec   
3477 FED6 BB                    tyx                            ;Check for zero offset (illegal)
3478 FED7 F0 1E                 beq   error
3479 FED9
3480 FED9 C8                    iny                            ;Move to high order part of elt
3481 FEDA C8                    iny   
3482 FEDB
3483 FEDB B7 E8                 lda   [ptr],y
3484 FEDD 30 18                 bmi   error                    ;Tried to kill non-exist element
3485 FEDF
3486 FEDF 48                    pha                            ;Save to return to caller
3487 FEE0 A9 00 80              lda   #list_alc_flag           ;Mark new guy as taken
3488 FEE3 97 E8                 sta   [ptr],y
3489 FEE5
3490 FEE5 A0 02 00              ldy   #list_freehead           ;Locate at free list header
3491 FEE8 B7 E8                 lda   [ptr],y                  ;Who's first in the free list
3492 FEEA 48                    pha                            ;Save him
3493 FEEB 8A                    txa                            ;Get back offset of guy to kill
3494 FEEC 97 E8                 sta   [ptr],y                  ;First free guy is now newly freed one
3495 FEEE 9B                    txy                            ;Now point new guy to old free head
3496 FEEF B7 E8                 lda   [ptr],y                  ;Get what was already there
3497 FEF1 AA                    tax   
3498 FEF2 68                    pla   
3499 FEF3 97 E8                 sta   [ptr],y
3500 FEF5
3501 FEF5 7A                    ply   
3502 FEF6 18                    clc   
3503 FEF7
3504 FEF7              error     
3505 FEF7 60                    rts   
3506 FEF8
3507 FEF8                       end_proc 
3508 FEF8                       eject 
3509 FEF8              ;======================================================================
3510 FEF8              ; grow_list : Grow a list by a specified number of bytes
3511 FEF8              ;
3512 FEF8              ; Created:      April  9, 1987
3513 FEF8              ; Modified:     June  9, 1987
3514 FEF8              ; Author:       Mike Askins
3515 FEF8              ;
3516 FEF8              ; Copyright Apple Computer Inc. 1987  All rights reserved
3517 FEF8              ;
3518 FEF8              ; Input:        A = Number of bytes to grow by
3519 FEF8              ;               X = <undefined>
3520 FEF8              ;               Y = <undefined>
3521 FEF8              ;               P = nvmxdizc
3522 FEF8              ;                   ..000...
3523 FEF8              ;             ptr = pointer to list
3524 FEF8              ;            hand = handle of list
3525 FEF8              ;
3526 FEF8              ; Output:       A = trashed
3527 FEF8              ;               X = trashed
3528 FEF8              ;               Y = trashed
3529 FEF8              ;               P = nvmxdizc
3530 FEF8              ;                   ..000..E -> 'List could not be grown'
3531 FEF8              ;               b = preserved
3532 FEF8              ;             ptr = changed if grow caused a move of the list
3533 FEF8              ;
3534 FEF8              ;======================================================================
3535 FEF8
3536 FEF8              grow_list proc 
3537 FEF8
3538 FEF8              ; The list handle should be re-dereferenced after running grow since
3539 FEF8              ;  the location of the list may have changed.
3540 FEF8
3541 FEF8 48                    pha                            ;Save the requested grow
3542 FEF9
3543 FEF9 F4 00 00              pea   $0000                    ;Push the high word of New size
3544 FEFC 18                    clc   
3545 FEFD 67 E8                 adc   [ptr]                    ;Got the new handle size
3546 FEFF 48                    pha                            ;Low part of size request
3547 FF00              *** optimized 15-Dec-92 DAL -- saved 2 bytes
3548 FF00              ;;;	ldy	hand+2
3549 FF00              ;;;	phy		;Push the handle back
3550 FF00              ;;;	ldx	hand
3551 FF00              ;;;	phx
3552 FF00 D4 FE                 pei   <hand+2
3553 FF02 D4 FC                 pei   <hand
3554 FF04              *** end 15-Dec-92
3555 FF04
3556 FF04 A2 02 19 22           _SetHandleSize 
3557 FF0B
3558 FF0B              ; It is possible that the list was moved by the MM.  Therefore it is important
3559 FF0B              ;  to dereference the handle again in case this is in fact what happened.
3560 FF0B
3561 FF0B 08                    php   
3562 FF0C A6 FC                 ldx   hand
3563 FF0E A4 FE                 ldy   hand+2
3564 FF10 20 96 FF              jsr   stp2                     ;Re-dereference the handle
3565 FF13 28                    plp   
3566 FF14
3567 FF14 FA                    plx                            ;Get back the requested grow
3568 FF15 B0 3C                 bcs   mem_err                  ;Branch if the grow failed
3569 FF17
3570 FF17              ; Now the segment is the new size.  Need to link the new entries into the
3571 FF17              ;   free list.  Start by setting up an index that points to the first of
3572 FF17              ;   elements that we're adding. 
3573 FF17
3574 FF17 A7 E8                 lda   [ptr]
3575 FF19 A8                    tay   
3576 FF1A DA                    phx                            ;... and save for later
3577 FF1B 48                    pha                            ;Keep first element we added
3578 FF1C 80 0D                 bra   loop2                    ;In case delta was 1 
3579 FF1E
3580 FF1E              ; Now loop to initialize each entry except for the last
3581 FF1E
3582 FF1E              loop      
3583 FF1E 97 E8                 sta   [ptr],y
3584 FF20 C8                    iny   
3585 FF21 C8                    iny   
3586 FF22
3587 FF22 48                    pha   
3588 FF23 A9 00 80              lda   #list_alc_flag           ;(probly $8000)
3589 FF26 97 E8                 sta   [ptr],y                  ;Mark segment as unallocated
3590 FF28 68                    pla   
3591 FF29 C8                    iny   
3592 FF2A C8                    iny   
3593 FF2B
3594 FF2B              loop2     
3595 FF2B 18                    clc   
3596 FF2C 69 04 00              adc   #$0004                   ;Each element is four bytes
3597 FF2F CA                    dex   
3598 FF30 CA                    dex   
3599 FF31 CA                    dex   
3600 FF32 CA                    dex   
3601 FF33 D0 E9                 bne   loop
3602 FF35
3603 FF35              ; Y is now positioned at the last new element
3604 FF35
3605 FF35 BB                    tyx   
3606 FF36 A0 02 00              ldy   #$0002
3607 FF39 B7 E8                 lda   [ptr],y                  ;Got the old free list header
3608 FF3B 48                    pha   
3609 FF3C A3 03                 lda   3,s                      ;Pull back the first new elt
3610 FF3E 97 E8                 sta   [ptr],y
3611 FF40 9B                    txy   
3612 FF41 68                    pla                            ;Get back old free list header
3613 FF42 97 E8                 sta   [ptr],y                  ;Store that in the last new element
3614 FF44
3615 FF44 C8                    iny   
3616 FF45 C8                    iny   
3617 FF46 A9 00 80              lda   #list_alc_flag           ;Mark the last guy as available
3618 FF49 97 E8                 sta   [ptr],y
3619 FF4B
3620 FF4B              ; Finally sum the old # elements with the new added and update the #elts field
3621 FF4B
3622 FF4B 68                    pla                            ;Pull off garbage
3623 FF4C 68                    pla                            ;Pull off requested grow
3624 FF4D 18                    clc   
3625 FF4E 67 E8                 adc   [ptr]                    ;Add the original value
3626 FF50 87 E8                 sta   [ptr]
3627 FF52 18                    clc                            ;Probably unnecessary...
3628 FF53
3629 FF53              mem_err   
3630 FF53 60                    rts   
3631 FF54
3632 FF54                       end_proc 
3633 FF54                       eject 
3634 FF54              ;======================================================================
3635 FF54              ; init_list : Generate a new list
3636 FF54              ;
3637 FF54              ; Created:      June  9, 1987
3638 FF54              ; Modified:     June  9, 1987
3639 FF54              ; Author:       Mike Askins
3640 FF54              ;
3641 FF54              ; Copyright Apple Computer Inc. 1987  All rights reserved
3642 FF54              ;
3643 FF54              ; Input:        A = <undefined>
3644 FF54              ;               X = <undefined>
3645 FF54              ;               Y = <undefined>
3646 FF54              ;               P = nvmxdizc
3647 FF54              ;                   ..000..0 = normal list
3648 FF54              ;                          1 = fixed, larger list (for seg_tab_hand)
3649 FF54              ;
3650 FF54              ; Output:       A = trashed
3651 FF54              ;               X = handle of new list
3652 FF54              ;               Y = handle of new list
3653 FF54              ;               P = nvmxdizc
3654 FF54              ;                   ..000..E -> 'could not get memory for the list'
3655 FF54              ;               b = preserved
3656 FF54              ;             ptr = pointer to new list
3657 FF54              ;            hand = handle of new list
3658 FF54              ;
3659 FF54              ;======================================================================
3660 FF54
3661 FF54              init_list proc 
3662 FF54
3663 FF54                       entry init_spcl_list
3664 FF54                       entry vcr_id_hand
3665 FF54                       entry fcr_id_hand
3666 FF54                       entry icr_id_hand
3667 FF54                       entry seg_tab_hand
3668 FF54
3669 FF54 18                    clc                            ;Select normal entry.
3670 FF55
3671 FF55 08           init_spcl_list php                      ;Save carry state.
3672 FF56
3673 FF56 A9 04 00              lda   #list_stump
3674 FF59 20 A0 FF              jsr   grab_mm_seg
3675 FF5C B0 21                 bcs   oops
3676 FF5E
3677 FF5E 20 92 FF              jsr   set_tab_ptr
3678 FF61
3679 FF61 A9 04 00              lda   #list_stump
3680 FF64 87 E8                 sta   [ptr]                    ;Store the length of the 'virgin' list
3681 FF66 A0 02 00              ldy   #list_freehead           ;Position at the free list header
3682 FF69 A9 00 00              lda   #$0000
3683 FF6C 97 E8                 sta   [ptr],y                  ;... and null it out
3684 FF6E
3685 FF6E A9 10 00              lda   #list_min_size*4         ;Grow the stump to a usable size
3686 FF71 28                    plp                            ;Do we want a larger one?
3687 FF72 90 03                 bcc   grow_it                  ;Nope.
3688 FF74 A9 00 01              lda   #list_min_size*4*16      ;Yes, so make it larger
3689 FF77 20 F8 FE     grow_it  jsr   grow_list                ;Sets carry per any error
3690 FF7A A6 FC                 ldx   hand                     ;Return the handle of the new list
3691 FF7C A4 FE                 ldy   hand+2
3692 FF7E 60                    rts   
3693 FF7F
3694 FF7F 28           oops     plp                            ;Balance stack.
3695 FF80 38                    sec                            ;Indicate error.
3696 FF81 60                    rts   
3697 FF82
3698 FF82 68 18 E1 00  seg_tab_hand DS B:4
3699 FF86 08 19 E1 00  vcr_id_hand DS B:4
3700 FF8A 58 19 E1 00  fcr_id_hand DS B:4
3701 FF8E A8 19 E1 00  icr_id_hand DS B:4
3702 FF92
3703 FF92                       end_proc 
3704 FF92
3705 FF92
3706 FF92              set_tab_ptr proc 
3707 FF92                       entry stp2
3708 FF92
3709 FF92 86 FC                 stx   hand
3710 FF94 84 FE                 sty   hand+2
3711 FF96
3712 FF96              stp2      
3713 FF96 20 79 FC              jsr   mm_deref                 ;Dereference the handle
3714 FF99 86 E8                 stx   ptr
3715 FF9B 84 EA                 sty   ptr+2
3716 FF9D 60                    rts   
3717 FF9E
3718 FF9E                       end_proc 
3719 FF9E                       eject 
3720 FF9E              ;======================================================================
3721 FF9E              ; grab_mm_seg : Gets a new memory manager segment of a particular size
3722 FF9E              ;                Returns a handle to the segment.
3723 FF9E              ;
3724 FF9E              ; Created:      April 14, 1987
3725 FF9E              ; Modified:     April 19, 1989
3726 FF9E              ; Author:       Mike Askins
3727 FF9E              ;
3728 FF9E              ; Copyright Apple Computer Inc. 1987  All rights reserved
3729 FF9E              ;
3730 FF9E              ; Input:        A = Segment Size Requested
3731 FF9E              ;               X = <reserved>
3732 FF9E              ;               Y = <reserved>
3733 FF9E              ;               P = nvmxdizc
3734 FF9E              ;                   ..000...
3735 FF9E              ;         gsos_id = Our MM ID word
3736 FF9E              ;
3737 FF9E              ; Output:       A = trashed
3738 FF9E              ;               X = New segment (handle low)
3739 FF9E              ;               Y = New segment (handle high)
3740 FF9E              ;               P = nvmxdizc
3741 FF9E              ;                   ..000..E
3742 FF9E              ;               b = preserved
3743 FF9E              ;
3744 FF9E              ;======================================================================
3745 FF9E
3746 FF9E              grab_fixed_seg proc 
3747 FF9E                       entry grab_mm_seg
3748 FF9E
3749 FF9E 38                    sec                            ;Select fixed attributes.
3750 FF9F              ;;;	bra	get_memory	;Go do it.
3751 FF9F 90                    DC B:$90                       ;opcode for BCC, never taken (save 1 byte, 15-Dec-92 DAL)
3752 FFA0
3753 FFA0 18           grab_mm_seg clc                         ;Select normal attributes.
3754 FFA1
3755 FFA1 A2 00 00     get_memory ldx   #0
3756 FFA4 DA                    phx                            ;Push space for long result
3757 FFA5 DA                    phx   
3758 FFA6
3759 FFA6 DA                    phx                            ;Hi part of size request
3760 FFA7 48                    pha                            ;Push size request low
3761 FFA8
3762 FFA8 AF E2 B9 00           lda   >gsos_id                 ;Get our ID and shove it
3763 FFAC 48                    pha   
3764 FFAD
3765 FFAD              ;Have segments page aligned for testing purposes
3766 FFAD
3767 FFAD A0 08 00     normal_att ldy   #mm_normal_attr        ;Attributes: no spcl mem.
3768 FFB0 90 03                 bcc   continue                 ;We're doing a normal allocate.
3769 FFB2 A0 08 40              ldy   #mm_fixed_attr           ;Attributes: fixed, no spcl mem.
3770 FFB5              continue  
3771 FFB5 AF 7F FE 00           lda   >lock_flag               ;is the rest of memory already locked?
3772 FFB9 F0 05                 beq   @not_locked              ;no, so just allocate the new block as unlocked
3773 FFBB 98                    tya                            ;else set the locked bit
3774 FFBC 09 00 80              ora   #$8000
3775 FFBF A8                    tay   
3776 FFC0              @not_locked  
3777 FFC0 5A                    phy                            ;put the attributes on the stack
3778 FFC1 DA                    phx                            ;Location info
3779 FFC2 DA                    phx                            ; top part
3780 FFC3
3781 FFC3 A2 02 09 22           _NewHandle                     ;Call memory manager to get memory
3782 FFCA FA                    plx                            ;Pull low part
3783 FFCB 7A                    ply                            ;Pull hi part
3784 FFCC
3785 FFCC 60                    rts   
3786 FFCD
3787 FFCD                       end_proc 
3788 FFCD                       eject 
3789 FFCD              ;======================================================================
3790 FFCD              ; free_mm_seg : Free a memory manager segment
3791 FFCD              ;
3792 FFCD              ; Created:      May  7, 1987
3793 FFCD              ; Modified:     May  7, 1987
3794 FFCD              ; Author:       Mike Askins
3795 FFCD              ;
3796 FFCD              ; Copyright Apple Computer Inc. 1987  All rights reserved
3797 FFCD              ;
3798 FFCD              ; Input:        A = undefined
3799 FFCD              ;               X = Handle (low)
3800 FFCD              ;               Y = Handle (high)
3801 FFCD              ;               P = nvmxdizc
3802 FFCD              ;                   ..000...
3803 FFCD              ;
3804 FFCD              ; Output:       A = trashed
3805 FFCD              ;               X = trashed
3806 FFCD              ;               Y = trashed
3807 FFCD              ;               P = nvmxdizc
3808 FFCD              ;                   ..000..E  1 -> 'Could Not Dispose of the Segment'
3809 FFCD              ;               b = preserved
3810 FFCD              ;
3811 FFCD              ;======================================================================
3812 FFCD
3813 FFCD              free_mm_seg proc 
3814 FFCD
3815 FFCD 5A                    phy   
3816 FFCE DA                    phx   
3817 FFCF
3818 FFCF A2 02 10 22           _DisposeHandle 
3819 FFD6
3820 FFD6 60                    rts   
3821 FFD7
3822 FFD7                       end_proc 
3823 FFD7                       eject 
3824 FFD7              ;======================================================================
3825 FFD7              ; unlock_hand, lock_hand, ul_hand : Lock or unlock handles
3826 FFD7              ;
3827 FFD7              ; Created:      July 15, 1987
3828 FFD7              ; Modified:     June 28, 1988
3829 FFD7              ; Author:       Mike Askins
3830 FFD7              ;
3831 FFD7              ; Copyright Apple Computer Inc. 1987  All rights reserved
3832 FFD7              ;
3833 FFD7              ; Input:        A = <undefined>
3834 FFD7              ;               X = handle (low)
3835 FFD7              ;               Y = handle (high)
3836 FFD7              ;               P = nvmxdizc
3837 FFD7              ;                   ..000..0 -> Unlock handle (ul_hand only!)
3838 FFD7              ;                          1 -> Lock handle (ul_hand only!)
3839 FFD7              ;
3840 FFD7              ; Output:       A = trashed
3841 FFD7              ;               X = preserved
3842 FFD7              ;               Y = preserved
3843 FFD7              ;               P = nvmxdizc
3844 FFD7              ;                   ..000...
3845 FFD7              ;               b = preserved
3846 FFD7              ;           Carry = preserved for ul_hand only
3847 FFD7              ;
3848 FFD7              ;======================================================================
3849 FFD7
3850 FFD7              unlock_hand proc 
3851 FFD7                       entry ul_hand
3852 FFD7                       entry lock_hand
3853 FFD7
3854 FFD7 18                    clc   
3855 FFD8              ;;;	bra	ul_hand
3856 FFD8 B0                    DC B:$b0                       ;opcode for BCS, never taken (save 1 byte, 15-Dec-92 DAL)
3857 FFD9
3858 FFD9              lock_hand  
3859 FFD9 38                    sec   
3860 FFDA
3861 FFDA              ul_hand   
3862 FFDA
3863 FFDA              ;;;	lda	<hand+2	;Must preserve this zp across call
3864 FFDA              ;;;	pha
3865 FFDA              ;;;	lda	<hand
3866 FFDA              ;;;	pha
3867 FFDA              *** optimized 17-Jul-92 DAL
3868 FFDA D4 FE                 pei   <hand+2                  ;Must preserve this zp across call
3869 FFDC D4 FC                 pei   <hand
3870 FFDE              *** end 17-Jul-92
3871 FFDE
3872 FFDE              ; Depending on the carry, set or clear the msb of the handle's attribute word.
3873 FFDE
3874 FFDE 86 FC                 stx   hand
3875 FFE0 84 FE                 sty   hand+2
3876 FFE2
3877 FFE2 5A                    phy   
3878 FFE3 A0 04 00              ldy   #$0004
3879 FFE6 B7 FC                 lda   [hand],y
3880 FFE8 29 FF 7F              and   #$7FFF                   ;Assume it's an unlock request
3881 FFEB 90 03                 bcc   skip
3882 FFED 49 00 80              eor   #$8000                   ;Thank you, Mr. Murphy
3883 FFF0              skip      
3884 FFF0 97 FC                 sta   [hand],y
3885 FFF2
3886 FFF2 7A                    ply                            ;Restore Y
3887 FFF3
3888 FFF3 68                    pla                            ;Restore hand zp location
3889 FFF4 85 FC                 sta   <hand
3890 FFF6 68                    pla   
3891 FFF7 85 FE                 sta   <hand+2
3892 FFF9 60                    rts   
3893 FFFA
3894 FFFA                       end_proc 
3895 FFFA                       eject 
3896 FFFA              ;==========================================================================
3897 FFFA              ; integrity.diag : Check the structure of managed memory and crash to the
3898 FFFA              ;                   monitor if an inconsistency is found.
3899 FFFA              ;
3900 FFFA              ; Created:      August 17, 1987
3901 FFFA              ; Modified:     November 12, 1987
3902 FFFA              ; Author:       Mike Askins
3903 FFFA              ;
3904 FFFA              ; Copyright Apple Computer Inc. 1987  All rights reserved
3905 FFFA              ;
3906 FFFA              ; Input:        A = <undefined>
3907 FFFA              ;               X = <undefined>
3908 FFFA              ;               Y = <undefined>
3909 FFFA              ;
3910 FFFA              ; Output:       A = preserved
3911 FFFA              ;               X = preserved
3912 FFFA              ;               Y = preserved
3913 FFFA              ;               P = nvmxdizc
3914 FFFA              ;                   ..000..E -> 'Out of Memory'
3915 FFFA              ;               b = preserved
3916 FFFA              ;          m_temp = trashed
3917 FFFA              ;
3918 FFFA              ;=======================================================================
3919 FFFA              ;
3920 FFFA              ; This routine checks all managed memory segments.  If it finds a problem
3921 FFFA              ;  it gracefully crashes into the monitor with the registers set as follows:
3922 FFFA              ;               A <- Offending segment's offset in the segment table
3923 FFFA              ;               X <- Exception Code
3924 FFFA              ;               Y <- Position in segment
3925 FFFA              ;  Exception Codes:
3926 FFFA              ;               $0001   Subsegment has leading size out of range
3927 FFFA              ;               $0002   Subsegment has inconsistent trailing size
3928 FFFA              ;               $0003   # of free blocks in segment inconsistent w/ free list
3929 FFFA              ;               $0004   Used block found in free list
3930 FFFA              ;               $0005   Forward link out of range
3931 FFFA              ;               $0006   Backward link is inconsistent
3932 FFFA              ;               $0007   Trailing dummy tab is missing
3933 FFFA              ;               $0008   Leading dummy tag is missing
3934 FFFA              ;
3935 FFFA              ;integrity_diag proc
3936 FFFA              ;
3937 FFFA              ; Hey Mike, we killed this routine for the demo
3938 FFFA              ;
3939 FFFA              ;	rtl
3940 FFFA              ;
3941 FFFA              ;seg_integ
3942 FFFA              ;
3943 FFFA              ;	rtl
3944 FFFA              ;
3945 FFFA              ; The code that was here can be found as real.seg.integ
3946 FFFA              ; The memory check debug call can't work without seg.integ
3947 FFFA              ;
3948 FFFA              ;act_seg
3949 FFFA              ;	DC.W	0	;# of segments counter
3950 FFFA              ;free_blks
3951 FFFA              ;	DC.W	0	;# of free blocks counter
3952 FFFA              ;tot_blks
3953 FFFA              ;	DC.W	0	;# blocks (free+used) counter
3954 FFFA              ;
3955 FFFA              ;	end_proc
3956 FFFA              ;	eject
3957 FFFA              *******************************************************************************
3958 FFFA              *
3959 FFFA              * End scm_main segment: $00D000-00FFFF
3960 FFFA              *
3961 FFFA              *******************************************************************************
